/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.transitions;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.constraints.animation.AnimatingConstraints;
import gg.essential.elementa.constraints.animation.AnimationStrategy;
import gg.essential.elementa.constraints.animation.Animations;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.transitions.Transition;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0014J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgg/essential/elementa/transitions/ShrinkTransition;", "Lgg/essential/elementa/transitions/Transition;", "time", "", "animationType", "Lgg/essential/elementa/constraints/animation/Animations;", "restoreConstraints", "", "(FLgg/essential/elementa/constraints/animation/Animations;Z)V", "heightConstraints", "", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/constraints/HeightConstraint;", "widthConstraints", "Lgg/essential/elementa/constraints/WidthConstraint;", "xConstraints", "Lgg/essential/elementa/constraints/XConstraint;", "yConstraints", "Lgg/essential/elementa/constraints/YConstraint;", "afterTransition", "", "component", "beforeTransition", "doTransition", "constraints", "Lgg/essential/elementa/constraints/animation/AnimatingConstraints;", "Elementa"})
public final class ShrinkTransition
extends Transition {
    private final float time;
    @NotNull
    private final Animations animationType;
    private final boolean restoreConstraints;
    @NotNull
    private final Map<UIComponent, XConstraint> xConstraints;
    @NotNull
    private final Map<UIComponent, YConstraint> yConstraints;
    @NotNull
    private final Map<UIComponent, WidthConstraint> widthConstraints;
    @NotNull
    private final Map<UIComponent, HeightConstraint> heightConstraints;

    @JvmOverloads
    public ShrinkTransition(float time, @NotNull Animations animationType, boolean restoreConstraints) {
        Intrinsics.checkNotNullParameter((Object)animationType, (String)"animationType");
        this.time = time;
        this.animationType = animationType;
        this.restoreConstraints = restoreConstraints;
        this.xConstraints = new LinkedHashMap();
        this.yConstraints = new LinkedHashMap();
        this.widthConstraints = new LinkedHashMap();
        this.heightConstraints = new LinkedHashMap();
    }

    public /* synthetic */ ShrinkTransition(float f, Animations animations, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            animations = Animations.OUT_EXP;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(f, animations, bl);
    }

    @Override
    protected void beforeTransition(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.xConstraints.put(component2, component2.getConstraints().getX());
        this.yConstraints.put(component2, component2.getConstraints().getY());
        this.widthConstraints.put(component2, component2.getConstraints().getWidth());
        this.heightConstraints.put(component2, component2.getConstraints().getHeight());
    }

    @Override
    protected void doTransition(@NotNull UIComponent component2, @NotNull AnimatingConstraints constraints) {
        AnimatingConstraints animatingConstraints;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        AnimatingConstraints $this$doTransition_u24lambda_u240 = animatingConstraints = constraints;
        boolean bl = false;
        AnimationStrategy animationStrategy = this.animationType;
        XConstraint xConstraint = this.xConstraints.get(component2);
        Intrinsics.checkNotNull((Object)xConstraint);
        AnimatingConstraints.setXAnimation$default($this$doTransition_u24lambda_u240, animationStrategy, this.time, ConstraintsKt.plus(xConstraint, UtilitiesKt.pixels$default(Float.valueOf(component2.getWidth() / 2.0f), false, false, 3, null)), 0.0f, 8, null);
        AnimationStrategy animationStrategy2 = this.animationType;
        YConstraint yConstraint = this.yConstraints.get(component2);
        Intrinsics.checkNotNull((Object)yConstraint);
        AnimatingConstraints.setYAnimation$default($this$doTransition_u24lambda_u240, animationStrategy2, this.time, ConstraintsKt.plus(yConstraint, UtilitiesKt.pixels$default(Float.valueOf(component2.getHeight() / 2.0f), false, false, 3, null)), 0.0f, 8, null);
        AnimatingConstraints.setWidthAnimation$default($this$doTransition_u24lambda_u240, this.animationType, this.time, UtilitiesKt.pixels$default(0, false, false, 3, null), 0.0f, 8, null);
        AnimatingConstraints.setHeightAnimation$default($this$doTransition_u24lambda_u240, this.animationType, this.time, UtilitiesKt.pixels$default(0, false, false, 3, null), 0.0f, 8, null);
    }

    @Override
    protected void afterTransition(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.restoreConstraints) {
            XConstraint xConstraint = this.xConstraints.get(component2);
            Intrinsics.checkNotNull((Object)xConstraint);
            component2.setX(xConstraint);
            YConstraint yConstraint = this.yConstraints.get(component2);
            Intrinsics.checkNotNull((Object)yConstraint);
            component2.setY(yConstraint);
            WidthConstraint widthConstraint = this.widthConstraints.get(component2);
            Intrinsics.checkNotNull((Object)widthConstraint);
            component2.setWidth(widthConstraint);
            HeightConstraint heightConstraint = this.heightConstraints.get(component2);
            Intrinsics.checkNotNull((Object)heightConstraint);
            component2.setHeight(heightConstraint);
        }
        this.xConstraints.remove(component2);
        this.yConstraints.remove(component2);
        this.widthConstraints.remove(component2);
        this.heightConstraints.remove(component2);
    }

    @JvmOverloads
    public ShrinkTransition(float time, @NotNull Animations animationType) {
        Intrinsics.checkNotNullParameter((Object)animationType, (String)"animationType");
        this(time, animationType, false, 4, null);
    }

    @JvmOverloads
    public ShrinkTransition(float time) {
        this(time, null, false, 6, null);
    }

    @JvmOverloads
    public ShrinkTransition() {
        this(0.0f, null, false, 7, null);
    }
}

