/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.essential.loader.stage2.LoaderLoggingUI;
import gg.essential.loader.stage2.LoaderUI;
import gg.essential.loader.stage2.Utils;
import gg.essential.loader.stage2.components.ForkedUpdatePromptUI;
import gg.essential.loader.stage2.data.ModId;
import gg.essential.loader.stage2.data.ModJarMetadata;
import gg.essential.loader.stage2.data.ModVersion;
import gg.essential.loader.stage2.diff.DiffPatcher;
import gg.essential.loader.stage2.jvm.ForkedJvmLoaderSwingUI;
import gg.essential.loader.stage2.restart.ForkedNeedsRestartUI;
import gg.essential.loader.stage2.util.Checksum;
import gg.essential.loader.stage2.util.VersionComparison;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class EssentialLoaderBase {
    private static final Logger LOGGER = LogManager.getLogger(EssentialLoaderBase.class);
    private static final String BASE_URL = System.getProperty("essential.download.url", System.getenv().getOrDefault("ESSENTIAL_DOWNLOAD_URL", "https://api.essential.gg/mods"));
    private static final String VERSION_BASE_URL = BASE_URL + "/v1/%s/versions/%s";
    private static final String VERSION_URL = VERSION_BASE_URL + "/platforms/%s";
    private static final String DOWNLOAD_URL = VERSION_URL + "/download";
    private static final String DIFF_URL = VERSION_BASE_URL + "/diff/%s/platforms/%s";
    private static final String CHANGELOG_URL = VERSION_BASE_URL + "/changelog";
    protected static final String CLASS_NAME = "gg.essential.api.tweaker.EssentialTweaker";
    private static final String FILE_BASE_NAME = "Essential (%s)";
    protected static final String FILE_EXTENSION = "jar";
    private static final String OVERRIDE_PINNED_VERSION_KEY = "overridePinnedVersion";
    private static final String PENDING_UPDATE_VERSION_KEY = "pendingUpdateVersion";
    private static final String PENDING_UPDATE_RESOLUTION_KEY = "pendingUpdateResolution";
    private final Path gameDir;
    private final String gameVersion;
    private final String apiGameVersion;
    private final String currentStage2Version;
    private final LoaderUI ui;

    public EssentialLoaderBase(Path gameDir, String gameVersion) {
        String stage2Branch;
        this.gameDir = gameDir;
        this.gameVersion = gameVersion;
        this.apiGameVersion = gameVersion.replace(".", "-");
        this.currentStage2Version = System.getProperty("essential.stage2.version");
        if (this.currentStage2Version == null && !(stage2Branch = System.getProperty("essential.stage2.branch", System.getenv().getOrDefault("ESSENTIAL_STAGE2_BRANCH", "stable"))).equals("stable")) {
            LOGGER.info("Essential Loader (stage2) branch set to \"{}\".", new Object[]{stage2Branch});
        }
        this.ui = LoaderUI.all(new LoaderLoggingUI().updatesEveryMillis(1000), new ForkedJvmLoaderSwingUI().updatesEveryMillis(16));
    }

    public void load() throws IOException {
        if (this.isInClassPath()) {
            if (!Boolean.getBoolean("essential.loader.relaunched")) {
                LOGGER.warn("Essential loaded as a regular mod. No automatic updates will be applied.");
            }
            this.loadPlatform();
            return;
        }
        List<Mod> modList = this.findMods();
        HashMap<Mod, ModJarMetadata> loadedMods = new HashMap<Mod, ModJarMetadata>();
        for (Mod mod : modList) {
            ModJarMetadata loadedMeta;
            if (Files.notExists(mod.dataDir, new LinkOption[0])) {
                Files.createDirectories(mod.dataDir, new FileAttribute[0]);
            }
            if ((loadedMeta = this.loadMod(mod)) == null) continue;
            loadedMods.put(mod, loadedMeta);
            ModVersion version = loadedMeta.getVersion();
            if (version.getVersion() == null) continue;
            System.setProperty(mod.safeSlug() + ".version", version.getVersion());
        }
        if (loadedMods.keySet().stream().anyMatch(Mod::isEssential)) {
            this.loadPlatform();
        }
    }

    private List<Mod> findMods() {
        ArrayList<Mod> modList = new ArrayList<Mod>();
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("essential-loader.properties");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                LOGGER.trace("Reading properties file at {}", new Object[]{url});
                Properties properties = new Properties();
                try (InputStream in = url.openStream();){
                    properties.load(in);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read properties file at `" + url + "`:", (Throwable)e);
                }
                Mod mod = new Mod();
                mod.id = new ModId(properties.getProperty("publisherSlug"), properties.getProperty("publisherId"), properties.getProperty("modSlug"), properties.getProperty("modId"));
                mod.displayName = properties.getProperty("displayName");
                mod.branch = properties.getProperty("branch", "stable");
                mod.pinnedFile = properties.getProperty("pinnedFile");
                mod.pinnedFileMd5 = properties.getProperty("pinnedFileMd5");
                mod.pinnedFileVersion = new ModVersion(properties.getProperty("pinnedFileVersionId"), properties.getProperty("pinnedFileVersion"));
                AutoUpdate autoUpdate = mod.autoUpdate = mod.pinnedFile != null ? AutoUpdate.Manual : AutoUpdate.Full;
                if (!mod.validate(url)) continue;
                modList.add(mod);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error looking for essential-loader property files:", (Throwable)e);
        }
        if (modList.stream().noneMatch(Mod::isEssential)) {
            Mod mod = new Mod();
            mod.id = ModId.ESSENTIAL;
            mod.displayName = "Essential";
            mod.autoUpdate = AutoUpdate.Full;
            mod.branch = "stable";
            assert (mod.validate(null));
            modList.add(mod);
        }
        Path dataDir = this.gameDir.resolve("essential");
        for (Mod mod : modList) {
            if (mod.isEssential()) {
                mod.dataDir = dataDir;
                mod.fileBaseName = String.format(FILE_BASE_NAME, this.gameVersion);
            } else {
                mod.dataDir = dataDir.resolve("mods").resolve(mod.safeSlug());
                mod.fileBaseName = this.gameVersion;
            }
            mod.configFile = mod.dataDir.resolve("essential-loader.properties");
            mod.readConfigFile();
            String configuredBranch = mod.config.getProperty("branch");
            mod.branch = this.determineBranch(mod, configuredBranch);
            String configuredAutoUpdate = System.getProperty(mod.safeSlug() + "." + "autoUpdate", mod.config.getProperty("autoUpdate"));
            if (configuredAutoUpdate != null) {
                mod.autoUpdate = AutoUpdate.from(configuredAutoUpdate);
            }
            System.setProperty(mod.safeSlug() + "." + "autoUpdate", mod.autoUpdate.toPropertyValue());
        }
        return modList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ModJarMetadata loadMod(Mod mod) throws IOException {
        essentialFile = (Path)Utils.findMostRecentFile(mod.dataDir, mod.fileBaseName, "jar").getKey();
        currentMeta = ModJarMetadata.EMPTY;
        if (Files.exists(essentialFile, new LinkOption[0])) {
            try {
                currentMeta = ModJarMetadata.readFromMetaFile(essentialFile);
                if (currentMeta == ModJarMetadata.EMPTY) {
                    currentMeta = ModJarMetadata.readFromJarFile(essentialFile);
                }
            }
            catch (IOException e) {
                EssentialLoaderBase.LOGGER.warn("Failed to read existing " + mod + " jar metadata", (Throwable)e);
            }
        }
        if (currentMeta == ModJarMetadata.EMPTY) {
            if (mod.pinnedFile != null) {
                if ((essentialFile = mod.installPinnedFile(essentialFile)) == null) {
                    return null;
                }
                currentMeta = mod.pinnedFileMeta();
            } else {
                latestMeta = this.fetchLatestVersion(mod, mod.branch);
                if (latestMeta == null) {
                    return null;
                }
                this.ui.start();
                try {
                    downloadedFile = this.update(mod, essentialFile, currentMeta, latestMeta);
                    if (downloadedFile == null) {
                        var6_7 = null;
                        return var6_7;
                    }
                    essentialFile = mod.installFile(essentialFile, downloadedFile, latestMeta);
                    currentMeta = latestMeta;
                }
                finally {
                    this.ui.complete();
                }
            }
        }
        if (mod.isPinnedVersionMoreRecentThan(currentMeta.getVersion())) {
            if ((essentialFile = mod.installPinnedFile(essentialFile)) == null) {
                return null;
            }
            currentMeta = mod.pinnedFileMeta();
        }
        if (mod.autoUpdate == AutoUpdate.Full) {
            latestMeta = this.fetchLatestVersion(mod, mod.branch);
            if (latestMeta != null && !latestMeta.getChecksum().equals(currentMeta.getChecksum())) {
                this.ui.start();
                try {
                    downloadedFile = this.update(mod, essentialFile, currentMeta, latestMeta);
                    if (downloadedFile == null) ** GOTO lbl102
                    essentialFile = mod.installFile(essentialFile, downloadedFile, latestMeta);
                    currentMeta = latestMeta;
                }
                finally {
                    this.ui.complete();
                }
            }
        } else if (mod.autoUpdate == AutoUpdate.Manual) {
            if (mod.pinnedFile != null) {
                latestPinnedVersion = mod.pinnedFileVersion.getVersion();
                if (latestPinnedVersion == null) {
                    EssentialLoaderBase.LOGGER.warn("Mod {} has pinned jar but does not specify version!", new Object[]{mod});
                }
            } else {
                latestPinnedVersion = null;
            }
            if ((pinOverride = mod.config.getProperty("overridePinnedVersion")) != null && latestPinnedVersion != null && VersionComparison.compareVersions(pinOverride, latestPinnedVersion) <= 0) {
                mod.config.remove("overridePinnedVersion");
                mod.writeConfigFile();
                pinOverride = null;
            }
            if (pinOverride == null && latestPinnedVersion != null && !currentMeta.getChecksum().equals(mod.pinnedFileMd5)) {
                essentialFile = mod.installPinnedFile(essentialFile);
                currentMeta = mod.pinnedFileMeta();
            }
            onlineVersion = (onlineMeta = this.fetchLatestVersion(mod, mod.branch)) != null ? onlineMeta.getVersion().getVersion() : null;
            localVersion = currentMeta.getVersion().getVersion();
            if (onlineVersion != null && localVersion != null && VersionComparison.compareVersions(onlineVersion, localVersion) > 0) {
                pendingUpdateVersion = mod.config.getProperty("pendingUpdateVersion");
                if (Objects.equals(pendingUpdateVersion, onlineVersion)) {
                    resolution = this.booleanOrNull(mod.config.getProperty("pendingUpdateResolution"));
                    if (resolution == null && (resolution = this.showUpdatePrompt(onlineMeta)) != null) {
                        mod.config.setProperty("pendingUpdateResolution", Boolean.toString(resolution));
                        mod.writeConfigFile();
                    }
                    if (resolution == Boolean.TRUE) {
                        this.ui.start();
                        try {
                            downloadedFile = this.update(mod, essentialFile, currentMeta, onlineMeta);
                            if (downloadedFile == null) ** GOTO lbl102
                            essentialFile = mod.installFile(essentialFile, downloadedFile, onlineMeta);
                            currentMeta = onlineMeta;
                            mod.config.setProperty("overridePinnedVersion", onlineMeta.getVersion().getVersion());
                            mod.config.remove("pendingUpdateVersion");
                            mod.config.remove("pendingUpdateResolution");
                            mod.writeConfigFile();
                        }
                        finally {
                            this.ui.complete();
                        }
                    } else {
                        EssentialLoaderBase.LOGGER.warn("Found newer Essential version {} [{}], skipping {}", new Object[]{onlineVersion, mod.branch, resolution == Boolean.FALSE ? "at user request" : "because no consent could be acquired"});
                    }
                } else {
                    EssentialLoaderBase.LOGGER.info("Found newer Essential version {} [{}]", new Object[]{onlineVersion, mod.branch});
                    mod.config.setProperty("pendingUpdateVersion", onlineVersion);
                    mod.config.remove("pendingUpdateResolution");
                    mod.writeConfigFile();
                }
            }
        }
lbl102:
        // 11 sources

        if (mod.autoUpdate != AutoUpdate.Manual && (mod.config.getProperty("pendingUpdateVersion") != null || mod.config.getProperty("pendingUpdateResolution") != null || mod.config.getProperty("overridePinnedVersion") != null)) {
            mod.config.remove("pendingUpdateVersion");
            mod.config.remove("pendingUpdateResolution");
            mod.config.remove("overridePinnedVersion");
            mod.writeConfigFile();
        }
        if (!Files.exists(essentialFile, new LinkOption[0])) {
            return null;
        }
        requiredStage2Version = this.getRequiredStage2VersionIfOutdated(essentialFile);
        if (requiredStage2Version != null) {
            try {
                jarFile = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            jarFileName = jarFile.getFileName().toString();
            configFile = jarFile.resolveSibling(jarFileName.substring(0, jarFileName.length() - 4) + ".properties");
            config = EssentialLoaderBase.readConfigFileAt(configFile);
            config.remove("pendingUpdateVersion");
            config.setProperty("pendingUpdateResolution", "true");
            if (AutoUpdate.access$000(config.getProperty("autoUpdate")) == AutoUpdate.Off) {
                config.setProperty("autoUpdate", "with-prompt");
            }
            EssentialLoaderBase.writeConfigFileTo(configFile, config);
            ui = new ForkedNeedsRestartUI(Collections.singletonList("Essential Loader"), Collections.emptyList());
            ui.show();
            ui.waitForClose();
            ui.exit();
            throw new AssertionError((Object)"JVM should have exited by now");
        }
        this.addToClasspath(mod, currentMeta, essentialFile, this.extractJarsInJar(mod, essentialFile));
        return currentMeta;
    }

    private String determineBranch(Mod mod, String configuredBranch) {
        String DEFAULT_SOURCE = "default";
        List<Pair> configs = Arrays.asList(Pair.of((Object)"property", (Object)System.getProperty(mod.safeSlug() + ".branch")), Pair.of((Object)"environment", (Object)System.getenv().get(mod.safeSlug().toUpperCase(Locale.ROOT) + "_BRANCH")), Pair.of((Object)"config", (Object)configuredBranch), Pair.of((Object)"file", (Object)this.determineBranchFromFile(mod)), Pair.of((Object)"default", (Object)mod.branch));
        String resultBranch = null;
        String resultSource = null;
        for (Pair config : configs) {
            String source = (String)config.getKey();
            String branch = (String)config.getValue();
            if (branch == null) {
                LOGGER.trace("Checked {} for {} branch, was not supplied.", new Object[]{source, mod});
                continue;
            }
            if (resultBranch != null) {
                if (source.equals("default")) continue;
                LOGGER.warn("{} branch supplied via {} as \"{}\" but ignored because {} is more important.", new Object[]{mod, source, branch, resultSource});
                continue;
            }
            Level level = source.equals("default") ? Level.DEBUG : Level.INFO;
            LOGGER.log(level, "{} branch set to \"{}\" via {}.", new Object[]{mod, branch, source});
            resultBranch = branch;
            resultSource = source;
        }
        assert (resultBranch != null);
        System.setProperty(mod.safeSlug() + ".branch", resultBranch);
        return resultBranch;
    }

    private String determineBranchFromFile(Mod mod) {
        String BRANCH_FILE_NAME = mod.safeSlug() + "_branch.txt";
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(BRANCH_FILE_NAME);
            if (!resources.hasMoreElements()) {
                return null;
            }
            URL url = resources.nextElement();
            String branch = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8).trim();
            LOGGER.info("Found {} for branch \"{}\".", new Object[]{url, branch});
            while (resources.hasMoreElements()) {
                LOGGER.warn("Found extra branch file, ignoring: {}", new Object[]{resources.nextElement()});
            }
            return branch;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to check for " + BRANCH_FILE_NAME + " file on classpath:", (Throwable)e);
            return null;
        }
    }

    private Path update(Mod mod, Path essentialFile, ModJarMetadata currentMeta, ModJarMetadata latestMeta) throws IOException {
        Path updatedFile;
        if (!currentMeta.getVersion().isUnknown() && (updatedFile = this.updateViaDiff(mod, essentialFile, currentMeta, latestMeta)) != null) {
            return updatedFile;
        }
        Path downloadedFile = this.updateViaDownload(mod, latestMeta);
        if (downloadedFile == null) {
            LOGGER.warn("Unable to download {}, please check your internet connection. If the problem persists, please contact Essential Support.", new Object[]{mod});
        }
        return downloadedFile;
    }

    private Path updateViaDiff(Mod mod, Path essentialFile, ModJarMetadata currentMeta, ModJarMetadata latestMeta) throws IOException {
        if (!Objects.equals(currentMeta.getChecksum(), Checksum.getChecksum(essentialFile))) {
            return null;
        }
        FileMeta meta = this.fetchDiffUrl(latestMeta.getMod(), currentMeta.getVersion(), latestMeta.getVersion());
        if (meta == null) {
            return null;
        }
        Path downloadedFile = Files.createTempFile("essential-download-", "", new FileAttribute[0]);
        if (!this.downloadFile(mod, meta.url, downloadedFile, meta.checksum)) {
            return null;
        }
        Path patchedFile = Files.createTempFile("essential-patched-", "", new FileAttribute[0]);
        Files.copy(essentialFile, patchedFile, StandardCopyOption.REPLACE_EXISTING);
        try {
            DiffPatcher.apply(patchedFile, downloadedFile);
            Files.delete(downloadedFile);
            String expected = latestMeta.getChecksum();
            String actual = Checksum.getChecksum(patchedFile);
            if (!Objects.equals(expected, actual)) {
                throw new IOException("Excepted checksum of result to be " + expected + " but was " + actual);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while applying diff:", (Throwable)e);
            Files.deleteIfExists(patchedFile);
            Files.deleteIfExists(downloadedFile);
            return null;
        }
        return patchedFile;
    }

    private Path updateViaDownload(Mod mod, ModJarMetadata latestMeta) throws IOException {
        FileMeta meta = this.fetchDownloadUrl(latestMeta.getMod(), latestMeta.getVersion());
        if (meta == null) {
            return null;
        }
        Path downloadedFile = Files.createTempFile("essential-download-", "", new FileAttribute[0]);
        if (!this.downloadFile(mod, meta.url, downloadedFile, meta.checksum)) {
            return null;
        }
        return downloadedFile;
    }

    private JsonObject fetchJsonObject(String endpoint, boolean allowEmpty) {
        URLConnection connection = null;
        try {
            String response;
            connection = this.prepareConnection(new URL(endpoint));
            try (InputStream inputStream = connection.getInputStream();){
                response = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            JsonElement jsonElement = new JsonParser().parse(response);
            if (!jsonElement.isJsonObject()) {
                if (allowEmpty && jsonElement.isJsonNull()) {
                    return new JsonObject();
                }
                throw new IOException("Excepted json object, got " + response);
            }
            return jsonElement.getAsJsonObject();
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Error occurred fetching " + endpoint + ": ", e);
            this.logConnectionInfoOnError(connection);
            return null;
        }
    }

    private ModJarMetadata fetchLatestVersion(Mod mod, String branch) {
        String checksum;
        JsonObject responseObject = this.fetchJsonObject(String.format(VERSION_URL, mod.id.getFullSlug(), branch, this.apiGameVersion), true);
        if (responseObject == null) {
            LOGGER.warn("{} does not support the following game version: {}", new Object[]{mod, this.gameVersion});
            return null;
        }
        JsonElement jsonId = responseObject.get("id");
        JsonElement jsonVersion = responseObject.get("version");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String id = jsonId != null && jsonId.isJsonPrimitive() ? jsonId.getAsString() : null;
        String version = jsonVersion != null && jsonVersion.isJsonPrimitive() ? jsonVersion.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? jsonChecksum.getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)version)) {
            LOGGER.warn("Unexpected response object data (id={}, version={}, checksum={})", new Object[]{jsonId, jsonVersion, jsonChecksum});
            return null;
        }
        return new ModJarMetadata(mod.id, new ModVersion(id, version), this.apiGameVersion, checksum);
    }

    private FileMeta fetchDownloadUrl(ModId modId, ModVersion modVersion) {
        return this.fetchFileMeta(String.format(DOWNLOAD_URL, modId.getFullSlug(), modVersion.getVersion(), this.apiGameVersion));
    }

    private FileMeta fetchDiffUrl(ModId modId, ModVersion oldVersion, ModVersion modVersion) {
        return this.fetchFileMeta(String.format(DIFF_URL, modId.getFullSlug(), oldVersion.getVersion(), modVersion.getVersion(), this.apiGameVersion));
    }

    private FileMeta fetchFileMeta(String endpoint) {
        String checksum;
        JsonObject responseObject = this.fetchJsonObject(endpoint, false);
        if (responseObject == null) {
            return null;
        }
        JsonElement jsonUrl = responseObject.get("url");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String url = jsonUrl != null && jsonUrl.isJsonPrimitive() ? jsonUrl.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? responseObject.get("checksum").getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)checksum)) {
            LOGGER.warn("Unexpected response object data (url={}, checksum={})", new Object[]{jsonUrl, jsonChecksum});
            return null;
        }
        try {
            return new FileMeta(new URL(url), checksum);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Received invalid url `" + url + "`:", (Throwable)e);
            return null;
        }
    }

    private URLConnection prepareConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(true);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Essential Initializer)");
        }
        return urlConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRequiredStage2VersionIfOutdated(Path modFile) {
        if (this.currentStage2Version == null) {
            return null;
        }
        try (FileSystem fileSystem = FileSystems.newFileSystem(modFile, (ClassLoader)null);){
            Path manifestPath = fileSystem.getPath("META-INF", "MANIFEST.MF");
            if (!Files.exists(manifestPath, new LinkOption[0])) {
                String string = null;
                return string;
            }
            Manifest manifest = new Manifest();
            InputStream in = Files.newInputStream(manifestPath, new OpenOption[0]);
            Object object = null;
            try {
                manifest.read(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            String requiredVersion = manifest.getMainAttributes().getValue(new Attributes.Name("Requires-Essential-Stage2-Version"));
            if (requiredVersion == null) {
                object = null;
                return object;
            }
            if (VersionComparison.compareVersions(this.currentStage2Version, requiredVersion) >= 0) {
                object = null;
                return object;
            }
            object = requiredVersion;
            return object;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read mod metadata from jar file at " + modFile + ":", (Throwable)e);
            return null;
        }
    }

    protected Path getExtractedJarsRoot(Mod mod) {
        return mod.dataDir.resolve("libraries").resolve(this.gameVersion);
    }

    private List<Path> extractJarsInJar(Mod mod, Path outerJar) throws IOException {
        Path extractedJarsRoot = this.getExtractedJarsRoot(mod);
        Files.createDirectories(extractedJarsRoot, new FileAttribute[0]);
        ArrayList<Path> extractedJars = new ArrayList<Path>();
        try (FileSystem fileSystem = FileSystems.newFileSystem(outerJar, (ClassLoader)null);){
            List innerJars;
            Path innerJarsRoot = fileSystem.getPath("META-INF", "jars");
            if (!Files.isDirectory(innerJarsRoot, new LinkOption[0])) {
                ArrayList<Path> arrayList = extractedJars;
                return arrayList;
            }
            try (Stream<Path> stream = Files.list(innerJarsRoot);){
                innerJars = stream.collect(Collectors.toList());
            }
            for (Path innerJar : innerJars) {
                Path extractedJar = extractedJarsRoot.resolve(innerJar.getFileName().toString());
                if (Files.exists(extractedJar, new LinkOption[0])) {
                    LOGGER.debug("Already extracted: {}", new Object[]{innerJar});
                } else {
                    LOGGER.debug("Extracting {} to {}", new Object[]{innerJar, extractedJar});
                    Path tmpJar = Files.createTempFile(extractedJarsRoot, "tmp", ".jar", new FileAttribute[0]);
                    Files.copy(innerJar, tmpJar, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(tmpJar, extractedJar, StandardCopyOption.ATOMIC_MOVE);
                }
                extractedJars.add(extractedJar);
            }
        }
        return extractedJars;
    }

    protected abstract void loadPlatform();

    @Nullable
    protected abstract ClassLoader getModClassLoader();

    protected void addToClasspath(Mod mod, ModJarMetadata jarMeta, Path mainJar, List<Path> innerJars) {
        this.addToClasspath(mainJar);
        for (Path jar : innerJars) {
            this.addToClasspath(jar);
        }
    }

    protected abstract void addToClasspath(Path var1);

    protected boolean classpathUpdatesImmediately() {
        return true;
    }

    protected boolean isInClassPath() {
        ClassLoader loader = this.getModClassLoader();
        if (loader == null) {
            return false;
        }
        return loader.getResource(CLASS_NAME.replace('.', '/') + ".class") != null;
    }

    public final void initialize() {
        if (!this.isInClassPath()) {
            return;
        }
        this.doInitialize();
    }

    protected void doInitialize() {
        try {
            ClassLoader loader = this.getModClassLoader();
            if (loader == null) {
                throw new IllegalStateException("Essential is about to be initialized but no associated class loader was found.");
            }
            Class.forName(CLASS_NAME, false, loader).getDeclaredMethod("initialize", File.class).invoke(null, this.gameDir.toFile());
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    public static URI asJar(URI uri) throws URISyntaxException {
        return new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath(), uri.getFragment());
    }

    private boolean downloadFile(Mod mod, URL url, Path target, String expectedHash) throws IOException {
        if (!this.attemptDownload(url, target)) {
            LOGGER.warn("Unable to download {}, please check your internet connection. If the problem persists, please contact Essential Support.", new Object[]{mod});
            Files.deleteIfExists(target);
            return false;
        }
        String downloadedChecksum = Checksum.getChecksum(target);
        if (downloadedChecksum.equals(expectedHash)) {
            return true;
        }
        LOGGER.warn("Downloaded {} file checksum did not match what we expected (downloaded={}, expected={}", new Object[]{mod, downloadedChecksum, expectedHash});
        Files.deleteIfExists(target);
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean attemptDownload(URL url, Path target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logConnectionInfoOnError(URLConnection connection) {
        if (connection == null) {
            return;
        }
        LOGGER.error("url: {}", new Object[]{connection.getURL()});
        LOGGER.error("cf-ray: {}", new Object[]{connection.getHeaderField("cf-ray")});
    }

    private Boolean showUpdatePrompt(ModJarMetadata newVersion) {
        String description = "";
        try {
            JsonObject responseObject = this.fetchJsonObject(String.format(CHANGELOG_URL, newVersion.getMod().getFullSlug(), newVersion.getVersion().getId()), false);
            if (responseObject != null) {
                description = responseObject.get("summary").getAsString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load changelog for " + newVersion, (Throwable)e);
        }
        if (System.getProperty("essential.integration_testing") != null) {
            String autoAnswer = System.getProperty("essential.stage2.fallback-prompt-auto-answer");
            if (autoAnswer != null) {
                return Boolean.parseBoolean(autoAnswer);
            }
            throw new RuntimeException("Update prompt opened unexpectedly!");
        }
        ForkedUpdatePromptUI promptUI = new ForkedUpdatePromptUI("Essential Mod Update!", description);
        promptUI.show();
        return promptUI.waitForClose();
    }

    private Boolean booleanOrNull(String str) {
        return str == null ? null : Boolean.valueOf(Boolean.parseBoolean(str));
    }

    private static Properties readConfigFileAt(Path path) {
        Properties config = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                config.load(in);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config at " + path + ":", (Throwable)e);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigFileTo(Path path, Properties config) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Path tempFile = Files.createTempFile(path.getParent(), "tmp-", ".properties", new FileAttribute[0]);
        try {
            try (BufferedWriter out = Files.newBufferedWriter(tempFile, new OpenOption[0]);){
                config.store(out, null);
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    public static enum AutoUpdate {
        Full,
        Manual,
        Off;

        public static final String WITH_PROMPT = "with-prompt";
        public static final String KEY = "autoUpdate";

        private static AutoUpdate from(String value) {
            if (value == null) {
                return Full;
            }
            if (value.equalsIgnoreCase(WITH_PROMPT)) {
                return Manual;
            }
            return Boolean.parseBoolean(value) ? Full : Off;
        }

        private String toPropertyValue() {
            switch (this) {
                case Full: {
                    return "true";
                }
                case Manual: {
                    return WITH_PROMPT;
                }
                case Off: {
                    return "false";
                }
            }
            throw new AssertionError();
        }
    }

    public class Mod {
        ModId id;
        String displayName;
        String pinnedFile;
        String pinnedFileMd5;
        ModVersion pinnedFileVersion;
        String branch;
        AutoUpdate autoUpdate;
        Path dataDir;
        String fileBaseName;
        Path configFile;
        Properties config;

        String slug() {
            String modSlug;
            String publisherSlug = this.id.getPublisherSlug();
            return Objects.equals(publisherSlug, modSlug = this.id.getModSlug()) ? modSlug : publisherSlug + ":" + modSlug;
        }

        String safeSlug() {
            return this.slug().replace(":", "_");
        }

        boolean isEssential() {
            return this.slug().equals("essential");
        }

        URL pinnedFileUrl() throws MalformedURLException {
            if (this.pinnedFile.startsWith("/")) {
                URL url = this.getClass().getClassLoader().getResource(this.pinnedFile.substring(1));
                if (url == null) {
                    LOGGER.fatal("Failed to find pinned jar file at {}", new Object[]{this.pinnedFile});
                }
                return url;
            }
            return new URL(this.pinnedFile);
        }

        ModJarMetadata pinnedFileMeta() {
            if (this.pinnedFileMd5 == null) {
                return null;
            }
            return new ModJarMetadata(this.id, this.pinnedFileVersion, null, this.pinnedFileMd5);
        }

        boolean validate(URL source) {
            return Stream.of(this.validateNotNull(source, "publisherSlug", this.id.getPublisherSlug()), this.validateNotNull(source, "modSlug", this.id.getModSlug()), this.validateNotNull(source, "displayName", this.displayName), this.pinnedFile == null || this.validateNotNull(source, "pinnedFileMd5", this.pinnedFileMd5)).allMatch(it -> it);
        }

        private boolean validateNotNull(URL source, String name, Object value) {
            if (value != null) {
                return true;
            }
            LOGGER.error("Mod configuration at {} is missing `{}` entry!", new Object[]{source, name});
            return false;
        }

        void readConfigFile() {
            this.config = EssentialLoaderBase.readConfigFileAt(this.configFile);
        }

        void writeConfigFile() throws IOException {
            EssentialLoaderBase.writeConfigFileTo(this.configFile, this.config);
        }

        Path installFile(Path destinationFile, Path sourceFile, ModJarMetadata metadata) throws IOException {
            try {
                Files.deleteIfExists(destinationFile);
                Files.deleteIfExists(ModJarMetadata.metaFilePath(destinationFile));
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete old " + this + " file, will try again later.", (Throwable)e);
            }
            destinationFile = Utils.findNextMostRecentFile(this.dataDir, this.fileBaseName, EssentialLoaderBase.FILE_EXTENSION);
            metadata.writeToMetaFile(destinationFile);
            Files.move(sourceFile, destinationFile, new CopyOption[0]);
            return destinationFile;
        }

        Path installPinnedFile(Path destinationFile) throws IOException {
            URL url = this.pinnedFileUrl();
            if (url == null) {
                return null;
            }
            Path downloadedFile = Files.createTempFile("essential-extract-", "", new FileAttribute[0]);
            if (!EssentialLoaderBase.this.downloadFile(this, url, downloadedFile, this.pinnedFileMd5)) {
                return null;
            }
            return this.installFile(destinationFile, downloadedFile, this.pinnedFileMeta());
        }

        public boolean isPinnedVersionMoreRecentThan(ModVersion version) {
            if (this.pinnedFileVersion == null) {
                return false;
            }
            if (this.pinnedFileVersion.getVersion() == null) {
                return false;
            }
            if (version == null) {
                return true;
            }
            if (version.getVersion() == null) {
                return true;
            }
            return VersionComparison.compareVersions(this.pinnedFileVersion.getVersion(), version.getVersion()) > 0;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static class FileMeta {
        URL url;
        String checksum;

        public FileMeta(URL url, String checksum) {
            this.url = url;
            this.checksum = checksum;
        }
    }
}

