/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.asm.compat;

import gg.essential.asm.EssentialTransformer;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.util.Annotations;

public class RandomPatchesTransformer
implements EssentialTransformer {
    private static final boolean isDev = RandomPatchesTransformer.isDevelopment();
    private static final String minecraftClient = isDev ? "net/minecraft/client/MinecraftClient" : "net/minecraft/class_310";
    private static final String getInstanceName = isDev ? "getInstance" : "method_1551";
    private static final String gameOptionsDescriptor = isDev ? "Lnet/minecraft/client/options/GameOptions;" : "Lnet/minecraft/class_315;";
    private static final String gameOptionsFieldName = isDev ? "options" : "field_1690";
    private static final String mixinMergedDescriptor = "Lorg/spongepowered/asm/mixin/transformer/meta/MixinMerged;";

    @Override
    public Set<String> getTargets() {
        return new HashSet<String>(){
            {
                this.add("net.minecraft.client.options.KeyBinding");
                this.add("net.minecraft.class_304");
            }
        };
    }

    @Override
    public void preApply(ClassNode classNode) {
    }

    @Override
    public void postApply(ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            if (!RandomPatchesTransformer.isRandomPatchesConflictMixin(methodNode)) continue;
            methodNode.instructions.insert(this.checkOptionsNotNull());
        }
    }

    private static boolean isRandomPatchesConflictMixin(MethodNode methodNode) {
        if (methodNode.visibleAnnotations == null || !methodNode.name.contains("conflicts")) {
            return false;
        }
        for (AnnotationNode annotation2 : methodNode.visibleAnnotations) {
            if (!annotation2.desc.equals(mixinMergedDescriptor) || !Annotations.getValue((AnnotationNode)annotation2, (String)"value").equals("com.therandomlabs.randompatches.mixin.client.keybindings.KeyBindingMixin")) continue;
            return true;
        }
        return false;
    }

    private InsnList checkOptionsNotNull() {
        InsnList list = new InsnList();
        LabelNode label2 = new LabelNode();
        list.add((AbstractInsnNode)new MethodInsnNode(184, minecraftClient, getInstanceName, "()L" + minecraftClient + ";"));
        list.add((AbstractInsnNode)new FieldInsnNode(180, minecraftClient, gameOptionsFieldName, gameOptionsDescriptor));
        list.add((AbstractInsnNode)new JumpInsnNode(199, label2));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)label2);
        return list;
    }

    private static boolean isDevelopment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }
}

