/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics;

import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.cosmetics.EssentialModelRendererKt;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.mixins.impl.client.gui.GuiInventoryExt;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelInstance;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.ExtensionsKt;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1007;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialModelRenderer
extends class_3887<class_742, class_591<class_742>> {
    private final class_1007 playerRenderer;

    public EssentialModelRenderer(class_1007 playerRenderer) {
        super((class_3883)playerRenderer);
        this.playerRenderer = playerRenderer;
    }

    public static boolean shouldRender(class_742 player2) {
        if (((Boolean)GuiInventoryExt.isInventoryEntityRendering.getUntracked()).booleanValue() && EssentialConfig.INSTANCE.getDisableCosmeticsInInventory()) {
            return false;
        }
        return !player2.method_5767() && !player2.method_7325();
    }

    public void render(UMatrixStack matrixStack, RenderBackend.VertexConsumerProvider vertexConsumerProvider, @NotNull CosmeticsRenderState cState, @Nullable Set<EnumPart> parts) {
        WearablesManager wearablesManager2 = cState.wearablesManager();
        if (wearablesManager2 == null) {
            return;
        }
        Map<Cosmetic, ModelInstance> models = wearablesManager2.getModels();
        if (models.isEmpty()) {
            return;
        }
        PlayerPose pose = PlayerPoseKt.toPose(this.playerRenderer);
        MinecraftRenderBackend.SkinTexture skin = new MinecraftRenderBackend.SkinTexture(cState.skinTexture());
        matrixStack.push();
        if (parts == null) {
            parts = new HashSet<EnumPart>(Arrays.asList(EnumPart.values()));
        }
        matrixStack.translate(0.0f, 1.501f, 0.0f);
        wearablesManager2.render(ExtensionsKt.toCommon(matrixStack), vertexConsumerProvider, pose, skin, parts);
        EssentialModelRendererKt.renderForHoverOutline(wearablesManager2, ExtensionsKt.toCommon(matrixStack), vertexConsumerProvider, pose, skin, parts);
        matrixStack.pop();
        cState.setRenderedPose(pose);
    }

    public void render(@NotNull class_4587 vMatrixStack, @NotNull class_4597 buffer, int light, @NotNull class_742 player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live(player2);
        UMatrixStack matrixStack = new UMatrixStack(vMatrixStack);
        MinecraftRenderBackend.VertexConsumerProvider vertexConsumerProvider = new MinecraftRenderBackend.VertexConsumerProvider(buffer, light);
        this.render(matrixStack, vertexConsumerProvider, cState, null);
    }
}

