/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.boxmask;

import gg.essential.cosmetics.boxmask.ModelClipper;
import gg.essential.model.Bone;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.Face;
import gg.essential.model.PositionTexVertex;
import gg.essential.model.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl;", "Lgg/essential/cosmetics/boxmask/ModelClipper;", "()V", "apply", "", "bone", "Lgg/essential/model/Bone;", "renderExclusions", "", "Lgg/essential/model/Box3;", "compute", "masks", "generateARegion", "intersectedFace", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$IntersectedFace;", "minYIntersect", "", "EnumRegion", "FaceRegion", "IntersectedFace", "cosmetics"})
public final class ModelClipperImpl
implements ModelClipper {
    @Override
    @NotNull
    public Bone compute(@NotNull Bone bone, @NotNull List<Box3> masks) {
        Intrinsics.checkNotNullParameter((Object)bone, (String)"bone");
        Intrinsics.checkNotNullParameter(masks, (String)"masks");
        if (masks.isEmpty()) {
            return bone;
        }
        Bone modifiedBone = bone.deepCopy();
        this.apply(modifiedBone, masks);
        return modifiedBone;
    }

    private final void apply(Bone bone, List<Box3> renderExclusions) {
        for (Cube cube : bone.cubeList) {
            Iterator<Face> iterator2 = cube.getQuadList().iterator();
            List newFaces = new ArrayList();
            while (iterator2.hasNext()) {
                Face next = iterator2.next();
                Box3 selfBox = new Box3(null, null, 3, null);
                PositionTexVertex[] vertices = next.vertexPositions;
                Vector3 a = vertices[0].vector3.clone();
                Vector3 b = vertices[1].vector3.clone();
                Vector3 c = vertices[2].vector3.clone();
                Vector3 d = vertices[3].vector3.clone();
                Object[] objectArray = new Vector3[]{a, b, c, d};
                selfBox.setFromPoints(CollectionsKt.listOf((Object[])objectArray));
                boolean matched = false;
                IntersectedFace intersectedFace = new IntersectedFace(next, cube.getMirror());
                for (Box3 exclusion : renderExclusions) {
                    Box3 intersect = selfBox.clone().intersect(exclusion);
                    if (Intrinsics.areEqual((Object)intersect, (Object)selfBox)) {
                        iterator2.remove();
                        matched = false;
                        break;
                    }
                    if (intersect.isEmpty()) continue;
                    matched = true;
                    float xHeight = intersect.getMax().x - intersect.getMin().x;
                    float zHeight = intersect.getMax().z - intersect.getMin().z;
                    float minYIntersect = Math.min(intersect.getMin().y, intersectedFace.getARegion().getPoints()[3].vector3.y);
                    if (xHeight == 0.0f) {
                        this.generateARegion(intersectedFace, minYIntersect);
                        continue;
                    }
                    if (!(zHeight == 0.0f)) continue;
                    this.generateARegion(intersectedFace, minYIntersect);
                }
                if (!matched) continue;
                iterator2.remove();
                newFaces.addAll((Collection)intersectedFace.generateFaces());
            }
            cube.getQuadList().addAll(newFaces);
        }
        for (Bone childModel : bone.childModels) {
            this.apply(childModel, renderExclusions);
        }
    }

    private final void generateARegion(IntersectedFace intersectedFace, float minYIntersect) {
        float texY;
        intersectedFace.getARegion().getPoints()[2].vector3.y = minYIntersect;
        intersectedFace.getARegion().getPoints()[3].vector3.y = minYIntersect;
        intersectedFace.getARegion().getPoints()[2].texturePositionY = texY = intersectedFace.getARegion().getPoints()[1].texturePositionY + (minYIntersect - intersectedFace.getARegion().getPoints()[0].vector3.y) / intersectedFace.getARegion().getSpacialYDistance() * intersectedFace.getARegion().getTextureYDistance();
        intersectedFace.getARegion().getPoints()[3].texturePositionY = texY;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;", "", "(Ljava/lang/String;I)V", "A", "B", "C", "D", "cosmetics"})
    private static final class EnumRegion
    extends Enum<EnumRegion> {
        public static final /* enum */ EnumRegion A = new EnumRegion();
        public static final /* enum */ EnumRegion B = new EnumRegion();
        public static final /* enum */ EnumRegion C = new EnumRegion();
        public static final /* enum */ EnumRegion D = new EnumRegion();
        private static final /* synthetic */ EnumRegion[] $VALUES;

        public static EnumRegion[] values() {
            return (EnumRegion[])$VALUES.clone();
        }

        public static EnumRegion valueOf(String value) {
            return Enum.valueOf(EnumRegion.class, value);
        }

        static {
            $VALUES = enumRegionArray = new EnumRegion[]{EnumRegion.A, EnumRegion.B, EnumRegion.C, EnumRegion.D};
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0005R\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "", "region", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;", "base", "Lgg/essential/model/Face;", "mirror", "", "(Lgg/essential/cosmetics/boxmask/ModelClipperImpl$EnumRegion;Lgg/essential/model/Face;Z)V", "points", "", "Lgg/essential/model/PositionTexVertex;", "getPoints", "()[Lgg/essential/model/PositionTexVertex;", "setPoints", "([Lgg/essential/model/PositionTexVertex;)V", "[Lgg/essential/model/PositionTexVertex;", "spacialYDistance", "", "getSpacialYDistance", "()F", "setSpacialYDistance", "(F)V", "textureYDistance", "getTextureYDistance", "setTextureYDistance", "flipFace", "", "toFace", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nModelClipperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n11328#2:131\n11663#2,3:132\n11418#2:139\n11529#2,4:140\n11328#2:148\n11663#2,3:149\n37#3:135\n36#3,3:136\n37#3:144\n36#3,3:145\n37#3:152\n36#3,3:153\n*S KotlinDebug\n*F\n+ 1 ModelClipperImpl.kt\ngg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion\n*L\n108#1:131\n108#1:132,3\n121#1:139\n121#1:140,4\n127#1:148\n127#1:149,3\n108#1:135\n108#1:136,3\n123#1:144\n123#1:145,3\n127#1:152\n127#1:153,3\n*E\n"})
    private static final class FaceRegion {
        @NotNull
        private PositionTexVertex[] points;
        private float spacialYDistance;
        private float textureYDistance;

        /*
         * WARNING - void declaration
         */
        public FaceRegion(@NotNull EnumRegion region, @NotNull Face base, boolean mirror) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            PositionTexVertex[] positionTexVertexArray = base.vertexPositions;
            FaceRegion faceRegion = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_13 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.copy());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            faceRegion.points = positionTexVertexArray2;
            if (mirror) {
                this.flipFace();
            }
            if (region == EnumRegion.A) {
                this.spacialYDistance = this.points[2].vector3.y - this.points[1].vector3.y;
                this.textureYDistance = this.points[2].texturePositionY - this.points[1].texturePositionY;
            }
        }

        @NotNull
        public final PositionTexVertex[] getPoints() {
            return this.points;
        }

        public final void setPoints(@NotNull PositionTexVertex[] positionTexVertexArray) {
            Intrinsics.checkNotNullParameter((Object)positionTexVertexArray, (String)"<set-?>");
            this.points = positionTexVertexArray;
        }

        public final float getSpacialYDistance() {
            return this.spacialYDistance;
        }

        public final void setSpacialYDistance(float f) {
            this.spacialYDistance = f;
        }

        public final float getTextureYDistance() {
            return this.textureYDistance;
        }

        public final void setTextureYDistance(float f) {
            this.textureYDistance = f;
        }

        /*
         * WARNING - void declaration
         */
        public final void flipFace() {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            PositionTexVertex[] positionTexVertexArray = this.points;
            FaceRegion faceRegion = this;
            boolean $i$f$mapIndexed = false;
            void var3_4 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.points[this.points.length - i2 - 1]);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            faceRegion.points = positionTexVertexArray2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Face toFace() {
            void $this$mapTo$iv$iv;
            PositionTexVertex[] $this$map$iv = this.points;
            boolean $i$f$map = false;
            PositionTexVertex[] positionTexVertexArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.copy());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PositionTexVertex[] positionTexVertexArray2 = thisCollection$iv.toArray(new PositionTexVertex[0]);
            if (positionTexVertexArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            PositionTexVertex[] positionTexVertexArray3 = positionTexVertexArray2;
            return new Face(positionTexVertexArray3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lgg/essential/cosmetics/boxmask/ModelClipperImpl$IntersectedFace;", "", "base", "Lgg/essential/model/Face;", "mirror", "", "(Lgg/essential/model/Face;Z)V", "aRegion", "Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "getARegion", "()Lgg/essential/cosmetics/boxmask/ModelClipperImpl$FaceRegion;", "generateFaces", "", "cosmetics"})
    private static final class IntersectedFace {
        @NotNull
        private final FaceRegion aRegion;

        public IntersectedFace(@NotNull Face base, boolean mirror) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.aRegion = new FaceRegion(EnumRegion.A, base, mirror);
        }

        @NotNull
        public final FaceRegion getARegion() {
            return this.aRegion;
        }

        @NotNull
        public final List<Face> generateFaces() {
            return CollectionsKt.listOf((Object)this.aRegion.toFace());
        }
    }
}

