/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.model;

import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.cosmetics.SkinLayer;
import gg.essential.cosmetics.holder.PriceHolder;
import gg.essential.cosmetics.holder.SkinLayersHolder;
import gg.essential.cosmetics.model.CosmeticTier;
import gg.essential.holder.DisplayNameHolder;
import gg.essential.lib.gson.annotations.SerializedName;
import gg.essential.model.EssentialAsset;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cosmetic
implements DisplayNameHolder,
PriceHolder,
SkinLayersHolder {
    @SerializedName(value="a")
    @NotNull
    private final String id;
    @SerializedName(value="b")
    @NotNull
    private final String type;
    @SerializedName(value="c")
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull String> displayNames;
    @SerializedName(value="f")
    private final int storePackageId;
    @SerializedName(value="g")
    private @Nullable Map<@NotNull String, @NotNull Double> prices;
    @SerializedName(value="h")
    private @Nullable Set<@NotNull String> tags;
    @SerializedName(value="i")
    @NotNull
    private final DateTime createdAt;
    @SerializedName(value="j")
    @Nullable
    private final DateTime availableAfter;
    @SerializedName(value="k")
    @Nullable
    private final DateTime availableUntil;
    @SerializedName(value="l")
    private @Nullable Map<@NotNull SkinLayer, @NotNull Boolean> skinLayers;
    @SerializedName(value="m")
    private @Nullable Map<@NotNull String, @NotNull Integer> categories;
    @SerializedName(value="n")
    @Nullable
    private final Integer defaultSortWeight;
    @SerializedName(value="o")
    @Nullable
    private Integer priceCoins;
    @SerializedName(value="p")
    @Nullable
    private CosmeticTier tier;
    @SerializedName(value="q")
    @NotNull
    private @NotNull Map<@NotNull String, @NotNull EssentialAsset> assetsMap;

    public Cosmetic(@NotNull String id2, @NotNull String type, @NotNull @NotNull Map<@NotNull String, @NotNull String> displayNames, int storePackageId, @Nullable Map<@NotNull String, @NotNull Double> prices, @Nullable Set<@NotNull String> tags, @NotNull DateTime createdAt, @Nullable DateTime availableAfter, @Nullable DateTime availableUntil, @Nullable Map<@NotNull SkinLayer, @NotNull Boolean> skinLayers, @Nullable Map<@NotNull String, @NotNull Integer> categories2, @Nullable Integer defaultSortWeight, @Nullable Integer priceCoins, @Nullable CosmeticTier tier, @NotNull @NotNull Map<@NotNull String, @NotNull EssentialAsset> assetsMap) {
        this.id = id2;
        this.type = type;
        this.displayNames = displayNames;
        this.storePackageId = storePackageId;
        this.prices = prices;
        this.tags = tags;
        this.createdAt = createdAt;
        this.availableAfter = availableAfter;
        this.availableUntil = availableUntil;
        this.skinLayers = skinLayers;
        this.categories = categories2;
        this.defaultSortWeight = defaultSortWeight;
        this.priceCoins = priceCoins;
        this.tier = tier;
        this.assetsMap = assetsMap;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull String> getDisplayNames() {
        return this.displayNames;
    }

    public int getStorePackageId() {
        return this.storePackageId;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull Double> getPrices() {
        if (this.prices == null) {
            this.prices = Collections.emptyMap();
        }
        return this.prices;
    }

    @NotNull
    public @NotNull Set<@NotNull String> getTags() {
        if (this.tags == null) {
            this.tags = Collections.emptySet();
        }
        return this.tags;
    }

    @NotNull
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public DateTime getAvailableAfter() {
        return this.availableAfter;
    }

    @Nullable
    public DateTime getAvailableUntil() {
        return this.availableUntil;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull SkinLayer, @NotNull Boolean> getSkinLayers() {
        if (this.skinLayers == null) {
            this.skinLayers = Collections.emptyMap();
        }
        return this.skinLayers;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull Integer> getCategories() {
        if (this.categories == null) {
            this.categories = Collections.emptyMap();
        }
        return this.categories;
    }

    public boolean isAvailable() {
        return this.availableAfter != null && this.isAvailableAt(new DateTime());
    }

    public boolean isAvailableAt(@NotNull DateTime dateTime) {
        return this.availableAfter != null && this.availableAfter.before(dateTime) && (this.availableUntil == null || this.availableUntil.after(dateTime));
    }

    @Nullable
    public Integer getDefaultSortWeight() {
        return this.defaultSortWeight;
    }

    @Nullable
    public Integer getPriceCoins() {
        return this.priceCoins;
    }

    @Nullable
    public CosmeticTier getTier() {
        return this.tier;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull EssentialAsset> getAssetsMap() {
        return this.assetsMap;
    }
}

