/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.skinmask;

import gg.essential.cosmetics.skinmask.SkinMask;
import gg.essential.lib.caffeine.cache.Cache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.RemovalCause;
import gg.essential.lib.caffeine.cache.RemovalListener;
import gg.essential.lib.caffeine.cache.Scheduler;
import gg.essential.mixins.ext.client.renderer.PlayerSkinTextureExt;
import gg.essential.universal.UImage;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.HelpersKt;
import gg.essential.util.Multithreading;
import gg.essential.util.image.bitmap.Bitmap;
import gg.essential.util.image.bitmap.GuiEssentialExtensionsKt;
import gg.essential.util.image.bitmap.UImageBitmap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaskedSkinProvider {
    private static final DynamicTextureManager dynamicTextureManager = new DynamicTextureManager();
    private class_2960 generatedSkin;
    private SkinMask generatedConfig;
    private class_2960 generatedId;

    public class_2960 provide(class_2960 skin, SkinMask config) {
        if (config.getParts().isEmpty() || !skin.method_12832().startsWith("skins/")) {
            this.generatedSkin = null;
            this.generatedConfig = null;
            return null;
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (skin.equals((Object)this.generatedSkin) && config.equals(this.generatedConfig) && this.generatedId != null) {
            this.generatedConfig = config;
            dynamicTextureManager.keepAlive(this);
            return this.generatedId;
        }
        class_1044 skinTexture = textureManager.method_4619(skin);
        if (skinTexture == null) {
            return null;
        }
        if (!(skinTexture instanceof PlayerSkinTextureExt)) {
            return null;
        }
        PlayerSkinTextureExt skinTextureExt = (PlayerSkinTextureExt)skinTexture;
        UImage skinImage = skinTextureExt.essential$getImage();
        if (skinImage == null) {
            return null;
        }
        Bitmap generatedTexture = config.apply(new UImageBitmap(skinImage));
        this.generatedSkin = skin;
        this.generatedConfig = config;
        this.generatedId = dynamicTextureManager.generateUniqueId(this.generatedSkin.toString().replace(':', '/'));
        dynamicTextureManager.register(this, this.generatedId, (class_1044)new MaskedSkinTexture(GuiEssentialExtensionsKt.toUImage(generatedTexture)));
        return this.generatedId;
    }

    void expireTexture(class_2960 id2) {
        if (id2.equals((Object)this.generatedId)) {
            this.generatedId = null;
        }
        class_310.method_1551().method_1531().method_4615(id2);
    }

    private static class DynamicTextureManager
    implements RemovalListener<MaskedSkinProvider, class_2960> {
        private final Cache<MaskedSkinProvider, class_2960> loaded = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).executor(Multithreading.POOL).scheduler(Scheduler.forScheduledExecutorService(Multithreading.getScheduledPool())).removalListener(this).build();
        private int nextUniqueId;

        private DynamicTextureManager() {
        }

        public class_2960 generateUniqueId(String name2) {
            return HelpersKt.identifier("essential", String.format(Locale.ROOT, "masked_skins/%s/%d", name2, this.nextUniqueId++));
        }

        public void register(MaskedSkinProvider provider2, class_2960 id2, class_1044 texture) {
            class_310.method_1551().method_1531().method_4616(id2, texture);
            this.loaded.put(provider2, id2);
        }

        public void keepAlive(MaskedSkinProvider provider2) {
            this.loaded.getIfPresent(provider2);
        }

        @Override
        public void onRemoval(@Nullable MaskedSkinProvider provider2, @Nullable class_2960 id2, @NotNull RemovalCause cause) {
            if (id2 == null || provider2 == null) {
                return;
            }
            ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> provider2.expireTexture(id2));
        }
    }

    private static class MaskedSkinTexture
    extends class_1046 {
        public MaskedSkinTexture(UImage image2) {
            super(null, "essential-masked-image", class_1068.method_4649(), false, null);
            ((PlayerSkinTextureExt)((Object)this)).essential$setImage(image2);
        }

        public void method_4625(@NotNull class_3300 resourceManager) {
        }
    }
}

