/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.cosmetics.state;

import gg.essential.cosmetics.events.AnimationEvent;
import gg.essential.cosmetics.events.AnimationEventType;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.state.TextureAnimationSync;
import gg.essential.model.Animation;
import gg.essential.model.BedrockModel;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ModelInstance;
import gg.essential.model.molang.MolangQueryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u0006\u0010&\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020 J\u0014\u0010)\u001a\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+J\u0006\u0010-\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgg/essential/cosmetics/state/EssentialAnimationSystem;", "", "bedrockModel", "Lgg/essential/model/BedrockModel;", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "animationState", "Lgg/essential/model/ModelAnimationState;", "textureAnimationSync", "Lgg/essential/cosmetics/state/TextureAnimationSync;", "animationTargets", "", "Lgg/essential/cosmetics/events/AnimationTarget;", "onAnimation", "Lkotlin/Function1;", "", "", "(Lgg/essential/model/BedrockModel;Lgg/essential/model/molang/MolangQueryEntity;Lgg/essential/model/ModelAnimationState;Lgg/essential/cosmetics/state/TextureAnimationSync;Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "animationStates", "Lgg/essential/cosmetics/state/EssentialAnimationSystem$AnimationEffectStates;", "highestPriority", "Lgg/essential/cosmetics/events/AnimationEvent;", "getHighestPriority", "()Lgg/essential/cosmetics/events/AnimationEvent;", "lastFrame", "", "ongoingAnimations", "", "pendingAnimationsForOtherModels", "fireTriggerFromAnimation", "animationName", "requiredType", "Lgg/essential/cosmetics/events/AnimationEventType;", "getAnimationByName", "name", "handleProbability", "", "event", "maybeFireTextureAnimationStartEvent", "processEvent", "type", "triggerPendingAnimationsForOtherModels", "models", "", "Lgg/essential/model/ModelInstance;", "updateAnimationState", "AnimationEffectStates", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nEssentialAnimationSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialAnimationSystem.kt\ngg/essential/cosmetics/state/EssentialAnimationSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1849#2:158\n1849#2,2:159\n1850#2:161\n1895#2,14:162\n*S KotlinDebug\n*F\n+ 1 EssentialAnimationSystem.kt\ngg/essential/cosmetics/state/EssentialAnimationSystem\n*L\n39#1:158\n40#1:159,2\n39#1:161\n90#1:162,14\n*E\n"})
public final class EssentialAnimationSystem {
    @NotNull
    private final BedrockModel bedrockModel;
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final ModelAnimationState animationState;
    @NotNull
    private final TextureAnimationSync textureAnimationSync;
    @NotNull
    private final Set<AnimationTarget> animationTargets;
    @NotNull
    private final Function1<String, Unit> onAnimation;
    @NotNull
    private final Set<AnimationEvent> ongoingAnimations;
    @NotNull
    private final AnimationEffectStates animationStates;
    @NotNull
    private final Set<String> pendingAnimationsForOtherModels;
    private float lastFrame;

    public EssentialAnimationSystem(@NotNull BedrockModel bedrockModel, @NotNull MolangQueryEntity entity, @NotNull ModelAnimationState animationState, @NotNull TextureAnimationSync textureAnimationSync, @NotNull Set<? extends AnimationTarget> animationTargets, @NotNull Function1<? super String, Unit> onAnimation) {
        Intrinsics.checkNotNullParameter((Object)bedrockModel, (String)"bedrockModel");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)animationState, (String)"animationState");
        Intrinsics.checkNotNullParameter((Object)textureAnimationSync, (String)"textureAnimationSync");
        Intrinsics.checkNotNullParameter(animationTargets, (String)"animationTargets");
        Intrinsics.checkNotNullParameter(onAnimation, (String)"onAnimation");
        this.bedrockModel = bedrockModel;
        this.entity = entity;
        this.animationState = animationState;
        this.textureAnimationSync = textureAnimationSync;
        this.animationTargets = animationTargets;
        this.onAnimation = onAnimation;
        this.ongoingAnimations = new LinkedHashSet();
        this.animationStates = new AnimationEffectStates();
        this.pendingAnimationsForOtherModels = new LinkedHashSet();
        this.processEvent(AnimationEventType.IDLE);
        this.processEvent(AnimationEventType.EQUIP);
        this.processEvent(AnimationEventType.EMOTE);
    }

    public final void triggerPendingAnimationsForOtherModels(@NotNull Collection<ModelInstance> models) {
        Intrinsics.checkNotNullParameter(models, (String)"models");
        if (this.pendingAnimationsForOtherModels.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = this.pendingAnimationsForOtherModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String pending = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = models;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ModelInstance it = (ModelInstance)element$iv2;
                boolean bl2 = false;
                it.getEssentialAnimationSystem().fireTriggerFromAnimation(pending, AnimationEventType.BY_OTHER);
            }
        }
        this.pendingAnimationsForOtherModels.clear();
    }

    public final void updateAnimationState() {
        Animation animation;
        List onComplete = new ArrayList();
        CollectionsKt.removeAll((Iterable)this.ongoingAnimations, (Function1)((Function1)new Function1<AnimationEvent, Boolean>(this, (List<AnimationEvent>)onComplete){
            final /* synthetic */ EssentialAnimationSystem this$0;
            final /* synthetic */ List<AnimationEvent> $onComplete;
            {
                this.this$0 = $receiver;
                this.$onComplete = $onComplete;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AnimationEvent ongoingAnimation) {
                Intrinsics.checkNotNullParameter((Object)ongoingAnimation, (String)"ongoingAnimation");
                for (ModelAnimationState.AnimationState animationState : EssentialAnimationSystem.access$getAnimationState$p(this.this$0).getActive()) {
                    boolean remove2;
                    if (!Intrinsics.areEqual((Object)animationState.getAnimation().getName(), (Object)ongoingAnimation.getName()) || ongoingAnimation.getLoops() <= 0) continue;
                    boolean bl = remove2 = animationState.getAnimTime() > animationState.getAnimation().getAnimationLength() * (float)ongoingAnimation.getLoops();
                    if (remove2 && ongoingAnimation.getOnComplete() != null) {
                        this.$onComplete.add(ongoingAnimation.getOnComplete());
                    }
                    return remove2;
                }
                return false;
            }
        }));
        this.ongoingAnimations.addAll(onComplete);
        AnimationEvent highestPriority = this.getHighestPriority();
        CollectionsKt.removeAll(this.animationState.getActive(), (Function1)((Function1)new Function1<ModelAnimationState.AnimationState, Boolean>(this, highestPriority){
            final /* synthetic */ EssentialAnimationSystem this$0;
            final /* synthetic */ AnimationEvent $highestPriority;
            {
                this.this$0 = $receiver;
                this.$highestPriority = $highestPriority;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ModelAnimationState.AnimationState animationState) {
                Intrinsics.checkNotNullParameter((Object)animationState, (String)"animationState");
                AnimationEvent animationByName = EssentialAnimationSystem.access$getAnimationByName(this.this$0, animationState.getAnimation().getName());
                return animationByName == null || animationByName != this.$highestPriority;
            }
        }));
        if (this.animationState.getActive().isEmpty() && highestPriority != null && (animation = this.bedrockModel.getAnimationByName(highestPriority.getName())) != null) {
            if (!((Collection)highestPriority.getTriggerInOtherCosmetic()).isEmpty()) {
                this.pendingAnimationsForOtherModels.addAll((Collection<String>)highestPriority.getTriggerInOtherCosmetic());
            }
            this.animationState.startAnimation(animation);
        }
    }

    private final AnimationEvent getHighestPriority() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.ongoingAnimations;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                AnimationEvent obj = (AnimationEvent)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = obj.getPriority();
                do {
                    Object e$iv = iterator$iv.next();
                    AnimationEvent obj2 = (AnimationEvent)e$iv;
                    $i$a$-maxByOrNull-EssentialAnimationSystem$highestPriority$1 = false;
                    int v$iv = obj2.getPriority();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private final AnimationEvent getAnimationByName(String name2) {
        for (AnimationEvent ongoingAnimation : this.ongoingAnimations) {
            if (!Intrinsics.areEqual((Object)ongoingAnimation.getName(), (Object)name2)) continue;
            return ongoingAnimation;
        }
        return null;
    }

    public final void processEvent(@NotNull AnimationEventType type) {
        AnimationEvent highestPriority;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List<AnimationEvent> animationEvents = this.bedrockModel.getAnimationEvents();
        AnimationEvent animationEvent = highestPriority = this.getHighestPriority();
        int priority = animationEvent != null ? animationEvent.getPriority() : 0;
        boolean needsUpdate = false;
        for (AnimationEvent event : animationEvents) {
            if (priority > event.getPriority() || event.getType() != type || event.getTarget() != AnimationTarget.ALL && !CollectionsKt.contains((Iterable)this.animationTargets, (Object)((Object)event.getTarget()))) continue;
            if (event.getSkips() != 0) {
                Integer n = this.animationStates.getSkips().get(event);
                if (n == null) {
                    n = 0;
                }
                int i2 = n + 1;
                Integer n2 = i2;
                ((Map)this.animationStates.getSkips()).put(event, n2);
                if (i2 % event.getSkips() != 0) continue;
            }
            if (!this.handleProbability(event)) continue;
            if (event.getTarget() != AnimationTarget.SELF) {
                this.onAnimation.invoke((Object)event.getName());
            }
            this.ongoingAnimations.add(event);
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.updateAnimationState();
        }
    }

    public final void fireTriggerFromAnimation(@NotNull String animationName, @Nullable AnimationEventType requiredType) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (Intrinsics.areEqual((Object)animationName, (Object)"texture_start")) {
            this.textureAnimationSync.syncTextureStart();
            return;
        }
        for (AnimationEvent animationEvent : this.bedrockModel.getAnimationEvents()) {
            if (!Intrinsics.areEqual((Object)animationEvent.getName(), (Object)animationName) || requiredType != null && animationEvent.getType() != requiredType) continue;
            this.ongoingAnimations.add(animationEvent);
            this.updateAnimationState();
            break;
        }
    }

    public static /* synthetic */ void fireTriggerFromAnimation$default(EssentialAnimationSystem essentialAnimationSystem, String string, AnimationEventType animationEventType, int n, Object object) {
        if ((n & 2) != 0) {
            animationEventType = null;
        }
        essentialAnimationSystem.fireTriggerFromAnimation(string, animationEventType);
    }

    private final boolean handleProbability(AnimationEvent event) {
        return (double)event.getProbability() > Random.Default.nextDouble();
    }

    public final void maybeFireTextureAnimationStartEvent() {
        int totalFrames = this.bedrockModel.getTextureFrameCount();
        int frame = (int)(this.entity.getLifeTime() * 7.0f);
        if ((float)(frame % totalFrames) < this.lastFrame) {
            this.onAnimation.invoke((Object)"texture_start");
            this.processEvent(AnimationEventType.TEXTURE_ANIMATION_START);
        }
        this.lastFrame = frame % totalFrames;
    }

    public static final /* synthetic */ ModelAnimationState access$getAnimationState$p(EssentialAnimationSystem $this) {
        return $this.animationState;
    }

    public static final /* synthetic */ AnimationEvent access$getAnimationByName(EssentialAnimationSystem $this, String name2) {
        return $this.getAnimationByName(name2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R6\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgg/essential/cosmetics/state/EssentialAnimationSystem$AnimationEffectStates;", "", "()V", "skips", "Ljava/util/HashMap;", "Lgg/essential/cosmetics/events/AnimationEvent;", "", "Lkotlin/collections/HashMap;", "getSkips", "()Ljava/util/HashMap;", "setSkips", "(Ljava/util/HashMap;)V", "cosmetics"})
    private static final class AnimationEffectStates {
        @NotNull
        private HashMap<AnimationEvent, Integer> skips = new HashMap();

        @NotNull
        public final HashMap<AnimationEvent, Integer> getSkips() {
            return this.skips;
        }

        public final void setSkips(@NotNull HashMap<AnimationEvent, Integer> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            this.skips = hashMap;
        }
    }
}

