/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.event.render;

import gg.essential.universal.UMatrixStack;
import gg.essential.util.UDrawContext;
import org.jetbrains.annotations.Nullable;

public final class RenderTickEvent {
    private final boolean pre;
    private final boolean loadingScreen;
    private final UMatrixStack matrixStack;
    private final UDrawContext drawContext;
    private final float partialTicksMenu;
    private final float partialTicksInGame;

    public RenderTickEvent(boolean pre, boolean loadingScreen, UDrawContext drawContext, UMatrixStack matrixStack, float partialTicksMenu, float partialTicksInGame) {
        this.pre = pre;
        this.loadingScreen = loadingScreen;
        this.matrixStack = matrixStack;
        this.drawContext = drawContext;
        this.partialTicksMenu = partialTicksMenu;
        this.partialTicksInGame = partialTicksInGame;
        if (!pre && drawContext == null) {
            throw new IllegalArgumentException("Post event requires draw context");
        }
    }

    public boolean isPre() {
        return this.pre;
    }

    public boolean isLoadingScreen() {
        return this.loadingScreen;
    }

    @Nullable
    public UDrawContext getDrawContext() {
        return this.drawContext;
    }

    public UMatrixStack getMatrixStack() {
        return this.matrixStack;
    }

    public float getPartialTicksMenu() {
        return this.partialTicksMenu;
    }

    public float getPartialTicksInGame() {
        return this.partialTicksInGame;
    }
}

