/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.effect;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.effects.Effect;
import gg.essential.gui.EssentialPalette;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lgg/essential/gui/common/effect/CheckerboardBackgroundEffect;", "Lgg/essential/elementa/effects/Effect;", "()V", "beforeDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawCheckerBoard", "component", "Lgg/essential/elementa/UIComponent;", "drawVertex", "graphics", "Lgg/essential/universal/UGraphics;", "x", "", "y", "color", "Ljava/awt/Color;", "essential-gui-essential"})
public final class CheckerboardBackgroundEffect
extends Effect {
    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.drawCheckerBoard(matrixStack, this.getBoundComponent());
    }

    private final void drawCheckerBoard(UMatrixStack matrixStack, UIComponent component3) {
        double left = component3.getLeft();
        double top = component3.getTop();
        double right = component3.getRight();
        double bottom = component3.getBottom();
        UGraphics graphics = UGraphics.getFromTessellator();
        graphics.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        int n = (int)(right - left);
        for (int x = 0; x < n; ++x) {
            int n2 = (int)(bottom - top);
            for (int y = 0; y < n2; ++y) {
                Color color2 = (x + y) % 2 == 0 ? Color.LIGHT_GRAY : EssentialPalette.TEXT_HIGHLIGHT;
                Intrinsics.checkNotNull((Object)graphics);
                double d = left + (double)x;
                double d2 = top + (double)y;
                Intrinsics.checkNotNull((Object)color2);
                this.drawVertex(graphics, matrixStack, d, d2, color2);
                this.drawVertex(graphics, matrixStack, left + (double)x, top + (double)y + 1.0, color2);
                this.drawVertex(graphics, matrixStack, left + (double)x + 1.0, top + (double)y + 1.0, color2);
                this.drawVertex(graphics, matrixStack, left + (double)x + 1.0, top + (double)y, color2);
            }
        }
        graphics.drawDirect();
    }

    private final void drawVertex(UGraphics graphics, UMatrixStack matrixStack, double x, double y, Color color2) {
        graphics.pos(matrixStack, x, y, 0.0).color((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, (float)color2.getAlpha() / 255.0f).endVertex();
    }
}

