/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.effects;

import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.SamplerUniform;
import gg.essential.universal.shader.UShader;
import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgg/essential/gui/effects/AlphaEffect;", "Lgg/essential/elementa/effects/Effect;", "alphaState", "Lgg/essential/elementa/state/State;", "", "(Lgg/essential/elementa/state/State;)V", "resources", "Lgg/essential/gui/effects/AlphaEffect$Resources;", "textureHeight", "", "textureWidth", "afterDraw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "beforeDraw", "cleanup", "setup", "Companion", "Resources", "essential-elementa-layoutdsl"})
public final class AlphaEffect
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State<Float> alphaState;
    @NotNull
    private final Resources resources;
    private int textureWidth;
    private int textureHeight;
    private static UShader shader;
    private static SamplerUniform textureUniform;

    public AlphaEffect(@NotNull State<Float> alphaState) {
        Intrinsics.checkNotNullParameter(alphaState, (String)"alphaState");
        this.alphaState = alphaState;
        this.resources = new Resources(this);
        this.textureWidth = -1;
        this.textureHeight = -1;
    }

    public void setup() {
        AlphaEffect.Companion.initShader();
        Resources.Companion.drainCleanupQueue();
        this.resources.setTextureId(GL11.glGenTextures());
    }

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        int height2;
        int width2;
        int y;
        int x;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                if (this.resources.getTextureId() == -1) {
                    throw new IllegalStateException("AlphaEffect has not yet been setup or has already been cleaned up! ElementaVersion.V4 or newer is required for proper operation!".toString());
                }
                double scale2 = UResolution.getScaleFactor();
                int left = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getLeft() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
                int right = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getRight() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportWidth())));
                int top = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getTop() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
                int bottom = RangesKt.coerceIn((int)((int)((double)this.getBoundComponent().getBottom() * scale2)), (ClosedRange)((ClosedRange)new IntRange(0, UResolution.getViewportHeight())));
                x = left;
                y = UResolution.getViewportHeight() - bottom;
                width2 = right - left;
                height2 = bottom - top;
                if (width2 == 0 || height2 == 0) break block5;
                UShader uShader = shader;
                if (uShader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                    uShader = null;
                }
                if (uShader.getUsable()) break block6;
            }
            return;
        }
        UGraphics.configureTexture((int)this.resources.getTextureId(), () -> AlphaEffect.beforeDraw$lambda$0(width2, this, height2, x, y));
    }

    public void afterDraw(@NotNull UMatrixStack matrixStack) {
        UShader uShader;
        double height2;
        double width2;
        double y;
        double x;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                double left = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getLeft()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportWidth() / UResolution.getScaleFactor()))))).doubleValue();
                double right = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getRight()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportWidth() / UResolution.getScaleFactor()))))).doubleValue();
                double top = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getTop()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportHeight() / UResolution.getScaleFactor()))))).doubleValue();
                double bottom = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.getBoundComponent().getBottom()), (ClosedFloatingPointRange)RangesKt.rangeTo((double)0.0, (double)((double)UResolution.getViewportHeight() / UResolution.getScaleFactor()))))).doubleValue();
                x = left;
                y = top;
                width2 = right - left;
                height2 = bottom - top;
                if (width2 == 0.0 || height2 == 0.0) break block9;
                UShader uShader2 = shader;
                if (uShader2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                    uShader2 = null;
                }
                if (uShader2.getUsable()) break block10;
            }
            return;
        }
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f - ((Number)this.alphaState.get()).floatValue();
        int prevAlphaTestFunc = 0;
        float prevAlphaTestRef = 0.0f;
        if (!UGraphics.isCoreProfile()) {
            prevAlphaTestFunc = GL11.glGetInteger((int)3009);
            prevAlphaTestRef = GL11.glGetFloat((int)3010);
            UGraphics.alphaFunc((int)519, (float)0.0f);
        }
        if ((uShader = shader) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader = null;
        }
        uShader.bind();
        SamplerUniform samplerUniform = textureUniform;
        if (samplerUniform == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureUniform");
            samplerUniform = null;
        }
        samplerUniform.setValue(this.resources.getTextureId());
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        worldRenderer.beginWithActiveShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        worldRenderer.pos(matrixStack, x, y + height2, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y + height2, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.drawDirect();
        UShader uShader3 = shader;
        if (uShader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader3 = null;
        }
        uShader3.unbind();
        if (!UGraphics.isCoreProfile()) {
            UGraphics.alphaFunc((int)prevAlphaTestFunc, (float)prevAlphaTestRef);
        }
    }

    public final void cleanup() {
        this.resources.close();
    }

    private static final void beforeDraw$lambda$0(int $width, AlphaEffect this$0, int $height, int $x, int $y) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if ($width != this$0.textureWidth || $height != this$0.textureHeight) {
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)$width, (int)$height, (int)0, (int)6408, (int)5121, null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            this$0.textureWidth = $width;
            this$0.textureHeight = $height;
        }
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)$x, (int)$y, (int)$width, (int)$height);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Companion;", "", "()V", "shader", "Lgg/essential/universal/shader/UShader;", "textureUniform", "Lgg/essential/universal/shader/SamplerUniform;", "initShader", "", "essential-elementa-layoutdsl"})
    public static final class Companion {
        private Companion() {
        }

        private final void initShader() {
            if (shader != null) {
                return;
            }
            shader = UShader.Companion.fromLegacyShader("#version 110\n\nvarying vec2 f_Position;\nvarying vec2 f_TexCoord;\n\nvoid main() {\n    f_Position = gl_Vertex.xy;\n    f_TexCoord = gl_MultiTexCoord0.st;\n\n    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n    gl_FrontColor = gl_Color;\n}", "#version 110\n\nuniform sampler2D u_Texture;\n\nvarying vec2 f_Position;\nvarying vec2 f_TexCoord;\n\nvoid main() {\n    gl_FragColor = gl_Color * vec4(texture2D(u_Texture, f_TexCoord).rgb, 1.0);\n}", BlendState.NORMAL, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            UShader uShader = shader;
            if (uShader == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader = null;
            }
            if (!uShader.getUsable()) {
                System.out.println((Object)"Failed to load AlphaEffect shader");
                return;
            }
            UShader uShader2 = shader;
            if (uShader2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                uShader2 = null;
            }
            textureUniform = uShader2.getSamplerUniform("u_Texture");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Resources;", "Ljava/lang/ref/PhantomReference;", "Lgg/essential/gui/effects/AlphaEffect;", "Ljava/io/Closeable;", "effect", "(Lgg/essential/gui/effects/AlphaEffect;)V", "textureId", "", "getTextureId", "()I", "setTextureId", "(I)V", "close", "", "Companion", "essential-elementa-layoutdsl"})
    private static final class Resources
    extends PhantomReference<AlphaEffect>
    implements Closeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int textureId;
        @NotNull
        private static final ReferenceQueue<AlphaEffect> referenceQueue = new ReferenceQueue();
        @NotNull
        private static final Set<Resources> toBeCleanedUp;

        public Resources(@NotNull AlphaEffect effect2) {
            Intrinsics.checkNotNullParameter((Object)((Object)effect2), (String)"effect");
            super(effect2, referenceQueue);
            this.textureId = -1;
            toBeCleanedUp.add(this);
        }

        public final int getTextureId() {
            return this.textureId;
        }

        public final void setTextureId(int n) {
            this.textureId = n;
        }

        @Override
        public void close() {
            toBeCleanedUp.remove(this);
            if (this.textureId != -1) {
                GL11.glDeleteTextures((int)this.textureId);
                this.textureId = -1;
            }
        }

        static {
            Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(...)");
            toBeCleanedUp = set2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/effects/AlphaEffect$Resources$Companion;", "", "()V", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "Lgg/essential/gui/effects/AlphaEffect;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "toBeCleanedUp", "", "Lgg/essential/gui/effects/AlphaEffect$Resources;", "getToBeCleanedUp", "()Ljava/util/Set;", "drainCleanupQueue", "", "essential-elementa-layoutdsl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ReferenceQueue<AlphaEffect> getReferenceQueue() {
                return referenceQueue;
            }

            @NotNull
            public final Set<Resources> getToBeCleanedUp() {
                return toBeCleanedUp;
            }

            public final void drainCleanupQueue() {
                while (true) {
                    Reference<AlphaEffect> reference = this.getReferenceQueue().poll();
                    if (reference == null) break;
                    ((Resources)reference).close();
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

