/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.friends.state;

import gg.essential.api.gui.NotificationBuilder;
import gg.essential.connectionmanager.common.model.relationships.Relationship;
import gg.essential.elementa.utils.ObservableList;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.friends.state.IRelationshipManager;
import gg.essential.gui.friends.state.IRelationshipStates;
import gg.essential.gui.friends.state.RelationshipStateManagerImpl;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.relationship.RelationshipManager;
import gg.essential.network.connectionmanager.relationship.RelationshipResponse;
import gg.essential.network.connectionmanager.relationship.RelationshipResponseKt;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.StringsKt;
import gg.essential.util.UUIDUtil;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\rJ\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u000f\u0010\u0018\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ9\u0010 \u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000b0\u001dH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010\"\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\"\u0010\rJ\u0017\u0010#\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b#\u0010\u001aJ\u0017\u0010$\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b$\u0010\u001aJ\u0015\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0016\u00a2\u0006\u0004\b(\u0010'J\u0015\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0016\u00a2\u0006\u0004\b)\u0010'J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070%H\u0016\u00a2\u0006\u0004\b*\u0010'J\u0019\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b.\u0010\u001aJ\u0017\u0010/\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b/\u0010\u001aJ\u0017\u00100\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b0\u0010\u001aJ\u0017\u00101\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b1\u0010\u001aJ\u001f\u00102\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b2\u0010\rJ\u001f\u00103\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b3\u0010\rR\"\u00105\u001a\u0010\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00070\u00070%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\"\u00107\u001a\u0010\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00070\u00070%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00106R\"\u00108\u001a\u0010\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00070\u00070%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00106R\"\u00109\u001a\u0010\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00070\u00070%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00106R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010:\u00a8\u0006;"}, d2={"Lgg/essential/gui/friends/state/RelationshipStateManagerImpl;", "Lgg/essential/gui/friends/state/IRelationshipStates;", "Lgg/essential/gui/friends/state/IRelationshipManager;", "Lgg/essential/network/connectionmanager/relationship/RelationshipManager;", "relationshipManager", "<init>", "(Lgg/essential/network/connectionmanager/relationship/RelationshipManager;)V", "Ljava/util/UUID;", "uuid", "", "notification", "", "acceptIncomingFriendRequest", "(Ljava/util/UUID;Z)V", "Ljava/util/concurrent/CompletableFuture;", "Lgg/essential/network/connectionmanager/relationship/RelationshipResponse;", "addFriend", "(Ljava/util/UUID;Z)Ljava/util/concurrent/CompletableFuture;", "blockPlayer", "cancelOutgoingFriendRequest", "clearAllIncomingRequests", "()V", "clearAllOutgoingRequests", "clearBlocked", "clearFriends", "clearIncomingFriendRequest", "(Ljava/util/UUID;)V", "clearOutgoingFriendRequest", "future", "Lkotlin/Function1;", "", "onSuccess", "consumeRelationshipFuture", "(Ljava/util/UUID;Ljava/util/concurrent/CompletableFuture;Lkotlin/jvm/functions/Function1;)V", "declineIncomingFriendRequest", "friendAdded", "friendRemoved", "Lgg/essential/elementa/utils/ObservableList;", "getObservableBlockedList", "()Lgg/essential/elementa/utils/ObservableList;", "getObservableFriendList", "getObservableIncomingRequests", "getObservableOutgoingRequests", "Ljava/time/Instant;", "getPendingRequestTime", "(Ljava/util/UUID;)Ljava/time/Instant;", "newIncomingFriendRequest", "newOutgoingFriendRequest", "playerBlocked", "playerUnblocked", "removeFriend", "unblockPlayer", "kotlin.jvm.PlatformType", "observableBlockedList", "Lgg/essential/elementa/utils/ObservableList;", "observableFriendList", "observableIncomingList", "observableOutgoingList", "Lgg/essential/network/connectionmanager/relationship/RelationshipManager;", "Essential 1.21-fabric"})
public final class RelationshipStateManagerImpl
implements IRelationshipStates,
IRelationshipManager {
    @NotNull
    private final RelationshipManager relationshipManager;
    @NotNull
    private final ObservableList<UUID> observableFriendList;
    @NotNull
    private final ObservableList<UUID> observableBlockedList;
    @NotNull
    private final ObservableList<UUID> observableIncomingList;
    @NotNull
    private final ObservableList<UUID> observableOutgoingList;

    public RelationshipStateManagerImpl(@NotNull RelationshipManager relationshipManager) {
        Intrinsics.checkNotNullParameter((Object)relationshipManager, (String)"relationshipManager");
        this.relationshipManager = relationshipManager;
        this.observableFriendList = new ObservableList(CollectionsKt.toMutableList((Collection)this.relationshipManager.getFriends().keySet()));
        this.observableBlockedList = new ObservableList(CollectionsKt.toMutableList((Collection)this.relationshipManager.getBlockedByMe().keySet()));
        this.observableIncomingList = new ObservableList(CollectionsKt.toMutableList((Collection)this.relationshipManager.getIncomingFriendRequests().keySet()));
        this.observableOutgoingList = new ObservableList(CollectionsKt.toMutableList((Collection)this.relationshipManager.getOutgoingFriendRequests().keySet()));
        this.relationshipManager.registerStateManager(this);
    }

    @Override
    @NotNull
    public ObservableList<UUID> getObservableFriendList() {
        return this.observableFriendList;
    }

    @Override
    @NotNull
    public ObservableList<UUID> getObservableBlockedList() {
        return this.observableBlockedList;
    }

    @Override
    @NotNull
    public ObservableList<UUID> getObservableIncomingRequests() {
        return this.observableIncomingList;
    }

    @Override
    @NotNull
    public ObservableList<UUID> getObservableOutgoingRequests() {
        return this.observableOutgoingList;
    }

    @Override
    @NotNull
    public CompletableFuture<RelationshipResponse> addFriend(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.addFriend(uuid, notification);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)addFriend.1.INSTANCE));
        }
        Intrinsics.checkNotNull(future2);
        return future2;
    }

    @Override
    public void removeFriend(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.removeFriend(uuid);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)removeFriend.1.INSTANCE));
        }
    }

    @Override
    public void acceptIncomingFriendRequest(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.acceptFriend(uuid);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(uuid){
                final /* synthetic */ UUID $uuid;
                {
                    this.$uuid = $uuid;
                    super(1);
                }

                public final void invoke(@NotNull String username) {
                    Intrinsics.checkNotNullParameter((Object)username, (String)"username");
                    gg.essential.api.gui.Notifications.push$default(Notifications.INSTANCE, "", "", 0.0f, null, null, (Function1)new Function1<NotificationBuilder, Unit>(this.$uuid, username){
                        final /* synthetic */ UUID $uuid;
                        final /* synthetic */ String $username;
                        {
                            this.$uuid = $uuid;
                            this.$username = $username;
                            super(1);
                        }

                        public final void invoke(@NotNull NotificationBuilder $this$push) {
                            Intrinsics.checkNotNullParameter((Object)$this$push, (String)"$this$push");
                            ExtensionsKt.iconAndMarkdownBody$default($this$push, CachedAvatarImage.create(this.$uuid), StringsKt.colored(this.$username, EssentialPalette.TEXT_HIGHLIGHT) + " accepted your friend request", null, 4, null);
                        }
                    }, 28, null);
                }
            }));
        }
    }

    @Override
    @NotNull
    public CompletableFuture<RelationshipResponse> blockPlayer(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.createBlockedRelationship(uuid, notification);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)blockPlayer.1.INSTANCE));
        }
        Intrinsics.checkNotNull(future2);
        return future2;
    }

    @Override
    public void unblockPlayer(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.unblock(uuid);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)unblockPlayer.1.INSTANCE));
        }
    }

    @Override
    public void declineIncomingFriendRequest(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.denyFriend(uuid);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)declineIncomingFriendRequest.1.INSTANCE));
        }
    }

    @Override
    public void cancelOutgoingFriendRequest(@NotNull UUID uuid, boolean notification) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletableFuture<RelationshipResponse> future2 = this.relationshipManager.cancelFriendRequest(uuid);
        if (notification) {
            Intrinsics.checkNotNull(future2);
            this.consumeRelationshipFuture(uuid, future2, (Function1<? super String, Unit>)((Function1)cancelOutgoingFriendRequest.1.INSTANCE));
        }
    }

    @Override
    @Nullable
    public Instant getPendingRequestTime(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Relationship relationship = this.relationshipManager.getIncomingFriendRequest(uuid);
        if (relationship == null && (relationship = this.relationshipManager.getOutgoingFriendRequest(uuid)) == null) {
            return null;
        }
        Relationship relationship2 = relationship;
        return relationship2.getSince().toInstant();
    }

    private final void consumeRelationshipFuture(UUID uuid, CompletableFuture<RelationshipResponse> future2, Function1<? super String, Unit> onSuccess) {
        EssentialGuiExtensionsKt.thenAcceptOnMainThread(future2, (Function1)new Function1<RelationshipResponse, Unit>(uuid, onSuccess){
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ Function1<String, Unit> $onSuccess;
            {
                this.$uuid = $uuid;
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull RelationshipResponse it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                switch (consumeRelationshipFuture.WhenMappings.$EnumSwitchMapping$0[it.getFriendRequestState().ordinal()]) {
                    case 1: {
                        CompletableFuture<String> completableFuture = UUIDUtil.getName(this.$uuid);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"getName(...)");
                        EssentialGuiExtensionsKt.thenAcceptOnMainThread(completableFuture, (Function1)new Function1<String, Unit>(this.$onSuccess){
                            final /* synthetic */ Function1<String, Unit> $onSuccess;
                            {
                                this.$onSuccess = $onSuccess;
                                super(1);
                            }

                            public final void invoke(String username) {
                                Intrinsics.checkNotNull((Object)username);
                                this.$onSuccess.invoke((Object)username);
                            }
                        });
                        break;
                    }
                    case 2: {
                        if (it.getRelationshipErrorResponse() == null) {
                            String string = RelationshipResponseKt.getMessage(it);
                            if (string == null) {
                                string = "";
                            }
                            ExtensionsKt.error$default(Notifications.INSTANCE, "Error", string, null, null, null, 28, null);
                            break;
                        }
                        RelationshipResponseKt.displayToast(it, this.$uuid);
                    }
                }
            }
        });
    }

    @Override
    public void friendAdded(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableFriendList.add((Object)uuid);
    }

    @Override
    public void friendRemoved(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableFriendList.remove((Object)uuid);
    }

    @Override
    public void clearFriends() {
        this.observableFriendList.clear();
    }

    @Override
    public void playerBlocked(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableBlockedList.add((Object)uuid);
    }

    @Override
    public void playerUnblocked(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableBlockedList.remove((Object)uuid);
    }

    @Override
    public void clearBlocked() {
        this.observableBlockedList.clear();
    }

    @Override
    public void newIncomingFriendRequest(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableIncomingList.add((Object)uuid);
    }

    @Override
    public void clearIncomingFriendRequest(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableIncomingList.remove((Object)uuid);
    }

    @Override
    public void clearAllIncomingRequests() {
        this.observableIncomingList.clear();
    }

    @Override
    public void newOutgoingFriendRequest(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableOutgoingList.add((Object)uuid);
    }

    @Override
    public void clearOutgoingFriendRequest(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.observableOutgoingList.remove((Object)uuid);
    }

    @Override
    public void clearAllOutgoingRequests() {
        this.observableOutgoingList.clear();
    }
}

