/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.components;

import gg.essential.Essential;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ChildBasedSizeConstraint;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.constraints.CopyConstraintFloat;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.SiblingConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.ContextOptionMenu;
import gg.essential.gui.common.ExtensionsKt;
import gg.essential.gui.common.IconButton;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.screenshot.LocalScreenshot;
import gg.essential.gui.screenshot.RemoteScreenshot;
import gg.essential.gui.screenshot.ScreenshotId;
import gg.essential.gui.screenshot.components.FocusEditComponent;
import gg.essential.gui.screenshot.components.FocusType;
import gg.essential.gui.screenshot.components.ScreenshotBrowser;
import gg.essential.gui.screenshot.components.ScreenshotComponentsKt;
import gg.essential.gui.screenshot.components.ScreenshotProperties;
import gg.essential.gui.screenshot.components.ShareButton;
import gg.essential.gui.util.ElementaExtensionsKt;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.media.model.Media;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JA\u0010\u000f\u001a\u00020\r2\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001b\u0010\u001c\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020!0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lgg/essential/gui/screenshot/components/ShareButton;", "Lgg/essential/elementa/components/UIContainer;", "Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "screenshotBrowser", "<init>", "(Lgg/essential/gui/screenshot/components/ScreenshotBrowser;)V", "Lkotlin/Function2;", "Ljava/io/File;", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "Ljava/util/concurrent/CompletableFuture;", "withUnsavedEdits", "Lkotlin/Function1;", "Lgg/essential/gui/screenshot/ScreenshotId;", "", "withoutUnsavedEdits", "checkForUnsavedEditsAndRun", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "openMenu", "()V", "Lgg/essential/gui/common/IconButton$Dimension;", "dimension", "setDimension", "(Lgg/essential/gui/common/IconButton$Dimension;)Lgg/essential/gui/screenshot/components/ShareButton;", "Lgg/essential/elementa/UIComponent;", "image$delegate", "Lkotlin/properties/ReadWriteProperty;", "getImage", "()Lgg/essential/elementa/UIComponent;", "image", "Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "getScreenshotBrowser", "()Lgg/essential/gui/screenshot/components/ScreenshotBrowser;", "Lgg/essential/elementa/state/State;", "", "shareHovered", "Lgg/essential/elementa/state/State;", "Lgg/essential/elementa/state/BasicState;", "shouldMenuExist", "Lgg/essential/elementa/state/BasicState;", "Essential 1.21-fabric"})
@SourceDebugExtension(value={"SMAP\nShareButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShareButton.kt\ngg/essential/gui/screenshot/components/ShareButton\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 Extensions.kt\ngg/essential/vigilance/utils/ExtensionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,200:1\n9#2,3:201\n22#3,5:204\n37#4,2:209\n*S KotlinDebug\n*F\n+ 1 ShareButton.kt\ngg/essential/gui/screenshot/components/ShareButton\n*L\n54#1:201,3\n58#1:204,5\n131#1:209,2\n*E\n"})
public final class ShareButton
extends UIContainer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ScreenshotBrowser screenshotBrowser;
    @NotNull
    private final State<Boolean> shareHovered;
    @NotNull
    private final BasicState<Boolean> shouldMenuExist;
    @NotNull
    private final ReadWriteProperty image$delegate;

    public ShareButton(@NotNull ScreenshotBrowser screenshotBrowser) {
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter((Object)((Object)screenshotBrowser), (String)"screenshotBrowser");
        this.screenshotBrowser = screenshotBrowser;
        this.shareHovered = ElementaExtensionsKt.hoveredState$default((UIComponent)this, false, false, 3, null);
        this.shouldMenuExist = new BasicState((Object)false);
        this.image$delegate = ComponentsKt.provideDelegate((UIComponent)ComponentsKt.childOf((UIComponent)new IconButton(EssentialPalette.UPLOAD_9X, null, "Share", false, false, false, false, 122, null).rebindIconColor(EssentialPalette.INSTANCE.getTextColor((State<Boolean>)((State)ExtensionsKt.or(this.shareHovered, (State<Boolean>)((State)this.shouldMenuExist))))).setColor((ColorConstraint)gg.essential.elementa.state.ExtensionsKt.toConstraint(EssentialPalette.INSTANCE.getButtonColor((State<Boolean>)((State)ExtensionsKt.or(this.shareHovered, (State<Boolean>)((State)this.shouldMenuExist)))))), (UIComponent)((UIComponent)this)), (Object)((Object)this), $$delegatedProperties[0]);
        UIComponent $this$constrain$iv = (UIComponent)this;
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints $this$_init__u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setWidth((WidthConstraint)new ChildBasedSizeConstraint(0.0f, 1, null));
        $this$_init__u24lambda_u240.setHeight((HeightConstraint)new ChildBasedSizeConstraint(0.0f, 1, null));
        UIComponent $this$onLeftClick$iv = this.getImage();
        boolean $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ShareButton this$0;
            {
                this.this$0 = shareButton;
                super(2);
            }

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$_init__u24lambda_u241 = $this$onMouseClick;
                    boolean bl = false;
                    ShareButton.access$getShouldMenuExist$p(this.this$0).set((Function1)2.1.INSTANCE);
                }
            }
        });
        this.shouldMenuExist.onSetValue((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (it) {
                    this.openMenu();
                }
            }
        });
    }

    @NotNull
    public final ScreenshotBrowser getScreenshotBrowser() {
        return this.screenshotBrowser;
    }

    private final UIComponent getImage() {
        return (UIComponent)this.image$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void openMenu() {
        List options2 = new ArrayList();
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager connectionManager2 = connectionManager;
        ScreenshotManager screenshotManager = connectionManager2.getScreenshotManager();
        Intrinsics.checkNotNullExpressionValue((Object)screenshotManager, (String)"getScreenshotManager(...)");
        ScreenshotManager screenshotManager2 = screenshotManager;
        FocusEditComponent editComponent = this.screenshotBrowser.getFocusEditComponent();
        if (OnboardingData.hasAcceptedTos() && connectionManager2.isAuthenticated()) {
            options2.add(new ContextOptionMenu.Option("Send to Friends", EssentialPalette.SOCIAL_10X, null, null, null, null, null, (Function0)new Function0<Unit>(this){
                final /* synthetic */ ShareButton this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ShareButton.access$checkForUnsavedEditsAndRun(this.this$0, openMenu.1.INSTANCE, openMenu.2.INSTANCE);
                }
            }, 124, null));
        }
        options2.add(new ContextOptionMenu.Option("Copy Picture", EssentialPalette.COPY_10X7, null, null, null, null, null, (Function0)new Function0<Unit>(editComponent, this, screenshotManager2){
            final /* synthetic */ FocusEditComponent $editComponent;
            final /* synthetic */ ShareButton this$0;
            final /* synthetic */ ScreenshotManager $screenshotManager;
            {
                this.$editComponent = $editComponent;
                this.this$0 = $receiver;
                this.$screenshotManager = $screenshotManager;
                super(0);
            }

            public final void invoke() {
                if (this.$editComponent.hasEdits()) {
                    CompletionStage completionStage;
                    CompletableFuture<File> completableFuture = this.$editComponent.exportEditImageToTempFile();
                    CompletionStage completionStage2 = completionStage = completableFuture != null ? completableFuture.thenAcceptAsync(arg_0 -> openMenu.2.invoke$lambda$0((Function1)new Function1<File, Unit>(this.$screenshotManager){
                        final /* synthetic */ ScreenshotManager $screenshotManager;
                        {
                            this.$screenshotManager = $screenshotManager;
                            super(1);
                        }

                        public final void invoke(File it) {
                            this.$screenshotManager.copyScreenshotToClipboard(it);
                            FileUtils.deleteQuietly((File)it);
                        }
                    }, arg_0), gg.essential.util.ExtensionsKt.getExecutor(UMinecraft.getMinecraft())) : null;
                    if (completionStage == null) {
                        gg.essential.gui.notification.ExtensionsKt.error$default(Notifications.INSTANCE, "Picture export failed", "", null, null, null, 28, null);
                    }
                } else {
                    Object object = (ScreenshotProperties)this.this$0.getScreenshotBrowser().getFocusing().get();
                    if (object == null || (object = ((ScreenshotProperties)object).getId()) == null) {
                        return;
                    }
                    Object id2 = object;
                    this.$screenshotManager.copyScreenshotToClipboard((ScreenshotId)id2);
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, 124, null));
        if (OnboardingData.hasAcceptedTos() && connectionManager2.isAuthenticated()) {
            options2.add(new ContextOptionMenu.Option("Copy Link", EssentialPalette.LINK_10X7, null, null, null, null, null, (Function0)new Function0<Unit>(this, screenshotManager2){
                final /* synthetic */ ShareButton this$0;
                final /* synthetic */ ScreenshotManager $screenshotManager;
                {
                    this.this$0 = $receiver;
                    this.$screenshotManager = $screenshotManager;
                    super(0);
                }

                public final void invoke() {
                    ShareButton.access$checkForUnsavedEditsAndRun(this.this$0, (Function2)new Function2<File, ClientScreenshotMetadata, CompletableFuture<?>>(this.$screenshotManager){
                        final /* synthetic */ ScreenshotManager $screenshotManager;
                        {
                            this.$screenshotManager = $screenshotManager;
                            super(2);
                        }

                        @NotNull
                        public final CompletableFuture<?> invoke(@NotNull File file, @NotNull ClientScreenshotMetadata metadata2) {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
                            CompletableFuture<Media> completableFuture = this.$screenshotManager.uploadAndCopyLinkToClipboard(file.toPath(), metadata2);
                            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"uploadAndCopyLinkToClipboard(...)");
                            return completableFuture;
                        }
                    }, (Function1)new Function1<ScreenshotId, Unit>(this.$screenshotManager){
                        final /* synthetic */ ScreenshotManager $screenshotManager;
                        {
                            this.$screenshotManager = $screenshotManager;
                            super(1);
                        }

                        public final void invoke(@NotNull ScreenshotId id2) {
                            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                            ScreenshotId screenshotId = id2;
                            if (screenshotId instanceof LocalScreenshot) {
                                this.$screenshotManager.uploadAndCopyLinkToClipboard(((LocalScreenshot)id2).getPath());
                            } else if (screenshotId instanceof RemoteScreenshot) {
                                this.$screenshotManager.copyLinkToClipboard(((RemoteScreenshot)id2).getMedia());
                            }
                        }
                    });
                }
            }, 124, null));
        }
        Collection $this$toTypedArray$iv = options2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ContextOptionMenu.Item[] itemArray = thisCollection$iv.toArray(new ContextOptionMenu.Item[0]);
        ContextOptionMenu menu = new ContextOptionMenu(0.0f, 0.0f, Arrays.copyOf(itemArray, itemArray.length), 0.0f, 8, null);
        menu.onClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ShareButton this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ShareButton.access$getShouldMenuExist$p(this.this$0).set((Object)false);
            }
        }));
        Window.Companion.enqueueRenderOperation((Function0)new Function0<Unit>(this, menu){
            final /* synthetic */ ShareButton this$0;
            final /* synthetic */ ContextOptionMenu $menu;
            {
                this.this$0 = $receiver;
                this.$menu = $menu;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getScreenshotBrowser().getFocusType().get() == FocusType.EDIT) {
                    ContextOptionMenu.Position position2 = new ContextOptionMenu.Position((UIComponent)this.this$0, true);
                    this.$menu.reposition(position2.getXConstraint(), position2.getYConstraint());
                } else {
                    this.$menu.reposition((XConstraint)ConstraintsKt.boundTo((SuperConstraint)((SuperConstraint)new CopyConstraintFloat(false, 1, null)), (UIComponent)((UIComponent)this.this$0)), (YConstraint)ConstraintsKt.boundTo((SuperConstraint)((SuperConstraint)new SiblingConstraint(2.0f, false, 2, null)), (UIComponent)((UIComponent)this.this$0)));
                }
                ComponentsKt.childOf((UIComponent)((UIComponent)this.$menu), (UIComponent)((UIComponent)Window.Companion.of((UIComponent)this.this$0)));
                this.$menu.init();
            }
        });
    }

    @NotNull
    public final ShareButton setDimension(@NotNull IconButton.Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        UIComponent uIComponent = this.getImage();
        Intrinsics.checkNotNull((Object)uIComponent, (String)"null cannot be cast to non-null type gg.essential.gui.common.IconButton");
        ((IconButton)uIComponent).setDimension(dimension);
        return this;
    }

    private final void checkForUnsavedEditsAndRun(Function2<? super File, ? super ClientScreenshotMetadata, ? extends CompletableFuture<?>> withUnsavedEdits, Function1<? super ScreenshotId, Unit> withoutUnsavedEdits) {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager connectionManager2 = connectionManager;
        ScreenshotManager screenshotManager = connectionManager2.getScreenshotManager();
        Intrinsics.checkNotNullExpressionValue((Object)screenshotManager, (String)"getScreenshotManager(...)");
        ScreenshotManager screenshotManager2 = screenshotManager;
        FocusEditComponent editComponent = this.screenshotBrowser.getFocusEditComponent();
        ScreenshotProperties focus = (ScreenshotProperties)this.screenshotBrowser.getFocusing().get();
        if (focus != null) {
            if (editComponent.hasEdits()) {
                CompletionStage completionStage;
                CompletableFuture<File> completableFuture = editComponent.exportEditImageToTempFile();
                CompletionStage completionStage2 = completionStage = completableFuture != null ? completableFuture.thenAcceptAsync(arg_0 -> ShareButton.checkForUnsavedEditsAndRun$lambda$2((Function1)new Function1<File, Unit>(screenshotManager2, focus, withUnsavedEdits){
                    final /* synthetic */ ScreenshotManager $screenshotManager;
                    final /* synthetic */ ScreenshotProperties $focus;
                    final /* synthetic */ Function2<File, ClientScreenshotMetadata, CompletableFuture<?>> $withUnsavedEdits;
                    {
                        this.$screenshotManager = $screenshotManager;
                        this.$focus = $focus;
                        this.$withUnsavedEdits = $withUnsavedEdits;
                        super(1);
                    }

                    public final void invoke(File it) {
                        String checksum = this.$screenshotManager.getChecksum(it);
                        if (checksum == null) {
                            gg.essential.gui.notification.ExtensionsKt.error$default(Notifications.INSTANCE, "Picture export failed", "", null, null, null, 28, null);
                            Essential.logger.debug("Unable to read checksum for " + it.getAbsolutePath());
                            FileUtils.deleteQuietly((File)it);
                            return;
                        }
                        ClientScreenshotMetadata clientScreenshotMetadata = this.$focus.getMetadata();
                        if (clientScreenshotMetadata == null || (clientScreenshotMetadata = ScreenshotComponentsKt.cloneWithNewChecksum(clientScreenshotMetadata, checksum)) == null) {
                            clientScreenshotMetadata = this.$screenshotManager.getScreenshotMetadataManager().createMetadata(HelpersKt.getImageTime(this.$focus, true), checksum);
                        }
                        ClientScreenshotMetadata metadata2 = clientScreenshotMetadata;
                        Intrinsics.checkNotNull((Object)it);
                        ((CompletableFuture)this.$withUnsavedEdits.invoke((Object)it, (Object)metadata2)).thenAcceptAsync(arg_0 -> checkForUnsavedEditsAndRun.1.invoke$lambda$0(it, arg_0), gg.essential.util.ExtensionsKt.getExecutor(UMinecraft.getMinecraft()));
                    }

                    private static final void invoke$lambda$0(File $it, Object object) {
                        FileUtils.deleteQuietly((File)$it);
                    }
                }, arg_0), gg.essential.util.ExtensionsKt.getExecutor(UMinecraft.getMinecraft())) : null;
                if (completionStage == null) {
                    gg.essential.gui.notification.ExtensionsKt.error$default(Notifications.INSTANCE, "Picture export failed", "", null, null, null, 28, null);
                }
            } else {
                withoutUnsavedEdits.invoke((Object)focus.getId());
            }
        }
    }

    private static final void checkForUnsavedEditsAndRun$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$checkForUnsavedEditsAndRun(ShareButton $this, Function2 withUnsavedEdits, Function1 withoutUnsavedEdits) {
        $this.checkForUnsavedEditsAndRun(withUnsavedEdits, (Function1<? super ScreenshotId, Unit>)withoutUnsavedEdits);
    }

    public static final /* synthetic */ BasicState access$getShouldMenuExist$p(ShareButton $this) {
        return $this.shouldMenuExist;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ShareButton.class, "image", "getImage()Lgg/essential/elementa/UIComponent;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

