/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.gui.screenshot.handler.ScreenshotChecksumManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.network.connectionmanager.media.IScreenshotMetadataManager;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.util.UUIDUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0019J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u001aJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u0015\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\"\u0010\u001aJ\u0019\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b#\u0010\u001aJ\u0015\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\f\u00a2\u0006\u0004\b%\u0010\u0012J\u0017\u0010&\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b&\u0010\u0012R\u001c\u0010)\u001a\n (*\u0004\u0018\u00010'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010.R8\u00101\u001a&\u0012\f\u0012\n (*\u0004\u0018\u00010\n0\n (*\u0012\u0012\f\u0012\n (*\u0004\u0018\u00010\n0\n\u0018\u0001000/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103\u00a8\u00064"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager;", "Lgg/essential/network/connectionmanager/media/IScreenshotMetadataManager;", "Ljava/io/File;", "metadataFolder", "Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "screenshotChecksumManager", "<init>", "(Ljava/io/File;Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;)V", "Lcom/sparkuniverse/toolbox/util/DateTime;", "time", "", "checksum", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "createMetadata", "(Lcom/sparkuniverse/toolbox/util/DateTime;Ljava/lang/String;)Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "metadata", "", "deleteMetadata", "(Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;)V", "file", "(Ljava/io/File;)V", "getMetadata", "(Ljava/io/File;)Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "Ljava/nio/file/Path;", "path", "(Ljava/nio/file/Path;)Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "(Ljava/lang/String;)Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "mediaId", "getMetadataCache", "getOrCreateMetadata", "fileName", "handleExternalDelete", "(Ljava/lang/String;)V", "imageChecksum", "readMetadata", "tryRecoverMetadata", "screenshotMetadata", "updateMetadata", "writeMetadata", "Lgg/essential/lib/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lgg/essential/lib/gson/Gson;", "", "metadataCache", "Ljava/util/Map;", "Ljava/io/File;", "", "", "negativeChecksumCache", "Ljava/util/Set;", "Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "Essential 1.21-fabric"})
@SourceDebugExtension(value={"SMAP\nScreenshotMetadataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n288#3,2:168\n*S KotlinDebug\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n*L\n101#1:168,2\n*E\n"})
public final class ScreenshotMetadataManager
implements IScreenshotMetadataManager {
    @NotNull
    private final File metadataFolder;
    @NotNull
    private final ScreenshotChecksumManager screenshotChecksumManager;
    private final Gson gson;
    @NotNull
    private final Map<String, ClientScreenshotMetadata> metadataCache;
    private final Set<String> negativeChecksumCache;

    public ScreenshotMetadataManager(@NotNull File metadataFolder, @NotNull ScreenshotChecksumManager screenshotChecksumManager) {
        Intrinsics.checkNotNullParameter((Object)metadataFolder, (String)"metadataFolder");
        Intrinsics.checkNotNullParameter((Object)screenshotChecksumManager, (String)"screenshotChecksumManager");
        this.metadataFolder = metadataFolder;
        this.screenshotChecksumManager = screenshotChecksumManager;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)DateTime.class), new DateTimeTypeAdapter()).create();
        this.metadataCache = new ConcurrentHashMap();
        this.negativeChecksumCache = Sets.newConcurrentHashSet();
    }

    public final void updateMetadata(@NotNull ClientScreenshotMetadata screenshotMetadata) {
        Intrinsics.checkNotNullParameter((Object)screenshotMetadata, (String)"screenshotMetadata");
        this.metadataCache.put(screenshotMetadata.getChecksum(), screenshotMetadata);
        this.writeMetadata(screenshotMetadata);
    }

    private final ClientScreenshotMetadata readMetadata(String imageChecksum) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        try {
            String fileContents = FilesKt.readText$default((File)new File(this.metadataFolder, imageChecksum), null, (int)1, null);
            clientScreenshotMetadata = this.gson.fromJson(fileContents, ClientScreenshotMetadata.class);
        }
        catch (JsonSyntaxException exception) {
            Essential.logger.error("Metadata corrupt for checksum " + imageChecksum + ". Attempting recovery.", (Throwable)exception);
            clientScreenshotMetadata = this.tryRecoverMetadata(imageChecksum);
        }
        catch (FileNotFoundException ignored) {
            clientScreenshotMetadata = null;
        }
        return clientScreenshotMetadata;
    }

    private final ClientScreenshotMetadata tryRecoverMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        block2: {
            ClientScreenshotMetadata clientScreenshotMetadata;
            Path path = (Path)CollectionsKt.firstOrNull(this.screenshotChecksumManager.getPathsForChecksum(checksum));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                DateTime dateTime = ScreenshotManager.getImageTime(it, null, false);
                Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"getImageTime(...)");
                clientScreenshotMetadata = this.createMetadata(dateTime, checksum);
            } else {
                clientScreenshotMetadata = null;
            }
            ClientScreenshotMetadata clientScreenshotMetadata2 = metadata2 = clientScreenshotMetadata;
            if (clientScreenshotMetadata2 == null) break block2;
            ClientScreenshotMetadata it = clientScreenshotMetadata2;
            boolean bl = false;
            this.writeMetadata(it);
        }
        return metadata2;
    }

    private final ClientScreenshotMetadata getMetadata(String checksum) {
        if (this.negativeChecksumCache.contains(checksum)) {
            return null;
        }
        ClientScreenshotMetadata metadata2 = this.metadataCache.compute(checksum, (arg_0, arg_1) -> ScreenshotMetadataManager.getMetadata$lambda$2((Function2)new Function2<String, ClientScreenshotMetadata, ClientScreenshotMetadata>(this, checksum){
            final /* synthetic */ ScreenshotMetadataManager this$0;
            final /* synthetic */ String $checksum;
            {
                this.this$0 = $receiver;
                this.$checksum = $checksum;
                super(2);
            }

            @Nullable
            public final ClientScreenshotMetadata invoke(@NotNull String string, @Nullable ClientScreenshotMetadata it) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                ClientScreenshotMetadata clientScreenshotMetadata = it;
                if (clientScreenshotMetadata == null) {
                    clientScreenshotMetadata = ScreenshotMetadataManager.access$readMetadata(this.this$0, this.$checksum);
                }
                return clientScreenshotMetadata;
            }
        }, arg_0, arg_1));
        if (metadata2 == null) {
            this.negativeChecksumCache.add(checksum);
        }
        return metadata2;
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.getMetadata(file);
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            return null;
        }
        String imageChecksum = string;
        return this.getMetadata(imageChecksum);
    }

    @Nullable
    public final ClientScreenshotMetadata getMetadataCache(@NotNull String mediaId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
            Iterable $this$firstOrNull$iv = this.metadataCache.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClientScreenshotMetadata it = (ClientScreenshotMetadata)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMediaId(), (Object)mediaId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void writeMetadata(ClientScreenshotMetadata metadata2) {
        this.negativeChecksumCache.remove(metadata2.getChecksum());
        try {
            File file = new File(this.metadataFolder, metadata2.getChecksum());
            String string = this.gson.toJson(metadata2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void handleExternalDelete(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = this.screenshotChecksumManager.remove(fileName);
        if (string == null) {
            return;
        }
        String checksum = string;
        ClientScreenshotMetadata metadata2 = this.getMetadata(checksum);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
        }
    }

    private final void deleteMetadata(ClientScreenshotMetadata metadata2) {
        File metadataFile = new File(this.metadataFolder, metadata2.getChecksum());
        this.metadataCache.remove(metadata2.getChecksum());
        FileUtils.deleteQuietly((File)metadataFile);
    }

    public final void deleteMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ClientScreenshotMetadata metadata2 = this.getMetadata(file);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
            this.screenshotChecksumManager.delete(file);
        }
    }

    @NotNull
    public final ClientScreenshotMetadata createMetadata(@NotNull DateTime time, @NotNull String checksum) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        UUID uUID = UUIDUtil.getClientUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getClientUUID(...)");
        return new ClientScreenshotMetadata(uUID, time, checksum, null, new ClientScreenshotMetadata.Location(ClientScreenshotMetadata.Location.Type.UNKNOWN, "Unknown"), false, false, null, 128, null);
    }

    @Override
    @NotNull
    public synchronized ClientScreenshotMetadata getOrCreateMetadata(@NotNull Path path) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNull((Object)file);
        ClientScreenshotMetadata existingMetadata = this.getMetadata(file);
        if (existingMetadata != null) {
            return existingMetadata;
        }
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            throw new IllegalStateException("No checksum for file " + file + ". Was the file deleted?");
        }
        String checksum = string;
        DateTime dateTime = ScreenshotManager.getImageTime(path, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"getImageTime(...)");
        ClientScreenshotMetadata it = clientScreenshotMetadata = this.createMetadata(dateTime, checksum);
        boolean bl = false;
        this.updateMetadata(it);
        return clientScreenshotMetadata;
    }

    private static final ClientScreenshotMetadata getMetadata$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ClientScreenshotMetadata)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ClientScreenshotMetadata access$readMetadata(ScreenshotMetadataManager $this, String imageChecksum) {
        return $this.readMetadata(imageChecksum);
    }
}

