/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.mojang.authlib.GameProfile;
import gg.essential.Essential;
import gg.essential.compat.ImmediatelyFastCompat;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.mixins.ext.client.network.NetHandlerPlayClientExt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.render.TextRenderTypeVertexConsumer;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.shader.BlendState;
import gg.essential.util.Diamond;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class OnlineIndicator {
    public static final ThreadLocal<Boolean> currentlyDrawingEntityName = ThreadLocal.withInitial(() -> false);

    public static boolean currentlyDrawingEntityName() {
        return currentlyDrawingEntityName.get();
    }

    public static void drawNametagIndicator(UMatrixStack matrixStack, class_4597 vertexConsumerProvider, CosmeticsRenderState cState, String str, int light) {
        if (!cState.onlineIndicator()) {
            return;
        }
        boolean alwaysOnTop = !cState.isSneaking();
        int stringWidth = class_310.method_1551().field_1772.method_1727(str);
        float vanillaX = -((float)(stringWidth / 2));
        Color color2 = EssentialPalette.ESSENTIAL_BLUE;
        float x1 = vanillaX - 11.0f;
        float y1 = -1.0f;
        float x2 = vanillaX - 1.0f;
        float y2 = OnlineIndicator.getDiamondBackgroundYMin();
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int backgroundOpacity = OnlineIndicator.getTextBackgroundOpacity();
        double z = 0.01;
        TextRenderTypeVertexConsumer vertexConsumer = TextRenderTypeVertexConsumer.create(vertexConsumerProvider, alwaysOnTop);
        vertexConsumer.pos(matrixStack, x1, y1, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x1, y2, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x2, y2, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        vertexConsumer.pos(matrixStack, x2, y1, z).color(0, 0, 0, backgroundOpacity).tex(0.0, 0.0).light(light).endVertex();
        float diamondCenter = (y1 + y2) / 2.0f + OnlineIndicator.getDiamondYOffset();
        Diamond.drawDiamond(matrixStack, vertexConsumer, 6, vanillaX - 6.0f, diamondCenter, ExtensionsKt.withAlpha((Color)color2, (int)32).getRGB(), light);
        if (alwaysOnTop) {
            vertexConsumer = TextRenderTypeVertexConsumer.create(vertexConsumerProvider, false);
            Diamond.drawDiamond(matrixStack, vertexConsumer, 6, vanillaX - 6.0f, diamondCenter, color2.getRGB(), light);
        }
    }

    public static float getDiamondBackgroundYMin() {
        return 9.0f;
    }

    public static int getTextBackgroundOpacity() {
        return (int)(UMinecraft.getMinecraft().field_1690.method_19343(0.25f) * 255.0f);
    }

    private static float getDiamondYOffset() {
        return -0.5f;
    }

    public static void drawTabIndicatorOuter(UMatrixStack matrixStack, class_4597.class_4598 provider2, class_640 networkPlayerInfo, int x, int y) {
        OnlineIndicator.drawTabIndicator(matrixStack, provider2, networkPlayerInfo, x, y);
    }

    private static void drawTabIndicator(UMatrixStack matrixStack, class_4597.class_4598 provider2, class_640 networkPlayerInfo, int x, int y) {
        ProfileStatus status2;
        UUID actualUuid;
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getShowEssentialIndicatorOnTab() || networkPlayerInfo == null) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        ProfileManager profileManager = connectionManager.getProfileManager();
        GameProfile gameProfile = networkPlayerInfo.method_2966();
        if (gameProfile == null) {
            return;
        }
        UUID playerUuid = gameProfile.getId();
        if (playerUuid == null) {
            return;
        }
        if (playerUuid.version() == 2 && (actualUuid = OnlineIndicator.findUUIDFromDisplayName(networkPlayerInfo.method_2971())) != null) {
            playerUuid = actualUuid;
        }
        if ((status2 = profileManager.getStatus(playerUuid)) == ProfileStatus.OFFLINE) {
            return;
        }
        OnlineIndicator.beforeTabDraw();
        BlendState prevBlendState = BlendState.active();
        BlendState.NORMAL.activate();
        matrixStack.push();
        TextRenderTypeVertexConsumer vertexConsumer = TextRenderTypeVertexConsumer.create((class_4597)provider2);
        matrixStack.translate(0.0f, 0.0f, 5.0f);
        Diamond.drawDiamond(matrixStack, vertexConsumer, 4, x - 9, (float)y + 1.5f, EssentialPalette.ESSENTIAL_BLUE.getRGB());
        provider2.method_22993();
        matrixStack.pop();
        prevBlendState.activate();
        OnlineIndicator.afterTabDraw();
    }

    public static UUID findUUIDFromDisplayName(class_2561 displayName) {
        String[] nameParts;
        if (displayName == null) {
            return null;
        }
        class_634 netHandler = UMinecraft.getNetHandler();
        if (netHandler == null) {
            return null;
        }
        Map<String, UUID> nameToIdCache = ((NetHandlerPlayClientExt)netHandler).essential$getNameIdCache();
        String unformattedText = displayName.getString();
        for (String part : nameParts = unformattedText.replaceAll("\\W", " ").split(" ")) {
            if (part.isEmpty() || !nameToIdCache.containsKey(part)) continue;
            return nameToIdCache.get(part);
        }
        return null;
    }

    public static void beforeTabDraw() {
        ImmediatelyFastCompat.beforeHudDraw();
    }

    public static void afterTabDraw() {
        ImmediatelyFastCompat.afterHudDraw();
    }
}

