/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.ice.stun;

import gg.essential.ice.UtilsKt;
import gg.essential.ice.stun.ChannelData;
import gg.essential.ice.stun.StunAttribute;
import gg.essential.ice.stun.StunClass;
import gg.essential.ice.stun.StunManager;
import gg.essential.ice.stun.StunMessage;
import gg.essential.ice.stun.StunRequest;
import gg.essential.ice.stun.StunSocket;
import gg.essential.ice.stun.StunType;
import gg.essential.ice.stun.TransactionId;
import gg.essential.ice.stun.UdpStunPacket;
import gg.essential.slf4j.ExtendedLoggerKt;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 .2\u00020\u0001:\u0005./012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010#\u001a\u00060\"R\u00020\u00002\u0006\u0010$\u001a\u00020\u000bJ\u0012\u0010%\u001a\u00060\u001dR\u00020\u00002\u0006\u0010&\u001a\u00020\u000bJ\u0012\u0010'\u001a\u00060\u000fR\u00020\u00002\u0006\u0010(\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0015R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0012\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00160\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u001dR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\"R\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lgg/essential/ice/stun/StunSocket;", "", "parentLogger", "Lorg/slf4j/Logger;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "manager", "Lgg/essential/ice/stun/StunManager;", "hostSocket", "Ljava/net/DatagramSocket;", "hostAddress", "Ljava/net/InetSocketAddress;", "(Lorg/slf4j/Logger;Lkotlinx/coroutines/CoroutineScope;Lgg/essential/ice/stun/StunManager;Ljava/net/DatagramSocket;Ljava/net/InetSocketAddress;)V", "endpoints", "", "Lgg/essential/ice/stun/StunSocket$Endpoint;", "getHostAddress", "()Ljava/net/InetSocketAddress;", "hostSendChannel", "Lkotlinx/coroutines/channels/Channel;", "Lkotlin/Pair;", "Ljava/net/DatagramPacket;", "Lkotlinx/coroutines/CompletableDeferred;", "", "hostSocketScope", "logger", "getLogger", "()Lorg/slf4j/Logger;", "relayAllocations", "Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "scope", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "stunBindings", "Lgg/essential/ice/stun/StunSocket$StunBinding;", "allocateBinding", "stunServer", "allocateRelay", "turnServer", "getEndpoint", "address", "send", "packet", "(Ljava/net/DatagramPacket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendUnchecked", "", "Companion", "Endpoint", "ReceivedPacket", "RelayAllocation", "StunBinding", "ice"})
@SourceDebugExtension(value={"SMAP\nStunSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,593:1\n372#2,7:594\n1#3:601\n*S KotlinDebug\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket\n*L\n226#1:594,7\n*E\n"})
public final class StunSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StunManager manager;
    @NotNull
    private final DatagramSocket hostSocket;
    @NotNull
    private final InetSocketAddress hostAddress;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineScope hostSocketScope;
    @NotNull
    private final Channel<Pair<DatagramPacket, CompletableDeferred<Boolean>>> hostSendChannel;
    @NotNull
    private final Map<InetSocketAddress, Endpoint> endpoints;
    @NotNull
    private final Map<InetSocketAddress, StunBinding> stunBindings;
    @NotNull
    private final Map<InetSocketAddress, RelayAllocation> relayAllocations;
    private static final boolean LOG_UDP_PACKET_CONTENT = Boolean.parseBoolean(System.getProperty("essential.sps.log_udp_packet_content"));

    public StunSocket(@NotNull Logger parentLogger, @NotNull CoroutineScope parentScope, @NotNull StunManager manager, @NotNull DatagramSocket hostSocket, @NotNull InetSocketAddress hostAddress) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)hostSocket, (String)"hostSocket");
        Intrinsics.checkNotNullParameter((Object)hostAddress, (String)"hostAddress");
        this.manager = manager;
        this.hostSocket = hostSocket;
        this.hostAddress = hostAddress;
        this.scope = CoroutineScopeKt.plus((CoroutineScope)parentScope, (CoroutineContext)((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)parentScope.getCoroutineContext()))));
        this.logger = ExtendedLoggerKt.withKeyValue(parentLogger, "hostAddress", this.hostAddress);
        this.hostSocketScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.scope.getCoroutineContext().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        BuildersKt.launch$default((CoroutineScope)this.scope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StunSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)Duration.Companion.getINFINITE-UwyO8pc(), (Continuation)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl22
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                        }
                        catch (Throwable var2_3) {
                            BuildersKt.launch$default((CoroutineScope)StunSocket.access$getHostSocketScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ StunSocket this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl14
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl14:
                                            // 2 sources

                                            CoroutineScopeKt.cancel$default((CoroutineScope)StunSocket.access$getHostSocketScope$p(this.this$0), null, (int)1, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            throw var2_3;
                        }
lbl22:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)StunSocket.access$getHostSocketScope$p(this.this$0), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.hostSendChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<Pair<? extends DatagramPacket, ? extends CompletableDeferred<Boolean>>, Unit>(this){
            final /* synthetic */ StunSocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<DatagramPacket, ? extends CompletableDeferred<Boolean>> pair) {
                block0: {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    DatagramPacket packet = (DatagramPacket)pair.component1();
                    CompletableDeferred deferred = (CompletableDeferred)pair.component2();
                    this.this$0.getLogger().warn("Failed to send packet of {} bytes to {}: hostSendChannel overflow", (Object)packet.getLength(), (Object)packet.getAddress());
                    CompletableDeferred completableDeferred = deferred;
                    if (completableDeferred == null) break block0;
                    completableDeferred.complete((Object)true);
                }
            }
        }));
        this.endpoints = new LinkedHashMap();
        this.stunBindings = new LinkedHashMap();
        this.relayAllocations = new LinkedHashMap();
        BuildersKt.launch((CoroutineScope)this.hostSocketScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            final /* synthetic */ StunSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Channel packetsToBeSorted = ChannelKt.Channel$default((int)10, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)this.hostSocketScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Channel<ReceivedPacket>)packetsToBeSorted, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ StunSocket this$0;
            final /* synthetic */ Channel<ReceivedPacket> $packetsToBeSorted;
            {
                this.this$0 = $receiver;
                this.$packetsToBeSorted = $packetsToBeSorted;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                DatagramPacket buf;
                MessageDigest sha256;
                CoroutineScope $this$launch;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$launch = (CoroutineScope)this.L$0;
                        sha256 = MessageDigest.getInstance("SHA-256");
                        buf = new DatagramPacket(new byte[1500], 1500);
                        break;
                    }
                    case 1: {
                        void $result;
                        buf = (DatagramPacket)this.L$2;
                        sha256 = (MessageDigest)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (JobKt.isActive((CoroutineContext)$this$launch.getCoroutineContext())) {
                    try {
                        this.this$0.hostSocket.receive(buf);
                    }
                    catch (Exception e) {
                        if (e instanceof SocketException) {
                            String string = e.getMessage();
                            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Network dropped connection on reset", (boolean)false, (int)2, null) : false;
                            if (bl) {
                                this.this$0.getLogger().trace("Ignoring nonsensical exception:", (Throwable)e);
                                continue;
                            }
                        }
                        if (this.this$0.hostSocket.isClosed()) break;
                        this.this$0.getLogger().error("Failed to receive:", (Throwable)e);
                        break;
                    }
                    InetSocketAddress remoteAddress = new InetSocketAddress(buf.getAddress(), buf.getPort());
                    byte[] byArray = buf.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                    byte[] bytes = ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)buf.getOffset(), (int)(buf.getOffset() + buf.getLength())));
                    if (LOG_UDP_PACKET_CONTENT) {
                        byte[] byArray2 = sha256.digest(bytes);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
                        String checksum = UtilsKt.toBase64String(byArray2);
                        String content = UtilsKt.toBase64String(bytes);
                        Object[] objectArray = new Object[]{Boxing.boxInt((int)bytes.length), checksum, content};
                        this.this$0.getLogger().atTrace().addKeyValue("hostAddress", (Object)this.this$0.getHostAddress()).addKeyValue("remoteAddress", (Object)remoteAddress).log("Received packet of {} bytes with checksum {}: {}", objectArray);
                    }
                    this.L$0 = $this$launch;
                    this.L$1 = sha256;
                    this.L$2 = buf;
                    this.label = 1;
                    object2 = this.$packetsToBeSorted.send((Object)new ReceivedPacket(this.this$0, null, (ComparableTimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()), remoteAddress, bytes), (Continuation)this);
                    if (object2 != object3) continue;
                    return object3;
                }
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.$packetsToBeSorted), null, (int)1, null);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.hostSocketScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<ReceivedPacket>)packetsToBeSorted, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Channel<ReceivedPacket> $packetsToBeSorted;
            final /* synthetic */ StunSocket this$0;
            {
                this.$packetsToBeSorted = $packetsToBeSorted;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block11: {
                    block14: {
                        block13: {
                            block12: {
                                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = this.$packetsToBeSorted.iterator();
lbl6:
                                        // 10 sources

                                        while (true) {
                                            this.L$0 = var2_3;
                                            this.label = 1;
                                            v0 = var2_3.hasNext((Continuation)this);
                                            if (v0 == var6_2) {
                                                return var6_2;
                                            }
                                            ** GOTO lbl17
                                            break;
                                        }
                                    }
                                    case 1: {
                                        var2_3 = (ChannelIterator)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        if (!((Boolean)v0).booleanValue()) break block11;
                                        packet = (ReceivedPacket)var2_3.next();
                                        if (!StunMessage.Companion.looksLikeStun(packet.getData())) break block12;
                                        if (StunSocket.access$getManager$p(this.this$0).messageReceived(this.this$0.getLogger(), packet) == null) ** GOTO lbl6
                                        relay = (RelayAllocation)StunSocket.access$getRelayAllocations$p(this.this$0).get(packet.getSource());
                                        if (relay == null) break;
                                        this.L$0 = var2_3;
                                        this.label = 2;
                                        v1 = relay.stunMessageReceived$ice(packet, message, (Continuation<? super Unit>)((Continuation)this));
                                        if (v1 != var6_2) ** GOTO lbl6
                                        return var6_2;
                                    }
                                    case 2: {
                                        var2_3 = (ChannelIterator)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl6
                                    }
                                }
                                this.this$0.getLogger().atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).addKeyValue("tId", (Object)message.getTransactionId()).log("Got unexpected STUN message: {}", (Object)message);
                                ** GOTO lbl6
                            }
                            relay = (RelayAllocation)StunSocket.access$getRelayAllocations$p(this.this$0).get(packet.getSource());
                            if (relay == null) break block13;
                            this.L$0 = var2_3;
                            this.label = 3;
                            v2 = relay.dataPacketReceived$ice(packet, (Continuation<? super Boolean>)((Continuation)this));
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl6
                            {
                                case 3: {
                                    var2_3 = (ChannelIterator)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
                                    ** GOTO lbl6
                                }
                            }
                        }
                        server = StunSocket.access$getManager$p(this.this$0).getServer(packet.getSource());
                        if (server == null) break block14;
                        this.L$0 = var2_3;
                        this.label = 4;
                        v3 = server.getDataReceiveChannel().send((Object)packet, (Continuation)this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl6
                        {
                            case 4: {
                                var2_3 = (ChannelIterator)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                                ** GOTO lbl6
                            }
                        }
                    }
                    this.this$0.getLogger().atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).log("Got unexpected data packet of {} bytes", (Object)Boxing.boxInt((int)packet.getData().length));
                    ** while (true)
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object send(@NotNull DatagramPacket var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof send.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StunSocket this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.send(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                $continuation.L$0 = deferred;
                $continuation.label = 1;
                v0 = this.hostSendChannel.send((Object)TuplesKt.to((Object)packet, (Object)deferred), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                deferred = (CompletableDeferred)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = deferred.await((Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void sendUnchecked(@NotNull DatagramPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.hostSendChannel.trySend-JP2dKIU((Object)TuplesKt.to((Object)packet, null));
    }

    @NotNull
    public final Endpoint getEndpoint(@NotNull InetSocketAddress address) {
        Endpoint endpoint;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Map<InetSocketAddress, Endpoint> $this$getOrPut$iv = this.endpoints;
        boolean $i$f$getOrPut = false;
        Endpoint value$iv = $this$getOrPut$iv.get(address);
        if (value$iv == null) {
            boolean bl = false;
            Endpoint answer$iv = new Endpoint(address);
            $this$getOrPut$iv.put(address, answer$iv);
            endpoint = answer$iv;
        } else {
            endpoint = value$iv;
        }
        return endpoint;
    }

    @NotNull
    public final StunBinding allocateBinding(@NotNull InetSocketAddress stunServer) {
        StunBinding stunBinding;
        Intrinsics.checkNotNullParameter((Object)stunServer, (String)"stunServer");
        if (!(!this.stunBindings.containsKey(stunServer))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Endpoint endpoint = this.getEndpoint(stunServer);
        StunBinding it = stunBinding = new StunBinding(endpoint);
        boolean bl = false;
        this.stunBindings.put(stunServer, it);
        return stunBinding;
    }

    @NotNull
    public final RelayAllocation allocateRelay(@NotNull InetSocketAddress turnServer) {
        RelayAllocation relayAllocation;
        Intrinsics.checkNotNullParameter((Object)turnServer, (String)"turnServer");
        if (!(!this.relayAllocations.containsKey(turnServer))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Endpoint endpoint = this.getEndpoint(turnServer);
        RelayAllocation it = relayAllocation = new RelayAllocation(endpoint);
        boolean bl = false;
        endpoint.setRelayAllocation$ice(it);
        this.relayAllocations.put(turnServer, it);
        return relayAllocation;
    }

    public static final /* synthetic */ CoroutineScope access$getHostSocketScope$p(StunSocket $this) {
        return $this.hostSocketScope;
    }

    public static final /* synthetic */ Channel access$getHostSendChannel$p(StunSocket $this) {
        return $this.hostSendChannel;
    }

    public static final /* synthetic */ Map access$getRelayAllocations$p(StunSocket $this) {
        return $this.relayAllocations;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgg/essential/ice/stun/StunSocket$Companion;", "", "()V", "LOG_UDP_PACKET_CONTENT", "", "maybeSliceArray", "", "offset", "", "length", "ice"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] maybeSliceArray(byte[] $this$maybeSliceArray, int offset, int length) {
            return offset == 0 && length == $this$maybeSliceArray.length ? $this$maybeSliceArray : ArraysKt.sliceArray((byte[])$this$maybeSliceArray, (IntRange)RangesKt.until((int)offset, (int)(offset + length)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lgg/essential/ice/stun/StunSocket$Endpoint;", "", "address", "Ljava/net/InetSocketAddress;", "(Lgg/essential/ice/stun/StunSocket;Ljava/net/InetSocketAddress;)V", "getAddress", "()Ljava/net/InetSocketAddress;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "relayAllocation", "Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "Lgg/essential/ice/stun/StunSocket;", "getRelayAllocation$ice", "()Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "setRelayAllocation$ice", "(Lgg/essential/ice/stun/StunSocket$RelayAllocation;)V", "request", "Lgg/essential/ice/stun/UdpStunPacket;", "message", "Lgg/essential/ice/stun/StunMessage;", "(Lgg/essential/ice/stun/StunMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "type", "Lgg/essential/ice/stun/StunType;", "attrs", "", "Lgg/essential/ice/stun/StunAttribute;", "(Lgg/essential/ice/stun/StunType;[Lgg/essential/ice/stun/StunAttribute;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ice"})
    public final class Endpoint {
        @NotNull
        private final InetSocketAddress address;
        @NotNull
        private final Logger logger;
        @Nullable
        private RelayAllocation relayAllocation;

        public Endpoint(InetSocketAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.logger = ExtendedLoggerKt.withKeyValue(StunSocket.this.getLogger(), "remoteAddress", this.address);
        }

        @NotNull
        public final InetSocketAddress getAddress() {
            return this.address;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Nullable
        public final RelayAllocation getRelayAllocation$ice() {
            return this.relayAllocation;
        }

        public final void setRelayAllocation$ice(@Nullable RelayAllocation relayAllocation) {
            this.relayAllocation = relayAllocation;
        }

        @Nullable
        public final Object request(@NotNull StunMessage message2, @NotNull Continuation<? super UdpStunPacket> $completion) {
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UdpStunPacket>, Object>(this, StunSocket.this, message2, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Endpoint this$0;
                final /* synthetic */ StunSocket this$1;
                final /* synthetic */ StunMessage $message;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$message = $message;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                            StunRequest request2 = new StunRequest(this.this$0.getLogger(), $this$coroutineScope, (Function2<? super DatagramPacket, ? super Continuation<? super Boolean>, ? extends Object>)((Function2)new Function2<DatagramPacket, Continuation<? super Boolean>, Object>((Object)this.this$1){

                                @Nullable
                                public final Object invoke(@NotNull DatagramPacket p0, @NotNull Continuation<? super Boolean> $completion) {
                                    return ((StunSocket)this.receiver).send(p0, $completion);
                                }
                            }), this.this$0.getAddress(), this.$message);
                            StunSocket.access$getManager$p(this.this$1).sendRequest(request2);
                            this.label = 1;
                            Object object3 = request2.await((Continuation<? super UdpStunPacket>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super UdpStunPacket>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super UdpStunPacket> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        @Nullable
        public final Object request(@NotNull StunType type, @NotNull StunAttribute[] attrs, @NotNull Continuation<? super UdpStunPacket> $completion) {
            return this.request(new StunMessage(type, StunClass.Request, TransactionId.Companion.create(), ArraysKt.toList((Object[])attrs)), $completion);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lgg/essential/ice/stun/StunSocket$ReceivedPacket;", "", "socket", "Lgg/essential/ice/stun/StunSocket;", "relay", "Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "timestamp", "Lkotlin/time/ComparableTimeMark;", "source", "Ljava/net/InetSocketAddress;", "data", "", "(Lgg/essential/ice/stun/StunSocket;Lgg/essential/ice/stun/StunSocket$RelayAllocation;Lkotlin/time/ComparableTimeMark;Ljava/net/InetSocketAddress;[B)V", "getData", "()[B", "getRelay", "()Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "getSocket", "()Lgg/essential/ice/stun/StunSocket;", "getSource", "()Ljava/net/InetSocketAddress;", "getTimestamp", "()Lkotlin/time/ComparableTimeMark;", "ice"})
    public static final class ReceivedPacket {
        @NotNull
        private final StunSocket socket;
        @Nullable
        private final RelayAllocation relay;
        @NotNull
        private final ComparableTimeMark timestamp;
        @NotNull
        private final InetSocketAddress source;
        @NotNull
        private final byte[] data;

        public ReceivedPacket(@NotNull StunSocket socket, @Nullable RelayAllocation relay, @NotNull ComparableTimeMark timestamp, @NotNull InetSocketAddress source, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.socket = socket;
            this.relay = relay;
            this.timestamp = timestamp;
            this.source = source;
            this.data = data;
        }

        @NotNull
        public final StunSocket getSocket() {
            return this.socket;
        }

        @Nullable
        public final RelayAllocation getRelay() {
            return this.relay;
        }

        @NotNull
        public final ComparableTimeMark getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final InetSocketAddress getSource() {
            return this.source;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010%\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010'J#\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010-J\u000e\u0010.\u001a\u00020&2\u0006\u0010+\u001a\u00020\u000bJ)\u0010/\u001a\u00020&2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001901\"\u00020\u00192\b\b\u0002\u00102\u001a\u00020)\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020)2\u0006\u00105\u001a\u000206H\u0080@\u00a2\u0006\u0004\b7\u00108J\u0016\u00109\u001a\u00020&2\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u00108J\u000e\u0010:\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010'J\u0010\u0010;\u001a\u00020&2\u0006\u00105\u001a\u00020\"H\u0002J&\u0010<\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>H\u0082@\u00a2\u0006\u0002\u0010?J \u0010@\u001a\u00020&2\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>H\u0080@\u00a2\u0006\u0004\bA\u0010BR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006C"}, d2={"Lgg/essential/ice/stun/StunSocket$RelayAllocation;", "", "endpoint", "Lgg/essential/ice/stun/StunSocket$Endpoint;", "Lgg/essential/ice/stun/StunSocket;", "(Lgg/essential/ice/stun/StunSocket;Lgg/essential/ice/stun/StunSocket$Endpoint;)V", "boundChannels", "", "Lkotlin/UShort;", "channelAddressToId", "", "Ljava/net/InetSocketAddress;", "channelIdToAddress", "lastCreatePermissionRequest", "Lkotlinx/coroutines/Job;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "mappedAddress", "Lkotlinx/coroutines/CompletableDeferred;", "getMappedAddress", "()Lkotlinx/coroutines/CompletableDeferred;", "previouslyRequestedPermissions", "", "Ljava/net/InetAddress;", "relayedAddress", "getRelayedAddress", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "sendChannel", "Lkotlinx/coroutines/channels/Channel;", "Ljava/net/DatagramPacket;", "getSendChannel", "()Lkotlinx/coroutines/channels/Channel;", "allocateAndHold", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bindChannel", "", "channelId", "address", "bindChannel-_TFR7lA", "(SLjava/net/InetSocketAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createChannel", "createPermission", "peerAddresses", "", "immediately", "([Ljava/net/InetAddress;Z)V", "dataPacketReceived", "packet", "Lgg/essential/ice/stun/StunSocket$ReceivedPacket;", "dataPacketReceived$ice", "(Lgg/essential/ice/stun/StunSocket$ReceivedPacket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "relayedPacketReceived", "release", "sendData", "stunDataIndicationReceived", "message", "Lgg/essential/ice/stun/StunMessage;", "(Lorg/slf4j/Logger;Lgg/essential/ice/stun/StunSocket$ReceivedPacket;Lgg/essential/ice/stun/StunMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stunMessageReceived", "stunMessageReceived$ice", "(Lgg/essential/ice/stun/StunSocket$ReceivedPacket;Lgg/essential/ice/stun/StunMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ice"})
    @SourceDebugExtension(value={"SMAP\nStunSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket$RelayAllocation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n*L\n1#1,593:1\n1#2:594\n1#2:596\n1#2:598\n1#2:600\n1#2:602\n1#2:604\n1#2:606\n1#2:608\n1#2:610\n37#3:595\n37#3:597\n37#3:599\n37#3:601\n37#3:603\n37#3:605\n37#3:607\n37#3:609\n*S KotlinDebug\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket$RelayAllocation\n*L\n363#1:596\n368#1:598\n376#1:600\n396#1:602\n409#1:604\n450#1:606\n549#1:608\n550#1:610\n363#1:595\n368#1:597\n376#1:599\n396#1:601\n409#1:603\n450#1:605\n549#1:607\n550#1:609\n*E\n"})
    public final class RelayAllocation {
        @NotNull
        private final Endpoint endpoint;
        @NotNull
        private final Logger logger;
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final Channel<DatagramPacket> sendChannel;
        @NotNull
        private final CompletableDeferred<InetSocketAddress> mappedAddress;
        @NotNull
        private final CompletableDeferred<InetSocketAddress> relayedAddress;
        @NotNull
        private final Map<InetSocketAddress, UShort> channelAddressToId;
        @NotNull
        private final Map<UShort, InetSocketAddress> channelIdToAddress;
        @NotNull
        private final Set<UShort> boundChannels;
        @Nullable
        private Job lastCreatePermissionRequest;
        @NotNull
        private Set<? extends InetAddress> previouslyRequestedPermissions;

        /*
         * WARNING - void declaration
         */
        public RelayAllocation(Endpoint endpoint) {
            void it;
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.endpoint = endpoint;
            this.logger = ExtendedLoggerKt.withKeyValue(StunSocket.this.getLogger(), "turnServer", this.endpoint.getAddress());
            CoroutineScope coroutineScope = StunSocket.this.getScope();
            RelayAllocation relayAllocation = this;
            boolean bl = false;
            relayAllocation.scope = CoroutineScopeKt.plus((CoroutineScope)it, (CoroutineContext)((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)it.getCoroutineContext()))));
            this.sendChannel = ChannelKt.Channel$default((int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
            this.mappedAddress = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)this.scope.getCoroutineContext()));
            this.relayedAddress = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)this.scope.getCoroutineContext()));
            this.channelAddressToId = new LinkedHashMap();
            this.channelIdToAddress = new LinkedHashMap();
            this.boundChannels = new LinkedHashSet();
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, StunSocket.this, null){
                int label;
                final /* synthetic */ RelayAllocation this$0;
                final /* synthetic */ StunSocket this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = RelayAllocation.access$allocateAndHold(this.this$0, (Continuation)this);
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                            }
                            catch (Throwable var2_3) {
                                BuildersKt.launch$default((CoroutineScope)StunSocket.access$getHostSocketScope$p(this.this$1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ RelayAllocation this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.release((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.getScope(), null, (int)1, null);
                                throw var2_3;
                            }
lbl23:
                            // 2 sources

                            BuildersKt.launch$default((CoroutineScope)StunSocket.access$getHostSocketScope$p(this.this$1), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                            CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.getScope(), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ RelayAllocation this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.this$0.getSendChannel().iterator();
lbl6:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl17
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) {
                                packet = (DatagramPacket)var2_3.next();
                                RelayAllocation.access$sendData(this.this$0, packet);
                                ** continue;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.previouslyRequestedPermissions = SetsKt.emptySet();
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        public final CoroutineScope getScope() {
            return this.scope;
        }

        @NotNull
        public final Channel<DatagramPacket> getSendChannel() {
            return this.sendChannel;
        }

        @NotNull
        public final CompletableDeferred<InetSocketAddress> getMappedAddress() {
            return this.mappedAddress;
        }

        @NotNull
        public final CompletableDeferred<InetSocketAddress> getRelayedAddress() {
            return this.relayedAddress;
        }

        /*
         * Unable to fully structure code
         */
        private final Object allocateAndHold(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof allocateAndHold.1)) ** GOTO lbl-1000
            var13_2 = var1_1;
            if ((var13_2.label & -2147483648) != 0) {
                var13_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ RelayAllocation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RelayAllocation.access$allocateAndHold(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_5 = new StunAttribute[]{StunAttribute.RequestedTransport.INSTANCE};
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.endpoint.request(StunType.Allocate, var4_5, (Continuation<? super UdpStunPacket>)$continuation);
                    if (v0 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    this = (RelayAllocation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    v1 = (UdpStunPacket)v0;
                    v2 = allocResponse = v1 != null ? v1.getMessage() : null;
                    if (allocResponse == null) {
                        this.logger.warn("Failed to contact TURN server, timed out.");
                        return Unit.INSTANCE;
                    }
                    if (allocResponse.getCls() == StunClass.ResponseSuccess) ** GOTO lbl45
                    this_$iv = allocResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v3 = it$iv;
                        if (!(v3 instanceof StunAttribute.ErrorCode)) {
                            v3 = null;
                        }
                        if ((it$iv = (StunAttribute)((StunAttribute.ErrorCode)v3)) == null) continue;
                        v4 = it$iv;
                        ** GOTO lbl41
                    }
                    v4 = null;
lbl41:
                    // 2 sources

                    v5 = err = (StunAttribute.ErrorCode)v4;
                    v6 = err;
                    this.logger.warn("Failed to allocate relay: {} {}", (Object)(v5 != null ? Boxing.boxInt((int)v5.getCode()) : null), (Object)(v6 != null ? v6.getMessage() : null));
                    return Unit.INSTANCE;
lbl45:
                    // 1 sources

                    this_$iv = allocResponse;
                    $i$f$attribute = false;
                    for (Object it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v7 = it$iv;
                        if (!(v7 instanceof StunAttribute.XorMappedAddress)) {
                            v7 = null;
                        }
                        if ((it$iv = (StunAttribute)((StunAttribute.XorMappedAddress)v7)) == null) continue;
                        v8 = it$iv;
                        ** GOTO lbl57
                    }
                    v8 = null;
lbl57:
                    // 2 sources

                    v9 = (StunAttribute.XorMappedAddress)v8;
                    v10 = mappedAddress = v9 != null ? v9.getAddress() : null;
                    if (mappedAddress == null) {
                        this.logger.warn("Allocate response is missing XOR-MAPPED-ADDRESS? {}", (Object)allocResponse);
                        return Unit.INSTANCE;
                    }
                    this.logger.debug("Received public address: {}", (Object)mappedAddress);
                    this.mappedAddress.complete((Object)mappedAddress);
                    this_$iv = allocResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v11 = it$iv;
                        if (!(v11 instanceof StunAttribute.XorRelayedAddress)) {
                            v11 = null;
                        }
                        if ((var9_22 = (StunAttribute)((StunAttribute.XorRelayedAddress)v11)) == null) continue;
                        v12 = var9_22;
                        ** GOTO lbl77
                    }
                    v12 = null;
lbl77:
                    // 2 sources

                    v13 = (StunAttribute.XorRelayedAddress)v12;
                    v14 = relayedAddress = v13 != null ? v13.getAddress() : null;
                    if (relayedAddress == null) {
                        this.logger.warn("Allocate response is missing XOR-RELAYED-ADDRESS? {}", (Object)allocResponse);
                        return Unit.INSTANCE;
                    }
                    this.logger.debug("Received relayed address: {}", (Object)relayedAddress);
                    this.relayedAddress.complete((Object)relayedAddress);
                    while (true) {
                        $continuation.L$0 = this;
                        $continuation.label = 2;
                        v15 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                        if (v15 == var14_4) {
                            return var14_4;
                        }
                        ** GOTO lbl98
                        break;
                    }
                }
                case 2: {
                    this = (RelayAllocation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v15 = $result;
lbl98:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v16 = this.endpoint.request(StunType.Refresh, new StunAttribute[0], (Continuation<? super UdpStunPacket>)$continuation);
                    if (v16 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl108
                }
                case 3: {
                    this = (RelayAllocation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v16 = $result;
lbl108:
                    // 2 sources

                    v17 = (UdpStunPacket)v16;
                    v18 = refreshResponse = v17 != null ? v17.getMessage() : null;
                    if (refreshResponse != null) ** GOTO lbl113
                    this.logger.warn("Failed to refresh allocation, timed out.");
                    ** GOTO lbl129
lbl113:
                    // 1 sources

                    if (refreshResponse.getCls() == StunClass.ResponseSuccess) ** continue;
                    this_$iv = refreshResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v19 = it$iv;
                        if (!(v19 instanceof StunAttribute.ErrorCode)) {
                            v19 = null;
                        }
                        if ((var10_25 = (StunAttribute)((StunAttribute.ErrorCode)v19)) == null) continue;
                        v20 = var10_25;
                        ** GOTO lbl126
                    }
                    v20 = null;
lbl126:
                    // 2 sources

                    v21 = err = (StunAttribute.ErrorCode)v20;
                    v22 = err;
                    this.logger.warn("Failed to refresh allocation: {} {}", (Object)(v21 != null ? Boxing.boxInt((int)v21.getCode()) : null), (Object)(v22 != null ? v22.getMessage() : null));
lbl129:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object release(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof release.1)) ** GOTO lbl-1000
            var10_2 = var1_1;
            if ((var10_2.label & -2147483648) != 0) {
                var10_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ RelayAllocation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RelayAllocation.access$release(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_5 = new StunAttribute[]{new StunAttribute.Lifetime(0, null)};
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.endpoint.request(StunType.Refresh, var4_5, (Continuation<? super UdpStunPacket>)$continuation);
                    if (v0 == var11_4) {
                        return var11_4;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    this = (RelayAllocation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    v1 = (UdpStunPacket)v0;
                    v2 = response = v1 != null ? v1.getMessage() : null;
                    if (response == null) {
                        this.logger.warn("Failed to release TURN allocation, timed out.");
                        return Unit.INSTANCE;
                    }
                    this_$iv = response;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v3 = it$iv;
                        if (!(v3 instanceof StunAttribute.ErrorCode)) {
                            v3 = null;
                        }
                        if ((var7_9 = (StunAttribute)((StunAttribute.ErrorCode)v3)) == null) continue;
                        v4 = var7_9;
                        ** GOTO lbl40
                    }
                    v4 = null;
lbl40:
                    // 2 sources

                    err = (StunAttribute.ErrorCode)v4;
                    if (response.getCls() == StunClass.ResponseSuccess) ** GOTO lbl-1000
                    v5 = err;
                    v6 = v5 != null ? v5.getCode() == 437 : false;
                    if (v6) lbl-1000:
                    // 2 sources

                    {
                        this.logger.trace("TURN allocation successfully released.");
                    } else {
                        v7 = err;
                        v8 = err;
                        this.logger.warn("Failed to release TURN allocation: {} {}", (Object)(v7 != null ? Boxing.boxInt((int)v7.getCode()) : null), (Object)(v8 != null ? v8.getMessage() : null));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final void createChannel(@NotNull InetSocketAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            if (this.channelAddressToId.containsKey(address)) {
                return;
            }
            short channelId = UShort.constructor-impl((short)((short)(16384 + this.channelAddressToId.size())));
            UShort uShort = UShort.box-impl((short)channelId);
            this.channelAddressToId.put(address, uShort);
            uShort = UShort.box-impl((short)channelId);
            this.channelIdToAddress.put(uShort, address);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, channelId, address, null){
                int label;
                final /* synthetic */ RelayAllocation this$0;
                final /* synthetic */ short $channelId;
                final /* synthetic */ InetSocketAddress $address;
                {
                    this.this$0 = $receiver;
                    this.$channelId = $channelId;
                    this.$address = $address;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = RelayAllocation.access$bindChannel-_TFR7lA(this.this$0, this.$channelId, this.$address, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) {
                                return Unit.INSTANCE;
                            }
                            RelayAllocation.access$getBoundChannels$p(this.this$0).add(UShort.box-impl((short)this.$channelId));
                            while (true) {
                                this.label = 2;
                                v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl28
                                break;
                            }
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl28:
                            // 2 sources

                            this.label = 3;
                            v2 = RelayAllocation.access$bindChannel-_TFR7lA(this.this$0, this.$channelId, this.$address, (Continuation)this);
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl36
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl36:
                            // 2 sources

                            if (((Boolean)v2).booleanValue()) ** continue;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object bindChannel-_TFR7lA(short var1_1, InetSocketAddress var2_2, Continuation<? super Boolean> var3_3) {
            if (!(var3_3 instanceof bindChannel.1)) ** GOTO lbl-1000
            var12_4 = var3_3;
            if ((var12_4.label & -2147483648) != 0) {
                var12_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ RelayAllocation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return RelayAllocation.access$bindChannel-_TFR7lA(this.this$0, (short)0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var6_7 = new StunAttribute[]{new StunAttribute.ChannelNumber((short)channelId, null), new StunAttribute.XorPeerAddress((InetSocketAddress)address)};
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.endpoint.request(StunType.ChannelBind, var6_7, (Continuation<? super UdpStunPacket>)$continuation);
                    if (v0 == var13_6) {
                        return var13_6;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    this = (RelayAllocation)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    v1 = response = (var5_8 = (UdpStunPacket)v0) != null ? var5_8.getMessage() : null;
                    if (response == null) {
                        this.logger.error("Failed to bind channel, timed out.");
                        return Boxing.boxBoolean((boolean)false);
                    }
                    if (response.getCls() == StunClass.ResponseSuccess) ** GOTO lbl44
                    this_$iv = response;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v2 = it$iv;
                        if (!(v2 instanceof StunAttribute.ErrorCode)) {
                            v2 = null;
                        }
                        if ((var9_12 = (StunAttribute)((StunAttribute.ErrorCode)v2)) == null) continue;
                        v3 = var9_12;
                        ** GOTO lbl40
                    }
                    v3 = null;
lbl40:
                    // 2 sources

                    v4 = err = (StunAttribute.ErrorCode)v3;
                    v5 = err;
                    this.logger.error("Failed to bind channel: {} {}", (Object)(v4 != null ? Boxing.boxInt((int)v4.getCode()) : null), (Object)(v5 != null ? v5.getMessage() : null));
                    return Boxing.boxBoolean((boolean)false);
lbl44:
                    // 1 sources

                    return Boxing.boxBoolean((boolean)true);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final void createPermission(@NotNull InetAddress[] peerAddresses, boolean immediately) {
            Intrinsics.checkNotNullParameter((Object)peerAddresses, (String)"peerAddresses");
            Set nowRequested = ArraysKt.toSet((Object[])peerAddresses);
            if (this.previouslyRequestedPermissions.containsAll(nowRequested)) {
                return;
            }
            Set allRequested = SetsKt.plus(this.previouslyRequestedPermissions, (Iterable)nowRequested);
            CoroutineStart start2 = immediately ? CoroutineStart.UNDISPATCHED : CoroutineStart.DEFAULT;
            Job job = this.lastCreatePermissionRequest;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.lastCreatePermissionRequest = BuildersKt.launch$default((CoroutineScope)this.scope, null, (CoroutineStart)start2, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Set<? extends InetAddress>)allRequested, null){
                int label;
                final /* synthetic */ RelayAllocation this$0;
                final /* synthetic */ Set<InetAddress> $allRequested;
                {
                    this.this$0 = $receiver;
                    this.$allRequested = $allRequested;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            RelayAllocation.access$setPreviouslyRequestedPermissions$p(this.this$0, this.$allRequested);
                            $this$map$iv = this.$allRequested;
                            $i$f$map = false;
                            var5_6 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            var8_11 = $this$mapTo$iv$iv.iterator();
                            while (var8_11.hasNext()) {
                                item$iv$iv = var8_11.next();
                                var10_14 = (InetAddress)item$iv$iv;
                                var12_16 = destination$iv$iv;
                                $i$a$-map-StunSocket$RelayAllocation$createPermission$1$attrs$1 = false;
                                var12_16.add(new StunAttribute.XorPeerAddress(new InetSocketAddress((InetAddress)it, 0)));
                            }
                            $this$toTypedArray$iv = (List)destination$iv$iv;
                            $i$f$toTypedArray = false;
                            thisCollection$iv = $this$toTypedArray$iv;
                            attrs = thisCollection$iv.toArray(new StunAttribute.XorPeerAddress[0]);
                            this.label = 1;
                            v0 = RelayAllocation.access$getEndpoint$p(this.this$0).request(StunType.CreatePermission, Arrays.copyOf(attrs, attrs.length), (Continuation<? super UdpStunPacket>)((Continuation)this));
                            if (v0 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl32
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl32:
                            // 2 sources

                            v1 = (UdpStunPacket)v0;
                            v2 = response = v1 != null ? v1.getMessage() : null;
                            if (response == null) {
                                this.this$0.getLogger().warn("Failed to install permission, timed out.");
                                return Unit.INSTANCE;
                            }
                            if (response.getCls() == StunClass.ResponseSuccess) ** GOTO lbl55
                            this_$iv = response;
                            $i$f$attribute = false;
                            for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                                $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                                v3 = it$iv;
                                if (!(v3 instanceof StunAttribute.ErrorCode)) {
                                    v3 = null;
                                }
                                if ((var8_11 = (StunAttribute)((StunAttribute.ErrorCode)v3)) == null) continue;
                                v4 = var8_11;
                                ** GOTO lbl50
                            }
                            v4 = null;
lbl50:
                            // 2 sources

                            err = (StunAttribute.ErrorCode)v4;
                            v5 = err;
                            v6 = err;
                            this.this$0.getLogger().warn("Failed to install permission: {} {}", (Object)(v5 != null ? Boxing.boxInt((int)v5.getCode()) : null), (Object)(v6 != null ? v6.getMessage() : null));
                            return Unit.INSTANCE;
lbl55:
                            // 1 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static /* synthetic */ void createPermission$default(RelayAllocation relayAllocation, InetAddress[] inetAddressArray, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            relayAllocation.createPermission(inetAddressArray, bl);
        }

        private final void sendData(DatagramPacket packet) {
            InetSocketAddress destination = new InetSocketAddress(packet.getAddress(), packet.getPort());
            UShort channelId = this.channelAddressToId.get(packet.getSocketAddress());
            if (channelId != null && this.boundChannels.contains(channelId)) {
                short s = channelId.unbox-impl();
                byte[] byArray = packet.getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
                byte[] data = ChannelData.Companion.encode-k_pLkZQ$default(ChannelData.Companion, s, Companion.maybeSliceArray(byArray, packet.getOffset(), packet.getLength()), 0, 0, 12, null);
                StunSocket.this.sendUnchecked(UtilsKt.DatagramPacket(data, this.endpoint.getAddress()));
                return;
            }
            InetAddress[] data = new InetAddress[1];
            Intrinsics.checkNotNullExpressionValue((Object)destination.getAddress(), (String)"getAddress(...)");
            this.createPermission(data, true);
            TransactionId transactionId = TransactionId.Companion.create();
            Object[] objectArray = new StunAttribute[2];
            objectArray[0] = new StunAttribute.XorPeerAddress(destination);
            byte[] byArray = packet.getData();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getData(...)");
            objectArray[1] = new StunAttribute.Data(Companion.maybeSliceArray(byArray, packet.getOffset(), packet.getLength()));
            StunMessage msg = new StunMessage(StunType.Send, StunClass.Indication, transactionId, CollectionsKt.listOf((Object[])objectArray));
            StunSocket.this.sendUnchecked(UtilsKt.DatagramPacket(msg.encode(), this.endpoint.getAddress()));
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object dataPacketReceived$ice(@NotNull ReceivedPacket var1_1, @NotNull Continuation<? super Boolean> var2_2) {
            if (!(var2_2 instanceof dataPacketReceived.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    /* synthetic */ Object result;
                    final /* synthetic */ RelayAllocation this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.dataPacketReceived$ice(null, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    channelData = ChannelData.Companion.tryDecode(packet.getData());
                    if (channelData == null) {
                        this.logger.warn("Got unexpected packet: {}", (Object)UtilsKt.toHexString(packet.getData()));
                        return Boxing.boxBoolean((boolean)false);
                    }
                    peerAddress = this.channelIdToAddress.get(UShort.box-impl((short)channelData.getChannelId-Mh2AYeg()));
                    if (peerAddress == null) {
                        this.logger.warn("Got ChannelData for unknown channel " + UShort.toString-impl((short)channelData.getChannelId-Mh2AYeg()) + '.');
                        return Boxing.boxBoolean((boolean)true);
                    }
                    $continuation.label = 1;
                    v0 = this.relayedPacketReceived(new ReceivedPacket(StunSocket.this, this, packet.getTimestamp(), peerAddress, channelData.getData()), (Continuation<? super Unit>)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    return Boxing.boxBoolean((boolean)true);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final Object stunMessageReceived$ice(@NotNull ReceivedPacket packet, @NotNull StunMessage message2, @NotNull Continuation<? super Unit> $completion) {
            Logger logger2 = ExtendedLoggerKt.withKeyValue(this.logger, "tId", message2.getTransactionId());
            switch (WhenMappings.$EnumSwitchMapping$1[message2.getCls().ordinal()]) {
                case 1: {
                    if (WhenMappings.$EnumSwitchMapping$0[message2.getType().ordinal()] == 1) {
                        Object object = this.stunDataIndicationReceived(logger2, packet, message2, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                    logger2.warn("Got unexpected STUN indication: {}", (Object)message2);
                    break;
                }
                case 2: {
                    logger2.warn("Got unexpected STUN request: {}", (Object)message2);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should have been handled by StunAgent.");
                }
            }
            return Unit.INSTANCE;
        }

        private final Object stunDataIndicationReceived(Logger logger2, ReceivedPacket packet, StunMessage message2, Continuation<? super Unit> $completion) {
            StunAttribute stunAttribute;
            InetSocketAddress peerAddress;
            block8: {
                StunAttribute stunAttribute2;
                boolean bl;
                boolean $i$f$attribute;
                StunMessage this_$iv;
                block7: {
                    this_$iv = message2;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        bl = false;
                        StunAttribute stunAttribute3 = it$iv;
                        if (!(stunAttribute3 instanceof StunAttribute.XorPeerAddress)) {
                            stunAttribute3 = null;
                        }
                        if ((it$iv = (StunAttribute)((StunAttribute.XorPeerAddress)stunAttribute3)) == null) continue;
                        stunAttribute2 = it$iv;
                        break block7;
                    }
                    stunAttribute2 = null;
                }
                StunAttribute.XorPeerAddress xorPeerAddress = (StunAttribute.XorPeerAddress)stunAttribute2;
                peerAddress = xorPeerAddress != null ? xorPeerAddress.getAddress() : null;
                this_$iv = message2;
                $i$f$attribute = false;
                for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                    StunAttribute stunAttribute4;
                    bl = false;
                    StunAttribute stunAttribute5 = it$iv;
                    if (!(stunAttribute5 instanceof StunAttribute.Data)) {
                        stunAttribute5 = null;
                    }
                    if ((stunAttribute4 = (StunAttribute)((StunAttribute.Data)stunAttribute5)) == null) continue;
                    stunAttribute = stunAttribute4;
                    break block8;
                }
                stunAttribute = null;
            }
            StunAttribute.Data data = (StunAttribute.Data)stunAttribute;
            if (peerAddress == null) {
                logger2.warn("STUN Data indication is missing XOR-PEER-ADDRESS attribute: {}", (Object)message2);
                return Unit.INSTANCE;
            }
            if (data == null) {
                logger2.trace("STUN Data indication without DATA attribute: {}", (Object)message2);
                return Unit.INSTANCE;
            }
            logger2.trace("Received STUN Data indication from peer {} with {} bytes of data.", (Object)peerAddress, (Object)Boxing.boxInt((int)data.getBytes().length));
            Object object = this.relayedPacketReceived(new ReceivedPacket(StunSocket.this, this, packet.getTimestamp(), peerAddress, data.getBytes()), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private final Object relayedPacketReceived(ReceivedPacket packet, Continuation<? super Unit> $completion) {
            if (StunMessage.Companion.looksLikeStun(packet.getData())) {
                StunMessage stunMessage = StunSocket.this.manager.messageReceived(this.logger, packet);
                if (stunMessage == null) {
                    return Unit.INSTANCE;
                }
                StunMessage message2 = stunMessage;
                this.logger.atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).addKeyValue("tId", (Object)message2.getTransactionId()).log("Got unexpected relayed STUN message: {}", (Object)message2);
            } else {
                StunManager.StunServer server = StunSocket.this.manager.getServer(packet.getSource());
                if (server != null) {
                    Object object = server.getDataReceiveChannel().send((Object)packet, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
                this.logger.atWarn().addKeyValue("remoteAddress", (Object)packet.getSource()).log("Got unexpected relayed data packet of {} bytes", (Object)Boxing.boxInt((int)packet.getData().length));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$allocateAndHold(RelayAllocation $this, Continuation $completion) {
            return $this.allocateAndHold((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$bindChannel-_TFR7lA(RelayAllocation $this, short channelId, InetSocketAddress address, Continuation $completion) {
            return $this.bindChannel-_TFR7lA(channelId, address, (Continuation<? super Boolean>)$completion);
        }

        public static final /* synthetic */ Set access$getBoundChannels$p(RelayAllocation $this) {
            return $this.boundChannels;
        }

        public static final /* synthetic */ void access$setPreviouslyRequestedPermissions$p(RelayAllocation $this, Set set2) {
            $this.previouslyRequestedPermissions = set2;
        }

        public static final /* synthetic */ Endpoint access$getEndpoint$p(RelayAllocation $this) {
            return $this.endpoint;
        }

        public static final /* synthetic */ Object access$stunDataIndicationReceived(RelayAllocation $this, Logger logger2, ReceivedPacket packet, StunMessage message2, Continuation $completion) {
            return $this.stunDataIndicationReceived(logger2, packet, message2, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$relayedPacketReceived(RelayAllocation $this, ReceivedPacket packet, Continuation $completion) {
            return $this.relayedPacketReceived(packet, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$sendData(RelayAllocation $this, DatagramPacket packet) {
            $this.sendData(packet);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[StunType.values().length];
                try {
                    nArray[StunType.Data.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[StunClass.values().length];
                try {
                    nArray[StunClass.Indication.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StunClass.Request.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lgg/essential/ice/stun/StunSocket$StunBinding;", "", "endpoint", "Lgg/essential/ice/stun/StunSocket$Endpoint;", "Lgg/essential/ice/stun/StunSocket;", "(Lgg/essential/ice/stun/StunSocket;Lgg/essential/ice/stun/StunSocket$Endpoint;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "mappedAddress", "Lkotlinx/coroutines/CompletableDeferred;", "Ljava/net/InetSocketAddress;", "getMappedAddress", "()Lkotlinx/coroutines/CompletableDeferred;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "bindAndHold", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ice"})
    @SourceDebugExtension(value={"SMAP\nStunSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket$StunBinding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StunMessage.kt\ngg/essential/ice/stun/StunMessage\n*L\n1#1,593:1\n1#2:594\n1#2:596\n1#2:598\n1#2:600\n37#3:595\n37#3:597\n37#3:599\n*S KotlinDebug\n*F\n+ 1 StunSocket.kt\ngg/essential/ice/stun/StunSocket$StunBinding\n*L\n294#1:596\n299#1:598\n316#1:600\n294#1:595\n299#1:597\n316#1:599\n*E\n"})
    public final class StunBinding {
        @NotNull
        private final Endpoint endpoint;
        @NotNull
        private final Logger logger;
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final CompletableDeferred<InetSocketAddress> mappedAddress;

        /*
         * WARNING - void declaration
         */
        public StunBinding(Endpoint endpoint) {
            void it;
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.endpoint = endpoint;
            this.logger = ExtendedLoggerKt.withKeyValue(StunSocket.this.getLogger(), "remoteAddress", this.endpoint.getAddress());
            CoroutineScope coroutineScope = StunSocket.this.getScope();
            StunBinding stunBinding = this;
            boolean bl = false;
            stunBinding.scope = CoroutineScopeKt.plus((CoroutineScope)it, (CoroutineContext)((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)it.getCoroutineContext()))));
            this.mappedAddress = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)this.scope.getCoroutineContext()));
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ StunBinding this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.bindAndHold((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                CoroutineScopeKt.cancel$default((CoroutineScope)this.this$0.getScope(), null, (int)1, null);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        public final CoroutineScope getScope() {
            return this.scope;
        }

        @NotNull
        public final CompletableDeferred<InetSocketAddress> getMappedAddress() {
            return this.mappedAddress;
        }

        /*
         * Unable to fully structure code
         */
        private final Object bindAndHold(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof bindAndHold.1)) ** GOTO lbl-1000
            var12_2 = var1_1;
            if ((var12_2.label & -2147483648) != 0) {
                var12_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ StunBinding this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return StunBinding.access$bindAndHold(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.endpoint.request(StunType.Binding, new StunAttribute[0], (Continuation<? super UdpStunPacket>)$continuation);
                    if (v0 == var13_4) {
                        return var13_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (StunBinding)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    v1 = (UdpStunPacket)v0;
                    v2 = initialResponse = v1 != null ? v1.getMessage() : null;
                    if (initialResponse == null) {
                        this.logger.warn("Failed to contact STUN server, timed out.");
                        return Unit.INSTANCE;
                    }
                    if (initialResponse.getCls() == StunClass.ResponseSuccess) ** GOTO lbl44
                    this_$iv = initialResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v3 = it$iv;
                        if (!(v3 instanceof StunAttribute.ErrorCode)) {
                            v3 = null;
                        }
                        if ((it$iv = (StunAttribute)((StunAttribute.ErrorCode)v3)) == null) continue;
                        v4 = it$iv;
                        ** GOTO lbl40
                    }
                    v4 = null;
lbl40:
                    // 2 sources

                    v5 = err = (StunAttribute.ErrorCode)v4;
                    v6 = err;
                    this.logger.warn("Failed to contact STUN server: {} {}", (Object)(v5 != null ? Boxing.boxInt((int)v5.getCode()) : null), (Object)(v6 != null ? v6.getMessage() : null));
                    return Unit.INSTANCE;
lbl44:
                    // 1 sources

                    this_$iv = initialResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v7 = it$iv;
                        if (!(v7 instanceof StunAttribute.XorMappedAddress)) {
                            v7 = null;
                        }
                        if ((var8_17 = (StunAttribute)((StunAttribute.XorMappedAddress)v7)) == null) continue;
                        v8 = var8_17;
                        ** GOTO lbl56
                    }
                    v8 = null;
lbl56:
                    // 2 sources

                    v9 = (StunAttribute.XorMappedAddress)v8;
                    v10 = mappedAddress = v9 != null ? v9.getAddress() : null;
                    if (mappedAddress == null) {
                        this.logger.warn("STUN server did not return XOR-MAPPED-ADDRESS?");
                        return Unit.INSTANCE;
                    }
                    this.logger.debug("Received public address from STUN server: {}", (Object)mappedAddress);
                    this.mappedAddress.complete((Object)mappedAddress);
                    while (true) {
                        $continuation.L$0 = this;
                        $continuation.label = 2;
                        v11 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                        if (v11 == var13_4) {
                            return var13_4;
                        }
                        ** GOTO lbl77
                        break;
                    }
                }
                case 2: {
                    this = (StunBinding)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v11 = $result;
lbl77:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v12 = this.endpoint.request(StunType.Binding, new StunAttribute[0], (Continuation<? super UdpStunPacket>)$continuation);
                    if (v12 == var13_4) {
                        return var13_4;
                    }
                    ** GOTO lbl87
                }
                case 3: {
                    this = (StunBinding)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v12 = $result;
lbl87:
                    // 2 sources

                    v13 = (UdpStunPacket)v12;
                    v14 = refreshResponse = v13 != null ? v13.getMessage() : null;
                    if (refreshResponse != null) ** GOTO lbl92
                    this.logger.warn("Failed to refresh binding, timed out.");
                    ** GOTO lbl108
lbl92:
                    // 1 sources

                    if (refreshResponse.getCls() == StunClass.ResponseSuccess) ** continue;
                    this_$iv = refreshResponse;
                    $i$f$attribute = false;
                    for (StunAttribute it$iv : (Iterable)this_$iv.getAttributes()) {
                        $i$a$-firstNotNullOfOrNull-StunMessage$attribute$1$iv = false;
                        v15 = it$iv;
                        if (!(v15 instanceof StunAttribute.ErrorCode)) {
                            v15 = null;
                        }
                        if ((var9_21 = (StunAttribute)((StunAttribute.ErrorCode)v15)) == null) continue;
                        v16 = var9_21;
                        ** GOTO lbl105
                    }
                    v16 = null;
lbl105:
                    // 2 sources

                    v17 = err = (StunAttribute.ErrorCode)v16;
                    v18 = err;
                    this.logger.warn("Failed to refresh binding: {} {}", (Object)(v17 != null ? Boxing.boxInt((int)v17.getCode()) : null), (Object)(v18 != null ? v18.getMessage() : null));
lbl108:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

