/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.image.imagescaling;

import gg.essential.gui.screenshot.downsampling.BufferBackedImage;
import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.image.imagescaling.AdvancedResizeOp;
import gg.essential.image.imagescaling.DimensionConstrain;
import gg.essential.image.imagescaling.ResampleFilter;
import gg.essential.image.imagescaling.ResampleFilters;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ResampleOp
extends AdvancedResizeOp {
    private static final ExecutorService service = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(100, Comparator.comparingInt(o -> ResampleTask.access$500((ResampleTask)o))));
    private static final Executor backgroundService = Runnable::run;
    public static final ThreadLocal<Boolean> isBackgroundTask = ThreadLocal.withInitial(() -> false);
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private float totalItems;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private AtomicInteger multipleInvocationLock = new AtomicInteger();
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    private static Executor getService() {
        if (isBackgroundTask.get().booleanValue()) {
            return backgroundService;
        }
        return service;
    }

    public ResampleOp(int destWidth, int destHeight) {
        this(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ResampleOp(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    static SubSamplingData createSubSampling(ResampleFilter filter2, int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float scale2 = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = filter2.getSamplingRadius();
        float centerOffset = 0.5f / scale2;
        if (scale2 < 1.0f) {
            float width2 = fwidth / scale2;
            numContributors = (int)(width2 * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width2) / (double)fwidth));
            for (int i2 = 0; i2 < dstSize; ++i2) {
                int k;
                int subindex = i2 * numContributors;
                float center = (float)i2 / scale2 + centerOffset;
                int left = (int)Math.floor(center - width2);
                int right = (int)Math.ceil(center + width2);
                for (int j = left; j <= right; ++j) {
                    float weight = filter2.apply((center - (float)j) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k2 = arrN[i2];
                    int n2 = i2;
                    arrN[n2] = arrN[n2] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k2] = n;
                    arrWeight[subindex + k2] = weight;
                }
                int max = arrN[i2];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        } else {
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i3 = 0; i3 < dstSize; ++i3) {
                int k;
                int subindex = i3 * numContributors;
                float center = (float)i3 / scale2 + centerOffset;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j = left; j <= right; ++j) {
                    float weight = filter2.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k3 = arrN[i3];
                    int n3 = i3;
                    arrN[n3] = arrN[n3] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k3] = n;
                    arrWeight[subindex + k3] = weight;
                }
                int max = arrN[i3];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter2) {
        this.filter = filter2;
    }

    @Override
    public PixelBuffer doFilter(PixelBuffer srcImg, int dstWidth, int dstHeight) throws InterruptedException {
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        if (dstWidth < 3 || dstHeight < 3) {
            throw new RuntimeException("Error doing rescale. Target size was " + dstWidth + "x" + dstHeight + " but must be at least 3x3.");
        }
        assert (this.multipleInvocationLock.incrementAndGet() == 1) : "Multiple concurrent invocations detected";
        this.nrChannels = srcImg.getChannels();
        this.srcWidth = srcImg.getWidth();
        this.srcHeight = srcImg.getHeight();
        byte[][] workPixels = new byte[this.srcHeight][dstWidth * 4];
        this.processedItems = 0;
        this.totalItems = this.srcHeight + dstWidth;
        this.horizontalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcWidth, dstWidth);
        this.verticalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcHeight, dstHeight);
        PixelBuffer scrImgCopy = srcImg;
        byte[][] workPixelsCopy = workPixels;
        CountDownLatch latch = new CountDownLatch(this.numberOfThreads);
        int i2 = 0;
        while (i2 < this.numberOfThreads) {
            int finalI = i2++;
            CountDownLatch finalLatch1 = latch;
            ResampleOp.getService().execute(new ResampleTask(dstWidth, () -> this.horizontallyFromSrcToWork(scrImgCopy, workPixelsCopy, finalI, this.numberOfThreads, finalLatch1)));
        }
        latch.await();
        int dstSize = dstHeight * dstWidth * 4;
        ByteBuf outPixels = srcImg.content().alloc().directBuffer(dstSize);
        outPixels.writerIndex(dstSize);
        ByteBuffer outPixelsCopy = outPixels.nioBuffer();
        latch = new CountDownLatch(this.numberOfThreads);
        int i3 = 0;
        while (i3 < this.numberOfThreads) {
            int finalI = i3++;
            CountDownLatch finalLatch = latch;
            ResampleOp.getService().execute(new ResampleTask(dstWidth, () -> this.verticalFromWorkToDst(workPixelsCopy, outPixelsCopy, finalI, this.numberOfThreads, finalLatch)));
        }
        latch.await();
        workPixels = null;
        assert (this.multipleInvocationLock.decrementAndGet() == 0) : "Multiple concurrent invocations detected";
        return new BufferBackedImage(dstWidth, dstHeight, outPixels);
    }

    private void verticalFromWorkToDst(byte[][] workPixels, ByteBuffer outPixels, int start2, int delta, CountDownLatch latch) {
        for (int x = start2; x < this.dstWidth; x += delta) {
            int xLocation = x * 4;
            for (int y = this.dstHeight - 1; y >= 0; --y) {
                int yTimesNumContributors = y * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y];
                int sampleLocation = (y * this.dstWidth + x) * 4;
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                int index2 = yTimesNumContributors;
                for (int j = max - 1; j >= 0; --j) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index2];
                    float arrWeight = this.verticalSubsamplingData.arrWeight[index2];
                    sample0 += (float)(workPixels[valueLocation][xLocation] & 0xFF) * arrWeight;
                    sample1 += (float)(workPixels[valueLocation][xLocation + 1] & 0xFF) * arrWeight;
                    sample2 += (float)(workPixels[valueLocation][xLocation + 2] & 0xFF) * arrWeight;
                    ++index2;
                }
                outPixels.put(sampleLocation, this.toByte(sample0));
                outPixels.put(sampleLocation + 1, this.toByte(sample1));
                outPixels.put(sampleLocation + 2, this.toByte(sample2));
                outPixels.put(sampleLocation + 3, (byte)-1);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
        latch.countDown();
    }

    private void horizontallyFromSrcToWork(PixelBuffer srcImg, byte[][] workPixels, int start2, int delta, CountDownLatch latch) {
        if (this.nrChannels == 1) {
            latch.countDown();
            return;
        }
        ByteBuffer srcImgArray = srcImg.getBuffer();
        for (int k = start2; k < this.srcHeight; k += delta) {
            int offset = k * srcImg.getWidth() * srcImg.getChannels();
            for (int i2 = this.dstWidth - 1; i2 >= 0; --i2) {
                int sampleLocation = i2 * 4;
                int max = this.horizontalSubsamplingData.arrN[i2];
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                int index2 = i2 * this.horizontalSubsamplingData.numContributors;
                for (int j = max - 1; j >= 0; --j) {
                    float arrWeight = this.horizontalSubsamplingData.arrWeight[index2];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index2] * srcImg.getChannels();
                    sample0 += (float)(srcImgArray.get(offset + pixelIndex) & 0xFF) * arrWeight;
                    sample1 += (float)(srcImgArray.get(offset + pixelIndex + 1) & 0xFF) * arrWeight;
                    sample2 += (float)(srcImgArray.get(offset + pixelIndex + 2) & 0xFF) * arrWeight;
                    ++index2;
                }
                workPixels[k][sampleLocation] = this.toByte(sample0);
                workPixels[k][sampleLocation + 1] = this.toByte(sample1);
                workPixels[k][sampleLocation + 2] = this.toByte(sample2);
            }
            ++this.processedItems;
            if (start2 != 0) continue;
            this.setProgress();
        }
        latch.countDown();
    }

    private byte toByte(float f) {
        if (f < 0.0f) {
            return 0;
        }
        if (f > 255.0f) {
            return -1;
        }
        return (byte)(f + 0.5f);
    }

    private void setProgress() {
        this.fireProgressChanged((float)this.processedItems / this.totalItems);
    }

    static class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final float[] arrWeight;
        private final int numContributors;

        private SubSamplingData(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
        }
    }

    static class ResampleTask
    implements Runnable {
        private final int targetWidth;
        private final Runnable operation;

        ResampleTask(int targetWidth, Runnable operation) {
            this.targetWidth = targetWidth;
            this.operation = operation;
        }

        public int getTargetWidth() {
            return this.targetWidth;
        }

        @Override
        public void run() {
            this.operation.run();
        }
    }
}

