/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.key;

import com.google.common.collect.ImmutableMap;
import gg.essential.api.utils.GuiUtil;
import gg.essential.config.EssentialConfig;
import gg.essential.mixins.transformers.client.options.GameOptionsAccessor;
import gg.essential.mixins.transformers.client.options.KeyBindingAccessor;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_442;
import org.apache.commons.lang3.ArrayUtils;

public class EssentialKeybinding {
    public static final List<EssentialKeybinding> ALL_BINDS = new ArrayList<EssentialKeybinding>();
    public static boolean cancelKeybinds = false;
    public final class_304 keyBinding;
    private final String keyId;
    private final boolean alwaysTick;
    private Runnable onInitialPress;
    private Runnable onRepeatedHold;
    private Runnable onRelease;
    private boolean registeredWithMinecraft = false;
    private boolean pressed = false;
    private boolean requiresEssentialFull = false;
    private static final Map<String, String> LEGACY_IDS = ImmutableMap.builder().build();

    public EssentialKeybinding(String keyId, String category2, int keyCode) {
        this(keyId, category2, keyCode, false);
    }

    public EssentialKeybinding(String keyId, String category2, int keyCode, boolean alwaysTick) {
        this.keyId = keyId;
        this.keyBinding = new class_304(LEGACY_IDS.getOrDefault(keyId, "keybind.name." + keyId), keyCode, category2);
        this.alwaysTick = alwaysTick;
        ALL_BINDS.add(this);
    }

    private int getKeyCode() {
        return ((KeyBindingAccessor)this.keyBinding).getBoundKey().method_1444();
    }

    public void register() {
        class_315 settings2 = class_310.method_1551().field_1690;
        ((GameOptionsAccessor)settings2).setKeyBindings(this.register(settings2.field_1839));
        KeyBindingAccessor.getKeybinds().put(this.keyBinding.method_1431(), this.keyBinding);
        class_304.method_1426();
    }

    class_304[] register(class_304[] allBindings) {
        if (this.registeredWithMinecraft) {
            return allBindings;
        }
        this.registeredWithMinecraft = true;
        return (class_304[])ArrayUtils.add((Object[])allBindings, (Object)this.keyBinding);
    }

    public EssentialKeybinding withInitialPress(Runnable runnable) {
        this.onInitialPress = runnable;
        return this;
    }

    public EssentialKeybinding requiresEssentialFull() {
        this.requiresEssentialFull = true;
        return this;
    }

    public EssentialKeybinding withRelease(Runnable runnable) {
        this.onRelease = runnable;
        return this;
    }

    public EssentialKeybinding withRepeatedHold(Runnable runnable) {
        this.onRepeatedHold = runnable;
        return this;
    }

    public void tickEvents() {
        if (this.alwaysTick) {
            this.tickMainMenu();
        } else if (GuiUtil.getOpenedScreen() instanceof class_442 ^ cancelKeybinds) {
            cancelKeybinds = false;
            this.tickMainMenu();
        } else if (UMinecraft.getWorld() != null) {
            this.tickWorld();
        }
    }

    private void tickMainMenu() {
        boolean keyDown;
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        int keyCode = this.getKeyCode();
        boolean bl = keyDown = keyCode != UKeyboard.KEY_NONE && UKeyboard.isKeyDown((int)keyCode);
        if (!this.pressed && keyDown) {
            this.pressed = true;
            if (this.onInitialPress != null) {
                this.onInitialPress.run();
            }
        } else if (this.pressed && keyDown) {
            if (this.onRepeatedHold != null) {
                this.onRepeatedHold.run();
            }
        } else if (this.pressed) {
            this.pressed = false;
            if (this.onRelease != null) {
                this.onRelease.run();
            }
        }
    }

    private void tickWorld() {
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (this.keyBinding.method_1436() && this.onInitialPress != null) {
            this.onInitialPress.run();
        } else if (this.keyBinding.method_1434() && this.onRepeatedHold != null) {
            this.onRepeatedHold.run();
        } else if (this.pressed && !this.keyBinding.method_1434() && this.onRelease != null) {
            this.onRelease.run();
        }
        this.pressed = this.keyBinding.method_1434();
    }

    public boolean isRegisteredWithMinecraft() {
        return this.registeredWithMinecraft;
    }

    public void setKeyCode(int keyCode) {
        this.keyBinding.method_1422(class_3675.method_15985((int)keyCode, (int)-1));
    }

    public boolean isBound() {
        return !this.keyBinding.method_1415();
    }

    public boolean isConflicting() {
        if (!this.isBound()) {
            return false;
        }
        for (class_304 binding : class_310.method_1551().field_1690.field_1839) {
            if (this.keyBinding == binding || !this.keyBinding.method_1435(binding)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyCode(int keyCode) {
        return this.isBound() && this.getKeyCode() == keyCode;
    }

    public void unregister() {
        if (!this.registeredWithMinecraft) {
            return;
        }
        class_315 settings2 = class_310.method_1551().field_1690;
        int i2 = ArrayUtils.indexOf((Object[])settings2.field_1839, (Object)this.keyBinding);
        if (i2 > 0) {
            ((GameOptionsAccessor)settings2).setKeyBindings((class_304[])ArrayUtils.removeAll((Object[])settings2.field_1839, (int[])new int[]{i2}));
        }
        KeyBindingAccessor.getKeybinds().remove(this.keyBinding.method_1431());
        class_304.method_1426();
        this.registeredWithMinecraft = false;
    }

    public boolean getRequiresEssentialFull() {
        return this.requiresEssentialFull;
    }
}

