/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.sugar.impl;

import gg.essential.lib.mixinextras.injector.StackExtension;
import gg.essential.lib.mixinextras.sugar.impl.SugarApplicationException;
import gg.essential.lib.mixinextras.sugar.impl.SugarApplicator;
import gg.essential.lib.mixinextras.sugar.impl.SugarParameter;
import gg.essential.lib.mixinextras.sugar.impl.ref.LocalRefUtils;
import gg.essential.lib.mixinextras.utils.ASMUtils;
import gg.essential.lib.mixinextras.utils.TargetDecorations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

class ShareSugarApplicator
extends SugarApplicator {
    private final String id;
    private Type innerType;

    ShareSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.id = this.mixin.getClassRef() + ':' + Annotations.getValue((AnnotationNode)this.sugar);
    }

    @Override
    void validate(Target target2, InjectionNodes.InjectionNode node) {
        this.innerType = LocalRefUtils.getTargetType(this.paramType, Type.getType(Object.class));
        if (this.innerType == this.paramType) {
            throw new SugarApplicationException("@Share parameter must be some variation of LocalRef.");
        }
    }

    @Override
    void prepare(Target target2, InjectionNodes.InjectionNode node) {
    }

    @Override
    void inject(Target target2, InjectionNodes.InjectionNode node, StackExtension stack) {
        int localRefIndex;
        Map refIndices = TargetDecorations.getOrPut(target2, "ShareSugar_LocalRefIndices", HashMap::new);
        if (!refIndices.containsKey(this.id)) {
            localRefIndex = target2.allocateLocal();
            refIndices.put(this.id, localRefIndex);
            LabelNode start2 = new LabelNode();
            LabelNode end = new LabelNode();
            target2.addLocalVariable(localRefIndex, "sharedRef" + localRefIndex, this.paramType.getDescriptor());
            List lvt = target2.method.localVariables;
            LocalVariableNode newVar = (LocalVariableNode)lvt.get(lvt.size() - 1);
            newVar.start = start2;
            newVar.end = end;
            target2.insns.insert((AbstractInsnNode)start2);
            target2.insns.add((AbstractInsnNode)end);
            InsnList init2 = new InsnList();
            LocalRefUtils.generateNew(init2, this.innerType);
            init2.add((AbstractInsnNode)new VarInsnNode(58, localRefIndex));
            init2.add((AbstractInsnNode)new VarInsnNode(25, localRefIndex));
            init2.add((AbstractInsnNode)new InsnNode(ASMUtils.getDummyOpcodeForType(this.innerType)));
            LocalRefUtils.generateInitialization(init2, this.innerType);
            target2.insns.insert((AbstractInsnNode)start2, init2);
            stack.ensureAtLeast(this.innerType.getSize() + 1);
        } else {
            localRefIndex = (Integer)refIndices.get(this.id);
        }
        stack.extra(1);
        target2.insns.insertBefore(node.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, localRefIndex));
    }
}

