/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    OptionalMethod(Class<?> returnType, String methodName, Class ... methodParams) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.methodParams = methodParams;
    }

    public boolean isSupported(T target2) {
        return this.getMethod(target2.getClass()) != null;
    }

    public Object invokeOptional(T target2, Object ... args) throws InvocationTargetException {
        Method m = this.getMethod(target2.getClass());
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(target2, args);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T target2, Object ... args) {
        try {
            return this.invokeOptional(target2, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error2 = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error2)).initCause(targetException);
            throw error2;
        }
    }

    public Object invoke(T target2, Object ... args) throws InvocationTargetException {
        Method m = this.getMethod(target2.getClass());
        if (m == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + target2));
        }
        try {
            return m.invoke(target2, args);
        }
        catch (IllegalAccessException e) {
            AssertionError error2 = new AssertionError((Object)("Unexpectedly could not call: " + m));
            ((Throwable)((Object)error2)).initCause(e);
            throw error2;
        }
    }

    public Object invokeWithoutCheckedException(T target2, Object ... args) {
        try {
            return this.invoke(target2, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error2 = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error2)).initCause(targetException);
            throw error2;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

