/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.gui.GuiOpenedEvent;
import gg.essential.mixins.ext.server.integrated.IntegratedServerExt;
import gg.essential.mixins.impl.client.MinecraftExt;
import gg.essential.mixins.impl.client.MinecraftHook;
import gg.essential.sps.McIntegratedServerManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_437;
import net.minecraft.class_5520;
import net.minecraft.class_7853;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MixinMinecraft
implements MinecraftExt {
    private final MinecraftHook minecraftHook = new MinecraftHook((class_310)this);
    private GuiOpenEvent guiOpenEvent;
    @Shadow
    @Mutable
    @Final
    private class_320 field_1726;
    @Shadow
    @Mutable
    @Final
    private CompletableFuture<ProfileResult> field_45899;
    @Shadow
    @Final
    private MinecraftSessionService field_1723;
    @Shadow
    @Mutable
    @Final
    private class_5520 field_26842;
    @Shadow
    @Mutable
    @Final
    private YggdrasilAuthenticationService field_39420;
    @Shadow
    @Mutable
    @Final
    private class_7853 field_39068;
    @Shadow
    @Final
    public File field_1697;
    @Shadow
    @Mutable
    @Final
    private UserApiService field_26902;
    @Shadow
    @Nullable
    private class_1132 field_1766;
    private static final String LAUNCH_INTEGRATED_SERVER = "startIntegratedServer";
    private static final String STOP_INTEGRATED_SERVER = "disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V";

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;dataFixer:Lcom/mojang/datafixers/DataFixer;", opcode=181, shift=At.Shift.AFTER)})
    private void preinit(CallbackInfo ci) {
        this.minecraftHook.preinit();
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/MinecraftClient;onResolutionChanged()V")})
    private void init(CallbackInfo ci) {
        this.minecraftHook.startGame();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        this.minecraftHook.postInit();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void runTick(CallbackInfo ci) {
        this.minecraftHook.runTick();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;cancelTasks()V", shift=At.Shift.AFTER)})
    private void unloadWorld(CallbackInfo ci) {
        this.minecraftHook.disconnect();
    }

    @Inject(method={"scheduleStop"}, at={@At(value="HEAD")})
    private void shutdown(CallbackInfo ci) {
        this.minecraftHook.shutdown();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")})
    private void checkThreadSafety(CallbackInfo ci) {
        if (!UMinecraft.isCallingFromMinecraftThread()) {
            Essential.logger.error("Detected call to `openScreen` on thread {}. This method is NOT thread safe and MUST NOT be called from any thread except the main client thread! Please report this to the mod responsible as per the following stacktrace:", (Object)Thread.currentThread(), (Object)new Throwable());
        }
    }

    @ModifyVariable(method={"setScreen"}, at=@At(value="HEAD"))
    public class_437 displayGuiScreen(class_437 screen) {
        this.guiOpenEvent = this.minecraftHook.displayGuiScreen(screen);
        return this.guiOpenEvent.getGui();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void displayGuiScreen(class_437 screen, CallbackInfo info) {
        if (this.guiOpenEvent != null && this.guiOpenEvent.isCancelled()) {
            info.cancel();
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="TAIL")})
    public void essential$fireGuiOpenedEvent(class_437 screen, CallbackInfo info) {
        if (screen == null) {
            return;
        }
        Essential.EVENT_BUS.post(new GuiOpenedEvent(screen));
    }

    @Override
    public void setSession(class_320 session) {
        class_320 oldSession = this.field_1726;
        this.field_1726 = session;
        this.field_45899 = CompletableFuture.supplyAsync(() -> this.field_1723.fetchProfile(session.method_44717(), true), class_156.method_27958());
        YggdrasilAuthenticationService authenticationService = this.field_39420;
        this.field_26902 = authenticationService.createUserApiService(session.method_1674());
        this.field_26842 = new class_5520((class_310)this, this.field_26902);
        this.field_39068 = class_7853.method_46532((UserApiService)this.field_26902, (class_320)session, (Path)this.field_1697.toPath());
        Essential.EVENT_BUS.post(new ReAuthEvent(HelpersKt.toUSession(session)));
    }

    @Inject(method={"startIntegratedServer"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;server:Lnet/minecraft/server/integrated/IntegratedServer;", shift=At.Shift.AFTER)})
    private void setIntegratedServerManager(CallbackInfo ci) {
        IntegratedServerExt ext = (IntegratedServerExt)this.field_1766;
        assert (ext != null);
        Essential.getInstance().getIntegratedServerManager().set(ext.getEssential$manager());
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;server:Lnet/minecraft/server/integrated/IntegratedServer;", shift=At.Shift.AFTER)})
    private void unsetIntegratedServerManager(CallbackInfo ci) {
        Essential.getInstance().getIntegratedServerManager().set((McIntegratedServerManager)null);
    }
}

