/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat4;
import gg.essential.mixins.impl.client.model.CapePoseSupplier;
import gg.essential.mixins.transformers.client.model.ModelPlayerAccessor;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.minecraft.PlayerPoseKt;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.util.GLUtil;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_972;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_972.class})
public abstract class Mixin_ApplyPoseTransform_Cape
extends class_3887<class_742, class_591<class_742>>
implements CapePoseSupplier {
    private static final String RENDER_LAYER = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V";
    private static final String PUSH_MATRIX = "Lnet/minecraft/client/util/math/MatrixStack;push()V";
    private static final String RENDER_CAPE = "Lnet/minecraft/client/render/entity/model/PlayerEntityModel;renderCape(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;II)V";
    @Unique
    private PlayerPose.Part renderedPose;
    @Unique
    private PlayerPose.Part resetPose;

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    private void unsetRenderedPose(CallbackInfo ci) {
        this.renderedPose = null;
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;push()V", shift=At.Shift.AFTER)})
    private void isolateCapeMatrix(class_4587 matrixStack, class_4597 buffer, int light, class_742 player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live(player2);
        PlayerPoseManager poseManager = cState.poseManager();
        if (poseManager == null) {
            return;
        }
        matrixStack.method_23760().method_23761().identity();
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/PlayerEntityModel;renderCape(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;II)V")})
    private void applyPoseTransform(class_4587 matrixStack, class_4597 buffer, int light, class_742 player2, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live(player2);
        PlayerPoseManager poseManager = cState.poseManager();
        if (poseManager == null) {
            return;
        }
        float scale2 = 0.0625f;
        class_630 capeModel = this.getCapeModel();
        MutableMat4 capeMatrix = GLUtil.INSTANCE.glGetMatrix(matrixStack, scale2);
        matrixStack.method_22909();
        matrixStack.method_22903();
        PlayerPose basePose = PlayerPoseKt.withCapePose(PlayerPose.Companion.neutral(), capeModel, capeMatrix);
        PlayerPose transformedPose = poseManager.computePose(cState.wearablesManager(), basePose);
        this.renderedPose = transformedPose.getCape();
        if (basePose.equals(transformedPose)) {
            GLUtil.INSTANCE.glMultMatrix(matrixStack, capeMatrix, scale2);
            return;
        }
        this.resetPose = PlayerPoseKt.toPose(capeModel);
        PlayerPoseKt.applyTo(transformedPose.getCape(), capeModel);
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/PlayerEntityModel;renderCape(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;II)V", shift=At.Shift.AFTER)})
    private void resetPose(CallbackInfo ci) {
        if (this.resetPose != null) {
            PlayerPoseKt.applyTo(this.resetPose, this.getCapeModel());
            this.resetPose = null;
        }
    }

    @Unique
    private class_630 getCapeModel() {
        return ((ModelPlayerAccessor)this.method_17165()).getCape();
    }

    @Override
    @Nullable
    public PlayerPose.Part getCapePose() {
        return this.renderedPose;
    }

    Mixin_ApplyPoseTransform_Cape() {
        super(null);
    }
}

