/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.per_server_settings;

import gg.essential.Essential;
import gg.essential.lib.mixinextras.injector.ModifyExpressionValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_310;
import net.minecraft.class_641;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={class_641.class})
public abstract class Mixin_PreserveCustomServerData {
    private static final String NBT_READ = "Lnet/minecraft/nbt/NbtIo;read(Ljava/nio/file/Path;)Lnet/minecraft/nbt/NbtCompound;";
    private static final String NBT_WRITE = "Lnet/minecraft/nbt/NbtIo;write(Lnet/minecraft/nbt/NbtCompound;Ljava/nio/file/Path;)V";
    @Shadow
    @Final
    private class_310 field_3750;

    @Unique
    private File backupFile() {
        return new File(this.field_3750.field_1697, "servers.essential.dat");
    }

    @ModifyArg(method={"saveFile"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;write(Lnet/minecraft/nbt/NbtCompound;Ljava/nio/file/Path;)V"))
    private class_2487 backupServerList(class_2487 tag2) throws IOException {
        class_2507.method_10630((class_2487)tag2, (Path)this.backupFile().toPath());
        return tag2;
    }

    @ModifyExpressionValue(method={"loadFile"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;read(Ljava/nio/file/Path;)Lnet/minecraft/nbt/NbtCompound;")})
    private class_2487 validateAndRestoreServerList(class_2487 vanillaTag) {
        class_2487 backupTag;
        if (vanillaTag == null) {
            return null;
        }
        try {
            backupTag = class_2507.method_10633((Path)this.backupFile().toPath());
        }
        catch (Exception e) {
            Essential.logger.error("Couldn't load server list backup", (Throwable)e);
            try {
                class_2507.method_10630((class_2487)vanillaTag, (Path)this.backupFile().toPath());
            }
            catch (Exception e1) {
                Essential.logger.error("Couldn't re-write server list backup", (Throwable)e1);
            }
            backupTag = null;
        }
        if (backupTag == null) {
            return vanillaTag;
        }
        if (vanillaTag.equals((Object)backupTag)) {
            return vanillaTag;
        }
        class_2499 vanillaServers = vanillaTag.method_10554("servers", 10);
        class_2499 backupServers = backupTag.method_10554("servers", 10);
        HashSet<class_2487> alreadyMatched = new HashSet<class_2487>();
        for (int pass = 0; pass < 3; ++pass) {
            block10: for (int vanillaIdx = 0; vanillaIdx < vanillaServers.size(); ++vanillaIdx) {
                List<class_2487> vanillaMatches;
                List<class_2487> backupMatches;
                class_2487 vanillaServer = vanillaServers.method_10602(vanillaIdx);
                if (alreadyMatched.contains(vanillaServer)) continue;
                String name2 = vanillaServer.method_10558("name");
                String address = vanillaServer.method_10558("ip");
                switch (pass) {
                    case 0: {
                        backupMatches = this.find(backupServers, alreadyMatched, name2, address);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, name2, address);
                        break;
                    }
                    case 1: {
                        backupMatches = this.find(backupServers, alreadyMatched, null, address);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, null, address);
                        break;
                    }
                    case 2: {
                        backupMatches = this.find(backupServers, alreadyMatched, name2, null);
                        vanillaMatches = this.find(vanillaServers, alreadyMatched, name2, null);
                        if (backupMatches.size() == vanillaMatches.size()) break;
                        continue block10;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (backupMatches.isEmpty()) continue;
                int index2 = vanillaMatches.indexOf(vanillaServer);
                if (index2 >= backupMatches.size()) {
                    index2 = backupMatches.size() - 1;
                }
                class_2487 backupServer = backupMatches.get(index2);
                alreadyMatched.add(vanillaServer);
                alreadyMatched.add(backupServer);
                for (String key : backupServer.method_10541()) {
                    if (!key.startsWith("essential:")) continue;
                    vanillaServer.method_10566(key, backupServer.method_10580(key));
                }
            }
        }
        return vanillaTag;
    }

    @Unique
    private List<class_2487> find(class_2499 list, Set<class_2487> alreadyMatched, String name2, String address) {
        ArrayList<class_2487> result = new ArrayList<class_2487>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            class_2487 server = list.method_10602(i2);
            if (alreadyMatched.contains(server) || name2 != null && !server.method_10558("name").equals(name2) || address != null && !server.method_10558("ip").equals(address)) continue;
            result.add(server);
        }
        return result;
    }
}

