/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.state.EssentialAnimationSystem;
import gg.essential.cosmetics.state.TextureAnimationSync;
import gg.essential.cosmetics.state.WearableLocator;
import gg.essential.model.BedrockModel;
import gg.essential.model.Bone;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.RenderMetadata;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.util.UMatrixStack;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J&\u00107\u001a\u00020\f2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020\u0003J\u0018\u0010B\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u0001052\u0006\u0010D\u001a\u00020ER\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006F"}, d2={"Lgg/essential/model/ModelInstance;", "", "model", "Lgg/essential/model/BedrockModel;", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "animationTargets", "", "Lgg/essential/cosmetics/events/AnimationTarget;", "onAnimation", "Lkotlin/Function1;", "", "", "(Lgg/essential/model/BedrockModel;Lgg/essential/model/molang/MolangQueryEntity;Ljava/util/Set;Lkotlin/jvm/functions/Function1;)V", "animationState", "Lgg/essential/model/ModelAnimationState;", "getAnimationState", "()Lgg/essential/model/ModelAnimationState;", "setAnimationState", "(Lgg/essential/model/ModelAnimationState;)V", "getAnimationTargets", "()Ljava/util/Set;", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "getCosmetic", "()Lgg/essential/network/cosmetics/Cosmetic;", "getEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "essentialAnimationSystem", "Lgg/essential/cosmetics/state/EssentialAnimationSystem;", "getEssentialAnimationSystem", "()Lgg/essential/cosmetics/state/EssentialAnimationSystem;", "setEssentialAnimationSystem", "(Lgg/essential/cosmetics/state/EssentialAnimationSystem;)V", "locator", "Lgg/essential/cosmetics/state/WearableLocator;", "getLocator", "()Lgg/essential/cosmetics/state/WearableLocator;", "setLocator", "(Lgg/essential/cosmetics/state/WearableLocator;)V", "getModel", "()Lgg/essential/model/BedrockModel;", "setModel", "(Lgg/essential/model/BedrockModel;)V", "getOnAnimation", "()Lkotlin/jvm/functions/Function1;", "textureAnimationSync", "Lgg/essential/cosmetics/state/TextureAnimationSync;", "getTextureAnimationSync", "()Lgg/essential/cosmetics/state/TextureAnimationSync;", "setTextureAnimationSync", "(Lgg/essential/cosmetics/state/TextureAnimationSync;)V", "computePose", "Lgg/essential/model/backend/PlayerPose;", "basePose", "render", "matrixStack", "Lgg/essential/model/util/UMatrixStack;", "vertexConsumerProvider", "Lgg/essential/model/backend/RenderBackend$VertexConsumerProvider;", "rootBone", "Lgg/essential/model/Bone;", "renderMetadata", "Lgg/essential/model/RenderMetadata;", "switchModel", "newModel", "updateLocators", "renderedPose", "state", "Lgg/essential/cosmetics/CosmeticsState;", "cosmetics"})
public final class ModelInstance {
    @NotNull
    private BedrockModel model;
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final Set<AnimationTarget> animationTargets;
    @NotNull
    private final Function1<String, Unit> onAnimation;
    @NotNull
    private WearableLocator locator;
    @NotNull
    private ModelAnimationState animationState;
    @NotNull
    private TextureAnimationSync textureAnimationSync;
    @NotNull
    private EssentialAnimationSystem essentialAnimationSystem;

    public ModelInstance(@NotNull BedrockModel model, @NotNull MolangQueryEntity entity, @NotNull Set<? extends AnimationTarget> animationTargets, @NotNull Function1<? super String, Unit> onAnimation) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(animationTargets, (String)"animationTargets");
        Intrinsics.checkNotNullParameter(onAnimation, (String)"onAnimation");
        this.model = model;
        this.entity = entity;
        this.animationTargets = animationTargets;
        this.onAnimation = onAnimation;
        this.locator = new WearableLocator(this.entity.getLocator());
        this.animationState = new ModelAnimationState(this.entity, this.locator);
        this.textureAnimationSync = new TextureAnimationSync(this.model.getTextureFrameCount());
        this.essentialAnimationSystem = new EssentialAnimationSystem(this.model, this.entity, this.animationState, this.textureAnimationSync, this.animationTargets, this.onAnimation);
    }

    @NotNull
    public final BedrockModel getModel() {
        return this.model;
    }

    public final void setModel(@NotNull BedrockModel bedrockModel) {
        Intrinsics.checkNotNullParameter((Object)bedrockModel, (String)"<set-?>");
        this.model = bedrockModel;
    }

    @NotNull
    public final MolangQueryEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final Set<AnimationTarget> getAnimationTargets() {
        return this.animationTargets;
    }

    @NotNull
    public final Function1<String, Unit> getOnAnimation() {
        return this.onAnimation;
    }

    @NotNull
    public final WearableLocator getLocator() {
        return this.locator;
    }

    public final void setLocator(@NotNull WearableLocator wearableLocator) {
        Intrinsics.checkNotNullParameter((Object)wearableLocator, (String)"<set-?>");
        this.locator = wearableLocator;
    }

    @NotNull
    public final ModelAnimationState getAnimationState() {
        return this.animationState;
    }

    public final void setAnimationState(@NotNull ModelAnimationState modelAnimationState) {
        Intrinsics.checkNotNullParameter((Object)modelAnimationState, (String)"<set-?>");
        this.animationState = modelAnimationState;
    }

    @NotNull
    public final TextureAnimationSync getTextureAnimationSync() {
        return this.textureAnimationSync;
    }

    public final void setTextureAnimationSync(@NotNull TextureAnimationSync textureAnimationSync) {
        Intrinsics.checkNotNullParameter((Object)textureAnimationSync, (String)"<set-?>");
        this.textureAnimationSync = textureAnimationSync;
    }

    @NotNull
    public final EssentialAnimationSystem getEssentialAnimationSystem() {
        return this.essentialAnimationSystem;
    }

    public final void setEssentialAnimationSystem(@NotNull EssentialAnimationSystem essentialAnimationSystem) {
        Intrinsics.checkNotNullParameter((Object)essentialAnimationSystem, (String)"<set-?>");
        this.essentialAnimationSystem = essentialAnimationSystem;
    }

    public final void switchModel(@NotNull BedrockModel newModel) {
        Intrinsics.checkNotNullParameter((Object)newModel, (String)"newModel");
        boolean newTextureAnimation = this.model.getTextureFrameCount() != newModel.getTextureFrameCount();
        boolean newAnimations = !Intrinsics.areEqual(this.model.getAnimations(), newModel.getAnimations()) || !Intrinsics.areEqual(this.model.getAnimationEvents(), newModel.getAnimationEvents());
        this.model = newModel;
        if (newTextureAnimation) {
            this.textureAnimationSync = new TextureAnimationSync(this.model.getTextureFrameCount());
        }
        if (newAnimations) {
            this.locator.setValid(false);
            this.locator = new WearableLocator(this.entity.getLocator());
            this.animationState = new ModelAnimationState(this.entity, this.locator);
        }
        if (newAnimations || newTextureAnimation) {
            this.essentialAnimationSystem = new EssentialAnimationSystem(this.model, this.entity, this.animationState, this.textureAnimationSync, this.animationTargets, this.onAnimation);
        }
    }

    @NotNull
    public final Cosmetic getCosmetic() {
        return this.model.getCosmetic();
    }

    @NotNull
    public final PlayerPose computePose(@NotNull PlayerPose basePose) {
        Intrinsics.checkNotNullParameter((Object)basePose, (String)"basePose");
        return this.model.computePose(basePose, this.animationState, this.entity);
    }

    public final void updateLocators(@Nullable PlayerPose renderedPose, @NotNull CosmeticsState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (this.animationState.locatorsNeedUpdating()) {
            PlayerPose playerPose = renderedPose;
            if (playerPose == null) {
                playerPose = PlayerPose.copy$default(PlayerPose.Companion.neutral(), null, null, null, null, null, null, PlayerPose.Part.Companion.getMISSING(), PlayerPose.Part.Companion.getMISSING(), PlayerPose.Part.Companion.getMISSING(), PlayerPose.Part.Companion.getMISSING(), PlayerPose.Part.Companion.getMISSING(), false, 2111, null);
            }
            PlayerPose pose = playerPose;
            Bone rootBone = this.model.getRootBone();
            this.animationState.apply(rootBone, false);
            this.model.applyPose(rootBone, pose, this.entity);
            Set set2 = state2.getHiddenBones().get(this.getCosmetic().getId());
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            this.model.propagateVisibilityToRootBone(state2.getSides().get(this.getCosmetic().getId()), rootBone, set2, SetsKt.minus((Set)ArraysKt.toSet((Object[])EnumPart.values()), (Iterable)state2.getHiddenParts().getOrDefault(this.getCosmetic().getId(), SetsKt.emptySet())));
            this.animationState.updateLocators(rootBone, 1.0f / 16.0f);
        }
    }

    public final void render(@NotNull UMatrixStack matrixStack, @NotNull RenderBackend.VertexConsumerProvider vertexConsumerProvider, @NotNull Bone rootBone, @NotNull RenderMetadata renderMetadata) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumerProvider, (String)"vertexConsumerProvider");
        Intrinsics.checkNotNullParameter((Object)rootBone, (String)"rootBone");
        Intrinsics.checkNotNullParameter((Object)renderMetadata, (String)"renderMetadata");
        this.animationState.apply(rootBone, false);
        for (Bone bone : this.model.getBones(rootBone)) {
            if (EnumPart.Companion.fromBoneName(bone.boxName) == null) continue;
            bone.userOffsetX = renderMetadata.getPositionAdjustment().x;
            bone.userOffsetY = renderMetadata.getPositionAdjustment().y;
            bone.userOffsetZ = renderMetadata.getPositionAdjustment().z;
        }
        this.model.render(matrixStack, vertexConsumerProvider, rootBone, this.entity, renderMetadata, this.textureAnimationSync.getAdjustedLifetime(this.entity.getLifeTime()));
    }
}

