/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.Essential;
import gg.essential.event.render.RenderTickEvent;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kotgl.matrix.matrices.Mat4;
import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.mixins.impl.client.renderer.entity.PlayerEntityRendererExt;
import gg.essential.model.ParticleSystem;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.util.KotglKt;
import gg.essential.model.util.Quaternion;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerMolangQuery
implements MolangQueryEntity,
ParticleSystem.Locator {
    private final class_1657 player;
    private long removedWorldTime = -1L;
    private static float partialTicksMenu;
    private static float partialTicksInGame;

    public PlayerMolangQuery(class_1657 player2) {
        this.player = player2;
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    private float getPartialTicks() {
        return this.player instanceof EmulatedUI3DPlayer.EmulatedPlayer ? partialTicksMenu : partialTicksInGame;
    }

    @Override
    public float getLifeTime() {
        if (this.player.field_6012 <= 1) {
            return (float)this.player.field_6012 / 20.0f;
        }
        return ((float)this.player.field_6012 + this.getPartialTicks()) / 20.0f;
    }

    @Override
    public float getTime() {
        if (this.isValid()) {
            return this.getLifeTime();
        }
        class_1937 world = this.player.method_5770();
        if (world == null) {
            return this.getLifeTime();
        }
        long worldTime = world.method_8510();
        if (this.removedWorldTime == -1L) {
            this.removedWorldTime = worldTime;
        }
        int timeSinceRemoved = (int)(worldTime - this.removedWorldTime);
        return ((float)(this.player.field_6012 + timeSinceRemoved) + this.getPartialTicks()) / 20.0f;
    }

    @Override
    public float getModifiedDistanceMoved() {
        float next = this.player.field_5973;
        float prev = this.player.field_6039;
        float now = prev + (next - prev) * this.getPartialTicks();
        return now * 16.0f;
    }

    @Override
    public float getModifiedMoveSpeed() {
        float next = this.player.field_5973;
        float prev = this.player.field_6039;
        return (next - prev) * 16.0f;
    }

    @Override
    @NotNull
    public ParticleSystem.Locator getLocator() {
        return this;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.player.method_5667();
    }

    @Override
    @Nullable
    public ParticleSystem.Locator getParent() {
        return null;
    }

    @Override
    public boolean isValid() {
        return !this.player.method_31481();
    }

    @Override
    @NotNull
    public Vec3 getPosition() {
        return (Vec3)this.getPositionAndRotation().getFirst();
    }

    @Override
    @NotNull
    public Quaternion getRotation() {
        return (Quaternion)this.getPositionAndRotation().getSecond();
    }

    private Vec3 getBasePosition() {
        float partialTicks = this.getPartialTicks();
        class_243 nextPos = this.player.method_19538();
        float nextX = (float)nextPos.field_1352;
        float nextY = (float)nextPos.field_1351;
        float nextZ = (float)nextPos.field_1350;
        float prevX = (float)this.player.field_6038;
        float prevY = (float)this.player.field_5971;
        float prevZ = (float)this.player.field_5989;
        if (this.player.method_18276()) {
            prevY -= 0.125f;
            nextY -= 0.125f;
        }
        return Vectors.vec3(prevX + (nextX - prevX) * partialTicks, prevY + (nextY - prevY) * partialTicks, prevZ + (nextZ - prevZ) * partialTicks);
    }

    private float getRenderYaw() {
        RealYawAccess access = (RealYawAccess)this.player;
        float next = access.essential$getRealRenderYaw();
        float prev = access.essential$getRealPrevRenderYaw();
        return prev + (next - prev) * this.getPartialTicks();
    }

    private Quaternion getBaseRotation() {
        return Quaternion.Companion.fromAxisAngle(Vectors.vecUnitY(), (float)(Math.PI - Math.toRadians(this.getRenderYaw())));
    }

    @Override
    @NotNull
    public Pair<Vec3, Quaternion> getPositionAndRotation() {
        if (!(this.player instanceof class_742)) {
            return new Pair((Object)this.getBasePosition(), (Object)this.getBaseRotation());
        }
        class_897 renderer = class_310.method_1551().method_1561().method_3953((class_1297)this.player);
        if (!(renderer instanceof PlayerEntityRendererExt)) {
            return new Pair((Object)this.getBasePosition(), (Object)this.getBaseRotation());
        }
        PlayerEntityRendererExt rendererExt = (PlayerEntityRendererExt)renderer;
        Mat4 mat = rendererExt.essential$getTransform((class_742)this.player, this.getRenderYaw(), this.getPartialTicks());
        MutableVec3 position2 = MutableVectors.plus(KotglKt.transformPosition(mat, Vectors.vecZero()), this.getBasePosition());
        Quaternion rotation = Quaternion.Companion.fromRotationMatrix(KotglKt.toMat3(mat));
        return new Pair((Object)position2, (Object)rotation);
    }

    @Override
    @NotNull
    public Vec3 getVelocity() {
        class_243 motion = this.player.method_18798();
        return Vectors.vec3((float)motion.field_1352 * 20.0f, (float)motion.field_1351 * 20.0f, (float)motion.field_1350 * 20.0f);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    static {
        Essential.EVENT_BUS.register(new Object(){

            @Subscribe(priority=1)
            private void renderWorld(RenderTickEvent event) {
                partialTicksMenu = event.getPartialTicksMenu();
                partialTicksInGame = event.getPartialTicksInGame();
            }
        });
    }

    public static interface RealYawAccess {
        public float essential$getRealRenderYaw();

        public float essential$getRealPrevRenderYaw();
    }
}

