/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.backend.atlas;

import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.atlas.Packing;
import gg.essential.model.backend.atlas.TextureAtlasKt;
import gg.essential.model.backend.atlas.WH;
import gg.essential.model.util.ResourceCleaner;
import gg.essential.model.util.UMatrixStack;
import gg.essential.model.util.UVertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgg/essential/model/backend/atlas/TextureAtlas;", "Ljava/lang/AutoCloseable;", "renderBackend", "Lgg/essential/model/backend/RenderBackend;", "atlasTexture", "Lgg/essential/model/backend/RenderBackend$Texture;", "textures", "", "Lgg/essential/model/backend/atlas/TextureAtlas$Entry;", "(Lgg/essential/model/backend/RenderBackend;Lgg/essential/model/backend/RenderBackend$Texture;Ljava/util/Map;)V", "getAtlasTexture", "()Lgg/essential/model/backend/RenderBackend$Texture;", "close", "", "offsetVertexConsumer", "Lgg/essential/model/util/UVertexConsumer;", "texture", "vertexConsumer", "Companion", "Entry", "cosmetics"})
public final class TextureAtlas
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderBackend renderBackend;
    @NotNull
    private final RenderBackend.Texture atlasTexture;
    @NotNull
    private final Map<RenderBackend.Texture, Entry> textures;
    @NotNull
    private static final ResourceCleaner<TextureAtlas> resourceCleaner = new ResourceCleaner();

    private TextureAtlas(RenderBackend renderBackend, RenderBackend.Texture atlasTexture, Map<RenderBackend.Texture, Entry> textures) {
        this.renderBackend = renderBackend;
        this.atlasTexture = atlasTexture;
        this.textures = textures;
        RenderBackend renderBackend2 = this.renderBackend;
        RenderBackend.Texture atlasTexture2 = this.atlasTexture;
        resourceCleaner.register(this, () -> TextureAtlas._init_$lambda$0(renderBackend2, atlasTexture2));
        resourceCleaner.runCleanups();
    }

    @NotNull
    public final RenderBackend.Texture getAtlasTexture() {
        return this.atlasTexture;
    }

    @Override
    public void close() {
        this.renderBackend.deleteTexture(this.atlasTexture);
    }

    @NotNull
    public final UVertexConsumer offsetVertexConsumer(@NotNull RenderBackend.Texture texture, @NotNull UVertexConsumer vertexConsumer) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        Entry entry = (Entry)MapsKt.getValue(this.textures, (Object)texture);
        return new UVertexConsumer(vertexConsumer, entry){
            private final /* synthetic */ UVertexConsumer $$delegate_0;
            final /* synthetic */ UVertexConsumer $vertexConsumer;
            final /* synthetic */ Entry $entry;
            {
                this.$vertexConsumer = $vertexConsumer;
                this.$entry = $entry;
                this.$$delegate_0 = $vertexConsumer;
            }

            @NotNull
            public UVertexConsumer color-EIFkdBU(int color2) {
                return this.$$delegate_0.color-EIFkdBU(color2);
            }

            @NotNull
            public UVertexConsumer endVertex() {
                return this.$$delegate_0.endVertex();
            }

            @NotNull
            public UVertexConsumer light-vX8ayIk(int light) {
                return this.$$delegate_0.light-vX8ayIk(light);
            }

            @NotNull
            public UVertexConsumer norm(@NotNull UMatrixStack stack, float x, float y, float z) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return this.$$delegate_0.norm(stack, x, y, z);
            }

            @NotNull
            public UVertexConsumer pos(@NotNull UMatrixStack stack, double x, double y, double z) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return this.$$delegate_0.pos(stack, x, y, z);
            }

            @NotNull
            public UVertexConsumer tex(double u, double v) {
                this.$vertexConsumer.tex(u * this.$entry.getUScale() + this.$entry.getUOffset(), v * this.$entry.getVScale() + this.$entry.getVOffset());
                return this;
            }
        };
    }

    private static final void _init_$lambda$0(RenderBackend $renderBackend, RenderBackend.Texture $atlasTexture) {
        Intrinsics.checkNotNullParameter((Object)$renderBackend, (String)"$renderBackend");
        Intrinsics.checkNotNullParameter((Object)$atlasTexture, (String)"$atlasTexture");
        $renderBackend.deleteTexture($atlasTexture);
    }

    public /* synthetic */ TextureAtlas(RenderBackend renderBackend, RenderBackend.Texture atlasTexture, Map textures, DefaultConstructorMarker $constructor_marker) {
        this(renderBackend, atlasTexture, textures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgg/essential/model/backend/atlas/TextureAtlas$Companion;", "", "()V", "resourceCleaner", "Lgg/essential/model/util/ResourceCleaner;", "Lgg/essential/model/backend/atlas/TextureAtlas;", "create", "renderBackend", "Lgg/essential/model/backend/RenderBackend;", "name", "", "textures", "", "Lgg/essential/model/backend/RenderBackend$Texture;", "cosmetics"})
    @SourceDebugExtension(value={"SMAP\nTextureAtlas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextureAtlas.kt\ngg/essential/model/backend/atlas/TextureAtlas$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1547#2:223\n1618#2,3:224\n1052#2:227\n1547#2:228\n1618#2,3:229\n1547#2:232\n1618#2,3:233\n1177#2,2:236\n1251#2,4:238\n*S KotlinDebug\n*F\n+ 1 TextureAtlas.kt\ngg/essential/model/backend/atlas/TextureAtlas$Companion\n*L\n56#1:223\n56#1:224,3\n58#1:227\n59#1:228\n59#1:229,3\n62#1:232\n62#1:233,3\n66#1:236,2\n66#1:238,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final TextureAtlas create(@NotNull RenderBackend renderBackend, @NotNull String name2, @NotNull Collection<? extends RenderBackend.Texture> textures) {
            void $this$associateTo$iv$iv;
            Collection<RenderBackend.BlitOp> collection;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Object object2;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)renderBackend, (String)"renderBackend");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(textures, (String)"textures");
            Iterable $this$map$iv = textures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                RenderBackend.Texture texture = (RenderBackend.Texture)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(TuplesKt.to((Object)it, (Object)new WH(it.getWidth(), it.getHeight())));
            }
            List toBePlaced = (List)destination$iv$iv;
            Iterable $this$sortedByDescending$iv = toBePlaced;
            boolean $i$f$sortedByDescending = false;
            List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    WH size;
                    Pair pair = (Pair)b;
                    boolean bl = false;
                    WH $this$create_u24lambda_u242_u24lambda_u241 = size = (WH)pair.component2();
                    boolean bl2 = false;
                    pair = (Pair)a;
                    Comparable comparable = Integer.valueOf($this$create_u24lambda_u242_u24lambda_u241.getW() * $this$create_u24lambda_u242_u24lambda_u241.getH() * Math.max($this$create_u24lambda_u242_u24lambda_u241.getW(), $this$create_u24lambda_u242_u24lambda_u241.getH()) / Math.min($this$create_u24lambda_u242_u24lambda_u241.getW(), $this$create_u24lambda_u242_u24lambda_u241.getH()));
                    bl = false;
                    $this$create_u24lambda_u242_u24lambda_u241 = size = (WH)pair.component2();
                    bl2 = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf($this$create_u24lambda_u242_u24lambda_u241.getW() * $this$create_u24lambda_u242_u24lambda_u241.getH() * Math.max($this$create_u24lambda_u242_u24lambda_u241.getW(), $this$create_u24lambda_u242_u24lambda_u241.getH()) / Math.min($this$create_u24lambda_u242_u24lambda_u241.getW(), $this$create_u24lambda_u242_u24lambda_u241.getH())));
                }
            });
            Iterable $this$map$iv2 = sorted;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Pair)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                object2.add((RenderBackend.Texture)it.getFirst());
            }
            Packing packing = TextureAtlasKt.access$pack((List)destination$iv$iv2, 4096);
            if (packing == null) {
                return null;
            }
            Packing packing2 = packing;
            RenderBackend.Texture atlasTexture = renderBackend.createTexture("atlas/" + name2, packing2.getAtlasWidth(), packing2.getAtlasHeight());
            $this$map$iv2 = packing2.getTextures();
            RenderBackend.Texture texture = atlasTexture;
            object2 = renderBackend;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (gg.essential.model.backend.atlas.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                RenderBackend.Texture texture2 = ((gg.essential.model.backend.atlas.Entry)object).component1();
                int x = ((gg.essential.model.backend.atlas.Entry)object).component2();
                int y = ((gg.essential.model.backend.atlas.Entry)object).component3();
                int w = ((gg.essential.model.backend.atlas.Entry)object).component4();
                int h = ((gg.essential.model.backend.atlas.Entry)object).component5();
                boolean flipped = ((gg.essential.model.backend.atlas.Entry)object).component6();
                collection.add(new RenderBackend.BlitOp(texture2, 0, 0, x, y, w, h));
            }
            collection = (List)destination$iv$iv2;
            object2.blitTexture(texture, (Iterable<RenderBackend.BlitOp>)collection);
            Iterable $this$associate$iv = packing2.getTextures();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv3;
                gg.essential.model.backend.atlas.Entry entry = (gg.essential.model.backend.atlas.Entry)element$iv$iv;
                boolean bl = false;
                RenderBackend.Texture texture3 = entry.component1();
                int x = entry.component2();
                int y = entry.component3();
                int w = entry.component4();
                int h = entry.component5();
                boolean flipped = entry.component6();
                entry = TuplesKt.to((Object)texture3, (Object)new Entry((double)w / (double)packing2.getAtlasWidth(), (double)h / (double)packing2.getAtlasHeight(), (double)x / (double)packing2.getAtlasWidth(), (double)y / (double)packing2.getAtlasHeight()));
                map2.put(entry.getFirst(), entry.getSecond());
            }
            Map texturesMap = destination$iv$iv3;
            return new TextureAtlas(renderBackend, atlasTexture, texturesMap, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lgg/essential/model/backend/atlas/TextureAtlas$Entry;", "", "uScale", "", "vScale", "uOffset", "vOffset", "(DDDD)V", "getUOffset", "()D", "getUScale", "getVOffset", "getVScale", "cosmetics"})
    private static final class Entry {
        private final double uScale;
        private final double vScale;
        private final double uOffset;
        private final double vOffset;

        public Entry(double uScale, double vScale, double uOffset, double vOffset) {
            this.uScale = uScale;
            this.vScale = vScale;
            this.uOffset = uOffset;
            this.vOffset = vOffset;
        }

        public final double getUScale() {
            return this.uScale;
        }

        public final double getVScale() {
            return this.vScale;
        }

        public final double getUOffset() {
            return this.uOffset;
        }

        public final double getVOffset() {
            return this.vOffset;
        }
    }
}

