/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.backend.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec4;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.ParticleEffect;
import gg.essential.model.ParticleSystem;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.light.Light;
import gg.essential.model.util.Color;
import gg.essential.model.util.KotglKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.universal.vertex.UVertexConsumer;
import gg.essential.util.HelpersKt;
import gg.essential.util.OptiFineAccessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007'()*+,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001d\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u00170\u00172\u0006\u0010\u0013\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J \u0010\u001f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0004\b\u001f\u0010 R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020%0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010#\u00a8\u0006."}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend;", "Lgg/essential/model/backend/RenderBackend;", "<init>", "()V", "Lgg/essential/model/backend/RenderBackend$Texture;", "dst", "", "Lgg/essential/model/backend/RenderBackend$BlitOp;", "ops", "", "blitTexture", "(Lgg/essential/model/backend/RenderBackend$Texture;Ljava/lang/Iterable;)V", "", "name", "", "width", "height", "createTexture", "(Ljava/lang/String;II)Lgg/essential/model/backend/RenderBackend$Texture;", "texture", "deleteTexture", "(Lgg/essential/model/backend/RenderBackend$Texture;)V", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_1921;", "getEmissiveArmorLayer", "(Lnet/minecraft/class_2960;)Lnet/minecraft/class_1921;", "getEmissiveLayer", "kotlin.jvm.PlatformType", "getEntityTranslucentCullLayer", "", "bytes", "readTexture", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "armorLayers", "Ljava/util/Map;", "emissiveLayers", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$DynamicTexture;", "registeredTextures", "CapeTexture", "CosmeticTexture", "DynamicTexture", "MinecraftTexture", "ParticleVertexConsumerProvider", "SkinTexture", "VertexConsumerProvider", "Essential 1.21-fabric"})
@SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,518:1\n372#2,7:519\n372#2,7:526\n*S KotlinDebug\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend\n*L\n209#1:519,7\n246#1:526,7\n*E\n"})
public final class MinecraftRenderBackend
implements RenderBackend {
    @NotNull
    public static final MinecraftRenderBackend INSTANCE = new MinecraftRenderBackend();
    @NotNull
    private static final Map<class_2960, DynamicTexture> registeredTextures = new LinkedHashMap();
    @NotNull
    private static final Map<class_2960, class_1921> emissiveLayers = new LinkedHashMap();
    @NotNull
    private static final Map<class_2960, class_1921> armorLayers = new LinkedHashMap();

    private MinecraftRenderBackend() {
    }

    @Override
    @NotNull
    public RenderBackend.Texture createTexture(@NotNull String name2, int width2, int height2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        class_2960 class_29602 = HelpersKt.identifier("essential", name2);
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"identifier(...)");
        return new DynamicTexture(class_29602, new ReleasedDynamicTexture(width2, height2));
    }

    @Override
    public void deleteTexture(@NotNull RenderBackend.Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        class_2960 identifier2 = ((DynamicTexture)texture).getIdentifier();
        ((DynamicTexture)texture).getTexture().method_4528();
        if (registeredTextures.remove(identifier2, texture)) {
            UMinecraft.getMinecraft().method_1531().method_4615(identifier2);
        }
    }

    @Override
    public void blitTexture(@NotNull RenderBackend.Texture dst, @NotNull Iterable<RenderBackend.BlitOp> ops) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        class_1060 textureManager = UMinecraft.getMinecraft().method_1531();
        boolean prevScissor = GL11.glGetBoolean((int)3089);
        if (prevScissor) {
            GL11.glDisable((int)3089);
        }
        int prevDrawFrameBufferBinding = GL11.glGetInteger((int)36006);
        int prevReadFrameBufferBinding = GL11.glGetInteger((int)36010);
        int dstBuffer = GL30.glGenFramebuffers();
        int srcBuffer = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36009, (int)dstBuffer);
        GL30.glBindFramebuffer((int)36008, (int)srcBuffer);
        GL30.glFramebufferTexture2D((int)36009, (int)36064, (int)3553, (int)MinecraftRenderBackend.blitTexture$glId(dst, textureManager), (int)0);
        for (RenderBackend.BlitOp blitOp : ops) {
            RenderBackend.Texture src = blitOp.component1();
            int srcX = blitOp.component2();
            int srcY = blitOp.component3();
            int destX = blitOp.component4();
            int destY = blitOp.component5();
            int width2 = blitOp.component6();
            int height2 = blitOp.component7();
            GL30.glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)MinecraftRenderBackend.blitTexture$glId(src, textureManager), (int)0);
            GL30.glBlitFramebuffer((int)srcX, (int)srcY, (int)(srcX + width2), (int)(srcY + height2), (int)destX, (int)destY, (int)(destX + width2), (int)(destY + height2), (int)16384, (int)9728);
        }
        GL30.glBindFramebuffer((int)36009, (int)prevDrawFrameBufferBinding);
        GL30.glBindFramebuffer((int)36008, (int)prevReadFrameBufferBinding);
        GL30.glDeleteFramebuffers((int)dstBuffer);
        GL30.glDeleteFramebuffers((int)srcBuffer);
        if (prevScissor) {
            GL11.glEnable((int)3089);
        }
    }

    public final class_1921 getEntityTranslucentCullLayer(@NotNull class_2960 texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        return class_1921.method_23689((class_2960)texture);
    }

    @NotNull
    public final class_1921 getEmissiveLayer(@NotNull class_2960 texture) {
        class_1921 class_19212;
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Map<class_2960, class_1921> $this$getOrPut$iv = emissiveLayers;
        boolean $i$f$getOrPut = false;
        class_1921 value$iv = $this$getOrPut$iv.get(texture);
        if (value$iv == null) {
            boolean bl = false;
            class_1921 inner = class_1921.method_23026((class_2960)texture);
            OptiFineAccessor of2 = OptiFineAccessor.Companion.getINSTANCE();
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.getEmissiveLayer.1.EmissiveLayer", "Lnet/minecraft/class_1921;", "<init>", "(Lnet/minecraft/class_1921;Lgg/essential/util/OptiFineAccessor;)V", "Essential 1.21-fabric"})
            public final class EmissiveLayer
            extends class_1921 {
                public EmissiveLayer(class_1921 $inner, @Nullable OptiFineAccessor $of) {
                    super("entity_translucent_emissive_cull", $inner.method_23031(), $inner.method_23033(), $inner.method_22722(), $inner.method_23037(), true, () -> EmissiveLayer._init_$lambda$0($inner, $of), () -> EmissiveLayer._init_$lambda$1($of, $inner));
                }

                private static final void _init_$lambda$0(class_1921 $inner, OptiFineAccessor $of) {
                    $inner.method_23516();
                    class_1921.field_21370.method_23516();
                    if ($of != null && $of.Config_isShaders()) {
                        $of.Shaders_pushProgram();
                        $of.Shaders_beginSpiderEyes();
                    }
                }

                private static final void _init_$lambda$1(OptiFineAccessor $of, class_1921 $inner) {
                    if ($of != null && $of.Config_isShaders()) {
                        $of.Shaders_endSpiderEyes();
                        $of.Shaders_popProgram();
                    }
                    class_1921.field_21370.method_23518();
                    $inner.method_23518();
                }
            }
            class_1921 answer$iv = new EmissiveLayer(inner, of2);
            $this$getOrPut$iv.put(texture, answer$iv);
            class_19212 = answer$iv;
        } else {
            class_19212 = value$iv;
        }
        return class_19212;
    }

    @NotNull
    public final class_1921 getEmissiveArmorLayer(@NotNull class_2960 texture) {
        class_1921 class_19212;
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Map<class_2960, class_1921> $this$getOrPut$iv = armorLayers;
        boolean $i$f$getOrPut = false;
        class_1921 value$iv = $this$getOrPut$iv.get(texture);
        if (value$iv == null) {
            boolean bl = false;
            class_1921 inner = INSTANCE.getEmissiveLayer(texture);
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.getEmissiveArmorLayer.1.EmissiveArmorLayer", "Lnet/minecraft/class_1921;", "<init>", "(Lnet/minecraft/class_1921;)V", "Essential 1.21-fabric"})
            public final class EmissiveArmorLayer
            extends class_1921 {
                public EmissiveArmorLayer(@NotNull class_1921 $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    super("armor_translucent_emissive", $inner.method_23031(), $inner.method_23033(), $inner.method_22722(), $inner.method_23037(), true, () -> EmissiveArmorLayer._init_$lambda$0($inner), () -> EmissiveArmorLayer._init_$lambda$1($inner));
                }

                private static final void _init_$lambda$0(class_1921 $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    $inner.method_23516();
                    class_1921.field_22241.method_23516();
                }

                private static final void _init_$lambda$1(class_1921 $inner) {
                    Intrinsics.checkNotNullParameter((Object)$inner, (String)"$inner");
                    class_1921.field_22241.method_23518();
                    $inner.method_23518();
                }
            }
            class_1921 answer$iv = new EmissiveArmorLayer(inner);
            $this$getOrPut$iv.put(texture, answer$iv);
            class_19212 = answer$iv;
        } else {
            class_19212 = value$iv;
        }
        return class_19212;
    }

    @Override
    @Nullable
    public Object readTexture(@NotNull String name2, @NotNull byte[] bytes, @NotNull Continuation<? super RenderBackend.Texture> $completion) {
        ReleasedDynamicTexture releasedDynamicTexture = UGraphics.getTexture((InputStream)new ByteArrayInputStream(bytes));
        Intrinsics.checkNotNullExpressionValue((Object)releasedDynamicTexture, (String)"getTexture(...)");
        return new CosmeticTexture(name2, releasedDynamicTexture);
    }

    private static final int blitTexture$glId(RenderBackend.Texture $this$blitTexture_u24glId, class_1060 textureManager) {
        Intrinsics.checkNotNull((Object)$this$blitTexture_u24glId, (String)"null cannot be cast to non-null type gg.essential.model.backend.minecraft.MinecraftRenderBackend.MinecraftTexture");
        class_1044 class_10442 = textureManager.method_4619(((MinecraftTexture)$this$blitTexture_u24glId).getIdentifier());
        Intrinsics.checkNotNull((Object)class_10442);
        return class_10442.method_4624();
    }

    public static final /* synthetic */ Map access$getRegisteredTextures$p() {
        return registeredTextures;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CapeTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/class_2960;", "identifier", "<init>", "(Lnet/minecraft/class_2960;)V", "component1", "()Lnet/minecraft/class_2960;", "copy", "(Lnet/minecraft/class_2960;)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CapeTexture;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "getHeight", "height", "Lnet/minecraft/class_2960;", "getIdentifier", "getWidth", "width", "Essential 1.21-fabric"})
    public static final class CapeTexture
    implements MinecraftTexture {
        @NotNull
        private final class_2960 identifier;

        public CapeTexture(@NotNull class_2960 identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            this.identifier = identifier2;
        }

        @Override
        @NotNull
        public class_2960 getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getWidth() {
            return 64;
        }

        @Override
        public int getHeight() {
            return 32;
        }

        @NotNull
        public final class_2960 component1() {
            return this.identifier;
        }

        @NotNull
        public final CapeTexture copy(@NotNull class_2960 identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            return new CapeTexture(identifier2);
        }

        public static /* synthetic */ CapeTexture copy$default(CapeTexture capeTexture, class_2960 class_29602, int n, Object object) {
            if ((n & 1) != 0) {
                class_29602 = capeTexture.identifier;
            }
            return capeTexture.copy(class_29602);
        }

        @NotNull
        public String toString() {
            return "CapeTexture(identifier=" + this.identifier + ")";
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CapeTexture)) {
                return false;
            }
            CapeTexture capeTexture = (CapeTexture)other;
            return Intrinsics.areEqual((Object)this.identifier, (Object)capeTexture.identifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$CosmeticTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$DynamicTexture;", "", "name", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "<init>", "(Ljava/lang/String;Lgg/essential/universal/utils/ReleasedDynamicTexture;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Essential 1.21-fabric"})
    public static final class CosmeticTexture
    extends DynamicTexture {
        @NotNull
        private final String name;

        public CosmeticTexture(@NotNull String name2, @NotNull ReleasedDynamicTexture texture) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            String string = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            class_2960 class_29602 = HelpersKt.identifier("essential", "textures/cosmetics/" + string);
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"identifier(...)");
            super(class_29602, texture);
            this.name = name2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0003\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$DynamicTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/class_2960;", "identifier", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "<init>", "(Lnet/minecraft/class_2960;Lgg/essential/universal/utils/ReleasedDynamicTexture;)V", "", "height", "I", "getHeight", "()I", "identifier$delegate", "Lkotlin/Lazy;", "getIdentifier", "()Lnet/minecraft/class_2960;", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "getTexture", "()Lgg/essential/universal/utils/ReleasedDynamicTexture;", "width", "getWidth", "Essential 1.21-fabric"})
    public static class DynamicTexture
    implements MinecraftTexture {
        @NotNull
        private final ReleasedDynamicTexture texture;
        private final int width;
        private final int height;
        @NotNull
        private final Lazy identifier$delegate;

        public DynamicTexture(@NotNull class_2960 identifier2, @NotNull ReleasedDynamicTexture texture) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            this.texture = texture;
            this.width = this.texture.getWidth();
            this.height = this.texture.getHeight();
            this.identifier$delegate = LazyKt.lazy((Function0)((Function0)new Function0<class_2960>(identifier2, this){
                final /* synthetic */ class_2960 $identifier;
                final /* synthetic */ DynamicTexture this$0;
                {
                    this.$identifier = $identifier;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final class_2960 invoke() {
                    DynamicTexture dynamicTexture = (DynamicTexture)MinecraftRenderBackend.access$getRegisteredTextures$p().get(this.$identifier);
                    if (dynamicTexture != null) {
                        DynamicTexture it = dynamicTexture;
                        boolean bl = false;
                        MinecraftRenderBackend.INSTANCE.deleteTexture(it);
                    }
                    UMinecraft.getMinecraft().method_1531().method_4616(this.$identifier, (class_1044)this.this$0.getTexture());
                    MinecraftRenderBackend.access$getRegisteredTextures$p().put(this.$identifier, this.this$0);
                    return this.$identifier;
                }
            }));
        }

        @NotNull
        public final ReleasedDynamicTexture getTexture() {
            return this.texture;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        @NotNull
        public class_2960 getIdentifier() {
            Lazy lazy2 = this.identifier$delegate;
            return (class_2960)lazy2.getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0005\u001a\u00020\u00028&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lgg/essential/model/backend/RenderBackend$Texture;", "Lnet/minecraft/class_2960;", "getIdentifier", "()Lnet/minecraft/class_2960;", "identifier", "Essential 1.21-fabric"})
    public static interface MinecraftTexture
    extends RenderBackend.Texture {
        @NotNull
        public class_2960 getIdentifier();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider;", "Lgg/essential/model/ParticleSystem$VertexConsumerProvider;", "<init>", "()V", "Lgg/essential/model/ParticleEffect$RenderPass;", "renderPass", "Lkotlin/Function1;", "Lgg/essential/model/util/UVertexConsumer;", "", "block", "provide", "(Lgg/essential/model/ParticleEffect$RenderPass;Lkotlin/jvm/functions/Function1;)V", "Essential 1.21-fabric"})
    public static final class ParticleVertexConsumerProvider
    implements ParticleSystem.VertexConsumerProvider {
        @Override
        public void provide(@NotNull ParticleEffect.RenderPass renderPass, @NotNull Function1<? super gg.essential.model.util.UVertexConsumer, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)renderPass, (String)"renderPass");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            RenderBackend.Texture texture = renderPass.getTexture();
            if (!(texture instanceof MinecraftTexture)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            BlendState prevBlend = BlendState.Companion.active();
            int prevTextureId = GL11.glGetInteger((int)32873);
            boolean prevCull = GL11.glIsEnabled((int)2884);
            (switch (WhenMappings.$EnumSwitchMapping$0[renderPass.getMaterial().ordinal()]) {
                case 1 -> new BlendState(BlendState.Equation.ADD, BlendState.Param.SRC_ALPHA, BlendState.Param.ONE, null, null, false, 56, null);
                case 2 -> BlendState.DISABLED;
                case 3 -> BlendState.NORMAL;
                default -> throw new NoWhenBranchMatchedException();
            }).activate();
            UGraphics.bindTexture((int)0, (class_2960)((MinecraftTexture)texture).getIdentifier());
            if (!prevCull) {
                RenderSystem.enableCull();
            }
            UGraphics renderer = UGraphics.getFromTessellator();
            renderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, class_290.field_1584);
            UVertexConsumer uVertexConsumer = renderer.asUVertexConsumer();
            Intrinsics.checkNotNullExpressionValue((Object)uVertexConsumer, (String)"asUVertexConsumer(...)");
            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\tJ/\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.ParticleVertexConsumerProvider.provide.VertexConsumerAdapter", "Lgg/essential/model/util/UVertexConsumer;", "Lgg/essential/universal/vertex/UVertexConsumer;", "inner", "<init>", "(Lgg/essential/universal/vertex/UVertexConsumer;)V", "Lgg/essential/model/util/Color;", "color", "color-EIFkdBU", "(I)Lgg/essential/model/util/UVertexConsumer;", "endVertex", "()Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/model/light/Light;", "light", "light-vX8ayIk", "Lgg/essential/model/util/UMatrixStack;", "stack", "", "x", "y", "z", "norm", "(Lgg/essential/model/util/UMatrixStack;FFF)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "", "pos", "(Lgg/essential/model/util/UMatrixStack;DDD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "u", "v", "tex", "(DD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/universal/vertex/UVertexConsumer;", "Essential 1.21-fabric"})
            @SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend$ParticleVertexConsumerProvider$provide$VertexConsumerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
            public final class VertexConsumerAdapter
            implements gg.essential.model.util.UVertexConsumer {
                @NotNull
                private final UVertexConsumer inner;

                public VertexConsumerAdapter(@NotNull UVertexConsumer inner) {
                    Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                    this.inner = inner;
                }

                @NotNull
                public VertexConsumerAdapter pos(@NotNull gg.essential.model.util.UMatrixStack stack, double x, double y, double z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$pos_u24lambda_u240 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec4 vec = MutableVectors.mutableVec4((float)x, (float)y, (float)z, 1.0f);
                    KotglKt.timesSelf(vec, stack.peek().getModel());
                    $this$pos_u24lambda_u240.inner.pos(UMatrixStack.UNIT, (double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter tex(double u, double v) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$tex_u24lambda_u241 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$tex_u24lambda_u241.inner.tex(u, v);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter norm(@NotNull gg.essential.model.util.UMatrixStack stack, float x, float y, float z) {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    return this;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer color-EIFkdBU(int color2) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$color_EIFkdBU_u24lambda_u243 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    int $this$color_EIFkdBU_u24lambda_u243_u24lambda_u242 = color2;
                    boolean bl2 = false;
                    $this$color_EIFkdBU_u24lambda_u243.inner.color(Color.getR-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getG-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getB-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF, Color.getA-w2LRezQ($this$color_EIFkdBU_u24lambda_u243_u24lambda_u242) & 0xFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer light-vX8ayIk(int light) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$light_vX8ayIk_u24lambda_u244 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$light_vX8ayIk_u24lambda_u244.inner.light(Light.getBlockLight-Mh2AYeg(light) & 0xFFFF, Light.getSkyLight-Mh2AYeg(light) & 0xFFFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter endVertex() {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$endVertex_u24lambda_u245 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$endVertex_u24lambda_u245.inner.endVertex();
                    return vertexConsumerAdapter;
                }
            }
            block.invoke((Object)new VertexConsumerAdapter(uVertexConsumer));
            renderer.drawDirect();
            if (!prevCull) {
                RenderSystem.disableCull();
            }
            UGraphics.bindTexture((int)0, (int)prevTextureId);
            prevBlend.activate();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParticlesFile.Material.values().length];
                try {
                    nArray[ParticlesFile.Material.Add.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticlesFile.Material.Cutout.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParticlesFile.Material.Blend.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$SkinTexture;", "Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$MinecraftTexture;", "Lnet/minecraft/class_2960;", "identifier", "<init>", "(Lnet/minecraft/class_2960;)V", "component1", "()Lnet/minecraft/class_2960;", "copy", "(Lnet/minecraft/class_2960;)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$SkinTexture;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "getHeight", "height", "Lnet/minecraft/class_2960;", "getIdentifier", "getWidth", "width", "Essential 1.21-fabric"})
    public static final class SkinTexture
    implements MinecraftTexture {
        @NotNull
        private final class_2960 identifier;

        public SkinTexture(@NotNull class_2960 identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            this.identifier = identifier2;
        }

        @Override
        @NotNull
        public class_2960 getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getWidth() {
            return 64;
        }

        @Override
        public int getHeight() {
            return 64;
        }

        @NotNull
        public final class_2960 component1() {
            return this.identifier;
        }

        @NotNull
        public final SkinTexture copy(@NotNull class_2960 identifier2) {
            Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
            return new SkinTexture(identifier2);
        }

        public static /* synthetic */ SkinTexture copy$default(SkinTexture skinTexture, class_2960 class_29602, int n, Object object) {
            if ((n & 1) != 0) {
                class_29602 = skinTexture.identifier;
            }
            return skinTexture.copy(class_29602);
        }

        @NotNull
        public String toString() {
            return "SkinTexture(identifier=" + this.identifier + ")";
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkinTexture)) {
                return false;
            }
            SkinTexture skinTexture = (SkinTexture)other;
            return Intrinsics.areEqual((Object)this.identifier, (Object)skinTexture.identifier);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider;", "Lgg/essential/model/backend/RenderBackend$VertexConsumerProvider;", "Lnet/minecraft/class_4597;", "provider", "", "light", "<init>", "(Lnet/minecraft/class_4597;I)V", "Lgg/essential/model/backend/RenderBackend$Texture;", "texture", "", "emissive", "Lkotlin/Function1;", "Lgg/essential/model/util/UVertexConsumer;", "", "block", "provide", "(Lgg/essential/model/backend/RenderBackend$Texture;ZLkotlin/jvm/functions/Function1;)V", "I", "getLight", "()I", "Lnet/minecraft/class_4597;", "getProvider", "()Lnet/minecraft/class_4597;", "Essential 1.21-fabric"})
    public static final class VertexConsumerProvider
    implements RenderBackend.VertexConsumerProvider {
        @NotNull
        private final class_4597 provider;
        private final int light;

        public VertexConsumerProvider(@NotNull class_4597 provider2, int light) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            this.provider = provider2;
            this.light = light;
        }

        @NotNull
        public final class_4597 getProvider() {
            return this.provider;
        }

        public final int getLight() {
            return this.light;
        }

        @Override
        public void provide(@NotNull RenderBackend.Texture texture, boolean emissive, @NotNull Function1<? super gg.essential.model.util.UVertexConsumer, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if (!(texture instanceof MinecraftTexture)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            class_4588 buffer = this.provider.getBuffer(emissive ? INSTANCE.getEmissiveLayer(((MinecraftTexture)texture).getIdentifier()) : INSTANCE.getEntityTranslucentCullLayer(((MinecraftTexture)texture).getIdentifier()));
            Intrinsics.checkNotNull((Object)buffer);
            /*
             * Illegal identifiers - consider using --renameillegalidents true
             */
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\r\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\tJ/\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"gg/essential/model/backend/minecraft/MinecraftRenderBackend.VertexConsumerProvider.provide.VertexConsumerAdapter", "Lgg/essential/model/util/UVertexConsumer;", "Lgg/essential/universal/vertex/UVertexConsumer;", "inner", "<init>", "(Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider;Lgg/essential/universal/vertex/UVertexConsumer;)V", "Lgg/essential/model/util/Color;", "color", "color-EIFkdBU", "(I)Lgg/essential/model/util/UVertexConsumer;", "endVertex", "()Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/model/light/Light;", "light", "light-vX8ayIk", "Lgg/essential/model/util/UMatrixStack;", "stack", "", "x", "y", "z", "norm", "(Lgg/essential/model/util/UMatrixStack;FFF)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "", "pos", "(Lgg/essential/model/util/UMatrixStack;DDD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "u", "v", "tex", "(DD)Lgg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter;", "Lgg/essential/universal/vertex/UVertexConsumer;", "Essential 1.21-fabric"})
            @SourceDebugExtension(value={"SMAP\nMinecraftRenderBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftRenderBackend.kt\ngg/essential/model/backend/minecraft/MinecraftRenderBackend$VertexConsumerProvider$provide$VertexConsumerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
            public final class VertexConsumerAdapter
            implements gg.essential.model.util.UVertexConsumer {
                @NotNull
                private final UVertexConsumer inner;
                final /* synthetic */ VertexConsumerProvider this$0;

                public VertexConsumerAdapter(@NotNull VertexConsumerProvider $receiver, @NotNull UVertexConsumer inner) {
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                    this.this$0 = $receiver;
                    this.inner = inner;
                }

                @NotNull
                public VertexConsumerAdapter pos(@NotNull gg.essential.model.util.UMatrixStack stack, double x, double y, double z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$pos_u24lambda_u240 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec4 vec = MutableVectors.mutableVec4((float)x, (float)y, (float)z, 1.0f);
                    KotglKt.timesSelf(vec, stack.peek().getModel());
                    $this$pos_u24lambda_u240.inner.pos(UMatrixStack.UNIT, (double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
                    $this$pos_u24lambda_u240.inner.color(1.0f, 1.0f, 1.0f, 1.0f);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter tex(double u, double v) {
                    VertexConsumerAdapter vertexConsumerAdapter = this;
                    VertexConsumerProvider vertexConsumerProvider = this.this$0;
                    VertexConsumerAdapter $this$tex_u24lambda_u241 = vertexConsumerAdapter;
                    boolean bl = false;
                    $this$tex_u24lambda_u241.inner.tex(u, v);
                    $this$tex_u24lambda_u241.inner.overlay(class_4608.method_23210((float)0.0f), class_4608.method_23212((boolean)false));
                    $this$tex_u24lambda_u241.inner.light(vertexConsumerProvider.getLight() & 0xFFFF, vertexConsumerProvider.getLight() >> 16 & 0xFFFF);
                    return vertexConsumerAdapter;
                }

                @NotNull
                public VertexConsumerAdapter norm(@NotNull gg.essential.model.util.UMatrixStack stack, float x, float y, float z) {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    VertexConsumerAdapter $this$norm_u24lambda_u242 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    MutableVec3 vec = MutableVectors.mutableVec3(x, y, z);
                    KotglKt.timesSelf(vec, stack.peek().getNormal());
                    $this$norm_u24lambda_u242.inner.norm(UMatrixStack.UNIT, vec.getX(), vec.getY(), vec.getZ());
                    return vertexConsumerAdapter;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer color-EIFkdBU(int color2) {
                    return this;
                }

                @NotNull
                public gg.essential.model.util.UVertexConsumer light-vX8ayIk(int light) {
                    return this;
                }

                @NotNull
                public VertexConsumerAdapter endVertex() {
                    VertexConsumerAdapter vertexConsumerAdapter;
                    VertexConsumerAdapter $this$endVertex_u24lambda_u243 = vertexConsumerAdapter = this;
                    boolean bl = false;
                    $this$endVertex_u24lambda_u243.inner.endVertex();
                    return vertexConsumerAdapter;
                }
            }
            block.invoke((Object)new VertexConsumerAdapter(this, UVertexConsumer.Companion.of(buffer)));
        }
    }
}

