/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.molang;

import gg.essential.model.molang.AbsExpr;
import gg.essential.model.molang.AddExpr;
import gg.essential.model.molang.AssignmentExpr;
import gg.essential.model.molang.CeilExpr;
import gg.essential.model.molang.ClampExpr;
import gg.essential.model.molang.ComparisonExpr;
import gg.essential.model.molang.ComplexExpr;
import gg.essential.model.molang.CosExpr;
import gg.essential.model.molang.FloorExpr;
import gg.essential.model.molang.InvExpr;
import gg.essential.model.molang.LiteralExpr;
import gg.essential.model.molang.LogicalAndExpr;
import gg.essential.model.molang.LogicalOrExpr;
import gg.essential.model.molang.MolangExpression;
import gg.essential.model.molang.MolangParserException;
import gg.essential.model.molang.MolangQuery;
import gg.essential.model.molang.MolangQueryAnimation;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.molang.MolangVariable;
import gg.essential.model.molang.MulExpr;
import gg.essential.model.molang.NegExpr;
import gg.essential.model.molang.QueryExpr;
import gg.essential.model.molang.RandomExpr;
import gg.essential.model.molang.ReturnExpr;
import gg.essential.model.molang.RoundExpr;
import gg.essential.model.molang.SinExpr;
import gg.essential.model.molang.StatementsExpr;
import gg.essential.model.molang.TernaryExpr;
import gg.essential.model.molang.TruncExpr;
import gg.essential.model.molang.VariableExpr;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013J\u0006\u0010!\u001a\u00020\u0013J\u0006\u0010\"\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u0013J/\u0010%\u001a\u00020&2!\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020&0(H\u0086\b\u00f8\u0001\u0000J\u000e\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u0013R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lgg/essential/model/molang/Parser;", "", "str", "", "(Ljava/lang/String;)V", "curr", "", "getCurr", "()C", "i", "", "getI", "()I", "setI", "(I)V", "returns", "getStr", "()Ljava/lang/String;", "fullyParseMolang", "Lgg/essential/model/molang/MolangExpression;", "parseAssignment", "parseComparisons", "parseEqualityChecks", "parseExpression", "parseIdentifier", "parseLiteral", "Lgg/essential/model/molang/LiteralExpr;", "parseLogicalAnds", "parseLogicalOrs", "parseMolang", "parseNullCoalescing", "parseProduct", "parseSimpleExpression", "parseStatement", "parseStatements", "parseSum", "parseTernary", "reads", "", "f", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "char", "s", "Lkotlin/ranges/CharRange;", "skipWhitespace", "", "tryFullyParseMolang", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nMolangExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MolangExpression.kt\ngg/essential/model/molang/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MolangExpression.kt\ngg/essential/model/molang/QueryExpr$Companion\n*L\n1#1,449:1\n205#1,9:450\n205#1,9:459\n205#1,9:468\n1#2:477\n113#3:478\n113#3:479\n113#3:480\n113#3:481\n*S KotlinDebug\n*F\n+ 1 MolangExpression.kt\ngg/essential/model/molang/Parser\n*L\n203#1:450,9\n204#1:459,9\n242#1:468,9\n267#1:478\n268#1:479\n269#1:480\n270#1:481\n*E\n"})
final class Parser {
    private int returns;
    @NotNull
    private final String str;
    private int i;

    public Parser(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.str = string;
    }

    @NotNull
    public final String getStr() {
        return this.str;
    }

    public final int getI() {
        return this.i;
    }

    public final void setI(int n) {
        this.i = n;
    }

    public final char getCurr() {
        return this.str.charAt(this.i);
    }

    public final boolean reads(char c) {
        boolean bl;
        Parser this_$iv = this;
        boolean $i$f$reads = false;
        if (this_$iv.getI() >= this_$iv.getStr().length()) {
            bl = false;
        } else {
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            if (it == c) {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean reads(@NotNull CharRange charRange) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)charRange, (String)"char");
        Parser this_$iv = this;
        boolean $i$f$reads = false;
        if (this_$iv.getI() >= this_$iv.getStr().length()) {
            bl = false;
        } else {
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            char c = charRange.getFirst();
            boolean bl3 = it <= charRange.getLast() ? c <= it : false;
            if (bl3) {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean reads(@NotNull Function1<? super Character, Boolean> f) {
        boolean bl;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$reads = false;
        if (this.getI() >= this.getStr().length()) {
            bl = false;
        } else if (((Boolean)f.invoke((Object)Character.valueOf(this.getCurr()))).booleanValue()) {
            int n = this.getI();
            this.setI(n + 1);
            this.skipWhitespace();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean reads(@NotNull String s) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (StringsKt.startsWith$default((String)this.str, (String)s, (int)this.i, (boolean)false, (int)4, null)) {
            this.i += s.length();
            this.skipWhitespace();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void skipWhitespace() {
        while (this.reads(' ')) {
        }
    }

    @NotNull
    public final LiteralExpr parseLiteral() {
        int start2 = this.i;
        while (this.reads(new CharRange('0', '9'))) {
        }
        if (this.reads('.')) {
            while (this.reads(new CharRange('0', '9'))) {
            }
        }
        this.reads('f');
        return new LiteralExpr(Float.parseFloat(StringsKt.replace$default((String)StringsKt.slice((String)this.str, (IntRange)RangesKt.until((int)start2, (int)this.i)), (String)" ", (String)"", (boolean)false, (int)4, null)));
    }

    @NotNull
    public final String parseIdentifier() {
        boolean bl;
        int start2 = this.i;
        do {
            Parser this_$iv = this;
            boolean $i$f$reads = false;
            if (this_$iv.getI() >= this_$iv.getStr().length()) {
                bl = false;
                continue;
            }
            char it = this_$iv.getCurr();
            boolean bl2 = false;
            if (Character.isLetterOrDigit(it) || it == '_') {
                int n = this_$iv.getI();
                this_$iv.setI(n + 1);
                this_$iv.skipWhitespace();
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        return StringsKt.replace$default((String)StringsKt.slice((String)this.str, (IntRange)RangesKt.until((int)start2, (int)this.i)), (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final MolangExpression parseSimpleExpression() {
        MolangExpression molangExpression;
        if (this.reads('(')) {
            MolangExpression molangExpression2;
            MolangExpression it = molangExpression2 = this.parseExpression();
            boolean bl = false;
            this.reads(')');
            molangExpression = molangExpression2;
        } else {
            char c = this.getCurr();
            boolean bl = '0' <= c ? c < ':' : false;
            if (bl) {
                molangExpression = this.parseLiteral();
            } else if (this.getCurr() == '-') {
                this.reads('-');
                molangExpression = new NegExpr(this.parseSimpleExpression());
            } else if (this.reads("math.pi")) {
                molangExpression = new LiteralExpr((float)Math.PI);
            } else if (this.reads("math.cos(")) {
                CosExpr cosExpr;
                CosExpr it = cosExpr = new CosExpr(this.parseExpression());
                boolean bl2 = false;
                this.reads(')');
                molangExpression = cosExpr;
            } else if (this.reads("math.sin(")) {
                SinExpr sinExpr;
                SinExpr it = sinExpr = new SinExpr(this.parseExpression());
                boolean bl3 = false;
                this.reads(')');
                molangExpression = sinExpr;
            } else if (this.reads("math.floor(")) {
                FloorExpr floorExpr;
                FloorExpr it = floorExpr = new FloorExpr(this.parseExpression());
                boolean bl4 = false;
                this.reads(')');
                molangExpression = floorExpr;
            } else if (this.reads("math.ceil(")) {
                CeilExpr ceilExpr;
                CeilExpr it = ceilExpr = new CeilExpr(this.parseExpression());
                boolean bl5 = false;
                this.reads(')');
                molangExpression = ceilExpr;
            } else if (this.reads("math.round(")) {
                RoundExpr roundExpr;
                RoundExpr it = roundExpr = new RoundExpr(this.parseExpression());
                boolean bl6 = false;
                this.reads(')');
                molangExpression = roundExpr;
            } else if (this.reads("math.trunc(")) {
                TruncExpr truncExpr;
                TruncExpr it = truncExpr = new TruncExpr(this.parseExpression());
                boolean bl7 = false;
                this.reads(')');
                molangExpression = truncExpr;
            } else if (this.reads("math.abs(")) {
                AbsExpr absExpr;
                AbsExpr it = absExpr = new AbsExpr(this.parseExpression());
                boolean bl8 = false;
                this.reads(')');
                molangExpression = absExpr;
            } else if (this.reads("math.clamp(")) {
                MolangExpression molangExpression3;
                MolangExpression it = molangExpression3 = this.parseExpression();
                boolean bl9 = false;
                this.reads(',');
                MolangExpression molangExpression4 = molangExpression3;
                it = molangExpression3 = this.parseExpression();
                MolangExpression molangExpression5 = molangExpression4;
                boolean bl10 = false;
                this.reads(',');
                MolangExpression molangExpression6 = this.parseExpression();
                MolangExpression molangExpression7 = molangExpression3;
                MolangExpression molangExpression8 = molangExpression5;
                it = molangExpression3 = new ClampExpr(molangExpression8, molangExpression7, molangExpression6);
                boolean bl11 = false;
                this.reads(')');
                molangExpression = molangExpression3;
            } else if (this.reads("math.random(")) {
                MolangExpression molangExpression9;
                MolangExpression it = molangExpression9 = this.parseExpression();
                boolean bl12 = false;
                this.reads(',');
                MolangExpression molangExpression10 = this.parseExpression();
                MolangExpression molangExpression11 = molangExpression9;
                it = molangExpression9 = new RandomExpr(molangExpression11, molangExpression10);
                boolean bl13 = false;
                this.reads(')');
                molangExpression = molangExpression9;
            } else if (this.reads("query.anim_time")) {
                QueryExpr.Companion this_$iv = QueryExpr.Companion;
                boolean $i$f$invoke = false;
                molangExpression = new QueryExpr((Function1<? super MolangQuery, Float>)((Function1)new Function1<MolangQuery, Float>(){

                    @NotNull
                    public final Float invoke(@NotNull MolangQuery $this$$receiver) {
                        float f;
                        Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                        MolangQuery molangQuery = $this$$receiver;
                        if (!(molangQuery instanceof MolangQueryAnimation)) {
                            molangQuery = null;
                        }
                        MolangQuery molangQuery2 = (MolangQueryAnimation)molangQuery;
                        if (molangQuery2 != null) {
                            MolangQueryAnimation $this$parseSimpleExpression_u24lambda_u2416 = (MolangQueryAnimation)molangQuery2;
                            boolean bl = false;
                            f = $this$parseSimpleExpression_u24lambda_u2416.getAnimTime();
                        } else {
                            f = 0.0f;
                        }
                        return Float.valueOf(f);
                    }
                }));
            } else if (this.reads("query.life_time")) {
                QueryExpr.Companion this_$iv = QueryExpr.Companion;
                boolean $i$f$invoke = false;
                molangExpression = new QueryExpr((Function1<? super MolangQuery, Float>)((Function1)new Function1<MolangQuery, Float>(){

                    @NotNull
                    public final Float invoke(@NotNull MolangQuery $this$$receiver) {
                        float f;
                        Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                        MolangQuery molangQuery = $this$$receiver;
                        if (!(molangQuery instanceof MolangQueryEntity)) {
                            molangQuery = null;
                        }
                        MolangQuery molangQuery2 = (MolangQueryEntity)molangQuery;
                        if (molangQuery2 != null) {
                            MolangQueryEntity $this$parseSimpleExpression_u24lambda_u2417 = (MolangQueryEntity)molangQuery2;
                            boolean bl = false;
                            f = $this$parseSimpleExpression_u24lambda_u2417.getLifeTime();
                        } else {
                            f = 0.0f;
                        }
                        return Float.valueOf(f);
                    }
                }));
            } else if (this.reads("query.modified_move_speed")) {
                QueryExpr.Companion this_$iv = QueryExpr.Companion;
                boolean $i$f$invoke = false;
                molangExpression = new QueryExpr((Function1<? super MolangQuery, Float>)((Function1)new Function1<MolangQuery, Float>(){

                    @NotNull
                    public final Float invoke(@NotNull MolangQuery $this$$receiver) {
                        float f;
                        Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                        MolangQuery molangQuery = $this$$receiver;
                        if (!(molangQuery instanceof MolangQueryEntity)) {
                            molangQuery = null;
                        }
                        MolangQuery molangQuery2 = (MolangQueryEntity)molangQuery;
                        if (molangQuery2 != null) {
                            MolangQueryEntity $this$parseSimpleExpression_u24lambda_u2418 = (MolangQueryEntity)molangQuery2;
                            boolean bl = false;
                            f = $this$parseSimpleExpression_u24lambda_u2418.getModifiedMoveSpeed();
                        } else {
                            f = 0.0f;
                        }
                        return Float.valueOf(f);
                    }
                }));
            } else if (this.reads("query.modified_distance_moved")) {
                QueryExpr.Companion this_$iv = QueryExpr.Companion;
                boolean $i$f$invoke = false;
                molangExpression = new QueryExpr((Function1<? super MolangQuery, Float>)((Function1)new Function1<MolangQuery, Float>(){

                    @NotNull
                    public final Float invoke(@NotNull MolangQuery $this$$receiver) {
                        float f;
                        Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                        MolangQuery molangQuery = $this$$receiver;
                        if (!(molangQuery instanceof MolangQueryEntity)) {
                            molangQuery = null;
                        }
                        MolangQuery molangQuery2 = (MolangQueryEntity)molangQuery;
                        if (molangQuery2 != null) {
                            MolangQueryEntity $this$parseSimpleExpression_u24lambda_u2419 = (MolangQueryEntity)molangQuery2;
                            boolean bl = false;
                            f = $this$parseSimpleExpression_u24lambda_u2419.getModifiedDistanceMoved();
                        } else {
                            f = 0.0f;
                        }
                        return Float.valueOf(f);
                    }
                }));
            } else if (this.reads("variable.")) {
                molangExpression = new VariableExpr(this.parseIdentifier());
            } else {
                throw new IllegalArgumentException("Unexpected character at index " + this.i);
            }
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression parseProduct() {
        MolangExpression left = this.parseSimpleExpression();
        while (true) {
            MolangExpression molangExpression;
            if (this.reads('*')) {
                molangExpression = new MulExpr(left, this.parseSimpleExpression());
            } else if (this.reads('/')) {
                molangExpression = new MulExpr(left, new InvExpr(this.parseSimpleExpression()));
            } else {
                return left;
            }
            left = molangExpression;
        }
    }

    @NotNull
    public final MolangExpression parseSum() {
        MolangExpression left = this.parseProduct();
        while (true) {
            MolangExpression molangExpression;
            if (this.reads('+')) {
                molangExpression = new AddExpr(left, this.parseProduct());
            } else if (this.reads('-')) {
                molangExpression = new AddExpr(left, new NegExpr(this.parseProduct()));
            } else {
                return left;
            }
            left = molangExpression;
        }
    }

    @NotNull
    public final MolangExpression parseComparisons() {
        MolangExpression left = this.parseSum();
        return this.reads("<=") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.LessThanOrEqual) : (this.reads(">=") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.GreaterThanOrEqual) : (this.reads('<') ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.LessThan) : (this.reads('>') ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.GreaterThan) : left)));
    }

    @NotNull
    public final MolangExpression parseEqualityChecks() {
        MolangExpression left = this.parseComparisons();
        return this.reads("==") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.Equal) : (this.reads("!=") ? (MolangExpression)new ComparisonExpr(left, this.parseSum(), ComparisonExpr.Op.NotEqual) : left);
    }

    @NotNull
    public final MolangExpression parseLogicalAnds() {
        MolangExpression left = this.parseEqualityChecks();
        while (this.reads("&&")) {
            left = new LogicalAndExpr(left, this.parseEqualityChecks());
        }
        return left;
    }

    @NotNull
    public final MolangExpression parseLogicalOrs() {
        MolangExpression left = this.parseLogicalAnds();
        while (this.reads("||")) {
            left = new LogicalOrExpr(left, this.parseLogicalAnds());
        }
        return left;
    }

    @NotNull
    public final MolangExpression parseTernary() {
        MolangExpression molangExpression;
        MolangExpression condition = this.parseLogicalOrs();
        if (this.reads('?')) {
            MolangExpression trueCase = this.parseTernary();
            this.reads(':');
            MolangExpression falseCase = this.parseTernary();
            molangExpression = new TernaryExpr(condition, trueCase, falseCase);
        } else {
            molangExpression = condition;
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression parseNullCoalescing() {
        return this.parseTernary();
    }

    @NotNull
    public final MolangExpression parseExpression() {
        MolangExpression molangExpression;
        if (this.reads('{')) {
            MolangExpression molangExpression2;
            MolangExpression it = molangExpression2 = this.parseStatements();
            boolean bl = false;
            this.reads('}');
            molangExpression = molangExpression2;
        } else {
            molangExpression = this.parseNullCoalescing();
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression parseAssignment() {
        MolangExpression left = this.parseExpression();
        if (!this.reads('=')) {
            return left;
        }
        if (!(left instanceof MolangVariable)) {
            throw new IllegalArgumentException("Cannot assign value to " + left);
        }
        MolangExpression right = this.parseExpression();
        return new AssignmentExpr((MolangVariable)((Object)left), right);
    }

    @NotNull
    public final MolangExpression parseStatement() {
        MolangExpression molangExpression;
        if (this.reads("return")) {
            ReturnExpr returnExpr;
            ReturnExpr it = returnExpr = new ReturnExpr(this.parseExpression());
            boolean bl = false;
            int n = this.returns;
            this.returns = n + 1;
            molangExpression = returnExpr;
        } else {
            molangExpression = this.parseAssignment();
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression parseStatements() {
        MolangExpression first = this.parseStatement();
        if (!this.reads(';')) {
            return first;
        }
        Object[] objectArray = new MolangExpression[]{first};
        List statements = CollectionsKt.mutableListOf((Object[])objectArray);
        while (this.i < this.str.length() && this.getCurr() != '}') {
            statements.add(this.parseStatement());
            this.reads(';');
        }
        return new StatementsExpr(statements, null, 2, null);
    }

    @NotNull
    public final MolangExpression parseMolang() {
        MolangExpression lastExpr;
        MolangExpression expr = this.parseStatements();
        if (expr instanceof StatementsExpr && Intrinsics.areEqual((Object)((StatementsExpr)expr).getResult(), (Object)MolangExpression.Companion.getZERO()) && (lastExpr = (MolangExpression)CollectionsKt.last(((StatementsExpr)expr).getStatements())) instanceof ReturnExpr) {
            expr = new StatementsExpr(CollectionsKt.dropLast(((StatementsExpr)expr).getStatements(), (int)1), ((ReturnExpr)lastExpr).getInner());
            int n = this.returns;
            this.returns = n + -1;
        }
        if (this.returns > 0) {
            expr = new ComplexExpr(expr);
        }
        return expr;
    }

    @NotNull
    public final MolangExpression fullyParseMolang() {
        MolangExpression molangExpression;
        MolangExpression it = molangExpression = this.parseMolang();
        boolean bl = false;
        if (this.i < this.str.length()) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to fully parse input, remaining: ");
            String string = this.str.substring(this.i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            throw new IllegalArgumentException(stringBuilder.append(string).toString());
        }
        return molangExpression;
    }

    @NotNull
    public final MolangExpression tryFullyParseMolang() {
        MolangExpression molangExpression;
        try {
            molangExpression = this.fullyParseMolang();
        }
        catch (Exception e) {
            throw new MolangParserException("Failed to parse `" + this.str + "`:", e);
        }
        return molangExpression;
    }
}

