/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.molang;

import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangExpression;
import gg.essential.model.molang.MolangQuery;
import gg.essential.model.molang.MolangQueryRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lgg/essential/model/molang/RandomExpr;", "Lgg/essential/model/molang/MolangExpression;", "low", "high", "(Lgg/essential/model/molang/MolangExpression;Lgg/essential/model/molang/MolangExpression;)V", "getHigh", "()Lgg/essential/model/molang/MolangExpression;", "getLow", "component1", "component2", "copy", "equals", "", "other", "", "eval", "", "context", "Lgg/essential/model/molang/MolangContext;", "hashCode", "", "toString", "", "cosmetics"})
public final class RandomExpr
implements MolangExpression {
    @NotNull
    private final MolangExpression low;
    @NotNull
    private final MolangExpression high;

    public RandomExpr(@NotNull MolangExpression low, @NotNull MolangExpression high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        this.low = low;
        this.high = high;
    }

    @NotNull
    public final MolangExpression getLow() {
        return this.low;
    }

    @NotNull
    public final MolangExpression getHigh() {
        return this.high;
    }

    @Override
    public float eval(@NotNull MolangContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float low = this.low.eval(context);
        float high = this.high.eval(context);
        MolangQuery molangQuery = context.getQuery();
        MolangQueryRandom molangQueryRandom = molangQuery instanceof MolangQueryRandom ? (MolangQueryRandom)molangQuery : null;
        if (molangQueryRandom == null || (molangQueryRandom = molangQueryRandom.getRandom()) == null) {
            molangQueryRandom = (Random)Random.Default;
        }
        MolangQueryRandom random = molangQueryRandom;
        return random.nextFloat() * (high - low) + low;
    }

    @NotNull
    public final MolangExpression component1() {
        return this.low;
    }

    @NotNull
    public final MolangExpression component2() {
        return this.high;
    }

    @NotNull
    public final RandomExpr copy(@NotNull MolangExpression low, @NotNull MolangExpression high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        return new RandomExpr(low, high);
    }

    public static /* synthetic */ RandomExpr copy$default(RandomExpr randomExpr, MolangExpression molangExpression, MolangExpression molangExpression2, int n, Object object) {
        if ((n & 1) != 0) {
            molangExpression = randomExpr.low;
        }
        if ((n & 2) != 0) {
            molangExpression2 = randomExpr.high;
        }
        return randomExpr.copy(molangExpression, molangExpression2);
    }

    @NotNull
    public String toString() {
        return "RandomExpr(low=" + this.low + ", high=" + this.high + ')';
    }

    public int hashCode() {
        int result = this.low.hashCode();
        result = result * 31 + this.high.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RandomExpr)) {
            return false;
        }
        RandomExpr randomExpr = (RandomExpr)other;
        if (!Intrinsics.areEqual((Object)this.low, (Object)randomExpr.low)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.high, (Object)randomExpr.high);
    }
}

