/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.chat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import com.sparkuniverse.toolbox.chat.model.Message;
import gg.essential.Essential;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.api.gui.Slot;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMemberAddPacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMemberRemovePacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMessageDeletePacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelUpdatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelCreatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageCreatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageReadStatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageReportPacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessagesRetrievePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMutePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChannelMemberActionResponsePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelAddPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelClearPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessageReportPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessageReportReasonsPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelRemovePacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.elementa.UIComponent;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.elementa.state.v2.ListKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateByKt;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedList;
import gg.essential.gui.friends.message.MessageUtils;
import gg.essential.gui.friends.message.v2.ClientMessage;
import gg.essential.gui.friends.message.v2.ClientMessageKt;
import gg.essential.gui.friends.message.v2.MessageRef;
import gg.essential.gui.friends.state.IMessengerManager;
import gg.essential.gui.friends.state.MessengerStateManagerImpl;
import gg.essential.gui.notification.Notifications;
import gg.essential.lib.okhttp3.HttpUrl;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.StateCallbackManager;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMemberAddPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMemberRemovePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMessageDeletePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelUpdatePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelAddPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelClearPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelMessagePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelMessageReportReasonsPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.StringsKt;
import gg.essential.util.UUIDUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatManager
extends StateCallbackManager<IMessengerManager>
implements NetworkedManager {
    @NotNull
    private final Map<Long, Channel> channels = Maps.newConcurrentMap();
    @NotNull
    private final Map<Long, ConcurrentMap<Long, Message>> channelMessages = Maps.newConcurrentMap();
    @NotNull
    private final MutableState<MutableTrackedList<Long>> channelsWithMessagesListState = ListKt.mutableListStateOf(new Long[0]);
    @NotNull
    private final Map<String, Map<String, String>> reportReasons = Maps.newConcurrentMap();
    @NotNull
    private final Set<Long> announcementChannelIds = Sets.newConcurrentHashSet();
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    public final MessengerStateManagerImpl messengerStateManager = new MessengerStateManagerImpl(this);
    @NotNull
    private final State<Integer> unreadMessageCount = StateByKt.stateBy(stateByScope -> {
        int unreadMessages = 0;
        for (Long channelId : stateByScope.invoke(this.channelsWithMessagesListState)) {
            unreadMessages += stateByScope.invoke(this.messengerStateManager.getNumUnread(channelId)).intValue();
        }
        return unreadMessages;
    });
    @NotNull
    private final PacketQueue mutedStateUpdateQueue;
    @NotNull
    private final PacketQueue sendMessageQueue;
    @NotNull
    private final Map<Long, Message> messageMap = Maps.newConcurrentMap();
    @NotNull
    private final Map<Long, EagerMessageResolver> channelEagerMessageResolverMap = new HashMap<Long, EagerMessageResolver>();
    @NotNull
    private final ServerChatChannelMessagePacketHandler serverChatChannelMessagePacketHandler = new ServerChatChannelMessagePacketHandler();

    public ChatManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.mutedStateUpdateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        this.sendMessageQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        connectionManager.registerPacketHandler(ChatChannelMemberAddPacket.class, new ChatChannelMemberAddPacketHandler());
        connectionManager.registerPacketHandler(ChatChannelMessageDeletePacket.class, new ChatChannelMessageDeletePacketHandler());
        connectionManager.registerPacketHandler(ChatChannelMemberRemovePacket.class, new ChatChannelMemberRemovePacketHandler());
        connectionManager.registerPacketHandler(ChatChannelUpdatePacket.class, new ChatChannelUpdatePacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelAddPacket.class, new ServerChatChannelAddPacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelClearPacket.class, new ServerChatChannelClearPacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelMessagePacket.class, this.serverChatChannelMessagePacketHandler);
        connectionManager.registerPacketHandler(ServerChatChannelRemovePacket.class, new ServerChatChannelRemovePacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelMessageReportReasonsPacket.class, new ServerChatChannelMessageReportReasonsPacketHandler());
    }

    @NotNull
    public Map<Long, Channel> getChannels() {
        return this.channels;
    }

    @NotNull
    public Map<String, Map<String, String>> getReportReasons() {
        return this.reportReasons;
    }

    public void setReportReasons(@Nullable Map<String, Map<String, String>> reportReasons) {
        this.reportReasons.clear();
        if (reportReasons == null) {
            return;
        }
        this.reportReasons.putAll(reportReasons);
    }

    @NotNull
    public Optional<Channel> getChannel(@NotNull Long id2) {
        return Optional.ofNullable(this.channels.get(id2));
    }

    public long getPrimaryAnnouncementChannelId() {
        Channel channel2 = this.getPrimaryAnnouncementChannel();
        return channel2 != null ? channel2.getId() : 0L;
    }

    @Nullable
    public Channel getPrimaryAnnouncementChannel() {
        for (Channel channel2 : this.channels.values()) {
            if (channel2.getType() != ChannelType.ANNOUNCEMENT) continue;
            return channel2;
        }
        return null;
    }

    public long mergeAnnouncementChannel(long id2) {
        return this.announcementChannelIds.contains(id2) && this.getPrimaryAnnouncementChannelId() != 0L ? this.getPrimaryAnnouncementChannelId() : id2;
    }

    @NotNull
    public Set<Long> getAnnouncementChannelIds() {
        return this.announcementChannelIds;
    }

    @NotNull
    public Map<String, String> getReportReasons(@NotNull String preferredLocale) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : this.reportReasons.entrySet()) {
            Map<String, String> values = entry.getValue();
            String value = values.get(preferredLocale);
            if (value == null) {
                value = values.get("en_US");
            }
            builder.put((Object)entry.getKey(), (Object)value);
        }
        return builder.build();
    }

    public void addChannels(@NotNull Iterable<Channel> channels) {
        for (Channel channel2 : channels) {
            this.addChannel(channel2);
        }
    }

    public void addChannel(@NotNull Channel channel2) {
        this.channels.put(channel2.getId(), channel2);
        for (UUID member : channel2.getMembers()) {
            CachedAvatarImage.ofUUID(member);
        }
        ServerChatChannelMessagePacketHandler.prefetching.incrementAndGet();
        this.retrieveRecentMessageHistory(channel2.getId(), 10, packet -> ServerChatChannelMessagePacketHandler.prefetching.decrementAndGet());
        if (ExtensionsKt.isAnnouncement(channel2)) {
            Iterator<Comparable<UUID>> iterator2 = this.announcementChannelIds.iterator();
            while (iterator2.hasNext()) {
                long announcementChannelId = (Long)iterator2.next();
                if (announcementChannelId == channel2.getId()) continue;
                ServerChatChannelMessagePacketHandler.prefetching.incrementAndGet();
                this.retrieveRecentMessageHistory(announcementChannelId, 100, packet -> ServerChatChannelMessagePacketHandler.prefetching.decrementAndGet());
            }
            this.announcementChannelIds.add(channel2.getId());
        }
        for (IMessengerManager iMessengerManager : this.getCallbacks()) {
            iMessengerManager.newChannel(channel2);
        }
    }

    public void setChannelInfo(long channelId, @Nullable String channelName, @Nullable String channelTopic) {
        Optional<Channel> channelOptional = this.getChannel(channelId);
        if (!channelOptional.isPresent()) {
            return;
        }
        Channel channel2 = channelOptional.get();
        if (channelName != null) {
            channel2.setName(channelName);
        }
        if (channelTopic != null) {
            channel2.setTopic(channelTopic);
        }
        for (IMessengerManager iMessengerManager : this.getCallbacks()) {
            iMessengerManager.channelUpdated(channel2);
        }
    }

    public void removeChannels(long[] channelIds) {
        for (long channelId : channelIds) {
            this.removeChannel(channelId);
        }
    }

    public void removeChannels(@NotNull Iterable<Long> channelIds) {
        for (long channelId : channelIds) {
            this.removeChannel(channelId);
        }
    }

    @Nullable
    public Channel removeChannel(long id2) {
        Channel channel2 = this.channels.remove(id2);
        ConcurrentMap<Long, Message> removed = this.channelMessages.remove(id2);
        if (removed != null) {
            for (Long messsageId : removed.keySet()) {
                this.messageMap.remove(messsageId);
            }
        }
        this.updateChannelListState();
        if (channel2 != null) {
            for (IMessengerManager iMessengerManager : this.getCallbacks()) {
                iMessengerManager.channelDeleted(channel2);
            }
        }
        this.channelEagerMessageResolverMap.remove(id2);
        this.announcementChannelIds.remove(id2);
        return channel2;
    }

    public void clearChannels() {
        this.channels.clear();
        this.channelMessages.clear();
        this.updateChannelListState();
        this.announcementChannelIds.clear();
        this.reportReasons.clear();
        this.channelEagerMessageResolverMap.clear();
        this.messageMap.clear();
        for (IMessengerManager callback : this.getCallbacks()) {
            callback.reset();
        }
    }

    @Override
    public void onConnected() {
        this.mutedStateUpdateQueue.reset();
        this.resetState();
    }

    @Override
    public void resetState() {
        this.clearChannels();
    }

    @Nullable
    public Map<Long, Message> getMessages(long channelId) {
        ConcurrentMap<Long, Message> messageMap = this.channelMessages.get(channelId);
        return messageMap != null ? Collections.unmodifiableMap(messageMap) : null;
    }

    public boolean upsertMessageToChannel(long channelId, @NotNull Message message2) {
        Channel channel2 = this.getChannel(channelId).orElse(null);
        if (channel2 == null) {
            Essential.logger.error("Received message: " + String.valueOf(message2) + " for channel that does not exist");
            return false;
        }
        boolean previousMessageExisted = this.messageMap.put(message2.getId(), message2) != null;
        ConcurrentMap map2 = this.channelMessages.get(channelId);
        if (map2 == null) {
            map2 = Maps.newConcurrentMap();
            this.channelMessages.put(channelId, map2);
            this.updateChannelListState();
        }
        map2.put(message2.getId(), message2);
        for (IMessengerManager iMessengerManager : this.getCallbacks()) {
            iMessengerManager.messageReceived(channel2, message2);
        }
        EagerMessageResolver eagerMessageResolver = this.channelEagerMessageResolverMap.get(channelId);
        if (eagerMessageResolver != null) {
            eagerMessageResolver.messageReceived(message2);
        }
        return previousMessageExisted;
    }

    public void sendMessage(long channelId, @NotNull String messageContent) {
        this.sendMessage(channelId, messageContent, null);
    }

    public void sendMessage(long channelId, @NotNull String messageContent, @Nullable Long replyToMessageId, @Nullable Consumer<Optional<Packet>> callback) {
        this.sendMessageQueue.enqueue(new ClientChatChannelMessageCreatePacket(channelId, messageContent, replyToMessageId), callback);
    }

    public void sendMessage(long channelId, @NotNull String messageContent, @Nullable Consumer<Optional<Packet>> callback) {
        this.sendMessage(channelId, messageContent, null, callback);
    }

    public void removeMessage(long channelId, long messageId) {
        Message message2;
        this.messageMap.remove(messageId);
        ConcurrentMap<Long, Message> channelMessages = this.channelMessages.get(channelId);
        if (channelMessages != null && (message2 = (Message)channelMessages.remove(messageId)) != null) {
            for (IMessengerManager iMessengerManager : this.getCallbacks()) {
                iMessengerManager.messageDeleted(message2);
            }
        }
    }

    public void updateMessage(ClientMessage message2, String newContents) {
        Message messageCopy = new Message(message2.getId(), message2.getChannel().getId(), message2.getSender(), newContents, true, message2.getReplyTo() == null ? null : Long.valueOf(message2.getReplyTo().getMessageId()), Instant.now().toEpochMilli());
        this.upsertMessageToChannel(messageCopy.getChannelId(), messageCopy);
    }

    public void deleteMessage(long channelId, long messageId) {
        this.deleteMessage(channelId, messageId, null);
        this.removeMessage(channelId, messageId);
    }

    public void deleteMessage(long channelId, long messageId, @Nullable Consumer<Optional<Packet>> callback) {
        this.connectionManager.send(new ChatChannelMessageDeletePacket(channelId, messageId), callback);
    }

    public void createGroupDM(@NotNull UUID[] members, @Nullable String groupName, @Nullable Consumer<Optional<Channel>> callback) {
        for (UUID member : members) {
            if (this.connectionManager.getRelationshipManager().isFriend(member) || member == UUIDUtil.getClientUUID()) continue;
            if (callback != null) {
                callback.accept(Optional.empty());
            }
            return;
        }
        if (groupName == null) {
            groupName = "New Group";
        } else if (groupName.length() > 64) {
            groupName = groupName.substring(0, 63);
        }
        this.connectionManager.send(new ClientChatChannelCreatePacket(ChannelType.GROUP_DIRECT_MESSAGE, groupName, members), response2 -> {
            Optional<Object> channel2;
            if (!response2.isPresent()) {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "Failed to create group.\nPlease try again.");
                channel2 = Optional.empty();
            } else if (response2.get() instanceof ServerChatChannelAddPacket) {
                channel2 = ((ServerChatChannelAddPacket)response2.get()).getChannels().stream().findFirst();
            } else {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "Failed to create group.\nPlease try again.");
                channel2 = Optional.empty();
            }
            if (callback != null) {
                callback.accept(channel2);
            }
        });
    }

    public void createDM(@NotNull UUID otherParty, @Nullable String playerName, @Nullable Consumer<Optional<Packet>> callback) {
        if (!this.connectionManager.getRelationshipManager().isFriend(otherParty)) {
            return;
        }
        this.connectionManager.send(new ClientChatChannelCreatePacket(ChannelType.DIRECT_MESSAGE, playerName, new UUID[]{otherParty}), callback);
    }

    public void updateChannelInformation(long channelId, @Nullable String channelName, @Nullable String channelTopic) {
        Channel currentChannelInfo = this.channels.get(channelId);
        if (currentChannelInfo == null) {
            return;
        }
        if (channelName == null) {
            channelName = currentChannelInfo.getName();
        } else if (channelName.length() > 64) {
            channelName = channelName.substring(0, 63);
        }
        if (channelTopic == null) {
            channelTopic = currentChannelInfo.getTopic();
        }
        if (channelName.equals(currentChannelInfo.getName()) && (channelTopic == null || channelTopic.equals(currentChannelInfo.getTopic()))) {
            return;
        }
        ChatChannelUpdatePacket update2 = new ChatChannelUpdatePacket(channelId, channelName, channelTopic);
        this.connectionManager.send(update2, responseOptional -> {
            Packet packet = responseOptional.orElse(null);
            if (!(packet instanceof ResponseActionPacket) || !((ResponseActionPacket)packet).isSuccessful()) {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "An unexpected error occurred. Please try again.");
                return;
            }
            this.setChannelInfo(channelId, update2.getName(), update2.getTopic());
        });
    }

    public void addPlayersToChannel(long channelId, @NotNull UUID[] players) {
        Channel channel2 = this.channels.get(channelId);
        if (channel2 == null) {
            return;
        }
        if (channel2.getType() != ChannelType.GROUP_DIRECT_MESSAGE) {
            return;
        }
        if (channel2.getType().hasUserLimit() && channel2.getMembers().size() + 1 > channel2.getType().getBaseUserLimit()) {
            gg.essential.gui.notification.ExtensionsKt.warning(Notifications.INSTANCE, "Group is full", "");
            return;
        }
        this.connectionManager.send(new ChatChannelMemberAddPacket(channelId, players), maybePacket -> {
            Packet packet = maybePacket.orElse(null);
            if (packet instanceof ServerChannelMemberActionResponsePacket) {
                for (Map.Entry<UUID, Boolean> entry : ((ServerChannelMemberActionResponsePacket)packet).getResults().entrySet()) {
                    UUID uuid = entry.getKey();
                    if (entry.getValue().booleanValue()) {
                        channel2.getMembers().add(uuid);
                        continue;
                    }
                    UUIDUtil.getName(uuid).thenAccept(name2 -> gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                        gg.essential.gui.notification.ExtensionsKt.markdownBody(builder, "Failed to add " + StringsKt.colored(name2, EssentialPalette.TEXT_HIGHLIGHT) + " to group. Please try again.");
                        return Unit.INSTANCE;
                    })));
                }
                for (IMessengerManager iMessengerManager : this.getCallbacks()) {
                    iMessengerManager.channelUpdated(channel2);
                }
            } else {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "Failed to add player to group. Please try again.");
            }
        });
    }

    public void removePlayerFromChannel(long channelId, @NotNull UUID player2) {
        Channel channel2 = this.channels.get(channelId);
        if (channel2 == null) {
            return;
        }
        if (channel2.getType() != ChannelType.GROUP_DIRECT_MESSAGE) {
            return;
        }
        if (!channel2.getMembers().contains(player2)) {
            return;
        }
        this.connectionManager.send(new ChatChannelMemberRemovePacket(channelId, new UUID[]{player2}), maybePacket -> {
            Packet packet = maybePacket.orElse(null);
            if (packet instanceof ServerChannelMemberActionResponsePacket) {
                for (Map.Entry<UUID, Boolean> entry : ((ServerChannelMemberActionResponsePacket)packet).getResults().entrySet()) {
                    UUID uuid = entry.getKey();
                    if (entry.getValue().booleanValue()) {
                        if (uuid.equals(UUIDUtil.getClientUUID())) {
                            this.removeChannel(channelId);
                            return;
                        }
                        channel2.getMembers().remove(uuid);
                        continue;
                    }
                    UUIDUtil.getName(uuid).thenAccept(name2 -> gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                        gg.essential.gui.notification.ExtensionsKt.markdownBody(builder, "Failed to remove " + StringsKt.colored(name2, EssentialPalette.TEXT_HIGHLIGHT) + " from group. Please try again.");
                        return Unit.INSTANCE;
                    })));
                }
                for (IMessengerManager iMessengerManager : this.getCallbacks()) {
                    iMessengerManager.channelUpdated(channel2);
                }
            } else {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "Failed to remove player from group. Please try again.");
            }
        });
    }

    public void retrieveMessageHistory(long channelId, @Nullable Long before, @Nullable Long after, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveMessageHistory(channelId, before, after, 50, callback);
    }

    public void retrieveMessageHistory(long channelId, Long before, Long after, int messageLimit, @Nullable Consumer<Optional<Packet>> callback) {
        if (!this.channels.containsKey(channelId)) {
            Essential.logger.error("Attempted to request message history for a channel that is not locally cached!");
            return;
        }
        this.connectionManager.send(new ClientChatChannelMessagesRetrievePacket(channelId, before, after, messageLimit), response2 -> {
            Packet packet = response2.orElse(null);
            if (packet instanceof ServerChatChannelMessagePacket) {
                boolean isEmpty2;
                boolean bl = isEmpty2 = ((ServerChatChannelMessagePacket)packet).getMessages().length == 0;
                if (before == null && after == null && isEmpty2) {
                    this.channelMessages.putIfAbsent(channelId, Maps.newConcurrentMap());
                    this.updateChannelListState();
                }
            }
            if (callback != null) {
                callback.accept((Optional<Packet>)response2);
            }
        });
    }

    public void retrieveRecentMessageHistory(long channelId, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveRecentMessageHistory(channelId, 50, callback);
    }

    public void retrieveRecentMessageHistory(long channelId, int messageLimit, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveMessageHistory(channelId, null, null, messageLimit, callback);
    }

    public boolean isMuted(@NotNull Channel channel2) {
        return channel2.isMuted();
    }

    public void updateMutedState(@NotNull Channel channel2, boolean muted) {
        this.mutedStateUpdateQueue.enqueue(new ClientChatChannelMutePacket(channel2.getId(), muted), response2 -> {
            boolean success;
            Packet packet = response2.orElse(null);
            boolean bl = success = packet instanceof ResponseActionPacket && ((ResponseActionPacket)packet).isSuccessful();
            if (success) {
                channel2.setMuted(muted);
            } else {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Error", "Failed to mute channel.\nPlease try again.");
            }
            for (IMessengerManager iMessengerManager : this.getCallbacks()) {
                iMessengerManager.channelUpdated(channel2);
            }
        });
    }

    public void fileReport(long channelId, long messageId, String reason) {
        this.mutedStateUpdateQueue.enqueue(new ClientChatChannelMessageReportPacket(channelId, messageId, reason), response2 -> {
            Packet packet = response2.orElse(null);
            if (packet instanceof ServerChatChannelMessageReportPacket) {
                Notifications.INSTANCE.push("Player Reported", "Thank you for reporting\nthis player.", 4.0f, (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)builder -> {
                    builder.withCustomComponent(Slot.ICON, (UIComponent)EssentialPalette.ROUND_WARNING_7X.create());
                    return Unit.INSTANCE;
                }));
            } else {
                gg.essential.gui.notification.ExtensionsKt.error(Notifications.INSTANCE, "Report Failed", "Failed to report player.\nPlease try again.");
            }
        });
    }

    private void updateChannelListState() {
        ListKt.setAll(this.channelsWithMessagesListState, new ArrayList<Long>(this.channelMessages.keySet()));
    }

    public void updateReadState(Message message2, boolean read2) {
        if (message2.isRead() == read2) {
            return;
        }
        Message messageCopy = new Message(message2.getId(), message2.getChannelId(), message2.getSender(), message2.getContents(), read2, message2.getReplyTargetId(), message2.getLastEditTime());
        this.upsertMessageToChannel(messageCopy.getChannelId(), messageCopy);
        for (IMessengerManager iMessengerManager : this.getCallbacks()) {
            iMessengerManager.messageReadStateUpdated(message2, read2);
        }
        this.connectionManager.send(new ClientChatChannelMessageReadStatePacket(message2.getChannelId(), message2.getId(), read2));
    }

    public State<Integer> getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public void membersAdded(long channelId, UUID[] members) {
        Optional<Channel> channelOptional = this.getChannel(channelId);
        if (!channelOptional.isPresent()) {
            return;
        }
        Channel channel2 = channelOptional.get();
        channel2.getMembers().addAll(Arrays.asList(members));
        for (IMessengerManager manager : this.getCallbacks()) {
            manager.channelUpdated(channel2);
        }
    }

    public void membersRemoved(long channelId, UUID[] members) {
        Optional<Channel> channelOptional = this.getChannel(channelId);
        if (!channelOptional.isPresent()) {
            return;
        }
        Channel channel2 = channelOptional.get();
        Arrays.asList(members).forEach(channel2.getMembers()::remove);
        for (IMessengerManager manager : this.getCallbacks()) {
            manager.channelUpdated(channel2);
        }
    }

    @Nullable
    public Message getMessageById(long messageId) {
        return this.messageMap.get(messageId);
    }

    @Nullable
    private Long getOldestLoadedMessageId(long channel2) {
        Map<Long, Message> messages2 = this.getMessages(channel2);
        if (messages2 == null) {
            return null;
        }
        Optional<Message> min = messages2.values().stream().min(Comparator.comparingLong(value -> MessageUtils.INSTANCE.getSentTimeStamp(value.getId())));
        return min.map(Message::getId).orElse(null);
    }

    public void retrieveChannelHistoryUntil(MessageRef ref) {
        if (ref.getMessageId() == -1L) {
            throw new IllegalArgumentException("Cannot request channel history for a deleted message");
        }
        if (ref.isInitialized()) {
            return;
        }
        Message messageById = this.getMessageById(ref.getMessageId());
        if (messageById != null) {
            ref.supplyValue(ClientMessageKt.infraInstanceToClient(messageById));
            return;
        }
        this.channelEagerMessageResolverMap.computeIfAbsent(ref.getChannelId(), x$0 -> new EagerMessageResolver((long)x$0)).resolve(ref);
    }

    public void sendGiftEmbed(UUID receiver, String cosmeticId) {
        if (receiver.equals(UUIDUtil.getClientUUID())) {
            return;
        }
        Optional<Map.Entry> channelEntry = this.getChannels().entrySet().stream().filter(entry -> ((Channel)entry.getValue()).getType() == ChannelType.DIRECT_MESSAGE && ((Channel)entry.getValue()).getMembers().contains(receiver)).findFirst();
        if (channelEntry.isPresent()) {
            HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
            urlBuilder.scheme("https").host("essential.gg").addPathSegment("gift").addPathSegment(cosmeticId);
            this.sendMessage((Long)channelEntry.get().getKey(), urlBuilder.build().toString());
        }
    }

    private class EagerMessageResolver {
        private final long channelId;
        private final Map<Long, List<MessageRef>> messageRefMap = new HashMap<Long, List<MessageRef>>();
        private boolean activelyResolving = false;
        private boolean retrievedAllMessages = false;
        private boolean messagesRequestedAtLeastOnce = false;

        private EagerMessageResolver(long channelId) {
            this.channelId = channelId;
        }

        public void resolve(MessageRef ref) {
            this.messageRefMap.computeIfAbsent(ref.getMessageId(), aLong -> new ArrayList()).add(ref);
            if (!this.activelyResolving) {
                this.activelyResolving = true;
                this.resolve();
            }
        }

        public void messageReceived(Message message2) {
            List<MessageRef> messageRefs = this.messageRefMap.remove(message2.getId());
            if (messageRefs != null) {
                for (MessageRef messageRef : messageRefs) {
                    messageRef.supplyValue(ClientMessageKt.infraInstanceToClient(message2));
                }
            }
        }

        private void resolve() {
            if (this.retrievedAllMessages || ChatManager.this.channelEagerMessageResolverMap.get(this.channelId) != this) {
                this.activelyResolving = false;
                return;
            }
            Long oldestLoadedMessageId = ChatManager.this.getOldestLoadedMessageId(this.channelId);
            if (oldestLoadedMessageId == null && this.messagesRequestedAtLeastOnce) {
                this.activelyResolving = false;
                this.retrievedAllMessages = true;
                return;
            }
            this.messagesRequestedAtLeastOnce = true;
            ChatManager.this.retrieveMessageHistory(this.channelId, oldestLoadedMessageId, null, 50, packetOptional -> {
                Packet packet = packetOptional.orElse(null);
                if (!(packet instanceof ServerChatChannelMessagePacket)) {
                    this.activelyResolving = false;
                    return;
                }
                @NotNull Message[] messages2 = ((ServerChatChannelMessagePacket)packet).getMessages();
                if (messages2.length == 0) {
                    this.activelyResolving = false;
                    this.retrievedAllMessages = true;
                    return;
                }
                if (!this.messageRefMap.isEmpty()) {
                    this.resolve();
                }
            });
        }
    }
}

