/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.ImmutableMap;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.checkout.ClientCheckoutCosmeticsPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticsUserEquippedVisibilityTogglePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticAnimationTriggerPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticTypesPopulatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsPopulatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsRevokePurchasePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsSkinTexturePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserEquippedVisibilityPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserUnlockedPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.categories.ServerCosmeticCategoriesPopulatePacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.connectionmanager.common.packet.wardrobe.ClientWardrobeSettingsPacket;
import gg.essential.connectionmanager.common.packet.wardrobe.ServerWardrobeSettingsPacket;
import gg.essential.connectionmanager.common.packet.wardrobe.ServerWardrobeStoreBundlePacket;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.model.CosmeticUnlockData;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.event.client.ClientTickEvent;
import gg.essential.event.network.server.ServerJoinEvent;
import gg.essential.event.sps.PlayerJoinSessionEvent;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.elementa.state.v2.collections.TrackedList;
import gg.essential.gui.modals.TOSModal;
import gg.essential.gui.notification.ExtensionsKt;
import gg.essential.gui.notification.HelpersKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mod.EssentialAsset;
import gg.essential.mod.Skin;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.network.connectionmanager.cosmetics.ConnectionManagerKt;
import gg.essential.network.connectionmanager.cosmetics.CosmeticEquipVisibilityResponse;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsDataWithChanges;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManagerKt;
import gg.essential.network.connectionmanager.cosmetics.EquippedCosmeticsManager;
import gg.essential.network.connectionmanager.cosmetics.EquippedCosmeticsManagerMcKt;
import gg.essential.network.connectionmanager.cosmetics.ICosmeticsManager;
import gg.essential.network.connectionmanager.cosmetics.InfraCosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.LocalCosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.ModelLoader;
import gg.essential.network.connectionmanager.cosmetics.WardrobeSettings;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticAnimationTriggerPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticCategoriesPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticSkinTexturePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticTypesPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsRevokePurchasePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsUserEquippedVisibilityPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsUserUnlockedPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerWardrobeSettingsPacketHandler;
import gg.essential.network.connectionmanager.handler.wardrobe.ServerWardrobeStoreBundlePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.network.cosmetics.cape.CapeCosmeticsManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.GuiUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmeticsManager
implements NetworkedManager,
ICosmeticsManager {
    public static final long LOAD_TIMEOUT_SECONDS = 60L;
    @NotNull
    private final ConnectionManager connectionManager;
    private final ReferenceHolder refHolder = new ReferenceHolderImpl();
    @NotNull
    private final PacketQueue updateQueue;
    @NotNull
    private final CapeCosmeticsManager capeManager;
    @NotNull
    private final WardrobeSettings wardrobeSettings;
    @NotNull
    private final InfraCosmeticsData infraCosmeticsData;
    @Nullable
    private final LocalCosmeticsData localCosmeticsData;
    @NotNull
    private final CosmeticsData cosmeticsData;
    @Nullable
    private final CosmeticsDataWithChanges cosmeticsDataWithChanges;
    @NotNull
    private final EquippedCosmeticsManager equippedCosmeticsManager;
    @NotNull
    private final MutableState<Map<String, CosmeticUnlockData>> unlockedCosmeticsData = StateKt.mutableStateOf(new HashMap());
    @NotNull
    private final State<Set<String>> unlockedCosmetics = gg.essential.gui.elementa.state.v2.combinators.StateKt.map(this.unlockedCosmeticsData, Map::keySet);
    @NotNull
    private final AssetLoader assetLoader;
    @NotNull
    private final ModelLoader modelLoader;
    @NotNull
    private CompletableFuture<Void> cosmeticsLoadedFuture = new CompletableFuture();
    private boolean receivedUnlockPacket = false;
    private boolean shownOfflineModeWarning = false;

    public CosmeticsManager(@NotNull ConnectionManager connectionManager, File baseDir) {
        this.connectionManager = connectionManager;
        this.assetLoader = new AssetLoader(baseDir.toPath().resolve("cosmetic-cache"));
        this.modelLoader = new ModelLoader(this.assetLoader);
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        this.capeManager = new CapeCosmeticsManager(connectionManager, this);
        this.wardrobeSettings = new WardrobeSettings();
        this.infraCosmeticsData = new InfraCosmeticsData(connectionManager, this.assetLoader);
        Path repoPath = baseDir.toPath().resolve("configuration");
        if (Files.notExists(repoPath, new LinkOption[0])) {
            repoPath = baseDir.toPath().resolve("cosmetics");
        }
        if (Files.exists(repoPath, new LinkOption[0])) {
            this.localCosmeticsData = new LocalCosmeticsData(repoPath, this.assetLoader);
            this.cosmeticsDataWithChanges = new CosmeticsDataWithChanges(this.localCosmeticsData);
            this.cosmeticsData = this.cosmeticsDataWithChanges;
        } else {
            this.localCosmeticsData = null;
            this.cosmeticsData = this.infraCosmeticsData;
            this.cosmeticsDataWithChanges = null;
        }
        this.equippedCosmeticsManager = new EquippedCosmeticsManager(this.connectionManager, this.connectionManager.getSubscriptionManager(), (Function1<? super String, Unit>)((Function1)hash -> {
            this.capeManager.queueCape((String)hash);
            return Unit.INSTANCE;
        }), this.cosmeticsData, this.infraCosmeticsData, (Function2<? super UUID, ? super Skin, Unit>)((Function2)(uuid, skin) -> {
            Essential.getInstance().getGameProfileManager().updatePlayerSkin((UUID)uuid, skin.getHash(), skin.getModel().getType());
            return Unit.INSTANCE;
        }), (Function1<? super Boolean, Unit>)((Function1)enabled -> {
            EquippedCosmeticsManagerMcKt.setCapeModelPartEnabled(enabled);
            return Unit.INSTANCE;
        }));
        CosmeticsManagerKt.onNewCosmetic(this.cosmeticsData, this.refHolder, cosmetic2 -> {
            ConnectionManagerKt.primeCache(this.modelLoader, this.assetLoader, cosmetic2);
            connectionManager.getNoticesManager().getCosmeticNotices().cosmeticAdded(cosmetic2.getId());
            if (this.localCosmeticsData != null) {
                this.unlockedCosmeticsData.set((Map<String, CosmeticUnlockData>)((Function1)set2 -> MapsKt.plus((Map)set2, (Pair)new Pair((Object)cosmetic2.getId(), (Object)new CosmeticUnlockData(new DateTime(), null, true)))));
            }
        });
        connectionManager.registerPacketHandler(ServerCosmeticsPopulatePacket.class, new ServerCosmeticsPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticTypesPopulatePacket.class, new ServerCosmeticTypesPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsUserUnlockedPacket.class, new ServerCosmeticsUserUnlockedPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsRevokePurchasePacket.class, new ServerCosmeticsRevokePurchasePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticAnimationTriggerPacket.class, new ServerCosmeticAnimationTriggerPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsUserEquippedVisibilityPacket.class, new ServerCosmeticsUserEquippedVisibilityPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsSkinTexturePacket.class, new ServerCosmeticSkinTexturePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticCategoriesPopulatePacket.class, new ServerCosmeticCategoriesPopulatePacketHandler(this));
        connectionManager.registerPacketHandler(ServerWardrobeSettingsPacket.class, new ServerWardrobeSettingsPacketHandler());
        connectionManager.registerPacketHandler(ServerWardrobeStoreBundlePacket.class, new ServerWardrobeStoreBundlePacketHandler());
        Essential.EVENT_BUS.register(this);
    }

    @NotNull
    public AssetLoader getAssetLoader() {
        return this.assetLoader;
    }

    @NotNull
    public ModelLoader getModelLoader() {
        return this.modelLoader;
    }

    @NotNull
    public CapeCosmeticsManager getCapeManager() {
        return this.capeManager;
    }

    @NotNull
    public EquippedCosmeticsManager getEquippedCosmeticsManager() {
        return this.equippedCosmeticsManager;
    }

    @NotNull
    public State<TrackedList<Cosmetic>> getCosmetics() {
        return this.cosmeticsData.getCosmetics();
    }

    public boolean getOwnCosmeticsVisible() {
        return this.equippedCosmeticsManager.getOwnCosmeticsVisible();
    }

    public void setOwnCosmeticsVisible(boolean state2) {
        this.equippedCosmeticsManager.setOwnCosmeticsVisible(state2);
    }

    @Override
    @NotNull
    public State<Set<String>> getUnlockedCosmetics() {
        return this.unlockedCosmetics;
    }

    @Override
    public State<Map<String, CosmeticUnlockData>> getUnlockedCosmeticsData() {
        return this.unlockedCosmeticsData;
    }

    public void addUnlockedCosmeticsData(@NotNull Map<String, CosmeticUnlockData> unlockedCosmeticsData) {
        this.infraCosmeticsData.requestCosmeticsIfMissing(unlockedCosmeticsData.keySet());
        this.unlockedCosmeticsData.set((Map<String, CosmeticUnlockData>)((Function1)set2 -> MapsKt.plus((Map)set2, (Map)unlockedCosmeticsData)));
        this.receivedUnlockPacket = true;
    }

    @Override
    public void unlockAllCosmetics() {
        CosmeticUnlockData unlockData = new CosmeticUnlockData(new DateTime(), null, true);
        this.unlockedCosmeticsData.set((Map<String, CosmeticUnlockData>)((Function1)set2 -> this.cosmeticsData.getCosmetics().get().stream().map(Cosmetic::getId).collect(Collectors.toMap(k -> k, v -> unlockData))));
    }

    @NotNull
    public Map<CosmeticSlot, String> getEquippedCosmetics() {
        return this.equippedCosmeticsManager.getEquippedCosmetics();
    }

    @NotNull
    public ImmutableMap<CosmeticSlot, EquippedCosmetic> getVisibleCosmetics(UUID playerId) {
        return this.equippedCosmeticsManager.getVisibleCosmetics(playerId);
    }

    @Nullable
    public Cosmetic getCosmetic(@NotNull String cosmeticId) {
        return this.cosmeticsData.getCosmetic(cosmeticId);
    }

    @NotNull
    public CompletableFuture<byte[]> getAssetBytes(@NotNull EssentialAsset asset, @NotNull AssetLoader.Priority priority) {
        return this.assetLoader.getAssetBytes(asset, priority);
    }

    @Override
    public void clearUnlockedCosmetics() {
        this.clearUnlockedCosmetics(false);
    }

    private void clearUnlockedCosmetics(boolean allowAutoUnlockIfSideloading) {
        this.unlockedCosmeticsData.set((Map<String, CosmeticUnlockData>)((Function1)set2 -> new HashMap()));
        if (allowAutoUnlockIfSideloading && this.localCosmeticsData != null) {
            this.unlockAllCosmetics();
        }
    }

    @Override
    public void resetState() {
        this.updateQueue.reset();
        this.clearUnlockedCosmetics(true);
        this.infraCosmeticsData.resetState();
        this.cosmeticsLoadedFuture = new CompletableFuture();
        this.receivedUnlockPacket = false;
        this.connectionManager.send(new ClientWardrobeSettingsPacket());
    }

    @Override
    public void onConnected() {
        this.resetState();
    }

    @Subscribe
    public void onSpsJoin(PlayerJoinSessionEvent event) {
        ConnectionManagerKt.unlockSpsCosmetics(this.connectionManager);
    }

    @Subscribe
    public void onWorldJoin(ServerJoinEvent event) {
        SPSManager spsManager;
        class_634 handler;
        if (!this.connectionManager.isAuthenticated()) {
            return;
        }
        if (!(EssentialConfig.INSTANCE.getDisableCosmetics() || this.shownOfflineModeWarning || (handler = UMinecraft.getMinecraft().method_1562()) == null || handler.method_48296().method_10771() || class_310.method_1551().method_1542())) {
            ExtensionsKt.warning(Notifications.INSTANCE, "Wardrobe items unavailable", "Wardrobe items are not visible on offline-mode servers.");
            this.shownOfflineModeWarning = true;
        }
        if ((spsManager = this.connectionManager.getSpsManager()).isSpsAddress(event.getServerData().field_3761) && spsManager.getLocalSession() == null) {
            ConnectionManagerKt.unlockSpsCosmetics(this.connectionManager);
        }
        ConnectionManagerKt.unlockServerCosmetics(this.connectionManager, event.getServerData().field_3761);
    }

    public void toggleOwnCosmeticVisibility(boolean notification) {
        boolean nextState = !this.getOwnCosmeticsVisible();
        this.setOwnCosmeticVisibility(notification, nextState);
    }

    public void setOwnCosmeticVisibility(boolean notification, boolean visible2) {
        if (!this.connectionManager.isAuthenticated()) {
            if (OnboardingData.hasAcceptedTos()) {
                ExtensionsKt.error(Notifications.INSTANCE, "Essential Network Error", "Unable to establish connection with the Essential Network.", (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE), (Function1<? super NotificationBuilder, Unit>)((Function1)b -> Unit.INSTANCE));
            } else if (GuiUtil.INSTANCE.openedScreen() == null) {
                HelpersKt.sendTosNotification((Function0<Unit>)((Function0)() -> {
                    GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)manager -> new TOSModal((ModalManager)manager, false, true, (Function1<? super Modal, Unit>)((Function1)it -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE))));
                    return Unit.INSTANCE;
                }));
            } else {
                GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)manager -> new TOSModal((ModalManager)manager, false, true, (Function1<? super Modal, Unit>)((Function1)it -> Unit.INSTANCE), (Function0<Unit>)((Function0)() -> Unit.INSTANCE))));
            }
            return;
        }
        if (visible2 != this.getOwnCosmeticsVisible()) {
            this.connectionManager.send(new ClientCosmeticsUserEquippedVisibilityTogglePacket(visible2), new CosmeticEquipVisibilityResponse(visible2, notification));
        }
    }

    @Override
    public CompletableFuture<Boolean> claimFreeItems(@NotNull Set<String> ids) {
        CompletableFuture<Boolean> future2 = new CompletableFuture<Boolean>();
        this.connectionManager.send(new ClientCheckoutCosmeticsPacket(ids, null), it -> {
            if (it.isPresent()) {
                Packet packet = (Packet)it.get();
                if (packet instanceof ResponseActionPacket) {
                    if (!((ResponseActionPacket)packet).isSuccessful()) {
                        Essential.debug.error("ClientCosmeticCheckoutPacket did give an expected response");
                    }
                } else if (packet instanceof ServerCosmeticsUserUnlockedPacket) {
                    future2.complete(true);
                    ServerCosmeticsUserUnlockedPacket unlockedPacket = (ServerCosmeticsUserUnlockedPacket)packet;
                    Essential.debug.debug(String.format("Automatically unlocked %d free cosmetics.", unlockedPacket.getUnlockedCosmetics().size()));
                }
            } else {
                Essential.debug.error("ClientCosmeticCheckoutPacket did not give a response");
            }
            if (!future2.isDone()) {
                future2.complete(false);
            }
        });
        return future2;
    }

    private boolean cosmeticDataLoadedFromInfra() {
        long timeout = 60000L;
        return this.wardrobeSettings.isSettingsLoaded() && this.receivedUnlockPacket && !this.cosmeticsData.getCosmetics().get().isEmpty() && !this.cosmeticsData.getCategories().get().isEmpty() && !this.cosmeticsData.getTypes().get().isEmpty() && (this.cosmeticsData != this.infraCosmeticsData || !this.infraCosmeticsData.hasActiveRequests(timeout));
    }

    @NotNull
    public CompletableFuture<Void> getCosmeticsLoadedFuture() {
        return this.cosmeticsLoadedFuture;
    }

    @Subscribe
    public void tick(ClientTickEvent tickEvent) {
        if (!this.cosmeticsLoadedFuture.isDone() && this.cosmeticDataLoadedFromInfra()) {
            this.cosmeticsLoadedFuture.complete(null);
        }
    }

    public void removeUnlockedCosmetics(List<String> revokedIds) {
        this.unlockedCosmeticsData.set((Map<String, CosmeticUnlockData>)((Function1)set2 -> set2.entrySet().stream().filter(e -> !revokedIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    @NotNull
    public WardrobeSettings getWardrobeSettings() {
        return this.wardrobeSettings;
    }

    @Override
    @NotNull
    public CosmeticsData getCosmeticsData() {
        return this.cosmeticsData;
    }

    @Override
    @NotNull
    public InfraCosmeticsData getInfraCosmeticsData() {
        return this.infraCosmeticsData;
    }

    @Override
    @Nullable
    public LocalCosmeticsData getLocalCosmeticsData() {
        return this.localCosmeticsData;
    }

    @Override
    @Nullable
    public CosmeticsDataWithChanges getCosmeticsDataWithChanges() {
        return this.cosmeticsDataWithChanges;
    }
}

