/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticPlayerSettingsPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserEquippedPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitSelectedRequestPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ServerCosmeticOutfitSelectedResponsePacket;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.mod.Model;
import gg.essential.mod.Skin;
import gg.essential.network.CMConnection;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsData;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManagerKt;
import gg.essential.network.connectionmanager.cosmetics.InfraCosmeticsData;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.USession;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002Bg\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0010\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020%0$2\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\t0\u0018J\u001c\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\t\u0018\u00010\u00182\u0006\u0010)\u001a\u00020\u0011J\u0006\u0010+\u001a\u00020\u0014J\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020%0$2\u0006\u0010)\u001a\u00020\u0011J \u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020%0\u00180.2\u0006\u0010)\u001a\u00020\u0011J\u0016\u0010/\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001101H\u0016J\u0016\u00102\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001101H\u0016J\b\u00103\u001a\u00020\nH\u0016J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u0014J<\u00106\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\t0\u00182\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018J\u0010\u00108\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0011H\u0002R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0016\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\t0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020%0$0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010&\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020%0\u00180'0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager;", "Lgg/essential/network/connectionmanager/NetworkedManager;", "Lgg/essential/network/connectionmanager/subscription/SubscriptionManager$Listener;", "connectionManager", "Lgg/essential/network/CMConnection;", "subscriptionManager", "Lgg/essential/network/connectionmanager/subscription/SubscriptionManager;", "queueOwnMojangCape", "Lkotlin/Function1;", "", "", "cosmeticsData", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;", "infraCosmeticsData", "Lgg/essential/network/connectionmanager/cosmetics/InfraCosmeticsData;", "applyPlayerSkin", "Lkotlin/Function2;", "Ljava/util/UUID;", "Lgg/essential/mod/Skin;", "applyCapeModelPartEnabled", "", "(Lgg/essential/network/CMConnection;Lgg/essential/network/connectionmanager/subscription/SubscriptionManager;Lkotlin/jvm/functions/Function1;Lgg/essential/network/connectionmanager/cosmetics/CosmeticsData;Lgg/essential/network/connectionmanager/cosmetics/InfraCosmeticsData;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "cosmeticSettings", "", "", "", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting;", "equippedCosmetics", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "ownCosmeticsVisible", "ownUuid", "getOwnUuid", "()Ljava/util/UUID;", "refHolder", "Lgg/essential/elementa/state/v2/ReferenceHolder;", "visibleCosmetics", "Lcom/google/common/collect/ImmutableMap;", "Lgg/essential/cosmetics/EquippedCosmetic;", "visibleCosmeticsStates", "Lgg/essential/gui/elementa/state/v2/MutableState;", "computeVisibleCosmetics", "playerId", "getEquippedCosmetics", "getOwnCosmeticsVisible", "getVisibleCosmetics", "getVisibleCosmeticsState", "Lgg/essential/gui/elementa/state/v2/State;", "onSubscriptionAdded", "uuids", "", "onSubscriptionRemoved", "resetState", "setOwnCosmeticsVisible", "state", "update", "settings", "updateVisibleCosmetics", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nEquippedCosmeticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EquippedCosmeticsManager.kt\ngg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager\n+ 2 CMConnection.kt\ngg/essential/network/CMConnectionKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n39#2:235\n39#2:236\n39#2:237\n372#3,7:238\n1855#4,2:245\n*S KotlinDebug\n*F\n+ 1 EquippedCosmeticsManager.kt\ngg/essential/network/connectionmanager/cosmetics/EquippedCosmeticsManager\n*L\n86#1:235\n89#1:236\n92#1:237\n204#1:238,7\n213#1:245,2\n*E\n"})
public final class EquippedCosmeticsManager
implements NetworkedManager,
SubscriptionManager.Listener {
    @NotNull
    private final CMConnection connectionManager;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final Function1<String, Unit> queueOwnMojangCape;
    @NotNull
    private final CosmeticsData cosmeticsData;
    @NotNull
    private final InfraCosmeticsData infraCosmeticsData;
    @NotNull
    private final Function2<UUID, Skin, Unit> applyPlayerSkin;
    @NotNull
    private final Function1<Boolean, Unit> applyCapeModelPartEnabled;
    @NotNull
    private final ReferenceHolder refHolder;
    @NotNull
    private final Map<UUID, Map<gg.essential.mod.cosmetics.CosmeticSlot, String>> equippedCosmetics;
    @NotNull
    private final Map<UUID, ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> visibleCosmetics;
    @NotNull
    private final Map<UUID, MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>>> visibleCosmeticsStates;
    @NotNull
    private final Map<UUID, Map<String, List<gg.essential.mod.cosmetics.settings.CosmeticSetting>>> cosmeticSettings;
    private boolean ownCosmeticsVisible;

    public EquippedCosmeticsManager(@NotNull CMConnection connectionManager, @NotNull SubscriptionManager subscriptionManager, @NotNull Function1<? super String, Unit> queueOwnMojangCape, @NotNull CosmeticsData cosmeticsData, @NotNull InfraCosmeticsData infraCosmeticsData, @NotNull Function2<? super UUID, ? super Skin, Unit> applyPlayerSkin, @NotNull Function1<? super Boolean, Unit> applyCapeModelPartEnabled) {
        CMConnection $this$registerPacketHandler$iv;
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)subscriptionManager, (String)"subscriptionManager");
        Intrinsics.checkNotNullParameter(queueOwnMojangCape, (String)"queueOwnMojangCape");
        Intrinsics.checkNotNullParameter((Object)cosmeticsData, (String)"cosmeticsData");
        Intrinsics.checkNotNullParameter((Object)infraCosmeticsData, (String)"infraCosmeticsData");
        Intrinsics.checkNotNullParameter(applyPlayerSkin, (String)"applyPlayerSkin");
        Intrinsics.checkNotNullParameter(applyCapeModelPartEnabled, (String)"applyCapeModelPartEnabled");
        this.connectionManager = connectionManager;
        this.subscriptionManager = subscriptionManager;
        this.queueOwnMojangCape = queueOwnMojangCape;
        this.cosmeticsData = cosmeticsData;
        this.infraCosmeticsData = infraCosmeticsData;
        this.applyPlayerSkin = applyPlayerSkin;
        this.applyCapeModelPartEnabled = applyCapeModelPartEnabled;
        this.refHolder = new ReferenceHolderImpl();
        this.equippedCosmetics = new LinkedHashMap();
        this.visibleCosmetics = new LinkedHashMap();
        ConcurrentMap concurrentMap = new MapMaker().weakValues().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.visibleCosmeticsStates = concurrentMap;
        this.cosmeticSettings = new LinkedHashMap();
        this.ownCosmeticsVisible = true;
        this.subscriptionManager.addListener(this);
        CosmeticsManagerKt.onNewCosmetic(this.cosmeticsData, this.refHolder, arg_0 -> EquippedCosmeticsManager._init_$lambda$0(this, arg_0));
        EssentialConfig.INSTANCE.getDisableCosmeticsState().onSetValue(this.refHolder, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean cosmeticsDisabled) {
                for (UUID playerId : equippedCosmetics.keySet()) {
                    this.updateVisibleCosmetics(playerId);
                }
                if (cosmeticsDisabled) {
                    return;
                }
                Map map2 = (Map)equippedCosmetics.get(this.getOwnUuid());
                String capeHash = map2 != null ? (String)map2.get(gg.essential.mod.cosmetics.CosmeticSlot.CAPE) : null;
                applyCapeModelPartEnabled.invoke((Object)(!Intrinsics.areEqual((Object)"CAPE_DISABLED", (Object)capeHash) ? 1 : 0));
            }
        }));
        CMConnection cMConnection = this.connectionManager;
        Function1 handler$iv = (Function1)new Function1<ServerCosmeticsUserEquippedPacket, Unit>(){

            public final void invoke(@NotNull ServerCosmeticsUserEquippedPacket packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                UUID uUID = packet.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                Map<CosmeticSlot, String> map2 = packet.getEquipped();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getEquipped(...)");
                Map<gg.essential.mod.cosmetics.CosmeticSlot, String> map3 = ConversionsKt.slotsToMod(map2);
                Map map4 = (Map)cosmeticSettings.get(packet.getUUID());
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                this.update(uUID, map3, map4);
            }
        };
        boolean $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(ServerCosmeticsUserEquippedPacket.class, handler$iv);
        $this$registerPacketHandler$iv = this.connectionManager;
        handler$iv = (Function1)new Function1<ServerCosmeticPlayerSettingsPacket, Unit>(){

            public final void invoke(@NotNull ServerCosmeticPlayerSettingsPacket packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                UUID uUID = packet.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                Map map2 = (Map)equippedCosmetics.get(packet.getUUID());
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map<String, List<CosmeticSetting>> map3 = packet.getSettings();
                Intrinsics.checkNotNullExpressionValue(map3, (String)"getSettings(...)");
                this.update(uUID, map2, ConversionsKt.settingsToModSetting(map3));
            }
        };
        $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(ServerCosmeticPlayerSettingsPacket.class, handler$iv);
        $this$registerPacketHandler$iv = this.connectionManager;
        handler$iv = (Function1)new Function1<ServerCosmeticOutfitSelectedResponsePacket, Unit>(){

            public final void invoke(@NotNull ServerCosmeticOutfitSelectedResponsePacket packet) {
                Map map2;
                Map equippedCosmetics;
                Map map3;
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                String skinTexture = packet.getSkinTexture();
                if (skinTexture != null && StringsKt.contains$default((CharSequence)skinTexture, (CharSequence)";", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{";"};
                    List list = StringsKt.split$default((CharSequence)skinTexture, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String type = (String)list.get(0);
                    String hash = (String)list.get(1);
                    Function2 function2 = applyPlayerSkin;
                    UUID uUID = packet.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    function2.invoke((Object)uUID, (Object)new Skin(hash, Intrinsics.areEqual((Object)type, (Object)"1") ? Model.ALEX : Model.STEVE));
                }
                if ((map3 = packet.getEquippedCosmetics()) == null) {
                    map3 = equippedCosmetics = MapsKt.emptyMap();
                }
                if ((map2 = packet.getCosmeticSettings()) == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map cosmeticSettings = map2;
                UUID uUID = packet.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                this.update(uUID, ConversionsKt.slotsToMod(equippedCosmetics), ConversionsKt.settingsToModSetting(cosmeticSettings));
            }
        };
        $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(ServerCosmeticOutfitSelectedResponsePacket.class, handler$iv);
    }

    private final UUID getOwnUuid() {
        return USession.Companion.activeNow().getUuid();
    }

    public final boolean getOwnCosmeticsVisible() {
        return this.ownCosmeticsVisible;
    }

    public final void setOwnCosmeticsVisible(boolean state2) {
        this.ownCosmeticsVisible = state2;
        this.updateVisibleCosmetics(this.getOwnUuid());
        if (EssentialConfig.INSTANCE.getOwnCosmeticsHidden() == state2) {
            EssentialConfig.INSTANCE.setOwnCosmeticsHidden(!state2);
        }
    }

    @NotNull
    public final Map<gg.essential.mod.cosmetics.CosmeticSlot, String> getEquippedCosmetics() {
        Map map2 = this.getEquippedCosmetics(this.getOwnUuid());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Nullable
    public final Map<gg.essential.mod.cosmetics.CosmeticSlot, String> getEquippedCosmetics(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.equippedCosmetics.get(playerId);
    }

    public final void update(@NotNull UUID playerId, @NotNull Map<gg.essential.mod.cosmetics.CosmeticSlot, String> equippedCosmetics, @NotNull Map<String, ? extends List<? extends gg.essential.mod.cosmetics.settings.CosmeticSetting>> settings2) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter(equippedCosmetics, (String)"equippedCosmetics");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        if (this.subscriptionManager.isSubscribedOrSelf(playerId)) {
            this.infraCosmeticsData.requestCosmeticsIfMissing(equippedCosmetics.values());
            this.equippedCosmetics.put(playerId, equippedCosmetics);
            this.cosmeticSettings.put(playerId, settings2);
            this.updateVisibleCosmetics(playerId);
            if (Intrinsics.areEqual((Object)playerId, (Object)this.getOwnUuid())) {
                String capeHash = equippedCosmetics.get(gg.essential.mod.cosmetics.CosmeticSlot.CAPE);
                boolean capeDisabled = Intrinsics.areEqual((Object)"CAPE_DISABLED", (Object)capeHash);
                if (!EssentialConfig.INSTANCE.getDisableCosmetics()) {
                    this.applyCapeModelPartEnabled.invoke((Object)(!capeDisabled ? 1 : 0));
                }
                if (!capeDisabled && capeHash != null) {
                    this.queueOwnMojangCape.invoke((Object)capeHash);
                }
            }
        }
    }

    private final void updateVisibleCosmetics(UUID playerId) {
        block1: {
            ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> newValue = this.computeVisibleCosmetics(playerId);
            if (Intrinsics.areEqual(this.visibleCosmetics.get(playerId), newValue)) break block1;
            this.visibleCosmetics.put(playerId, newValue);
            MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> mutableState2 = this.visibleCosmeticsStates.get(playerId);
            if (mutableState2 != null) {
                mutableState2.set((Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>)newValue);
            }
        }
    }

    private final ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> computeVisibleCosmetics(UUID playerId) {
        Map<gg.essential.mod.cosmetics.CosmeticSlot, String> map2 = this.equippedCosmetics.get(playerId);
        if (map2 == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(...)");
            return immutableMap;
        }
        Map<gg.essential.mod.cosmetics.CosmeticSlot, String> cosmeticIds = map2;
        Map map3 = this.cosmeticSettings.get(playerId);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map settings2 = map3;
        boolean cosmeticsHidden = EssentialConfig.INSTANCE.getDisableCosmetics() || !this.ownCosmeticsVisible && Intrinsics.areEqual((Object)playerId, (Object)this.getOwnUuid());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<gg.essential.mod.cosmetics.CosmeticSlot, String> entry : cosmeticIds.entrySet()) {
            Cosmetic cosmetic2;
            gg.essential.mod.cosmetics.CosmeticSlot slot = entry.getKey();
            String value = entry.getValue();
            if (!EquippedCosmeticsManager.computeVisibleCosmetics$isVisible(cosmeticsHidden, slot) || this.cosmeticsData.getCosmetic(value) == null) continue;
            List list = (List)settings2.get(value);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            builder.put((Object)slot, (Object)new EquippedCosmetic(cosmetic2, list));
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"build(...)");
        return immutableMap;
    }

    @NotNull
    public final ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> getVisibleCosmetics(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        ImmutableMap immutableMap = this.visibleCosmetics.get(playerId);
        if (immutableMap == null) {
            ImmutableMap immutableMap2 = ImmutableMap.of();
            immutableMap = immutableMap2;
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap2, (String)"of(...)");
        }
        return immutableMap;
    }

    @NotNull
    public final State<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> getVisibleCosmeticsState(@NotNull UUID playerId) {
        MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> mutableState2;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Map<UUID, MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>>> $this$getOrPut$iv = this.visibleCosmeticsStates;
        boolean $i$f$getOrPut = false;
        MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> value$iv = $this$getOrPut$iv.get(playerId);
        if (value$iv == null) {
            boolean bl = false;
            ImmutableMap<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic> immutableMap = this.visibleCosmetics.get(playerId);
            MutableState<Map> answer$iv = StateKt.mutableStateOf(immutableMap != null ? (Map)immutableMap : MapsKt.emptyMap());
            $this$getOrPut$iv.put(playerId, answer$iv);
            mutableState2 = answer$iv;
        } else {
            mutableState2 = value$iv;
        }
        return mutableState2;
    }

    @Override
    public void resetState() {
        this.equippedCosmetics.clear();
        this.visibleCosmetics.clear();
        Iterable $this$forEach$iv = this.visibleCosmeticsStates.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableState it = (MutableState)element$iv;
            boolean bl = false;
            it.set(MapsKt.emptyMap());
        }
        this.cosmeticSettings.clear();
    }

    @Override
    public void onSubscriptionAdded(@NotNull Set<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        for (UUID uuid : uuids) {
            this.connectionManager.call(new ClientCosmeticOutfitSelectedRequestPacket(uuid)).fireAndForget();
        }
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        for (UUID uuid : uuids) {
            this.equippedCosmetics.remove(uuid);
            this.visibleCosmetics.remove(uuid);
            this.cosmeticSettings.remove(uuid);
            MutableState<Map<gg.essential.mod.cosmetics.CosmeticSlot, EquippedCosmetic>> mutableState2 = this.visibleCosmeticsStates.get(uuid);
            if (mutableState2 == null) continue;
            mutableState2.set(MapsKt.emptyMap());
        }
    }

    private static final void _init_$lambda$0(EquippedCosmeticsManager this$0, Cosmetic cosmetic2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        for (Map.Entry<UUID, Map<gg.essential.mod.cosmetics.CosmeticSlot, String>> entry : this$0.equippedCosmetics.entrySet()) {
            UUID key = entry.getKey();
            Map<gg.essential.mod.cosmetics.CosmeticSlot, String> value = entry.getValue();
            if (!Intrinsics.areEqual((Object)cosmetic2.getId(), (Object)value.get(cosmetic2.getType().getSlot()))) continue;
            this$0.updateVisibleCosmetics(key);
        }
    }

    private static final boolean computeVisibleCosmetics$isVisible(boolean cosmeticsHidden, gg.essential.mod.cosmetics.CosmeticSlot slot) {
        if (Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.ICON)) {
            return true;
        }
        if (cosmeticsHidden && !Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.EMOTE)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)slot, (Object)gg.essential.mod.cosmetics.CosmeticSlot.EMOTE) || !EssentialConfig.INSTANCE.getDisableEmotes();
    }
}

