/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice;

import gg.essential.connectionmanager.common.packet.ice.IceCandidatePacket;
import gg.essential.connectionmanager.common.packet.ice.IceSessionPacket;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.modal.sps.FirewallBlockingModal;
import gg.essential.ice.CandidateManager;
import gg.essential.ice.CandidateType;
import gg.essential.ice.IceAgent;
import gg.essential.ice.LocalCandidate;
import gg.essential.ice.RemoteCandidate;
import gg.essential.ice.RemoteCandidateImpl;
import gg.essential.ice.stun.StunManager;
import gg.essential.network.CMConnection;
import gg.essential.network.connectionmanager.ice.IceManager;
import gg.essential.network.connectionmanager.ice.IceManagerImpl;
import gg.essential.network.connectionmanager.ice.PseudoTcpChannel;
import gg.essential.network.connectionmanager.ice.QuicChannel;
import gg.essential.slf4j.ChannelLogger;
import gg.essential.slf4j.CombinedLogger;
import gg.essential.slf4j.DelegatingLogger;
import gg.essential.slf4j.ExtendedLoggerKt;
import gg.essential.util.CoroutineChannelUtilsKt;
import gg.essential.util.DispatchersKt;
import gg.essential.util.FirewallUtil;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.USession;
import gg.essential.util.UuidNameLookup;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.KeyValuePair;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.DefaultLoggingEventBuilder;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 ;2\u00020\u0001:\t;<=>?@ABCB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ6\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0004J\u0016\u0010.\u001a\u00020&2\u0006\u0010(\u001a\u00020\bH\u0084@\u00a2\u0006\u0002\u0010/J,\u00100\u001a\u00060\u000fR\u00020\u00002\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\b2\u0006\u00101\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J \u00102\u001a\u0002032\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H$J\f\u00104\u001a\u00060\fR\u00020\u0000H\u0002J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000207H\u0002J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010'\u001a\u00020\u0011H\u0002R\u0014\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0015X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0012\u0010 \u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl;", "", "cmConnection", "Lgg/essential/network/CMConnection;", "logFolder", "Ljava/nio/file/Path;", "isInvited", "Lkotlin/Function1;", "Ljava/util/UUID;", "", "(Lgg/essential/network/CMConnection;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)V", "candidateManager", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$SharedCandidateManager;", "connections", "", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$IceConnection;", "connectionsScope", "Lkotlinx/coroutines/CoroutineScope;", "getConnectionsScope", "()Lkotlinx/coroutines/CoroutineScope;", "integratedServerVoicePort", "", "getIntegratedServerVoicePort", "()I", "setIntegratedServerVoicePort", "(I)V", "proxyHttpPort", "getProxyHttpPort", "()Ljava/lang/Integer;", "setProxyHttpPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "resourcePackHttpServerPort", "getResourcePackHttpServerPort", "stunManager", "Lgg/essential/ice/stun/StunManager;", "accept", "Lkotlinx/coroutines/Deferred;", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$McConnectionArgs;", "scope", "user", "ufrag", "", "password", "telemetry", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;", "connect", "(Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIceConnection", "client", "createServerAgent", "", "getCandidateManager", "handlePacket", "packet", "Lgg/essential/connectionmanager/common/packet/ice/IceCandidatePacket;", "Lgg/essential/connectionmanager/common/packet/ice/IceSessionPacket;", "setupLogging", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$LoggerSetup;", "Companion", "Flags", "IceConnection", "LoggerSetup", "McConnectionArgs", "PrettyIOException", "PrettyPrintingLogger", "SharedCandidateManager", "Telemetry", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nIceManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl\n+ 2 CMConnection.kt\ngg/essential/network/CMConnectionKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,740:1\n39#2:741\n39#2:742\n1#3:743\n*S KotlinDebug\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl\n*L\n127#1:741\n128#1:742\n*E\n"})
public abstract class IceManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMConnection cmConnection;
    @NotNull
    private final Path logFolder;
    @NotNull
    private final Function1<UUID, Boolean> isInvited;
    @NotNull
    private final CoroutineScope connectionsScope;
    @NotNull
    private final StunManager stunManager;
    @Nullable
    private SharedCandidateManager candidateManager;
    @NotNull
    private final Map<UUID, IceConnection> connections;
    @Nullable
    private Integer proxyHttpPort;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"essential/ice");
    @NotNull
    private static final CoroutineDispatcher mainThread = Dispatchers.getDefault().limitedParallelism(1);
    @NotNull
    private static AtomicInteger nextIceConnectionId = new AtomicInteger(0);
    @NotNull
    private static final SecureRandom secureRandom = new SecureRandom();

    public IceManagerImpl(@NotNull CMConnection cmConnection, @NotNull Path logFolder, @NotNull Function1<? super UUID, Boolean> isInvited) {
        CMConnection $this$registerPacketHandler$iv;
        Intrinsics.checkNotNullParameter((Object)cmConnection, (String)"cmConnection");
        Intrinsics.checkNotNullParameter((Object)logFolder, (String)"logFolder");
        Intrinsics.checkNotNullParameter(isInvited, (String)"isInvited");
        this.cmConnection = cmConnection;
        this.logFolder = logFolder;
        this.isInvited = isInvited;
        this.connectionsScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)mainThread));
        this.stunManager = new StunManager(this.connectionsScope);
        this.connections = new LinkedHashMap();
        CMConnection cMConnection = this.cmConnection;
        Function1 handler$iv = (Function1)new Function1<IceSessionPacket, Unit>(){

            public final void invoke(@NotNull IceSessionPacket it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BuildersKt.launch$default((CoroutineScope)this.getConnectionsScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                    int label;
                    final /* synthetic */ IceManagerImpl this$0;
                    final /* synthetic */ IceSessionPacket $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.handlePacket(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        boolean $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(IceSessionPacket.class, handler$iv);
        $this$registerPacketHandler$iv = this.cmConnection;
        handler$iv = (Function1)new Function1<IceCandidatePacket, Unit>(){

            public final void invoke(@NotNull IceCandidatePacket it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BuildersKt.launch$default((CoroutineScope)this.getConnectionsScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                    int label;
                    final /* synthetic */ IceManagerImpl this$0;
                    final /* synthetic */ IceCandidatePacket $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.handlePacket(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        $i$f$registerPacketHandler = false;
        $this$registerPacketHandler$iv.registerPacketHandler(IceCandidatePacket.class, handler$iv);
        BuildersKt.launch$default((CoroutineScope)this.connectionsScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IceManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists(this.this$0.logFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            return Unit.INSTANCE;
                        }
                        for (Path entry : PathsKt.listDirectoryEntries$default((Path)this.this$0.logFolder, null, (int)1, null)) {
                            try {
                                Files.delete(entry);
                            }
                            catch (Throwable e) {
                                LOGGER.warn("Failed to delete " + entry + ':', e);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    protected final CoroutineScope getConnectionsScope() {
        return this.connectionsScope;
    }

    protected abstract int getIntegratedServerVoicePort();

    protected abstract void setIntegratedServerVoicePort(int var1);

    protected abstract int getResourcePackHttpServerPort();

    @Nullable
    public final Integer getProxyHttpPort() {
        return this.proxyHttpPort;
    }

    public final void setProxyHttpPort(@Nullable Integer n) {
        this.proxyHttpPort = n;
    }

    private final void handlePacket(IceSessionPacket packet) {
        IceConnection outgoingConnection;
        IceConnection iceConnection;
        UUID uUID = packet.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUser(...)");
        UUID user = uUID;
        IceConnection iceConnection2 = this.connections.get(user);
        if (iceConnection2 != null) {
            IceConnection iceConnection3;
            IceConnection it = iceConnection3 = iceConnection2;
            boolean bl = false;
            iceConnection = it.getJob().isActive() && !it.getRemoteCreds().isCompleted() ? iceConnection3 : null;
        } else {
            iceConnection = outgoingConnection = null;
        }
        if (outgoingConnection != null) {
            CompletableDeferred<Pair<String, byte[]>> completableDeferred = outgoingConnection.getRemoteCreds();
            String string = packet.getUfrag();
            String string2 = packet.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPassword(...)");
            completableDeferred.complete((Object)new Pair((Object)string, (Object)StringsKt.encodeToByteArray((String)string2)));
        } else if (((Boolean)this.isInvited.invoke((Object)user)).booleanValue()) {
            String string = packet.getUfrag();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUfrag(...)");
            String string3 = packet.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPassword(...)");
            this.createServerAgent(user, string, string3);
        } else {
            LOGGER.debug("Ignoring IceSessionPacket from {} because they weren't invited.", (Object)user);
        }
    }

    private final void handlePacket(IceCandidatePacket packet) {
        UUID uUID = packet.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUser(...)");
        UUID user = uUID;
        IceConnection connection = this.connections.get(user);
        if (connection == null) {
            LOGGER.debug("Ignoring candidate from {} because they have no active session.", (Object)user);
            return;
        }
        String candidateStr = packet.getCandidate();
        if (candidateStr != null) {
            RemoteCandidate remoteCandidate = IceManagerImpl.Companion.candidateFromString(candidateStr);
            if (remoteCandidate == null) {
                return;
            }
            RemoteCandidate candidate2 = remoteCandidate;
            connection.getAgent().getRemoteCandidateChannel().trySend-JP2dKIU((Object)candidate2);
        } else {
            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)connection.getAgent().getRemoteCandidateChannel()), null, (int)1, null);
        }
    }

    @Nullable
    protected final Object connect(@NotNull UUID user, @NotNull Continuation<? super McConnectionArgs> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)mainThread), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super McConnectionArgs>, Object>(user, this, null){
            Object L$0;
            int label;
            final /* synthetic */ UUID $user;
            final /* synthetic */ IceManagerImpl this$0;
            {
                this.$user = $user;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        IceManagerImpl.access$getLOGGER$cp().info("Creating client-side ICE agent for {}", (Object)this.$user);
lbl6:
                        // 3 sources

                        while (FirewallUtil.INSTANCE.isFirewallBlocking()) {
                            var2_3 = this.$user;
                            $i$f$suspendCancellableCoroutine = false;
                            this.L$0 = var2_3;
                            this.label = 1;
                            uCont$iv = (Continuation)this;
                            $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                            cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                            cancellable$iv.initCancellability();
                            continuation = (CancellableContinuation)cancellable$iv;
                            $i$a$-suspendCancellableCoroutine-IceManagerImpl$connect$2$1 = false;
                            manager = GuiEssentialPlatform.Companion.getPlatform().createModalManager();
                            manager.queueModal(new FirewallBlockingModal(manager, var2_3, (Function1<? super Modal, Unit>)((Function1)new Function1<Modal, Unit>((CancellableContinuation<? super Unit>)continuation){
                                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                                {
                                    this.$continuation = $continuation;
                                    super(1);
                                }

                                public final void invoke(@NotNull Modal $this$$receiver) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)$this$$receiver), (String)"$this$$receiver");
                                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new PrettyIOException("ICE setup failed - Firewall enabled", null))));
                                }
                            }), (Function1<? super Modal, Unit>)((Function1)new Function1<Modal, Unit>((CancellableContinuation<? super Unit>)continuation){
                                final /* synthetic */ CancellableContinuation<Unit> $continuation;
                                {
                                    this.$continuation = $continuation;
                                    super(1);
                                }

                                public final void invoke(@NotNull Modal $this$$receiver) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)$this$$receiver), (String)"$this$$receiver");
                                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                                }
                            })));
                            v0 = cancellable$iv.getResult();
                            if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                            }
                            v1 = v0;
                            if (v0 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$suspendCancellableCoroutine = false;
                        (UUID)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl6
                    }
                }
                $this$forEach$iv = IceManagerImpl.access$getConnections$p(this.this$0);
                $i$f$forEach = false;
                var4_5 = $this$forEach$iv.entrySet().iterator();
                while (var4_5.hasNext()) {
                    it = element$iv = var4_5.next();
                    $i$a$-forEach-IceManagerImpl$connect$2$2 = false;
                    Job.DefaultImpls.cancel$default((Job)((Job)((IceConnection)it.getValue()).getJob()), null, (int)1, null);
                }
                IceManagerImpl.access$getConnections$p(this.this$0).clear();
                connection = IceManagerImpl.access$createIceConnection(this.this$0, this.this$0.getConnectionsScope(), this.$user, true, Telemetry.None.INSTANCE);
                IceManagerImpl.access$getConnections$p(this.this$0).put(this.$user, connection);
                this.L$0 = null;
                this.label = 2;
                v2 = connection.getConnectJob().await((Continuation)this);
                if (v2 == var10_2) {
                    return var10_2;
                }
                ** GOTO lbl57
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl57:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super McConnectionArgs> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected abstract void createServerAgent(@NotNull UUID var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    protected final Deferred<McConnectionArgs> accept(@NotNull CoroutineScope scope2, @NotNull UUID user, @NotNull String ufrag, @NotNull String password, @NotNull Telemetry telemetry) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)ufrag, (String)"ufrag");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
        Object[] objectArray = new Object[]{user, ufrag, password};
        LOGGER.info("Creating server-side ICE agent at request from {} (ufrag: {}, pwd: {})", objectArray);
        IceConnection iceConnection = this.connections.remove(user);
        if (iceConnection != null && (iceConnection = iceConnection.getJob()) != null) {
            Job.DefaultImpls.cancel$default((Job)((Job)iceConnection), null, (int)1, null);
        }
        IceConnection connection = this.createIceConnection(scope2, user, false, telemetry);
        this.connections.put(user, connection);
        connection.getRemoteCreds().complete((Object)new Pair((Object)ufrag, (Object)StringsKt.encodeToByteArray((String)password)));
        return connection.getConnectJob();
    }

    private final LoggerSetup setupLogging(CoroutineScope scope2) {
        int iceConnectionId = nextIceConnectionId.incrementAndGet();
        Instant startInstant = Instant.now();
        long startTimeMark = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        Channel fileChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        ChannelLogger fileLogger = new ChannelLogger(Level.TRACE, (Channel<Pair<ComparableTimeMark, LoggingEvent>>)fileChannel, (TimeSource.WithComparableMarks)TimeSource.Monotonic.INSTANCE);
        Intrinsics.checkNotNull((Object)startInstant);
        fileLogger.info("Log starts at {} ({} local time)", startInstant, IceManagerImpl.setupLogging$toLocalTime(startInstant));
        Logger logger2 = LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOGGER");
        Logger logger3 = (Logger)new CombinedLogger(ExtendedLoggerKt.withKeyValue((Logger)new PrettyPrintingLogger(logger2), "iceConnectionId", iceConnectionId), (Logger)new PrettyPrintingLogger((Logger)fileLogger));
        Path file = this.logFolder.resolve("connection-" + iceConnectionId + ".log");
        Job fileJob2 = BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, (Channel<Pair<ComparableTimeMark, LoggingEvent>>)fileChannel, startTimeMark, startInstant, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            long J$0;
            int label;
            final /* synthetic */ Path $file;
            final /* synthetic */ Channel<Pair<ComparableTimeMark, LoggingEvent>> $fileChannel;
            final /* synthetic */ long $startTimeMark;
            final /* synthetic */ Instant $startInstant;
            {
                this.$file = $file;
                this.$fileChannel = $fileChannel;
                this.$startTimeMark = $startTimeMark;
                this.$startInstant = $startInstant;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var26_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$file;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"$file");
                        PathsKt.createParentDirectories((Path)v0, (FileAttribute[])new FileAttribute[0]);
                        v1 = this.$file;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"$file");
                        var2_3 = v1;
                        var5_4 = new OpenOption[]{};
                        var3_5 = Charsets.UTF_8;
                        var4_6 = 8192;
                        var2_3 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)var2_3, Arrays.copyOf(var5_4, var5_4.length)), (Charset)var3_5), var4_6);
                        var3_5 = this.$fileChannel;
                        var4_7 = this.$startTimeMark;
                        var6_8 = this.$startInstant;
                        var7_9 = null;
                        try {
                            out = (BufferedWriter)var2_3;
                            $i$a$-use-IceManagerImpl$setupLogging$fileJob$1$1 = false;
                            localTimeFormat = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
                            var11_15 = var3_5.iterator();
                        }
                        catch (Throwable var8_11) {
                            try {
                                var7_9 = var8_11;
                                throw var8_11;
                            }
                            catch (Throwable var8_12) {
                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var7_9);
                                throw var8_12;
                            }
                        }
lbl34:
                        // 3 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.L$1 = var3_5;
                            this.L$2 = var6_8;
                            this.L$3 = out;
                            this.L$4 = localTimeFormat;
                            this.L$5 = var11_15;
                            this.J$0 = var4_7;
                            this.label = 1;
                            v2 = var11_15.hasNext((Continuation)this);
                            if (v2 == var26_2) {
                                return var26_2;
                            }
                            ** GOTO lbl60
                            break;
                        }
                    }
                    case 1: {
                        $i$a$-use-IceManagerImpl$setupLogging$fileJob$1$1 = false;
                        var4_7 = this.J$0;
                        var11_15 = (ChannelIterator)this.L$5;
                        localTimeFormat = (DateTimeFormatter)this.L$4;
                        out = (BufferedWriter)this.L$3;
                        var7_9 = null;
                        var6_8 = (Instant)this.L$2;
                        var3_5 = (Channel)this.L$1;
                        var2_3 = (Closeable)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl60:
                            // 2 sources

                            if (!((Boolean)v2).booleanValue()) ** GOTO lbl83
                            var12_16 = (Pair)var11_15.next();
                            timeMark = (ComparableTimeMark)var12_16.component1();
                            event = (LoggingEvent)var12_16.component2();
                            var17_20 = relativeTime = timeMark.minus-UwyO8pc((ComparableTimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)var4_7));
                            var19_22 = Duration.getNanosecondsComponent-impl((long)var17_20);
                            var20_23 = Duration.getInWholeSeconds-impl((long)var17_20);
                            v3 = java.time.Duration.ofSeconds(var20_23, var19_22);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toComponents-impl(...)");
                            localTime = LocalTime.from(var6_8.plus(v3).atZone(ZoneId.systemDefault()));
                            var23_25 = "%03d.%03d";
                            var19_21 = new Object[]{Boxing.boxLong((long)Duration.getInWholeSeconds-impl((long)relativeTime)), Boxing.boxLong((long)(Duration.getInWholeMilliseconds-impl((long)relativeTime) % (long)1000))};
                            Intrinsics.checkNotNullExpressionValue((Object)String.format(var23_25, Arrays.copyOf(var19_21, var19_21.length)), (String)"format(...)");
                            localTimeStr = localTime.format(localTimeFormat);
                            message = MessageFormatter.basicArrayFormat((String)event.getMessage(), (Object[])event.getArgumentArray());
                            line = '[' + relativeTimeStr + "][" + localTimeStr + "][" + event.getLevel() + "] " + message + '\n';
                            out.write(line);
                            v4 = event.getThrowable();
                            if (v4 != null) {
                                v4.printStackTrace(new PrintWriter(out));
                            }
                            if (!var3_5.isEmpty()) ** GOTO lbl34
                            out.flush();
                            ** continue;
lbl83:
                            // 1 sources

                            var8_10 = Unit.INSTANCE;
                        }
                        CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var7_9);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Intrinsics.checkNotNull((Object)file);
        return new LoggerSetup(iceConnectionId, logger3, file, fileJob2, (SendChannel)fileChannel, (Logger)fileLogger);
    }

    private final SharedCandidateManager getCandidateManager() {
        Object active2 = this.candidateManager;
        if (active2 == null || active2.getCandidateManager().getAnyShutDown()) {
            Channel<Job> channel2 = active2;
            if (channel2 != null && (channel2 = channel2.getChildren()) != null) {
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)channel2), null, (int)1, null);
            }
            this.candidateManager = active2 = new SharedCandidateManager();
        }
        return active2;
    }

    private final IceConnection createIceConnection(CoroutineScope scope2, UUID user, boolean client, Telemetry telemetry) {
        LoggerSetup logging = this.setupLogging(scope2);
        Logger logger2 = logging.getLogger();
        Object[] objectArray = new Object[]{USession.Companion.activeNow().getUsername(), USession.Companion.activeNow().getUuid(), UuidNameLookup.nameState(user, "[name not yet known]").getUntracked(), user, client ? "client" : "server"};
        logger2.info("Starting connection between {} ({}) and {} ({}), we are the {}", objectArray);
        SharedCandidateManager sharedCandidateManager = this.getCandidateManager();
        sharedCandidateManager.getLogging().getLogger().debug("Manager now in used by connection {}", (Object)logging.getId());
        logging.getFileLogger().debug("CandidateManager logs are stored in {}", (Object)sharedCandidateManager.getLogging().getFile());
        IceConnection connection = new IceConnection(logger2, scope2, this.stunManager, sharedCandidateManager.getCandidateManager(), user, client, telemetry);
        sharedCandidateManager.getChildren().trySend-JP2dKIU((Object)connection.getJob());
        BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connection, logging, null){
            int label;
            final /* synthetic */ IceConnection $connection;
            final /* synthetic */ LoggerSetup $logging;
            {
                this.$connection = $connection;
                this.$logging = $logging;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return connection;
    }

    private static final LocalTime setupLogging$toLocalTime(Instant $this$setupLogging_u24toLocalTime) {
        LocalTime localTime = LocalTime.from($this$setupLogging_u24toLocalTime.atZone(ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"from(...)");
        return localTime;
    }

    public static final /* synthetic */ Map access$getConnections$p(IceManagerImpl $this) {
        return $this.connections;
    }

    public static final /* synthetic */ IceConnection access$createIceConnection(IceManagerImpl $this, CoroutineScope scope2, UUID user, boolean client, Telemetry telemetry) {
        return $this.createIceConnection(scope2, user, client, telemetry);
    }

    public static final /* synthetic */ CMConnection access$getCmConnection$p(IceManagerImpl $this) {
        return $this.cmConnection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mainThread", "Lkotlinx/coroutines/CoroutineDispatcher;", "getMainThread$annotations", "nextIceConnectionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "secureRandom", "Ljava/security/SecureRandom;", "candidateFromString", "Lgg/essential/ice/RemoteCandidate;", "string", "", "candidateToString", "candidate", "Lgg/essential/ice/LocalCandidate;", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getMainThread$annotations() {
        }

        private final String candidateToString(LocalCandidate candidate2) {
            List list;
            List $this$candidateToString_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$candidateToString_u24lambda_u240.add(candidate2.getPriority());
            $this$candidateToString_u24lambda_u240.add(1);
            $this$candidateToString_u24lambda_u240.add("udp");
            $this$candidateToString_u24lambda_u240.add(candidate2.getPriority());
            String string = candidate2.getAddress().getAddress().getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
            $this$candidateToString_u24lambda_u240.add(StringsKt.substringBefore$default((String)string, (char)'%', null, (int)2, null));
            $this$candidateToString_u24lambda_u240.add(candidate2.getAddress().getPort());
            $this$candidateToString_u24lambda_u240.add("typ");
            $this$candidateToString_u24lambda_u240.add(candidate2.getType().getShortName());
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)list), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        private final RemoteCandidate candidateFromString(String string) {
            try {
                String[] stringArray = new String[]{" "};
                List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                int priority = Integer.parseInt((String)parts.get(3));
                String address = (String)parts.get(4);
                int port = Integer.parseInt((String)parts.get(5));
                CandidateType type = (CandidateType)((Object)MapsKt.getValue(CandidateType.Companion.getByShortName(), parts.get(7)));
                InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName(address), port);
                return new RemoteCandidateImpl(type, socketAddress, priority);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse candidate \"" + string + "\":", (Throwable)e);
                return null;
            }
        }

        public static final /* synthetic */ String access$candidateToString(Companion $this, LocalCandidate candidate2) {
            return $this.candidateToString(candidate2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Flags;", "", "logger", "Lorg/slf4j/Logger;", "localCreds", "Lkotlin/Pair;", "", "", "remoteCreds", "(Lorg/slf4j/Logger;Lkotlin/Pair;Lkotlin/Pair;)V", "flags", "isQuic", "", "()Z", "voicePort", "", "getVoicePort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nIceManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$Flags\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,740:1\n643#2,5:741\n*S KotlinDebug\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$Flags\n*L\n627#1:741,5\n*E\n"})
    private static final class Flags {
        @NotNull
        private final Pair<String, String> flags;
        private final boolean isQuic;
        @Nullable
        private final Integer voicePort;

        /*
         * WARNING - void declaration
         */
        public Flags(@NotNull Logger logger2, @NotNull Pair<String, byte[]> localCreds, @NotNull Pair<String, byte[]> remoteCreds) {
            Integer n;
            String flag;
            String flags2;
            block7: {
                String string;
                void $this$voicePort_u24lambda_u243;
                boolean bl;
                Flags $this$isQuic_u24lambda_u241;
                Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
                Intrinsics.checkNotNullParameter(localCreds, (String)"localCreds");
                Intrinsics.checkNotNullParameter(remoteCreds, (String)"remoteCreds");
                Flags flags3 = this;
                Flags flags4 = this;
                boolean bl2 = false;
                String localUfrag = (String)localCreds.getFirst();
                String remoteUfrag = (String)remoteCreds.getFirst();
                String[] stringArray = new String[]{"-"};
                List localParts = StringsKt.split$default((CharSequence)localUfrag, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String[] stringArray2 = new String[]{"-"};
                List remoteParts = StringsKt.split$default((CharSequence)remoteUfrag, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String localFlags = localParts.size() > 2 ? (String)localParts.get(1) : "";
                String remoteFlags = remoteParts.size() > 2 ? (String)remoteParts.get(1) : "";
                flags4.flags = new Pair((Object)localFlags, (Object)remoteFlags);
                Flags $this$flags_u24lambda_u240 = this;
                flags4 = this;
                boolean bl3 = false;
                boolean localSupport = StringsKt.contains$default((CharSequence)((CharSequence)$this$isQuic_u24lambda_u241.flags.getFirst()), (CharSequence)"q", (boolean)false, (int)2, null);
                boolean remoteSupport = StringsKt.contains$default((CharSequence)((CharSequence)$this$isQuic_u24lambda_u241.flags.getSecond()), (CharSequence)"q", (boolean)false, (int)2, null);
                if (localSupport && remoteSupport) {
                    logger2.info("Using QUIC because both parties support it.");
                    bl = true;
                } else {
                    String who = localSupport ? "the remote client does" : (remoteSupport ? "the local client does" : "both sides do");
                    logger2.warn("Not using QUIC (falling back to PseudoTCP) because {} not support it.", (Object)who);
                    bl = false;
                }
                boolean bl4 = bl;
                flags4.isQuic = bl4;
                $this$isQuic_u24lambda_u241 = this;
                flags4 = this;
                boolean bl5 = false;
                flags2 = StringsKt.contains$default((CharSequence)((CharSequence)$this$voicePort_u24lambda_u243.flags.getFirst()), (CharSequence)"v", (boolean)false, (int)2, null) ? (String)$this$voicePort_u24lambda_u243.flags.getFirst() : (String)$this$voicePort_u24lambda_u243.flags.getSecond();
                String $this$takeWhile$iv = StringsKt.substringAfter((String)flags2, (String)"v", (String)"");
                boolean $i$f$takeWhile = false;
                int n2 = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl6 = false;
                    if (Character.isDigit(it)) continue;
                    String string2 = $this$takeWhile$iv;
                    int n3 = 0;
                    String string3 = string2.substring(n3, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block7;
                }
                string = flag = $this$takeWhile$iv;
            }
            if (((CharSequence)flag).length() == 0) {
                logger2.warn("Connection does not support voice tunneling.");
                n = null;
            } else {
                Integer n4;
                try {
                    n4 = Integer.parseInt(flag);
                }
                catch (NumberFormatException e) {
                    logger2.error("Failed to parse voice port from \"" + flags2 + "\":", (Throwable)e);
                    n4 = null;
                }
                n = n4;
            }
            flags4.voicePort = n;
        }

        public final boolean isQuic() {
            return this.isQuic;
        }

        @Nullable
        public final Integer getVoicePort() {
            return this.voicePort;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0084\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001d\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020'00\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010$R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020'0009\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010$\u00a8\u0006B"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$IceConnection;", "", "logger", "Lorg/slf4j/Logger;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "stunManager", "Lgg/essential/ice/stun/StunManager;", "candidateManager", "Lgg/essential/ice/CandidateManager;", "user", "Ljava/util/UUID;", "client", "", "telemetry", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;", "(Lgg/essential/network/connectionmanager/ice/IceManagerImpl;Lorg/slf4j/Logger;Lkotlinx/coroutines/CoroutineScope;Lgg/essential/ice/stun/StunManager;Lgg/essential/ice/CandidateManager;Ljava/util/UUID;ZLgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;)V", "agent", "Lgg/essential/ice/IceAgent;", "getAgent", "()Lgg/essential/ice/IceAgent;", "getClient", "()Z", "connectJob", "Lkotlinx/coroutines/Deferred;", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$McConnectionArgs;", "getConnectJob", "()Lkotlinx/coroutines/Deferred;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "flags", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Flags;", "forwardLocalCandidatesJob", "Lkotlinx/coroutines/Job;", "getForwardLocalCandidatesJob", "()Lkotlinx/coroutines/Job;", "inboundDataChannel", "Lkotlinx/coroutines/channels/Channel;", "", "inboundPacketSortingJob", "getInboundPacketSortingJob", "inboundVoiceChannel", "job", "Lkotlinx/coroutines/CompletableJob;", "getJob", "()Lkotlinx/coroutines/CompletableJob;", "localCreds", "Lkotlin/Pair;", "", "getLocalCreds", "()Lkotlin/Pair;", "outboundDataChannel", "outboundPacketMergingJob", "getOutboundPacketMergingJob", "outboundVoiceChannel", "remoteCreds", "Lkotlinx/coroutines/CompletableDeferred;", "getRemoteCreds", "()Lkotlinx/coroutines/CompletableDeferred;", "getTelemetry", "()Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;", "getUser", "()Ljava/util/UUID;", "voiceProxyJob", "getVoiceProxyJob", "essential-gui-essential"})
    protected final class IceConnection {
        @NotNull
        private final UUID user;
        private final boolean client;
        @NotNull
        private final Telemetry telemetry;
        @NotNull
        private final CompletableJob job;
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final Pair<String, byte[]> localCreds;
        @NotNull
        private final CompletableDeferred<Pair<String, byte[]>> remoteCreds;
        @NotNull
        private final Deferred<Flags> flags;
        @NotNull
        private final IceAgent agent;
        @NotNull
        private final Job forwardLocalCandidatesJob;
        @NotNull
        private final Channel<byte[]> inboundDataChannel;
        @NotNull
        private final Channel<byte[]> outboundDataChannel;
        @NotNull
        private final Channel<byte[]> inboundVoiceChannel;
        @NotNull
        private final Channel<byte[]> outboundVoiceChannel;
        @NotNull
        private final Job inboundPacketSortingJob;
        @NotNull
        private final Job outboundPacketMergingJob;
        @NotNull
        private final Deferred<McConnectionArgs> connectJob;
        @NotNull
        private final Job voiceProxyJob;

        /*
         * WARNING - void declaration
         */
        public IceConnection(@NotNull Logger logger2, @NotNull CoroutineScope parentScope, @NotNull StunManager stunManager, @NotNull CandidateManager candidateManager, UUID user, @NotNull boolean client, Telemetry telemetry) {
            void $this$localCreds_u24lambda_u240;
            String flags2;
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)stunManager, (String)"stunManager");
            Intrinsics.checkNotNullParameter((Object)candidateManager, (String)"candidateManager");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
            this.user = user;
            this.client = client;
            this.telemetry = telemetry;
            this.job = JobKt.Job((Job)JobKt.getJob((CoroutineContext)parentScope.getCoroutineContext()));
            this.coroutineScope = CoroutineScopeKt.plus((CoroutineScope)parentScope, (CoroutineContext)((CoroutineContext)this.job));
            IceConnection iceConnection = this;
            IceManagerImpl iceManagerImpl = IceManagerImpl.this;
            IceConnection iceConnection2 = iceConnection;
            IceConnection iceConnection3 = this;
            boolean bl = false;
            String string = flags2 = IceManager.SUPPORTS_QUIC ? "q" : "";
            if (!$this$localCreds_u24lambda_u240.client) {
                flags2 = flags2 + 'v' + iceManagerImpl.getIntegratedServerVoicePort();
            }
            byte[] randomness = new byte[20];
            secureRandom.nextBytes(randomness);
            String username = "essential-" + flags2 + '-' + Hex.encodeHexString((byte[])ArraysKt.sliceArray((byte[])randomness, (IntRange)RangesKt.until((int)0, (int)4)));
            String string2 = Hex.encodeHexString((byte[])ArraysKt.sliceArray((byte[])randomness, (IntRange)RangesKt.until((int)4, (int)20)));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeHexString(...)");
            byte[] password = StringsKt.encodeToByteArray((String)string2);
            iceConnection3.localCreds = new Pair((Object)username, (Object)password);
            this.remoteCreds = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.flags = BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Flags>, Object>(logger2, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ Logger $logger;
                final /* synthetic */ IceConnection this$0;
                {
                    this.$logger = $logger;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var3_3 = this.this$0.getLocalCreds();
                            var2_4 = this.$logger;
                            this.L$0 = var2_4;
                            this.L$1 = var3_3;
                            this.label = 1;
                            v0 = this.this$0.getRemoteCreds().await((Continuation)this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            var3_3 = (Pair<String, byte[]>)this.L$1;
                            var2_4 = (Logger)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            var4_5 = v0;
                            var5_6 = (Pair)var4_5;
                            var6_7 = var3_3;
                            var7_8 = var2_4;
                            return new Flags(var7_8, var6_7, (Pair<String, byte[]>)var5_6);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Flags> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.agent = new IceAgent(logger2, CoroutineScopeKt.CoroutineScope((CoroutineContext)this.job.plus((CoroutineContext)mainThread)), stunManager, candidateManager, this.client, this.localCreds, (Deferred<Pair<String, byte[]>>)((Deferred)this.remoteCreds));
            this.forwardLocalCandidatesJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)DispatchersKt.getClient(Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(IceManagerImpl.this, this, null){
                Object L$0;
                int label;
                final /* synthetic */ IceManagerImpl this$0;
                final /* synthetic */ IceConnection this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            IceManagerImpl.access$getCmConnection$p(this.this$0).call(new IceSessionPacket(this.this$1.getUser(), (String)this.this$1.getLocalCreds().getFirst(), StringsKt.decodeToString((byte[])((byte[])this.this$1.getLocalCreds().getSecond())))).fireAndForget();
                            var2_3 = this.this$1.getAgent().getLocalCandidateChannel().iterator();
lbl7:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl18
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) {
                                candidate = (LocalCandidate)var2_3.next();
                                IceManagerImpl.access$getCmConnection$p(this.this$0).call(new IceCandidatePacket(this.this$1.getUser(), gg.essential.network.connectionmanager.ice.IceManagerImpl$Companion.access$candidateToString(IceManagerImpl.Companion, candidate))).fireAndForget();
                                ** continue;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this.inboundDataChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<byte[], Unit>(logger2){
                final /* synthetic */ Logger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull byte[] packet) {
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    this.$logger.warn("IceConnection.inboundDataChannel overflow, dropping packet of {} bytes", (Object)packet.length);
                }
            }));
            this.outboundDataChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<byte[], Unit>(logger2){
                final /* synthetic */ Logger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull byte[] packet) {
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    this.$logger.warn("IceConnection.outboundDataChannel overflow, dropping packet of {} bytes", (Object)packet.length);
                }
            }));
            this.inboundVoiceChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<byte[], Unit>(logger2){
                final /* synthetic */ Logger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull byte[] packet) {
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    this.$logger.warn("IceConnection.inboundVoiceChannel overflow, dropping packet of {} bytes", (Object)packet.length);
                }
            }));
            this.outboundVoiceChannel = ChannelKt.Channel((int)1000, (BufferOverflow)BufferOverflow.DROP_OLDEST, (Function1)((Function1)new Function1<byte[], Unit>(logger2){
                final /* synthetic */ Logger $logger;
                {
                    this.$logger = $logger;
                    super(1);
                }

                public final void invoke(@NotNull byte[] packet) {
                    Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                    this.$logger.warn("IceConnection.outboundVoiceChannel overflow, dropping packet of {} bytes", (Object)packet.length);
                }
            }));
            this.inboundPacketSortingJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ IceConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.this$0.getAgent().getInboundDataChannel().iterator();
lbl6:
                            // 4 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl17
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) break;
                            var3_4 = (Pair)var2_3.next();
                            candidate = (LocalCandidate)var3_4.component1();
                            data = (byte[])var3_4.component2();
                            this.this$0.getTelemetry().packetReceived(data.length, candidate.isIPv6(), candidate.isRelay());
                            if (!(data.length == 0 == false) || data[0] != IceManager.VOICE_HEADER_BYTE) break;
                            this.L$0 = var2_3;
                            this.label = 2;
                            v1 = IceConnection.access$getInboundVoiceChannel$p(this.this$0).send((Object)data, (Continuation)this);
                            if (v1 != var6_2) ** GOTO lbl6
                            return var6_2;
                        }
                        case 2: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl6
                        }
                    }
                    this.L$0 = var2_3;
                    this.label = 3;
                    v2 = IceConnection.access$getInboundDataChannel$p(this.this$0).send((Object)data, (Continuation)this);
                    if (v2 == var6_2) {
                        return var6_2;
                    }
                    ** GOTO lbl43
                    {
                        case 3: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl43:
                            // 2 sources

                            ** continue;
                        }
                    }
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)IceConnection.access$getInboundVoiceChannel$p(this.this$0)), null, (int)1, null);
                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)IceConnection.access$getInboundDataChannel$p(this.this$0)), null, (int)1, null);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this.outboundPacketMergingJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ IceConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            Channel mergedChannel = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
                            BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<byte[]>)mergedChannel, this.this$0, null){
                                int label;
                                final /* synthetic */ Channel<byte[]> $mergedChannel;
                                final /* synthetic */ IceConnection this$0;
                                {
                                    this.$mergedChannel = $mergedChannel;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ReceiveChannel[] receiveChannelArray = new ReceiveChannel[]{IceConnection.access$getOutboundVoiceChannel$p(this.this$0), IceConnection.access$getOutboundDataChannel$p(this.this$0)};
                                            this.label = 1;
                                            Object object3 = CoroutineChannelUtilsKt.forwardChannelsInto((SendChannel)this.$mergedChannel, receiveChannelArray, (Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<byte[]>)mergedChannel, this.this$0, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ Channel<byte[]> $mergedChannel;
                                final /* synthetic */ IceConnection this$0;
                                {
                                    this.$mergedChannel = $mergedChannel;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            var2_3 = this.$mergedChannel.iterator();
lbl6:
                                            // 2 sources

                                            while (true) {
                                                this.L$0 = var2_3;
                                                this.label = 1;
                                                v0 = var2_3.hasNext((Continuation)this);
                                                if (v0 == var4_2) {
                                                    return var4_2;
                                                }
                                                ** GOTO lbl17
                                                break;
                                            }
                                        }
                                        case 1: {
                                            var2_3 = (ChannelIterator)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            if (!((Boolean)v0).booleanValue()) break;
                                            packet = (byte[])var2_3.next();
                                            this.this$0.getTelemetry().packetSent(packet.length);
                                            this.L$0 = var2_3;
                                            this.label = 2;
                                            v1 = this.this$0.getAgent().getOutboundDataChannel().send((Object)packet, (Continuation)this);
                                            if (v1 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl30
                                        }
                                        case 2: {
                                            var2_3 = (ChannelIterator)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl30:
                                            // 2 sources

                                            ** continue;
                                        }
                                    }
                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.this$0.getAgent().getOutboundDataChannel()), null, (int)1, null);
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this.connectJob = BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super McConnectionArgs>, Object>(this, logger2, IceManagerImpl.this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ IceConnection this$0;
                final /* synthetic */ Logger $logger;
                final /* synthetic */ IceManagerImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.$logger = $logger;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((long)IceManager.ICE_TIMEOUT, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ IceConnection this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.this$0.getAgent().getReadyForData().await((Continuation)this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            if ((Unit)v0 == null) {
                                throw new PrettyIOException((this.this$0.getClient() != false ? "Server" : "Client") + " is unreachable (ICE failed)", null);
                            }
                            connectionJob = JobKt.Job((Job)((Job)this.this$0.getJob()));
                            connectionScope = CoroutineScopeKt.plus((CoroutineScope)this.this$0.getCoroutineScope(), (CoroutineContext)((CoroutineContext)connectionJob));
                            this.L$0 = connectionJob;
                            this.L$1 = connectionScope;
                            this.label = 2;
                            v1 = IceConnection.access$getFlags$p(this.this$0).await((Continuation)this);
                            if (v1 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            connectionScope = (CoroutineScope)this.L$1;
                            connectionJob = (CompletableJob)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            if (!((Flags)v1).isQuic()) break;
                            quicChannel = new QuicChannel(connectionScope, this.$logger, (ReceiveChannel<byte[]>)((ReceiveChannel)IceConnection.access$getInboundDataChannel$p(this.this$0)), (SendChannel<? super byte[]>)((SendChannel)IceConnection.access$getOutboundDataChannel$p(this.this$0)));
                            if (!this.this$0.getClient()) break;
                            this.L$0 = connectionJob;
                            this.L$1 = null;
                            this.label = 3;
                            v2 = quicChannel.connect((Continuation<? super Pair<? extends Pair<? extends ReceiveChannel<byte[]>, ? extends SendChannel<? super byte[]>>, Integer>>)((Continuation)this));
                            if (v2 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl44
                        }
                        case 3: {
                            connectionJob = (CompletableJob)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl44:
                            // 2 sources

                            var6_6 = (Pair)v2;
                            streams = (Pair)var6_6.component1();
                            httpPort = ((Number)var6_6.component2()).intValue();
                            this.this$1.setProxyHttpPort(Boxing.boxInt((int)httpPort));
                            v3 = streams;
                            ** GOTO lbl78
                        }
                    }
                    this.L$0 = connectionJob;
                    this.L$1 = null;
                    this.label = 4;
                    v4 = quicChannel.accept(this.this$1.getResourcePackHttpServerPort(), (Continuation<? super Pair<? extends ReceiveChannel<byte[]>, ? extends SendChannel<? super byte[]>>>)((Continuation)this));
                    if (v4 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl61
                    {
                        case 4: {
                            connectionJob = (CompletableJob)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl61:
                            // 2 sources

                            v3 = (Pair)v4;
                            ** GOTO lbl78
                        }
                    }
                    this.this$1.setProxyHttpPort(null);
                    pseudoTcpChannel = new PseudoTcpChannel(connectionScope, (ReceiveChannel<byte[]>)((ReceiveChannel)IceConnection.access$getInboundDataChannel$p(this.this$0)), (SendChannel<? super byte[]>)((SendChannel)IceConnection.access$getOutboundDataChannel$p(this.this$0)));
                    this.L$0 = connectionJob;
                    this.L$1 = null;
                    this.label = 5;
                    v5 = TimeoutKt.withTimeoutOrNull((long)IceManager.TCP_TIMEOUT, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends ReceiveChannel<? extends byte[]>, ? extends SendChannel<? super byte[]>>>, Object>(this.this$0, pseudoTcpChannel, null){
                        int label;
                        final /* synthetic */ IceConnection this$0;
                        final /* synthetic */ PseudoTcpChannel $pseudoTcpChannel;
                        {
                            this.this$0 = $receiver;
                            this.$pseudoTcpChannel = $pseudoTcpChannel;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    if (!this.this$0.getClient()) break;
                                    this.label = 1;
                                    v0 = this.$pseudoTcpChannel.connect((Continuation<? super Pair<? extends ReceiveChannel<byte[]>, ? extends SendChannel<? super byte[]>>>)((Continuation)this));
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl14
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl14:
                                    // 2 sources

                                    v1 = (Pair)v0;
                                    ** GOTO lbl25
                                }
                            }
                            this.label = 2;
                            v2 = this.$pseudoTcpChannel.accept((Continuation<? super Pair<? extends ReceiveChannel<byte[]>, ? extends SendChannel<? super byte[]>>>)((Continuation)this));
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl24
                            {
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl24:
                                    // 2 sources

                                    v1 = (Pair)v2;
lbl25:
                                    // 2 sources

                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends ReceiveChannel<byte[]>, ? extends SendChannel<? super byte[]>>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    if (v5 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl76
                    {
                        case 5: {
                            connectionJob = (CompletableJob)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl76:
                            // 2 sources

                            if ((v3 = (Pair)v5) == null) {
                                throw new PrettyIOException(this.this$0.getClient() != false ? "Connect timed out" : "Accept timed out", null);
                            }
lbl78:
                            // 4 sources

                            var4_9 = v3;
                            recvChannel = (ReceiveChannel)var4_9.component1();
                            sendChannel = (SendChannel)var4_9.component2();
                            return new McConnectionArgs(this.this$0.getCoroutineScope(), (ReceiveChannel<byte[]>)recvChannel, (SendChannel<? super byte[]>)sendChannel, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, connectionJob, this.$logger){
                                final /* synthetic */ IceConnection this$0;
                                final /* synthetic */ CompletableJob $connectionJob;
                                final /* synthetic */ Logger $logger;
                                {
                                    this.this$0 = $receiver;
                                    this.$connectionJob = $connectionJob;
                                    this.$logger = $logger;
                                    super(0);
                                }

                                public final void invoke() {
                                    BuildersKt.launch$default((CoroutineScope)this.this$0.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$connectionJob, this.$logger, this.this$0, null){
                                        int label;
                                        final /* synthetic */ CompletableJob $connectionJob;
                                        final /* synthetic */ Logger $logger;
                                        final /* synthetic */ IceConnection this$0;
                                        {
                                            this.$connectionJob = $connectionJob;
                                            this.$logger = $logger;
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    this.$connectionJob.complete();
                                                    this.label = 1;
                                                    v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$connectionJob, null){
                                                        int label;
                                                        final /* synthetic */ CompletableJob $connectionJob;
                                                        {
                                                            this.$connectionJob = $connectionJob;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * WARNING - void declaration
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object object) {
                                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)object);
                                                                    this.label = 1;
                                                                    Object object3 = this.$connectionJob.join((Continuation)this);
                                                                    if (object3 != object2) return Unit.INSTANCE;
                                                                    return object2;
                                                                }
                                                                case 1: {
                                                                    void $result;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    Object object3 = $result;
                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        @Nullable
                                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (Continuation)((Continuation)this));
                                                    if (v0 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl16
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl16:
                                                    // 2 sources

                                                    v1 = timedOut = v0 == null;
                                                    if (timedOut) {
                                                        this.$logger.warn("Failed to cleanly shut down connection, force closing now.");
                                                    } else {
                                                        this.$logger.debug("Connection shut down cleanly, closing ICE now.");
                                                    }
                                                    Job.DefaultImpls.cancel$default((Job)((Job)this.this$0.getJob()), null, (int)1, null);
                                                    this.this$0.getTelemetry().closed();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            }));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super McConnectionArgs> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            this.voiceProxyJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logger2, null){
                Object L$0;
                int label;
                final /* synthetic */ IceConnection this$0;
                final /* synthetic */ Logger $logger;
                {
                    this.this$0 = $receiver;
                    this.$logger = $logger;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = IceConnection.access$getFlags$p(this.this$0).await((Continuation)this);
                            if (v0 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = ((Flags)v0).getVoicePort();
                            if (v1 == null) {
                                return Unit.INSTANCE;
                            }
                            voicePort = v1;
                            var3_4 = new DatagramSocket(null);
                            var4_5 = this.this$0;
                            var5_6 = this.$logger;
                            var6_7 = null;
                            proxySocket = (DatagramSocket)var3_4;
                            $i$a$-use-IceManagerImpl$IceConnection$voiceProxyJob$1$1 = false;
                            proxyPort = var4_5.getClient() != false ? voicePort : 0;
                            downstreamAddress = new AtomicReference<SocketAddress>(var4_5.getClient() != false ? null : new InetSocketAddress(InetAddress.getLoopbackAddress(), voicePort));
                            try {
                                proxySocket.bind(new InetSocketAddress(null, proxyPort));
                            }
                            catch (SocketException e) {
                                var5_6.error("Failed to allocate port for voice chat forwarding:", (Throwable)e);
                                var12_16 = Unit.INSTANCE;
                                CloseableKt.closeFinally((Closeable)var3_4, (Throwable)var6_7);
                                return var12_16;
                            }
                            this.L$0 = var3_4;
                            this.label = 2;
                            v2 = SupervisorKt.supervisorScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(proxySocket, var4_5, downstreamAddress, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ DatagramSocket $proxySocket;
                                final /* synthetic */ IceConnection this$0;
                                final /* synthetic */ AtomicReference<SocketAddress> $downstreamAddress;
                                {
                                    this.$proxySocket = $proxySocket;
                                    this.this$0 = $receiver;
                                    this.$downstreamAddress = $downstreamAddress;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            CoroutineScope $this$supervisorScope = (CoroutineScope)this.L$0;
                                            Job outboundJob2 = BuildersKt.launch$default((CoroutineScope)$this$supervisorScope, (CoroutineContext)((CoroutineContext)new CoroutineName("Voice Proxy Outbound")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$proxySocket, this.this$0, this.$downstreamAddress, null){
                                                Object L$1;
                                                Object L$2;
                                                int label;
                                                private /* synthetic */ Object L$0;
                                                final /* synthetic */ DatagramSocket $proxySocket;
                                                final /* synthetic */ IceConnection this$0;
                                                final /* synthetic */ AtomicReference<SocketAddress> $downstreamAddress;
                                                {
                                                    this.$proxySocket = $proxySocket;
                                                    this.this$0 = $receiver;
                                                    this.$downstreamAddress = $downstreamAddress;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                                 * Unable to fully structure code
                                                 * Enabled aggressive block sorting
                                                 * Enabled unnecessary exception pruning
                                                 * Enabled aggressive exception aggregation
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            buf = new byte[65535];
                                                            buf[0] = IceManager.VOICE_HEADER_BYTE;
                                                            packet = new DatagramPacket(buf, 1, buf.length - 1);
                                                            try {
                                                            }
                                                            catch (IOException e) {
                                                                if (JobKt.isActive((CoroutineContext)$this$launch.getCoroutineContext()) == false) return Unit.INSTANCE;
                                                                throw e;
                                                            }
lbl18:
                                                            // 3 sources

                                                            while (JobKt.isActive((CoroutineContext)$this$launch.getCoroutineContext())) {
                                                                this.$proxySocket.receive(packet);
                                                                if (this.this$0.getClient()) {
                                                                    this.$downstreamAddress.set(packet.getSocketAddress());
                                                                }
                                                                this.L$0 = $this$launch;
                                                                this.L$1 = buf;
                                                                this.L$2 = packet;
                                                                this.label = 1;
                                                                v0 = IceConnection.access$getOutboundVoiceChannel$p(this.this$0).send((Object)ArraysKt.sliceArray((byte[])buf, (IntRange)RangesKt.until((int)0, (int)(1 + packet.getLength()))), (Continuation)this);
                                                                if (v0 != var6_2) continue;
                                                                return var6_2;
                                                            }
                                                            break;
                                                        }
                                                        case 1: {
                                                            packet = (DatagramPacket)this.L$2;
                                                            buf = (byte[])this.L$1;
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
                                                                ** GOTO lbl18
                                                            }
                                                        }
                                                    }
                                                    SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)IceConnection.access$getOutboundVoiceChannel$p(this.this$0)), null, (int)1, null);
                                                    return Unit.INSTANCE;
                                                    finally {
                                                        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)IceConnection.access$getOutboundVoiceChannel$p(this.this$0)), null, (int)1, null);
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                    function2.L$0 = value;
                                                    return (Continuation)function2;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                            BuildersKt.launch$default((CoroutineScope)$this$supervisorScope, (CoroutineContext)((CoroutineContext)new CoroutineName("Voice Proxy Inbound")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$proxySocket, this.$downstreamAddress, outboundJob2, null){
                                                Object L$0;
                                                int label;
                                                final /* synthetic */ IceConnection this$0;
                                                final /* synthetic */ DatagramSocket $proxySocket;
                                                final /* synthetic */ AtomicReference<SocketAddress> $downstreamAddress;
                                                final /* synthetic */ Job $outboundJob;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$proxySocket = $proxySocket;
                                                    this.$downstreamAddress = $downstreamAddress;
                                                    this.$outboundJob = $outboundJob;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                                 * Unable to fully structure code
                                                 * Enabled aggressive block sorting
                                                 * Enabled unnecessary exception pruning
                                                 * Enabled aggressive exception aggregation
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            try {
                                                                var2_3 = IceConnection.access$getInboundVoiceChannel$p(this.this$0).iterator();
                                                            }
                                                            catch (Throwable var2_4) {
                                                                Job.DefaultImpls.cancel$default((Job)this.$outboundJob, null, (int)1, null);
                                                                this.$proxySocket.close();
                                                                throw var2_4;
                                                            }
lbl13:
                                                            // 2 sources

                                                            while (true) {
                                                                this.L$0 = var2_3;
                                                                this.label = 1;
                                                                v0 = var2_3.hasNext((Continuation)this);
                                                                if (v0 == var4_2) {
                                                                    return var4_2;
                                                                }
                                                                ** GOTO lbl25
                                                                break;
                                                            }
                                                        }
                                                        case 1: {
                                                            var2_3 = (ChannelIterator)this.L$0;
                                                            {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl25:
                                                                // 2 sources

                                                                if (!((Boolean)v0).booleanValue()) ** GOTO lbl29
                                                                buf = (byte[])var2_3.next();
                                                                this.$proxySocket.send(new DatagramPacket(buf, 1, buf.length - 1, this.$downstreamAddress.get()));
                                                                ** continue;
                                                            }
lbl29:
                                                            // 1 sources

                                                            Job.DefaultImpls.cancel$default((Job)this.$outboundJob, null, (int)1, null);
                                                            this.$proxySocket.close();
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    function2.L$0 = value;
                                    return (Continuation)function2;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            ** if (v2 != var13_2) goto lbl42
lbl41:
                            // 1 sources

                            return var13_2;
lbl42:
                            // 1 sources

                            ** GOTO lbl51
                        }
                        case 2: {
                            $i$a$-use-IceManagerImpl$IceConnection$voiceProxyJob$1$1 = false;
                            var6_7 = null;
                            var3_4 = (Closeable)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl51:
                                // 2 sources

                                var7_8 = Unit.INSTANCE;
                                ** GOTO lbl61
                            }
                            catch (Throwable var7_9) {
                                var6_7 = var7_9;
                                throw var7_9;
                            }
                        }
                        catch (Throwable var7_10) {
                            throw var7_10;
                        }
                        {
                            finally {
                                CloseableKt.closeFinally((Closeable)var3_4, (Throwable)var6_7);
                            }
lbl61:
                            // 1 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        @NotNull
        public final UUID getUser() {
            return this.user;
        }

        public final boolean getClient() {
            return this.client;
        }

        @NotNull
        public final Telemetry getTelemetry() {
            return this.telemetry;
        }

        @NotNull
        public final CompletableJob getJob() {
            return this.job;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }

        @NotNull
        public final Pair<String, byte[]> getLocalCreds() {
            return this.localCreds;
        }

        @NotNull
        public final CompletableDeferred<Pair<String, byte[]>> getRemoteCreds() {
            return this.remoteCreds;
        }

        @NotNull
        public final IceAgent getAgent() {
            return this.agent;
        }

        @NotNull
        public final Job getForwardLocalCandidatesJob() {
            return this.forwardLocalCandidatesJob;
        }

        @NotNull
        public final Job getInboundPacketSortingJob() {
            return this.inboundPacketSortingJob;
        }

        @NotNull
        public final Job getOutboundPacketMergingJob() {
            return this.outboundPacketMergingJob;
        }

        @NotNull
        public final Deferred<McConnectionArgs> getConnectJob() {
            return this.connectJob;
        }

        @NotNull
        public final Job getVoiceProxyJob() {
            return this.voiceProxyJob;
        }

        public static final /* synthetic */ Channel access$getInboundVoiceChannel$p(IceConnection $this) {
            return $this.inboundVoiceChannel;
        }

        public static final /* synthetic */ Channel access$getInboundDataChannel$p(IceConnection $this) {
            return $this.inboundDataChannel;
        }

        public static final /* synthetic */ Channel access$getOutboundVoiceChannel$p(IceConnection $this) {
            return $this.outboundVoiceChannel;
        }

        public static final /* synthetic */ Channel access$getOutboundDataChannel$p(IceConnection $this) {
            return $this.outboundDataChannel;
        }

        public static final /* synthetic */ Deferred access$getFlags$p(IceConnection $this) {
            return $this.flags;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$LoggerSetup;", "", "id", "", "logger", "Lorg/slf4j/Logger;", "file", "Ljava/nio/file/Path;", "fileJob", "Lkotlinx/coroutines/Job;", "fileChannel", "Lkotlinx/coroutines/channels/SendChannel;", "fileLogger", "(ILorg/slf4j/Logger;Ljava/nio/file/Path;Lkotlinx/coroutines/Job;Lkotlinx/coroutines/channels/SendChannel;Lorg/slf4j/Logger;)V", "getFile", "()Ljava/nio/file/Path;", "getFileChannel", "()Lkotlinx/coroutines/channels/SendChannel;", "getFileJob", "()Lkotlinx/coroutines/Job;", "getFileLogger", "()Lorg/slf4j/Logger;", "getId", "()I", "getLogger", "essential-gui-essential"})
    private static final class LoggerSetup {
        private final int id;
        @NotNull
        private final Logger logger;
        @NotNull
        private final Path file;
        @NotNull
        private final Job fileJob;
        @NotNull
        private final SendChannel<?> fileChannel;
        @NotNull
        private final Logger fileLogger;

        public LoggerSetup(int id2, @NotNull Logger logger2, @NotNull Path file, @NotNull Job fileJob2, @NotNull SendChannel<?> fileChannel, @NotNull Logger fileLogger) {
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileJob2, (String)"fileJob");
            Intrinsics.checkNotNullParameter(fileChannel, (String)"fileChannel");
            Intrinsics.checkNotNullParameter((Object)fileLogger, (String)"fileLogger");
            this.id = id2;
            this.logger = logger2;
            this.file = file;
            this.fileJob = fileJob2;
            this.fileChannel = fileChannel;
            this.fileLogger = fileLogger;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        @NotNull
        public final Job getFileJob() {
            return this.fileJob;
        }

        @NotNull
        public final SendChannel<?> getFileChannel() {
            return this.fileChannel;
        }

        @NotNull
        public final Logger getFileLogger() {
            return this.fileLogger;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$McConnectionArgs;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "inboundChannel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "", "outboundChannel", "Lkotlinx/coroutines/channels/SendChannel;", "onClose", "Lkotlin/Function0;", "", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/channels/ReceiveChannel;Lkotlinx/coroutines/channels/SendChannel;Lkotlin/jvm/functions/Function0;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getInboundChannel", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "getOnClose", "()Lkotlin/jvm/functions/Function0;", "getOutboundChannel", "()Lkotlinx/coroutines/channels/SendChannel;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "essential-gui-essential"})
    protected static final class McConnectionArgs {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final ReceiveChannel<byte[]> inboundChannel;
        @NotNull
        private final SendChannel<byte[]> outboundChannel;
        @NotNull
        private final Function0<Unit> onClose;

        public McConnectionArgs(@NotNull CoroutineScope coroutineScope, @NotNull ReceiveChannel<byte[]> inboundChannel, @NotNull SendChannel<? super byte[]> outboundChannel, @NotNull Function0<Unit> onClose2) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(inboundChannel, (String)"inboundChannel");
            Intrinsics.checkNotNullParameter(outboundChannel, (String)"outboundChannel");
            Intrinsics.checkNotNullParameter(onClose2, (String)"onClose");
            this.coroutineScope = coroutineScope;
            this.inboundChannel = inboundChannel;
            this.outboundChannel = outboundChannel;
            this.onClose = onClose2;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }

        @NotNull
        public final ReceiveChannel<byte[]> getInboundChannel() {
            return this.inboundChannel;
        }

        @NotNull
        public final SendChannel<byte[]> getOutboundChannel() {
            return this.outboundChannel;
        }

        @NotNull
        public final Function0<Unit> getOnClose() {
            return this.onClose;
        }

        @NotNull
        public final CoroutineScope component1() {
            return this.coroutineScope;
        }

        @NotNull
        public final ReceiveChannel<byte[]> component2() {
            return this.inboundChannel;
        }

        @NotNull
        public final SendChannel<byte[]> component3() {
            return this.outboundChannel;
        }

        @NotNull
        public final Function0<Unit> component4() {
            return this.onClose;
        }

        @NotNull
        public final McConnectionArgs copy(@NotNull CoroutineScope coroutineScope, @NotNull ReceiveChannel<byte[]> inboundChannel, @NotNull SendChannel<? super byte[]> outboundChannel, @NotNull Function0<Unit> onClose2) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(inboundChannel, (String)"inboundChannel");
            Intrinsics.checkNotNullParameter(outboundChannel, (String)"outboundChannel");
            Intrinsics.checkNotNullParameter(onClose2, (String)"onClose");
            return new McConnectionArgs(coroutineScope, inboundChannel, outboundChannel, onClose2);
        }

        public static /* synthetic */ McConnectionArgs copy$default(McConnectionArgs mcConnectionArgs, CoroutineScope coroutineScope, ReceiveChannel receiveChannel, SendChannel sendChannel, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                coroutineScope = mcConnectionArgs.coroutineScope;
            }
            if ((n & 2) != 0) {
                receiveChannel = mcConnectionArgs.inboundChannel;
            }
            if ((n & 4) != 0) {
                sendChannel = mcConnectionArgs.outboundChannel;
            }
            if ((n & 8) != 0) {
                function0 = mcConnectionArgs.onClose;
            }
            return mcConnectionArgs.copy(coroutineScope, receiveChannel, sendChannel, function0);
        }

        @NotNull
        public String toString() {
            return "McConnectionArgs(coroutineScope=" + this.coroutineScope + ", inboundChannel=" + this.inboundChannel + ", outboundChannel=" + this.outboundChannel + ", onClose=" + this.onClose + ')';
        }

        public int hashCode() {
            int result = this.coroutineScope.hashCode();
            result = result * 31 + this.inboundChannel.hashCode();
            result = result * 31 + this.outboundChannel.hashCode();
            result = result * 31 + this.onClose.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McConnectionArgs)) {
                return false;
            }
            McConnectionArgs mcConnectionArgs = (McConnectionArgs)other;
            if (!Intrinsics.areEqual((Object)this.coroutineScope, (Object)mcConnectionArgs.coroutineScope)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.inboundChannel, mcConnectionArgs.inboundChannel)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.outboundChannel, mcConnectionArgs.outboundChannel)) {
                return false;
            }
            return Intrinsics.areEqual(this.onClose, mcConnectionArgs.onClose);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0014\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$PrettyIOException;", "Ljava/io/IOException;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "toString", "essential-gui-essential"})
    protected static class PrettyIOException
    extends IOException {
        public PrettyIOException(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.getMessage();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$PrettyPrintingLogger;", "Lgg/essential/slf4j/DelegatingLogger;", "delegate", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "log", "", "event", "Lorg/slf4j/event/LoggingEvent;", "makeLoggingEventBuilder", "Lorg/slf4j/spi/LoggingEventBuilder;", "level", "Lorg/slf4j/event/Level;", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nIceManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$PrettyPrintingLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,740:1\n1253#2,4:741\n1855#2,2:746\n1#3:745\n*S KotlinDebug\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$PrettyPrintingLogger\n*L\n654#1:741,4\n683#1:746,2\n*E\n"})
    private static final class PrettyPrintingLogger
    extends DelegatingLogger {
        public PrettyPrintingLogger(@NotNull Logger delegate2) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            super(delegate2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(@NotNull LoggingEvent event) {
            List list;
            LoggingEventBuilder loggingEventBuilder;
            Iterator iterator2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            StringBuilder result = new StringBuilder();
            List keyValuePairs = event.getKeyValuePairs();
            if (keyValuePairs != null && !((Collection)keyValuePairs).isEmpty()) {
                Object[] destination$iv;
                void $this$associateTo$iv;
                Iterable iterable = keyValuePairs;
                Map map2 = new LinkedHashMap();
                boolean $i$f$associateTo = false;
                for (Object element$iv : $this$associateTo$iv) {
                    iterator2 = destination$iv;
                    KeyValuePair it = (KeyValuePair)element$iv;
                    boolean bl = false;
                    it = TuplesKt.to((Object)it.key, (Object)it.value);
                    iterator2.put(it.getFirst(), it.getSecond());
                }
                void keyValueMap = destination$iv;
                Object v = keyValueMap.remove("iceConnectionId");
                if (v != null) {
                    Object it = v;
                    boolean bl = false;
                    result.append("" + '[' + it + "] ");
                }
                destination$iv = new Object[]{keyValueMap.remove("hostAddress"), keyValueMap.remove("turnServer"), keyValueMap.remove("relayAddress"), keyValueMap.remove("remoteAddress")};
                Set parties = SetsKt.setOfNotNull((Object[])destination$iv);
                if (!((Collection)parties).isEmpty()) {
                    CollectionsKt.joinTo$default((Iterable)parties, (Appendable)result, (CharSequence)" <> ", (CharSequence)"[", (CharSequence)"] ", (int)0, null, (Function1)log.2.INSTANCE, (int)48, null);
                }
                Object v2 = keyValueMap.remove("tId");
                if (v2 != null) {
                    Object it = v2;
                    boolean bl = false;
                    result.append("" + '[' + it + "] ");
                }
                if (!keyValueMap.isEmpty()) {
                    CollectionsKt.joinTo$default((Iterable)keyValueMap.entrySet(), (Appendable)result, (CharSequence)"", null, null, (int)0, null, (Function1)log.4.INSTANCE, (int)60, null);
                }
            }
            result.append(event.getMessage());
            LoggingEventBuilder $this$log_u24lambda_u244 = loggingEventBuilder = this.getDelegate().atLevel(event.getLevel());
            boolean bl = false;
            $this$log_u24lambda_u244.setMessage(result.toString());
            List list2 = list = event.getArguments();
            if (list2 != null) {
                Intrinsics.checkNotNull((Object)list2);
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    $this$log_u24lambda_u244.addArgument(it);
                }
            }
            $this$log_u24lambda_u244.setCause(event.getThrowable());
            loggingEventBuilder.log();
        }

        @Override
        @NotNull
        public LoggingEventBuilder makeLoggingEventBuilder(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return (LoggingEventBuilder)new DefaultLoggingEventBuilder((Logger)this, level);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$SharedCandidateManager;", "", "(Lgg/essential/network/connectionmanager/ice/IceManagerImpl;)V", "candidateManager", "Lgg/essential/ice/CandidateManager;", "getCandidateManager", "()Lgg/essential/ice/CandidateManager;", "children", "Lkotlinx/coroutines/channels/Channel;", "Lkotlinx/coroutines/Job;", "getChildren", "()Lkotlinx/coroutines/channels/Channel;", "job", "Lkotlinx/coroutines/CompletableJob;", "getJob", "()Lkotlinx/coroutines/CompletableJob;", "logging", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$LoggerSetup;", "getLogging", "()Lgg/essential/network/connectionmanager/ice/IceManagerImpl$LoggerSetup;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nIceManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$SharedCandidateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,740:1\n1549#2:741\n1620#2,3:742\n1549#2:745\n1620#2,3:746\n*S KotlinDebug\n*F\n+ 1 IceManagerImpl.kt\ngg/essential/network/connectionmanager/ice/IceManagerImpl$SharedCandidateManager\n*L\n308#1:741\n308#1:742,3\n309#1:745\n309#1:746,3\n*E\n"})
    private final class SharedCandidateManager {
        @NotNull
        private final CompletableJob job;
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final LoggerSetup logging;
        @NotNull
        private final CandidateManager candidateManager;
        @NotNull
        private final Channel<Job> children;

        public SharedCandidateManager() {
            Collection<InetSocketAddress> collection;
            String it;
            Collection<InetSocketAddress> collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            this.job = JobKt.Job((Job)JobKt.getJob((CoroutineContext)IceManagerImpl.this.getConnectionsScope().getCoroutineContext()));
            this.scope = CoroutineScopeKt.plus((CoroutineScope)IceManagerImpl.this.getConnectionsScope(), (CoroutineContext)((CoroutineContext)this.job));
            this.logging = IceManagerImpl.this.setupLogging(IceManagerImpl.this.getConnectionsScope());
            BuildersKt.launch$default((CoroutineScope)IceManagerImpl.this.getConnectionsScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ SharedCandidateManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = this.this$0.getJob().join((Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.this$0.getLogging().getLogger().debug("CandidateManager closing");
                            SendChannel.DefaultImpls.close$default(this.this$0.getLogging().getFileChannel(), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            Iterable iterable = IceManager.STUN_HOSTS;
            StunManager stunManager = IceManagerImpl.this.stunManager;
            CoroutineScope coroutineScope = this.scope;
            Logger logger2 = this.logging.getLogger();
            SharedCandidateManager sharedCandidateManager = this;
            boolean $i$f$map = false;
            void var4_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new InetSocketAddress(InetAddress.getByName(it), 3478));
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = IceManager.TURN_HOSTS;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new InetSocketAddress(InetAddress.getByName(it), 3478));
            }
            Collection<InetSocketAddress> collection3 = collection = (List)destination$iv$iv;
            Collection<InetSocketAddress> collection4 = collection2;
            StunManager stunManager2 = stunManager;
            CoroutineScope coroutineScope2 = coroutineScope;
            Logger logger3 = logger2;
            sharedCandidateManager.candidateManager = new CandidateManager(logger3, coroutineScope2, stunManager2, (List<? extends InetSocketAddress>)collection4, (List<? extends InetSocketAddress>)collection3);
            this.children = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ SharedCandidateManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = this.this$0.getChildren().send((Object)JobKt.getJob((CoroutineContext)$this$launch.getCoroutineContext()), (Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            candidates = new ArrayList<E>();
                            var4_5 = this.this$0.getCandidateManager().getCandidates(JobKt.getJob((CoroutineContext)$this$launch.getCoroutineContext())).iterator();
lbl18:
                            // 2 sources

                            while (true) {
                                this.L$0 = candidates;
                                this.L$1 = var4_5;
                                this.label = 2;
                                v1 = var4_5.hasNext((Continuation)this);
                                if (v1 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl31
                                break;
                            }
                        }
                        case 2: {
                            var4_5 = (ChannelIterator)this.L$1;
                            candidates = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl31:
                            // 2 sources

                            if (((Boolean)v1).booleanValue()) {
                                candidate = (LocalCandidate)var4_5.next();
                                candidates.add(candidate);
                                ** continue;
                            }
                            this.L$0 = candidates;
                            this.L$1 = null;
                            this.label = 3;
                            v2 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl47
                        }
                        case 3: {
                            candidates = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl47:
                            // 3 sources

                            for (LocalCandidate candidate : candidates) {
                                candidate.close();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ SharedCandidateManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.this$0.getChildren().iterator();
lbl6:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl17
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) break;
                            child = (Job)var2_3.next();
                            this.L$0 = var2_3;
                            this.label = 2;
                            v1 = child.join((Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            var2_3 = (ChannelIterator)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            ** continue;
                        }
                    }
                    Job.DefaultImpls.cancel$default((Job)((Job)this.this$0.getJob()), null, (int)1, null);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public final CompletableJob getJob() {
            return this.job;
        }

        @NotNull
        public final CoroutineScope getScope() {
            return this.scope;
        }

        @NotNull
        public final LoggerSetup getLogging() {
            return this.logging;
        }

        @NotNull
        public final CandidateManager getCandidateManager() {
            return this.candidateManager;
        }

        @NotNull
        public final Channel<Job> getChildren() {
            return this.children;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u000bJ\b\u0010\u0002\u001a\u00020\u0003H&J \u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;", "", "closed", "", "packetReceived", "bytes", "", "ipv6", "", "relay", "packetSent", "None", "essential-gui-essential"})
    public static interface Telemetry {
        public void packetReceived(int var1, boolean var2, boolean var3);

        public void packetSent(int var1);

        public void closed();

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry$None;", "Lgg/essential/network/connectionmanager/ice/IceManagerImpl$Telemetry;", "()V", "closed", "", "packetReceived", "bytes", "", "ipv6", "", "relay", "packetSent", "essential-gui-essential"})
        public static final class None
        implements Telemetry {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }

            @Override
            public void packetReceived(int bytes, boolean ipv6, boolean relay) {
            }

            @Override
            public void packetSent(int bytes) {
            }

            @Override
            public void closed() {
            }
        }
    }
}

