/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic;

import gg.essential.quic.LogOnce;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;

public class LogOnceHandler
extends ChannelDuplexHandler {
    private final LogOnce logOnce;
    private final String name;
    private final String readKey;
    private final String writeKey;

    public LogOnceHandler(LogOnce logOnce, String name2) {
        this.logOnce = logOnce;
        this.name = name2 != null ? name2 : ((Object)((Object)this)).getClass().getSimpleName();
        this.readKey = this.name + ".channelRead";
        this.writeKey = this.name + ".write";
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logOnce.log(this.readKey, () -> ctx.channel() + " " + msg);
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logOnce.log(this.writeKey, () -> ctx.channel() + " " + msg);
        super.write(ctx, msg, promise);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logOnce.log(this.name + ".channelInactive", ctx.channel());
        super.channelInactive(ctx);
    }
}

