/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic.backend;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Locale;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SelfSignedCert {
    private static final Date DEFAULT_NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date DEFAULT_NOT_AFTER = new Date(253402300799000L);
    private final X509Certificate certificate;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public SelfSignedCert() throws Exception {
        KeyPair keypair;
        SecureRandom random = new SecureRandom();
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        X500Name owner = new X500Name("CN=localhost");
        BigInteger serial = new BigInteger(64, random);
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(owner, serial, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, Locale.ROOT, owner, SubjectPublicKeyInfo.getInstance((Object)keypair.getPublic().getEncoded()));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keypair.getPrivate());
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certHolder);
        certificate.verify(keypair.getPublic());
        this.certificate = certificate;
        this.publicKey = keypair.getPublic();
        this.privateKey = keypair.getPrivate();
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public PublicKey publicKey() {
        return this.publicKey;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }
}

