/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/util/LimitedExecutor;", "Ljava/util/concurrent/Executor;", "Ljava/lang/Runnable;", "delegate", "parallelism", "", "workQueue", "Ljava/util/Queue;", "(Ljava/util/concurrent/Executor;ILjava/util/Queue;)V", "activeWorkers", "lock", "Ljava/lang/Object;", "execute", "", "work", "run", "utils"})
public final class LimitedExecutor
implements Executor,
Runnable {
    @NotNull
    private final Executor delegate;
    private final int parallelism;
    @NotNull
    private final Queue<Runnable> workQueue;
    @NotNull
    private final Object lock;
    private int activeWorkers;

    public LimitedExecutor(@NotNull Executor delegate2, int parallelism, @NotNull Queue<Runnable> workQueue) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        Intrinsics.checkNotNullParameter(workQueue, (String)"workQueue");
        this.delegate = delegate2;
        this.parallelism = parallelism;
        this.workQueue = workQueue;
        this.lock = new Object();
    }

    public /* synthetic */ LimitedExecutor(Executor executor, int n, Queue queue, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        this(executor, n, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable work) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        this.workQueue.offer(work);
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.activeWorkers < this.parallelism) {
                int n = this.activeWorkers;
                this.activeWorkers = n + 1;
                this.delegate.execute(this);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        Object object;
        try {
            while (this.workQueue.poll() != null) {
                Runnable work;
                work.run();
            }
            object = this.lock;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Object object2 = this.lock;
            synchronized (object2) {
                boolean bl3;
                boolean bl4 = false;
                if (!this.workQueue.isEmpty()) {
                    bl3 = true;
                } else {
                    int n = this.activeWorkers;
                    this.activeWorkers = n + -1;
                    bl3 = false;
                }
                bl2 = bl3;
            }
            boolean moreWork = bl2;
            if (moreWork) {
                this.delegate.execute(this);
            }
            throw throwable;
        }
        synchronized (object) {
            boolean bl5;
            boolean bl6 = false;
            if (!this.workQueue.isEmpty()) {
                bl5 = true;
            } else {
                int n = this.activeWorkers;
                this.activeWorkers = n + -1;
                bl5 = false;
            }
            bl = bl5;
        }
        boolean moreWork = bl;
        if (moreWork) {
            this.delegate.execute(this);
        }
    }
}

