/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.config.EssentialConfig;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\f\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u0001*\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\u0007\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"DATE_FORMAT", "", "DATE_FORMAT_NO_YEAR", "daysTimeMap", "Ljava/util/TreeMap;", "", "kotlin.jvm.PlatformType", "weeksTimeMap", "formatDate", "date", "Ljava/time/LocalDate;", "displayYear", "", "formatDateAndTime", "Ljava/time/temporal/TemporalAccessor;", "formatTime", "time", "includeSeconds", "getTimeFormat", "formatter", "pattern", "toCosmeticOptionTime", "Ljava/time/Instant;", "toShortString", "Ljava/time/Duration;", "weeks", "expiredText", "essential-gui-essential"})
public final class TimeFormatKt {
    @NotNull
    public static final String DATE_FORMAT = "MMM dd, yyyy";
    @NotNull
    public static final String DATE_FORMAT_NO_YEAR = "MMM dd";
    @NotNull
    private static final TreeMap<Long, String> weeksTimeMap;
    @NotNull
    private static final TreeMap<Long, String> daysTimeMap;

    @NotNull
    public static final String getTimeFormat(boolean includeSeconds) {
        String seconds = includeSeconds ? ":ss" : "";
        return EssentialConfig.INSTANCE.getTimeFormat() == 0 ? "h:mm" + seconds + " a" : "HH:mm" + seconds;
    }

    @NotNull
    public static final String formatDate(@NotNull LocalDate date, boolean displayYear) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return TimeFormatKt.formatter(date, displayYear ? DATE_FORMAT : DATE_FORMAT_NO_YEAR);
    }

    public static /* synthetic */ String formatDate$default(LocalDate localDate, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TimeFormatKt.formatDate(localDate, bl);
    }

    @NotNull
    public static final String formatTime(@NotNull TemporalAccessor time, boolean includeSeconds) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return TimeFormatKt.formatter(time, TimeFormatKt.getTimeFormat(includeSeconds));
    }

    @NotNull
    public static final String formatDateAndTime(@NotNull TemporalAccessor date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return TimeFormatKt.formatter(date, "MMM dd, yyyy @ " + TimeFormatKt.getTimeFormat(false));
    }

    @NotNull
    public static final String formatter(@NotNull TemporalAccessor $this$formatter, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$formatter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        DateTimeFormatter format = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH).withZone(ZoneId.systemDefault());
        String string = format.format($this$formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String toCosmeticOptionTime(@NotNull Instant $this$toCosmeticOptionTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toCosmeticOptionTime, (String)"<this>");
        Duration duration = Duration.between(Instant.now(), $this$toCosmeticOptionTime);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return TimeFormatKt.toShortString$default(duration, false, null, 3, null);
    }

    @NotNull
    public static final String toShortString(@NotNull Duration $this$toShortString, boolean weeks, @NotNull String expiredText) {
        Intrinsics.checkNotNullParameter((Object)$this$toShortString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expiredText, (String)"expiredText");
        long delta = $this$toShortString.toMillis();
        TreeMap<Long, String> timeMap = weeks ? weeksTimeMap : daysTimeMap;
        Map.Entry<Long, String> entry = timeMap.floorEntry(delta);
        if (entry == null) {
            return expiredText;
        }
        Map.Entry<Long, String> ceilEntry = entry;
        Map.Entry<Long, String> floorEntry = timeMap.floorEntry(((Number)ceilEntry.getKey()).longValue() - 1L);
        if (ceilEntry == floorEntry || floorEntry == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Long l = ceilEntry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"<get-key>(...)");
            return stringBuilder.append(delta / ((Number)l).longValue()).append(ceilEntry.getValue()).toString();
        }
        Long l = ceilEntry.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"<get-key>(...)");
        long ceilUnits = delta / ((Number)l).longValue();
        Long l2 = ceilEntry.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"<get-key>(...)");
        long l3 = delta - ceilUnits * ((Number)l2).longValue();
        Long l4 = floorEntry.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"<get-key>(...)");
        long floorUnits = l3 / ((Number)l4).longValue();
        return ceilUnits + ceilEntry.getValue() + ' ' + floorUnits + floorEntry.getValue();
    }

    public static /* synthetic */ String toShortString$default(Duration duration, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            string = "Expired";
        }
        return TimeFormatKt.toShortString(duration, bl, string);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TimeUnit.DAYS.toMillis(7L), (Object)"w"), TuplesKt.to((Object)TimeUnit.DAYS.toMillis(1L), (Object)"d"), TuplesKt.to((Object)TimeUnit.HOURS.toMillis(1L), (Object)"h"), TuplesKt.to((Object)TimeUnit.MINUTES.toMillis(1L), (Object)"m"), TuplesKt.to((Object)TimeUnit.SECONDS.toMillis(1L), (Object)"s")};
        weeksTimeMap = new TreeMap(MapsKt.mutableMapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)TimeUnit.DAYS.toMillis(1L), (Object)"d"), TuplesKt.to((Object)TimeUnit.HOURS.toMillis(1L), (Object)"h"), TuplesKt.to((Object)TimeUnit.MINUTES.toMillis(1L), (Object)"m"), TuplesKt.to((Object)TimeUnit.SECONDS.toMillis(1L), (Object)"s")};
        daysTimeMap = new TreeMap(MapsKt.mutableMapOf((Pair[])pairArray));
    }
}

