/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ChiseledBookshelfProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final MapCodec<class_1799> BOOK_CODEC;

    private static class_1799 getHitBook(BlockAccessor accessor) {
        if (accessor.showDetails()) {
            return class_1799.field_8037;
        }
        Optional<class_1799> result = accessor.readData(BOOK_CODEC);
        return result.orElse(class_1799.field_8037);
    }

    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        class_1799 item = ChiseledBookshelfProvider.getHitBook(accessor);
        return item.method_7960() ? null : IElementHelper.get().item(item);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_1799 item = ChiseledBookshelfProvider.getHitBook(accessor);
        if (item.method_7960()) {
            return;
        }
        tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
        tooltip.add((class_2561)IDisplayHelper.get().stripColor(item.method_7964()));
        if (item.method_57826(class_9334.field_49643)) {
            ArrayList list = Lists.newArrayList();
            ((class_9304)item.method_57825(class_9334.field_49643, (Object)class_9304.field_49385)).method_57409(class_1792.class_9635.method_59528((class_1937)accessor.getLevel()), list::add, (class_1836)class_1836.field_41070);
            tooltip.addAll(list);
        }
    }

    @Override
    public void appendServerData(class_2487 data, BlockAccessor accessor) {
        class_2586 class_25862 = accessor.getBlockEntity();
        if (class_25862 instanceof class_7716) {
            class_7716 bookshelf = (class_7716)class_25862;
            int slot = ((class_7714)accessor.getBlock()).method_47580((class_3965)accessor.getHitResult(), accessor.getBlockState()).orElse(-1);
            if (slot == -1) {
                return;
            }
            class_1799 book = bookshelf.method_5438(slot);
            if (!book.method_7960()) {
                accessor.writeData(BOOK_CODEC, book);
            }
        }
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_CHISELED_BOOKSHELF;
    }

    @Override
    public int getDefaultPriority() {
        return ItemStorageProvider.getBlock().getDefaultPriority() + 1;
    }

    static {
        BOOK_CODEC = class_1799.field_24671.fieldOf("book");
    }
}

