/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    public static final Codec<WailaConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)ConfigGeneral.CODEC.fieldOf("general").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigGeneral.CODEC)).forGetter(WailaConfig::getGeneral), (App)ConfigOverlay.CODEC.fieldOf("overlay").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigOverlay.CODEC)).forGetter(WailaConfig::getOverlay), (App)ConfigFormatting.CODEC.fieldOf("formatting").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigFormatting.CODEC)).forGetter(WailaConfig::getFormatting), (App)ConfigHistory.CODEC.fieldOf("history").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigHistory.CODEC)).forGetter(WailaConfig::getHistory)).apply((Applicative)i, WailaConfig::new));
    private final ConfigGeneral general;
    private final ConfigOverlay overlay;
    private final ConfigFormatting formatting;
    private final ConfigHistory history;

    public WailaConfig(ConfigGeneral general, ConfigOverlay overlay, ConfigFormatting formatting, ConfigHistory history) {
        this.general = general;
        this.overlay = overlay;
        this.formatting = formatting;
        this.history = history;
    }

    @Override
    public ConfigGeneral getGeneral() {
        return this.general;
    }

    @Override
    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    public ConfigHistory getHistory() {
        return this.history;
    }

    @Override
    public IPluginConfig getPlugin() {
        return PluginConfig.INSTANCE;
    }

    public static class ConfigGeneral
    implements IWailaConfig.IConfigGeneral {
        public static final Codec<ConfigGeneral> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("previewOverlay").orElse((Object)true).forGetter($ -> $.previewOverlay), (App)Codec.BOOL.fieldOf("displayTooltip").orElse((Object)true).forGetter(ConfigGeneral::shouldDisplayTooltip), (App)Codec.BOOL.fieldOf("displayBlocks").orElse((Object)true).forGetter(ConfigGeneral::getDisplayBlocks), (App)Codec.BOOL.fieldOf("displayEntities").orElse((Object)true).forGetter(ConfigGeneral::getDisplayEntities), (App)Codec.BOOL.fieldOf("displayBosses").orElse((Object)true).forGetter(ConfigGeneral::getDisplayBosses), (App)class_3542.method_28140(IWailaConfig.DisplayMode::values).fieldOf("displayMode").orElse((Object)IWailaConfig.DisplayMode.TOGGLE).forGetter(ConfigGeneral::getDisplayMode), (App)Codec.BOOL.fieldOf("enableTextToSpeech").orElse((Object)false).forGetter(ConfigGeneral::shouldEnableTextToSpeech), (App)class_3542.method_28140(IWailaConfig.TTSMode::values).fieldOf("ttsMode").orElse((Object)IWailaConfig.TTSMode.PRESS).forGetter(ConfigGeneral::getTTSMode), (App)class_3542.method_28140(IWailaConfig.FluidMode::values).fieldOf("fluidMode").orElse((Object)IWailaConfig.FluidMode.ANY).forGetter(ConfigGeneral::getDisplayFluids), (App)Codec.floatRange((float)0.0f, (float)20.0f).fieldOf("extendedReach").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigGeneral::getExtendedReach), (App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(ConfigGeneral::isDebug), (App)Codec.BOOL.fieldOf("itemModNameTooltip").orElse((Object)true).forGetter(ConfigGeneral::showItemModNameTooltip), (App)class_3542.method_28140(IWailaConfig.BossBarOverlapMode::values).fieldOf("bossBarOverlapMode").orElse((Object)IWailaConfig.BossBarOverlapMode.PUSH_DOWN).forGetter(ConfigGeneral::getBossBarOverlapMode), (App)Codec.BOOL.fieldOf("builtinCamouflage").orElse((Object)true).forGetter(ConfigGeneral::getBuiltinCamouflage), (App)ExtraOptions.CODEC.orElseGet(() -> (ExtraOptions)JadeCodecs.createFromEmptyMap(ExtraOptions.CODEC.codec())).forGetter($ -> $.extraOptions)).apply((Applicative)i, ConfigGeneral::new));
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList((Object[])new String[]{"emi"});
        public boolean previewOverlay;
        private boolean displayTooltip;
        private boolean displayBlocks;
        private boolean displayEntities;
        private boolean displayBosses;
        private IWailaConfig.DisplayMode displayMode;
        private boolean enableTextToSpeech;
        private IWailaConfig.TTSMode ttsMode;
        private IWailaConfig.FluidMode fluidMode;
        private float extendedReach;
        private boolean debug;
        private boolean itemModNameTooltip;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode;
        private boolean builtinCamouflage;
        private final ExtraOptions extraOptions;

        public ConfigGeneral(boolean previewOverlay, boolean displayTooltip, boolean displayBlocks, boolean displayEntities, boolean displayBosses, IWailaConfig.DisplayMode displayMode, boolean enableTextToSpeech, IWailaConfig.TTSMode ttsMode, IWailaConfig.FluidMode fluidMode, float extendedReach, boolean debug, boolean itemModNameTooltip, IWailaConfig.BossBarOverlapMode bossBarOverlapMode, boolean builtinCamouflage, ExtraOptions extraOptions) {
            this.previewOverlay = previewOverlay;
            this.displayTooltip = displayTooltip;
            this.displayBlocks = displayBlocks;
            this.displayEntities = displayEntities;
            this.displayBosses = displayBosses;
            this.displayMode = displayMode;
            this.enableTextToSpeech = enableTextToSpeech;
            this.ttsMode = ttsMode;
            this.fluidMode = fluidMode;
            this.extendedReach = extendedReach;
            this.debug = debug;
            this.itemModNameTooltip = itemModNameTooltip;
            this.bossBarOverlapMode = bossBarOverlapMode;
            this.builtinCamouflage = builtinCamouflage;
            this.extraOptions = extraOptions;
        }

        public static void init() {
            List<String> names = itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map($ -> ModIdentification.getModName($).orElse((String)$)).toList();
            itemModNameTooltipDisabledByMods.clear();
            itemModNameTooltipDisabledByMods.addAll(names);
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        @Override
        public void setHideFromDebug(boolean hideFromDebug) {
            this.extraOptions.setHideFromDebug(hideFromDebug);
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean shouldHideFromDebug() {
            return this.extraOptions.hideFromDebug();
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getExtendedReach() {
            return this.extendedReach;
        }

        @Override
        public void setExtendedReach(float extendedReach) {
            this.extendedReach = class_3532.method_15363((float)extendedReach, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByMods.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.extraOptions.setHideFromTabList(hideFromTabList);
        }

        @Override
        public void setHideFromGUIs(boolean hideFromGUIs) {
            this.extraOptions.setHideFromGUIs(hideFromGUIs);
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.extraOptions.hideFromTabList();
        }

        @Override
        public boolean shouldHideFromGUIs() {
            return this.extraOptions.hideFromGUIs();
        }

        @Override
        public boolean getDisplayBosses() {
            return this.displayBosses;
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.displayBosses = displayBosses;
        }

        @Override
        public boolean getBuiltinCamouflage() {
            return this.builtinCamouflage;
        }

        @Override
        public void setBuiltinCamouflage(boolean builtinCamouflage) {
            this.builtinCamouflage = builtinCamouflage;
        }

        public static final class ExtraOptions {
            public static final MapCodec<ExtraOptions> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("hideFromDebug").orElse((Object)true).forGetter(ExtraOptions::hideFromDebug), (App)Codec.BOOL.fieldOf("hideFromTabList").orElse((Object)true).forGetter(ExtraOptions::hideFromTabList), (App)Codec.BOOL.fieldOf("hideFromGUIs").orElse((Object)true).forGetter(ExtraOptions::hideFromGUIs)).apply((Applicative)i, ExtraOptions::new));
            private boolean hideFromDebug;
            private boolean hideFromTabList;
            private boolean hideFromGUIs;

            public ExtraOptions(boolean hideFromDebug, boolean hideFromTabList, boolean hideFromGUIs) {
                this.hideFromDebug = hideFromDebug;
                this.hideFromTabList = hideFromTabList;
                this.hideFromGUIs = hideFromGUIs;
            }

            public boolean hideFromDebug() {
                return this.hideFromDebug;
            }

            public boolean hideFromTabList() {
                return this.hideFromTabList;
            }

            public boolean hideFromGUIs() {
                return this.hideFromGUIs;
            }

            public void setHideFromDebug(boolean hideFromDebug) {
                this.hideFromDebug = hideFromDebug;
            }

            public void setHideFromTabList(boolean hideFromTabList) {
                this.hideFromTabList = hideFromTabList;
            }

            public void setHideFromGUIs(boolean hideFromGUIs) {
                this.hideFromGUIs = hideFromGUIs;
            }
        }
    }

    public static class ConfigOverlay
    implements IWailaConfig.IConfigOverlay {
        public static final Codec<ConfigOverlay> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("activeTheme").orElse((Object)Theme.DEFAULT_THEME_ID).forGetter($ -> $.activeTheme), (App)Codec.FLOAT.fieldOf("overlayPosX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getOverlayPosX), (App)Codec.FLOAT.fieldOf("overlayPosY").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayPosY), (App)Codec.floatRange((float)0.2f, (float)2.0f).fieldOf("overlayScale").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayScale), (App)Codec.FLOAT.fieldOf("overlayAnchorX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getAnchorX), (App)Codec.FLOAT.fieldOf("overlayAnchorY").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getAnchorY), (App)Codec.BOOL.fieldOf("overlaySquare").orElse((Object)false).forGetter(ConfigOverlay::getSquare), (App)Codec.BOOL.fieldOf("flipMainHand").orElse((Object)false).forGetter(ConfigOverlay::getFlipMainHand), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("autoScaleThreshold").orElse((Object)Float.valueOf(0.4f)).forGetter(ConfigOverlay::getAutoScaleThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("alpha").orElse((Object)Float.valueOf(0.7f)).forGetter(ConfigOverlay::getAlpha), (App)class_3542.method_28140(IWailaConfig.IconMode::values).fieldOf("iconMode").orElse((Object)IWailaConfig.IconMode.TOP).forGetter(ConfigOverlay::getIconMode), (App)Codec.BOOL.fieldOf("animation").orElse((Object)true).forGetter(ConfigOverlay::getAnimation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("disappearingDelay").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getDisappearingDelay)).apply((Applicative)i, ConfigOverlay::new));
        public class_2960 activeTheme;
        private float overlayPosX;
        private float overlayPosY;
        private float overlayScale;
        private float overlayAnchorX;
        private float overlayAnchorY;
        private boolean overlaySquare;
        private boolean flipMainHand;
        private float autoScaleThreshold;
        private float alpha;
        private transient Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode;
        private boolean animation;
        private float disappearingDelay;

        public ConfigOverlay(class_2960 activeTheme, float overlayPosX, float overlayPosY, float overlayScale, float overlayAnchorX, float overlayAnchorY, boolean overlaySquare, boolean flipMainHand, float autoScaleThreshold, float alpha, IWailaConfig.IconMode iconMode, boolean animation, float disappearingDelay) {
            this.activeTheme = activeTheme;
            this.overlayPosX = overlayPosX;
            this.overlayPosY = overlayPosY;
            this.overlayScale = overlayScale;
            this.overlayAnchorX = overlayAnchorX;
            this.overlayAnchorY = overlayAnchorY;
            this.overlaySquare = overlaySquare;
            this.flipMainHand = flipMainHand;
            this.autoScaleThreshold = autoScaleThreshold;
            this.alpha = alpha;
            this.iconMode = iconMode;
            this.animation = animation;
            this.disappearingDelay = disappearingDelay;
        }

        @Override
        public float getOverlayPosX() {
            return class_3532.method_15363((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = class_3532.method_15363((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return class_3532.method_15363((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = class_3532.method_15363((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = class_3532.method_15363((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return class_3532.method_15363((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = class_3532.method_15363((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return class_3532.method_15363((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = class_3532.method_15363((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (this.flipMainHand && class_310.method_1551().field_1690.method_42552().method_41753() == class_1306.field_6182) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public boolean getSquare() {
            return this.overlaySquare;
        }

        @Override
        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        public void applyTheme(class_2960 id) {
            this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            this.activeTheme = this.activeThemeInstance.id;
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }
    }

    public static class ConfigFormatting
    implements IWailaConfig.IConfigFormatting {
        public static final Codec<ConfigFormatting> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2583.class_2584.field_46613.fieldOf("itemModNameStyle").orElseGet(() -> class_2583.field_24360.method_27705(new class_124[]{class_124.field_1078, class_124.field_1056})).forGetter(ConfigFormatting::getItemModNameStyle)).apply((Applicative)i, ConfigFormatting::new));
        private class_2583 itemModNameStyle;

        public ConfigFormatting(class_2583 itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public class_2583 getItemModNameStyle() {
            return this.itemModNameStyle;
        }

        @Override
        public void setItemModNameStyle(class_2583 itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public class_2561 registryName(String name) {
            return class_2561.method_43470((String)name).method_27692(IThemeHelper.get().isLightColorScheme() ? class_124.field_1063 : class_124.field_1080);
        }
    }

    public static class ConfigHistory {
        public static final Codec<ConfigHistory> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.optionalFieldOf("hintOverlayToggle", (Object)true).forGetter($ -> $.hintOverlayToggle), (App)Codec.BOOL.optionalFieldOf("hintNarratorToggle", (Object)true).forGetter($ -> $.hintNarratorToggle), (App)Codec.INT.optionalFieldOf("themesHash", (Object)0).forGetter($ -> $.themesHash)).apply((Applicative)i, ConfigHistory::new));
        public boolean hintOverlayToggle;
        public boolean hintNarratorToggle;
        public int themesHash;

        public ConfigHistory(boolean hintOverlayToggle, boolean hintNarratorToggle, int themesHash) {
            this.hintOverlayToggle = hintOverlayToggle;
            this.hintNarratorToggle = hintNarratorToggle;
            this.themesHash = themesHash;
        }
    }
}

