/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.track;

import snownee.jade.track.TrackInfo;
import snownee.jade.util.SmoothChasingValue;

public class ProgressTrackInfo
extends TrackInfo {
    private final boolean canDecrease;
    private float width;
    private int ticksSinceWidthChanged;
    private float ticksSinceValueChanged;
    private final SmoothChasingValue smoothProgress = new SmoothChasingValue();
    private float progress;
    private float expectedWidth;

    public ProgressTrackInfo(boolean canDecrease, float progress, float width) {
        this.canDecrease = canDecrease;
        this.progress = progress;
        this.width = width;
        this.smoothProgress.start(progress);
    }

    public float getWidth() {
        return this.width;
    }

    @Override
    public void update(float pTicks) {
        if (this.progress != this.smoothProgress.getTarget() && this.ticksSinceValueChanged > 0.0f) {
            if (this.ticksSinceValueChanged > 10.0f) {
                this.smoothProgress.withSpeed(0.4f);
            } else if (this.canDecrease || this.progress > this.smoothProgress.getTarget()) {
                float spd = Math.abs(this.progress - this.smoothProgress.getTarget()) / this.ticksSinceValueChanged;
                spd = Math.max(0.1f, 4.0f * spd);
                this.smoothProgress.withSpeed(spd);
            }
            this.ticksSinceValueChanged = pTicks;
        } else {
            this.ticksSinceValueChanged += pTicks;
        }
        if (!this.canDecrease && this.progress < this.smoothProgress.getTarget()) {
            if (this.smoothProgress.isMoving()) {
                this.smoothProgress.withSpeed(Math.max(0.5f, this.smoothProgress.getSpeed()));
                if (this.smoothProgress.getTarget() > 0.9f) {
                    this.smoothProgress.target(1.0f);
                }
            } else {
                this.smoothProgress.start(this.progress);
            }
        } else {
            this.smoothProgress.target(this.progress);
        }
        this.smoothProgress.tick(pTicks);
    }

    public void setExpectedWidth(float expectedWidth) {
        this.expectedWidth = expectedWidth;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getSmoothProgress() {
        return this.smoothProgress.value;
    }

    @Override
    public void tick() {
        if (this.width != this.expectedWidth && (this.expectedWidth > this.width || ++this.ticksSinceWidthChanged > 10)) {
            this.width = this.expectedWidth;
            this.ticksSinceWidthChanged = 0;
        }
    }
}

