/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.command;

import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.argument.FunctionArgument;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2096;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2177;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2183;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2196;
import net.minecraft.class_2203;
import net.minecraft.class_2212;
import net.minecraft.class_2214;
import net.minecraft.class_2216;
import net.minecraft.class_2223;
import net.minecraft.class_2224;
import net.minecraft.class_2232;
import net.minecraft.class_2233;
import net.minecraft.class_2239;
import net.minecraft.class_2240;
import net.minecraft.class_2243;
import net.minecraft.class_2245;
import net.minecraft.class_2247;
import net.minecraft.class_2252;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2264;
import net.minecraft.class_2270;
import net.minecraft.class_2273;
import net.minecraft.class_2274;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_2321;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3019;
import net.minecraft.class_3039;
import net.minecraft.class_5242;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5473;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7733;
import net.minecraft.class_7737;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public abstract class CommandArgument {
    private static final List<? extends CommandArgument> baseTypes = Lists.newArrayList((Object[])new CommandArgument[]{new StringArgument(), new VanillaUnconfigurableArgument("bool", BoolArgumentType::bool, (c, p) -> BooleanValue.of(BoolArgumentType.getBool((CommandContext)c, (String)p)), false), new FloatArgument(), new IntArgument(), new WordArgument(), new GreedyStringArgument(), new VanillaUnconfigurableArgument("yaw", class_5473::method_30658, (c, p) -> new NumericValue(class_5473.method_30660((CommandContext)c, (String)p)), true), new BlockPosArgument(), new VanillaUnconfigurableArgument("block", class_2257::method_9653, (c, p) -> {
        class_2247 result = class_2257.method_9655((CommandContext)c, (String)p);
        return new BlockValue(result.method_9494(), ((class_2168)c.getSource()).method_9225(), Vanilla.BlockInput_getTag(result));
    }, param -> (ctx, builder) -> ((class_2257)ctx.getArgument(param, class_2257.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("blockpredicate", class_2252::method_9645, (c, p) -> ValueConversions.ofBlockPredicate((class_5455)((class_2168)c.getSource()).method_9211().method_30611(), class_2252.method_9644((CommandContext)c, (String)p)), param -> (ctx, builder) -> ((class_2252)ctx.getArgument(param, class_2252.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("teamcolor", class_2177::method_9276, (c, p) -> {
        class_124 format = class_2177.method_9277((CommandContext)c, (String)p);
        return ListValue.of(StringValue.of(format.method_537()), ValueConversions.ofRGB(format.method_532()));
    }, false), new VanillaUnconfigurableArgument("columnpos", class_2264::method_9701, (c, p) -> ValueConversions.of(class_2264.method_9702((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("dimension", class_2181::method_9288, (c, p) -> ValueConversions.of(class_2181.method_9289((CommandContext)c, (String)p)), false), new EntityArgument(), new VanillaUnconfigurableArgument("anchor", class_2183::method_9295, (c, p) -> StringValue.of(class_2183.method_9294((CommandContext)c, (String)p).name()), false), new VanillaUnconfigurableArgument("entitytype", c -> class_7733.method_45603((class_7157)c, (class_5321)class_7924.field_41266), (c, p) -> ValueConversions.of(class_7733.method_45610((CommandContext)c, (String)p).method_40237()), (SuggestionProvider<class_2168>)class_2321.field_10935), new VanillaUnconfigurableArgument("floatrange", class_2224::method_30918, (c, p) -> ValueConversions.of((class_2096)c.getArgument(p, class_2096.class_2099.class)), true), new PlayerProfileArgument(), new VanillaUnconfigurableArgument("intrange", class_2224::method_9422, (c, p) -> ValueConversions.of(class_2224.class_2227.method_9425((CommandContext)c, (String)p)), true), new VanillaUnconfigurableArgument("enchantment", class_7924.field_41265), new SlotArgument(), new VanillaUnconfigurableArgument("item", class_2287::method_9776, (c, p) -> ValueConversions.of(class_2287.method_9777((CommandContext)c, (String)p).method_9781(1, false), ((class_2168)c.getSource()).method_30497()), param -> (ctx, builder) -> ((class_2287)ctx.getArgument(param, class_2287.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("message", class_2196::method_9340, (c, p) -> new FormattedTextValue(class_2196.method_9339((CommandContext)c, (String)p)), true), new VanillaUnconfigurableArgument("effect", class_7924.field_41208), new TagArgument(), new VanillaUnconfigurableArgument("path", class_2203::method_9360, (c, p) -> StringValue.of(class_2203.method_9358((CommandContext)c, (String)p).toString()), true), new VanillaUnconfigurableArgument("objective", class_2214::method_9391, (c, p) -> ValueConversions.of(class_2214.method_9395((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("criterion", class_2216::method_9399, (c, p) -> StringValue.of(class_2216.method_9402((CommandContext)c, (String)p).method_1225()), false), new VanillaUnconfigurableArgument("particle", class_2223::method_9417, (c, p) -> ValueConversions.of(class_2223.method_9421((CommandContext)c, (String)p), ((class_2168)c.getSource()).method_30497()), (SuggestionProvider<class_2168>)((SuggestionProvider)(c, b) -> class_2172.method_9270((Iterable)((class_2168)c.getSource()).method_9211().method_30611().method_30530(class_7924.field_41210).method_10235(), (SuggestionsBuilder)b))), new VanillaUnconfigurableArgument("recipe", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9442((CommandContext)c, (String)p).comp_1932()), (SuggestionProvider<class_2168>)class_2321.field_10932), new VanillaUnconfigurableArgument("advancement", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9439((CommandContext)c, (String)p).comp_1919()), (SuggestionProvider<class_2168>)((SuggestionProvider)(ctx, builder) -> class_2172.method_9257(((class_2168)ctx.getSource()).method_9211().method_3851().method_12893().stream().map(class_8779::comp_1919), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("lootcondition", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9443((CommandContext)c, (String)p)), (SuggestionProvider<class_2168>)((SuggestionProvider)(ctx, builder) -> class_2172.method_9270((Iterable)((class_2168)ctx.getSource()).method_9211().method_58576().method_58290(class_7924.field_41198), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("loottable", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9443((CommandContext)c, (String)p)), (SuggestionProvider<class_2168>)class_3039.field_13605), new VanillaUnconfigurableArgument("attribute", class_7924.field_41251), new VanillaUnconfigurableArgument("boss", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9443((CommandContext)c, (String)p)), (SuggestionProvider<class_2168>)class_3019.field_13482), new VanillaUnconfigurableArgument("biome", c -> class_7737.method_45637((class_7157)c, (class_5321)class_7924.field_41236), (c, p) -> {
        class_7737.class_7741 result = class_7737.method_45636((CommandContext)c, (String)"biome", (class_5321)class_7924.field_41236);
        Either res = result.method_45647();
        if (res.left().isPresent()) {
            return ValueConversions.of(((class_6880.class_6883)res.left().get()).method_40237());
        }
        if (res.right().isPresent()) {
            return ValueConversions.of(((class_6885.class_6888)res.right().get()).method_40251());
        }
        return Value.NULL;
    }, (SuggestionProvider<class_2168>)((SuggestionProvider)(ctx, builder) -> class_2172.method_9270((Iterable)((class_2168)ctx.getSource()).method_9211().method_30611().method_30530(class_7924.field_41236).method_10235(), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("sound", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9443((CommandContext)c, (String)p)), (SuggestionProvider<class_2168>)class_2321.field_10934), new VanillaUnconfigurableArgument("storekey", class_2232::method_9441, (c, p) -> ValueConversions.of(class_2232.method_9443((CommandContext)c, (String)p)), (SuggestionProvider<class_2168>)((SuggestionProvider)(ctx, builder) -> class_2172.method_9257((Stream)((class_2168)ctx.getSource()).method_9211().method_22827().method_22542(), (SuggestionsBuilder)builder))), new CustomIdentifierArgument(), new VanillaUnconfigurableArgument("rotation", class_2270::method_9717, (c, p) -> {
        class_241 rot = class_2270.method_9716((CommandContext)c, (String)p).method_9709((class_2168)c.getSource());
        return ListValue.of(new NumericValue(rot.field_1343), new NumericValue(rot.field_1342));
    }, true), new ScoreholderArgument(), new VanillaUnconfigurableArgument("scoreboardslot", class_2239::method_9468, (c, p) -> StringValue.of(class_2239.method_9465((CommandContext)c, (String)p).method_15434()), false), new VanillaUnconfigurableArgument("swizzle", class_2273::method_9721, (c, p) -> StringValue.of(class_2273.method_9720((CommandContext)c, (String)p).stream().map(class_2350.class_2351::method_15434).collect(Collectors.joining())), true), new VanillaUnconfigurableArgument("team", class_2243::method_9482, (c, p) -> StringValue.of(class_2243.method_9480((CommandContext)c, (String)p).method_1197()), false), new VanillaUnconfigurableArgument("time", class_2245::method_9489, (c, p) -> new NumericValue(IntegerArgumentType.getInteger((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("uuid", class_5242::method_27643, (c, p) -> StringValue.of(class_5242.method_27645((CommandContext)c, (String)p).toString()), false), new VanillaUnconfigurableArgument("surfacelocation", class_2274::method_9723, (c, p) -> {
        class_241 res = class_2274.method_9724((CommandContext)c, (String)p);
        return ListValue.of(NumericValue.of(Float.valueOf(res.field_1343)), NumericValue.of(Float.valueOf(res.field_1342)));
    }, false), new LocationArgument()});
    public static final Map<String, CommandArgument> builtIns = baseTypes.stream().collect(Collectors.toMap(CommandArgument::getTypeSuffix, a -> a));
    public static final CommandArgument DEFAULT = baseTypes.get(0);
    protected String suffix;
    @Nullable
    protected Collection<String> examples;
    protected boolean needsMatching;
    protected boolean caseSensitive = true;
    protected Function<String, SuggestionProvider<class_2168>> suggestionProvider;
    protected FunctionArgument customSuggester;

    public static CommandSyntaxException error(String text) {
        return new SimpleCommandExceptionType((Message)class_2561.method_43470((String)text)).create();
    }

    public static CommandArgument getTypeForArgument(String argument, CarpetScriptHost host) {
        String[] components = argument.split("_");
        for (int i = 0; i < components.length; ++i) {
            String candidate = String.join((CharSequence)"_", Arrays.asList(components).subList(i, components.length));
            CommandArgument arg = host.appArgTypes.get(candidate);
            if (arg != null) {
                return arg;
            }
            arg = builtIns.get(candidate);
            if (arg == null) continue;
            return arg;
        }
        return DEFAULT;
    }

    public static RequiredArgumentBuilder<class_2168, ?> argumentNode(String param, CarpetScriptHost host) throws CommandSyntaxException {
        CommandArgument arg = CommandArgument.getTypeForArgument(param, host);
        if (arg.suggestionProvider != null) {
            return class_2170.method_9244((String)param, arg.getArgumentType(host)).suggests(arg.suggestionProvider.apply(param));
        }
        if (!arg.needsMatching) {
            return class_2170.method_9244((String)param, arg.getArgumentType(host));
        }
        String hostName = host.getName();
        CarpetScriptServer scriptServer = host.scriptServer();
        return class_2170.method_9244((String)param, arg.getArgumentType(host)).suggests((ctx, b) -> {
            CarpetScriptHost cHost = scriptServer.modules.get(hostName).retrieveOwnForExecution((class_2168)ctx.getSource());
            return arg.suggest((CommandContext<class_2168>)ctx, b, cHost);
        });
    }

    protected CommandArgument(String suffix, @Nullable Collection<String> examples, boolean suggestFromExamples) {
        this.suffix = suffix;
        this.examples = examples;
        this.needsMatching = suggestFromExamples;
    }

    protected abstract ArgumentType<?> getArgumentType(CarpetScriptHost var1) throws CommandSyntaxException;

    public static Value getValue(CommandContext<class_2168> context, String param, CarpetScriptHost host) throws CommandSyntaxException {
        return CommandArgument.getTypeForArgument(param, host).getValueFromContext(context, param);
    }

    protected abstract Value getValueFromContext(CommandContext<class_2168> var1, String var2) throws CommandSyntaxException;

    public String getTypeSuffix() {
        return this.suffix;
    }

    public static CommandArgument buildFromConfig(String suffix, Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
        if (!config.containsKey("type")) {
            throw CommandArgument.error("Custom type " + suffix + " should at least specify the type");
        }
        String baseType = config.get("type").getString();
        if (!builtIns.containsKey(baseType)) {
            throw CommandArgument.error("Unknown base type " + baseType + " for custom type " + suffix);
        }
        CommandArgument variant = builtIns.get(baseType).factory(host.scriptServer().server).get();
        variant.suffix = suffix;
        variant.configure(config, host);
        return variant;
    }

    protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
        this.caseSensitive = config.getOrDefault("case_sensitive", Value.TRUE).getBoolean();
        if (config.containsKey("suggester")) {
            this.customSuggester = FunctionArgument.fromCommandSpec(host, config.get("suggester"));
        }
        if (config.containsKey("suggest")) {
            if (config.containsKey("suggester")) {
                throw CommandArgument.error("Attempted to provide 'suggest' list while 'suggester' is present for custom type " + this.suffix);
            }
            Value suggestionValue = config.get("suggest");
            if (!(suggestionValue instanceof ListValue)) {
                throw CommandArgument.error("Argument suggestions needs to be a list for custom type " + this.suffix);
            }
            this.examples = ((ListValue)suggestionValue).getItems().stream().map(Value::getString).collect(Collectors.toSet());
            if (!this.examples.isEmpty()) {
                this.needsMatching = true;
            }
        }
    }

    public CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder suggestionsBuilder, CarpetScriptHost host) throws CommandSyntaxException {
        String prefix = suggestionsBuilder.getRemaining();
        if (!this.caseSensitive) {
            prefix = prefix.toLowerCase(Locale.ROOT);
        }
        this.suggestFor(context, prefix, host).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    protected List<String> suggestFor(CommandContext<class_2168> context, String prefix, CarpetScriptHost host) throws CommandSyntaxException {
        return this.getOptions(context, host).stream().filter(s -> this.optionMatchesPrefix(prefix, (String)s)).collect(Collectors.toList());
    }

    protected Collection<String> getOptions(CommandContext<class_2168> context, CarpetScriptHost host) throws CommandSyntaxException {
        if (this.customSuggester != null) {
            Runnable currentSection = Carpet.startProfilerSection("Scarpet command");
            HashMap<Value, Value> params = new HashMap<Value, Value>();
            for (ParsedCommandNode pnode : context.getNodes()) {
                CommandNode node = pnode.getNode();
                if (!(node instanceof ArgumentCommandNode)) continue;
                params.put(StringValue.of(node.getName()), CommandArgument.getValue(context, node.getName(), host));
            }
            ArrayList<Value> args = new ArrayList<Value>(this.customSuggester.args.size() + 1);
            args.add(MapValue.wrap(params));
            args.addAll(this.customSuggester.args);
            Value response = host.handleCommand((class_2168)context.getSource(), this.customSuggester.function, args);
            if (!(response instanceof ListValue)) {
                throw CommandArgument.error("Custom suggester should return a list of options for custom type " + this.suffix);
            }
            Collection res = ((ListValue)response).getItems().stream().map(Value::getString).collect(Collectors.toList());
            currentSection.run();
            return res;
        }
        return this.needsMatching ? this.examples : Collections.singletonList("... " + this.getTypeSuffix());
    }

    protected boolean optionMatchesPrefix(String prefix, String option) {
        if (!this.caseSensitive) {
            option = option.toLowerCase(Locale.ROOT);
        }
        int i = 0;
        while (!option.startsWith(prefix, i)) {
            if ((i = option.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract Supplier<CommandArgument> factory(MinecraftServer var1);

    private static class StringArgument
    extends CommandArgument {
        Set<String> validOptions = Collections.emptySet();

        private StringArgument() {
            super("string", StringArgumentType.StringType.QUOTABLE_PHRASE.getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.string();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            String choseValue = StringArgumentType.getString(context, (String)param);
            if (!this.caseSensitive) {
                choseValue = choseValue.toLowerCase(Locale.ROOT);
            }
            if (!this.validOptions.isEmpty() && !this.validOptions.contains(choseValue)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Incorrect value for " + param + ": " + choseValue + " for custom type " + this.suffix))).create();
            }
            return StringValue.of(choseValue);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("options")) {
                Value optionsValue = config.get("options");
                if (!(optionsValue instanceof ListValue)) {
                    throw StringArgument.error("Custom string type requires options passed as a list for custom type " + this.suffix);
                }
                this.validOptions = ((ListValue)optionsValue).getItems().stream().map(v -> this.caseSensitive ? v.getString() : v.getString().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            }
        }

        @Override
        protected Collection<String> getOptions(CommandContext<class_2168> context, CarpetScriptHost host) throws CommandSyntaxException {
            return this.validOptions.isEmpty() ? super.getOptions(context, host) : this.validOptions;
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return StringArgument::new;
        }
    }

    public static class VanillaUnconfigurableArgument
    extends CommandArgument {
        private final ArgumentProvider argumentTypeSupplier;
        private final ArgumentProviderEx argumentTypeSupplierEx;
        private final ValueExtractor valueExtractor;
        private final boolean providesExamples;

        public VanillaUnconfigurableArgument(String suffix, ArgumentProvider argumentTypeSupplier, ValueExtractor valueExtractor, boolean suggestFromExamples) {
            super(suffix, null, suggestFromExamples);
            try {
                this.examples = argumentTypeSupplier.get().getExamples();
            }
            catch (CommandSyntaxException e) {
                this.examples = Collections.emptyList();
            }
            this.providesExamples = suggestFromExamples;
            this.argumentTypeSupplier = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplierEx = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProvider argumentTypeSupplier, ValueExtractor valueExtractor, SuggestionProvider<class_2168> suggester) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = param -> suggester;
            this.providesExamples = false;
            this.argumentTypeSupplier = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplierEx = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, boolean suggestFromExamples, MinecraftServer server) {
            super(suffix, null, suggestFromExamples);
            try {
                class_7157 context = class_7157.method_46722((class_7225.class_7874)server.method_30611(), (class_7699)server.method_27728().method_45560());
                this.examples = argumentTypeSupplier.get(context).getExamples();
            }
            catch (CommandSyntaxException e) {
                this.examples = Collections.emptyList();
            }
            this.providesExamples = suggestFromExamples;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, SuggestionProvider<class_2168> suggester) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = param -> suggester;
            this.providesExamples = false;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, Function<String, SuggestionProvider<class_2168>> suggesterGen) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = suggesterGen;
            this.providesExamples = false;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public <T> VanillaUnconfigurableArgument(String suffix, class_5321<class_2378<T>> registry) {
            this(suffix, (class_7157 c) -> class_7733.method_45603((class_7157)c, (class_5321)registry), (CommandContext<class_2168> c, String p) -> ValueConversions.of(class_7733.method_45602((CommandContext)c, (String)p, (class_5321)registry).method_40237()), (SuggestionProvider<class_2168>)((SuggestionProvider)(c, b) -> class_2172.method_9270((Iterable)((class_2168)c.getSource()).method_9211().method_30611().method_30530(registry).method_10235(), (SuggestionsBuilder)b)));
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) throws CommandSyntaxException {
            return this.argumentTypeSupplier != null ? this.argumentTypeSupplier.get() : this.argumentTypeSupplierEx.get(class_7157.method_46722((class_7225.class_7874)host.scriptServer().server.method_30611(), (class_7699)host.scriptServer().server.method_27728().method_45560()));
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            return this.valueExtractor.apply(context, param);
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return this.argumentTypeSupplier != null ? () -> new VanillaUnconfigurableArgument(this.getTypeSuffix(), this.argumentTypeSupplier, this.valueExtractor, this.providesExamples) : () -> new VanillaUnconfigurableArgument(this.getTypeSuffix(), this.argumentTypeSupplierEx, this.valueExtractor, this.providesExamples, server);
        }
    }

    @FunctionalInterface
    private static interface ArgumentProvider {
        public ArgumentType<?> get() throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface ValueExtractor {
        public Value apply(CommandContext<class_2168> var1, String var2) throws CommandSyntaxException;
    }

    private static class FloatArgument
    extends CommandArgument {
        private Double min = null;
        private Double max = null;

        private FloatArgument() {
            super("float", DoubleArgumentType.doubleArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.min != null) {
                if (this.max != null) {
                    return DoubleArgumentType.doubleArg((double)this.min, (double)this.max);
                }
                return DoubleArgumentType.doubleArg((double)this.min);
            }
            return DoubleArgumentType.doubleArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) {
            return new NumericValue(DoubleArgumentType.getDouble(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getDouble();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getDouble();
            }
            if (this.max != null && this.min == null) {
                throw FloatArgument.error("Double types cannot be only upper-bounded for custom type " + this.suffix);
            }
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return FloatArgument::new;
        }
    }

    private static class IntArgument
    extends CommandArgument {
        private Long min = null;
        private Long max = null;

        private IntArgument() {
            super("int", LongArgumentType.longArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.min != null) {
                if (this.max != null) {
                    return LongArgumentType.longArg((long)this.min, (long)this.max);
                }
                return LongArgumentType.longArg((long)this.min);
            }
            return LongArgumentType.longArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) {
            return new NumericValue(LongArgumentType.getLong(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getLong();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getLong();
            }
            if (this.max != null && this.min == null) {
                throw IntArgument.error("Double types cannot be only upper-bounded for custom type " + this.suffix);
            }
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return IntArgument::new;
        }
    }

    private static class WordArgument
    extends StringArgument {
        private WordArgument() {
            this.suffix = "term";
            this.examples = StringArgumentType.StringType.SINGLE_WORD.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.word();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return WordArgument::new;
        }
    }

    private static class GreedyStringArgument
    extends StringArgument {
        private GreedyStringArgument() {
            this.suffix = "text";
            this.examples = StringArgumentType.StringType.GREEDY_PHRASE.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.greedyString();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return GreedyStringArgument::new;
        }
    }

    private static class BlockPosArgument
    extends CommandArgument {
        private boolean mustBeLoaded = false;

        private BlockPosArgument() {
            super("pos", class_2262.method_9698().getExamples(), false);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return class_2262.method_9698();
        }

        @Override
        public Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            class_2338 pos = this.mustBeLoaded ? class_2262.method_9696(context, (String)param) : class_2262.method_9697(context, (String)param);
            return ValueConversions.of(pos);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.mustBeLoaded = config.getOrDefault("loaded", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return BlockPosArgument::new;
        }
    }

    @FunctionalInterface
    private static interface ArgumentProviderEx {
        public ArgumentType<?> get(class_7157 var1) throws CommandSyntaxException;
    }

    private static class EntityArgument
    extends CommandArgument {
        boolean onlyFans = false;
        boolean single = false;

        private EntityArgument() {
            super("entities", class_2186.method_9306().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.onlyFans) {
                return this.single ? class_2186.method_9305() : class_2186.method_9308();
            }
            return this.single ? class_2186.method_9309() : class_2186.method_9306();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            Collection founds = class_2186.method_9307(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(founds.stream().map(EntityValue::new));
            }
            if (founds.isEmpty()) {
                return Value.NULL;
            }
            if (founds.size() == 1) {
                return new EntityValue((class_1297)founds.iterator().next());
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Multiple entities returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.onlyFans = config.getOrDefault("players", Value.FALSE).getBoolean();
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return EntityArgument::new;
        }
    }

    private static class PlayerProfileArgument
    extends CommandArgument {
        boolean single = false;

        private PlayerProfileArgument() {
            super("players", class_2191.method_9329().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return class_2191.method_9329();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            Collection profiles = class_2191.method_9330(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(profiles.stream().map(p -> StringValue.of(p.getName())));
            }
            int size = profiles.size();
            if (size == 0) {
                return Value.NULL;
            }
            if (size == 1) {
                return StringValue.of(((GameProfile)profiles.iterator().next()).getName());
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Multiple game profiles returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return PlayerProfileArgument::new;
        }
    }

    private static class SlotArgument
    extends CommandArgument {
        private String restrict;
        private static final Map<String, ContainerIds> RESTRICTED_CONTAINERS = new HashMap<String, ContainerIds>(){
            {
                int i;
                for (String source : Arrays.asList("player", "enderchest", "equipment", "armor", "weapon", "container", "villager", "horse")) {
                    this.put(source, new ContainerIds((IntSet)new IntOpenHashSet(), new HashSet<String>()));
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("player")).numericalIds().add(i);
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("container." + i);
                }
                for (i = 0; i < 9; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("hotbar." + i);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("inventory." + i);
                }
                for (String place : Arrays.asList("weapon", "weapon.mainhand", "weapon.offhand")) {
                    ((ContainerIds)this.get("player")).commandIds().add(place);
                    ((ContainerIds)this.get("equipment")).commandIds().add(place);
                    ((ContainerIds)this.get("weapon")).commandIds().add(place);
                }
                for (String place : Arrays.asList("armor.feet", "armor.legs", "armor.chest", "armor.head")) {
                    ((ContainerIds)this.get("player")).commandIds().add(place);
                    ((ContainerIds)this.get("equipment")).commandIds().add(place);
                    ((ContainerIds)this.get("armor")).commandIds().add(place);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("enderchest")).numericalIds().add(200 + i);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("enderchest")).commandIds().add("enderchest." + i);
                }
                for (i = 0; i < 6; ++i) {
                    ((ContainerIds)this.get("equipment")).numericalIds().add(98 + i);
                }
                for (i = 0; i < 4; ++i) {
                    ((ContainerIds)this.get("armor")).numericalIds().add(100 + i);
                }
                for (i = 0; i < 2; ++i) {
                    ((ContainerIds)this.get("weapon")).numericalIds().add(98 + i);
                }
                for (i = 0; i < 54; ++i) {
                    ((ContainerIds)this.get("container")).numericalIds().add(i);
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("container")).commandIds().add("container." + i);
                }
                for (i = 0; i < 8; ++i) {
                    ((ContainerIds)this.get("villager")).numericalIds().add(i);
                }
                for (i = 0; i < 8; ++i) {
                    ((ContainerIds)this.get("villager")).commandIds().add("villager." + i);
                }
                for (i = 0; i < 15; ++i) {
                    ((ContainerIds)this.get("horse")).numericalIds().add(500 + i);
                }
                for (i = 0; i < 15; ++i) {
                    ((ContainerIds)this.get("horse")).commandIds().add("horse." + i);
                }
                ((ContainerIds)this.get("horse")).numericalIds().add(400);
                ((ContainerIds)this.get("horse")).commandIds().add("horse.saddle");
                ((ContainerIds)this.get("horse")).numericalIds().add(401);
                ((ContainerIds)this.get("horse")).commandIds().add("horse.armor");
            }
        };

        protected SlotArgument() {
            super("slot", class_2240.method_9473().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return class_2240.method_9473();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            int slot = class_2240.method_9469(context, (String)param);
            if (this.restrict != null && !RESTRICTED_CONTAINERS.get(this.restrict).numericalIds().contains(slot)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Incorrect slot restricted to " + this.restrict + " for custom type " + this.suffix))).create();
            }
            return ValueConversions.ofVanillaSlotResult(slot);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("restrict")) {
                this.restrict = config.get("restrict").getString().toLowerCase(Locale.ROOT);
                this.needsMatching = true;
                if (!RESTRICTED_CONTAINERS.containsKey(this.restrict)) {
                    throw SlotArgument.error("Incorrect slot restriction " + this.restrict + " for custom type " + this.suffix);
                }
            }
        }

        @Override
        protected Collection<String> getOptions(CommandContext<class_2168> context, CarpetScriptHost host) throws CommandSyntaxException {
            return this.restrict == null ? super.getOptions(context, host) : RESTRICTED_CONTAINERS.get(this.restrict).commandIds();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return SlotArgument::new;
        }

        private record ContainerIds(IntSet numericalIds, Set<String> commandIds) {
        }
    }

    private static class TagArgument
    extends CommandArgument {
        boolean mapRequired = true;

        private TagArgument() {
            super("tag", class_2179.method_9284().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return this.mapRequired ? class_2179.method_9284() : class_2212.method_9389();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) {
            return this.mapRequired ? new NBTSerializableValue((class_2520)class_2179.method_9285(context, (String)param)) : new NBTSerializableValue(class_2212.method_9390(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.mapRequired = !config.getOrDefault("allow_element", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return TagArgument::new;
        }
    }

    private static class CustomIdentifierArgument
    extends CommandArgument {
        Set<class_2960> validOptions = Collections.emptySet();

        protected CustomIdentifierArgument() {
            super("identifier", Collections.emptyList(), true);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return class_2232.method_9441();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            class_2960 choseValue = class_2232.method_9443(context, (String)param);
            if (!this.validOptions.isEmpty() && !this.validOptions.contains(choseValue)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Incorrect value for " + param + ": " + String.valueOf(choseValue) + " for custom type " + this.suffix))).create();
            }
            return ValueConversions.of(choseValue);
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return CustomIdentifierArgument::new;
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("options")) {
                Value optionsValue = config.get("options");
                if (!(optionsValue instanceof ListValue)) {
                    throw CustomIdentifierArgument.error("Custom sting type requires options passed as a list for custom type " + this.suffix);
                }
                this.validOptions = ((ListValue)optionsValue).getItems().stream().map(v -> class_2960.method_60654((String)v.getString())).collect(Collectors.toSet());
            }
        }
    }

    private static class ScoreholderArgument
    extends CommandArgument {
        boolean single = false;

        private ScoreholderArgument() {
            super("scoreholder", class_2233.method_9447().getExamples(), false);
            this.suggestionProvider = param -> class_2233.field_9951;
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return this.single ? class_2233.method_9447() : class_2233.method_9451();
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) throws CommandSyntaxException {
            Collection holders = class_2233.method_9458(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(holders.stream().map(ValueConversions::of));
            }
            int size = holders.size();
            if (size == 0) {
                return Value.NULL;
            }
            if (size == 1) {
                return ValueConversions.of((class_9015)holders.iterator().next());
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Multiple score holders returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return PlayerProfileArgument::new;
        }
    }

    private static class LocationArgument
    extends CommandArgument {
        boolean blockCentered = true;

        private LocationArgument() {
            super("location", class_2277.method_9737().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return class_2277.method_9735((boolean)this.blockCentered);
        }

        @Override
        protected Value getValueFromContext(CommandContext<class_2168> context, String param) {
            return ValueConversions.of(class_2277.method_9736(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.blockCentered = config.getOrDefault("block_centered", Value.TRUE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return LocationArgument::new;
        }
    }
}

