/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_3218;
import net.minecraft.class_9240;

public class WorldTools {
    public static boolean canHasChunk(class_3218 world, class_1923 chpos, @Nullable Map<String, class_2861> regionCache, boolean deepcheck) {
        if (world.method_8402(chpos.field_9181, chpos.field_9180, class_2806.field_16423, false) != null) {
            return true;
        }
        String currentRegionName = "r." + chpos.method_17885() + "." + chpos.method_17886() + ".mca";
        if (regionCache != null && regionCache.containsKey(currentRegionName)) {
            class_2861 region = regionCache.get(currentRegionName);
            if (region == null) {
                return false;
            }
            return region.method_12423(chpos);
        }
        Path regionsFolder = Vanilla.MinecraftServer_storageSource(world.method_8503()).method_27424(world.method_27983()).resolve("region");
        Path regionPath = regionsFolder.resolve(currentRegionName);
        if (!regionPath.toFile().exists()) {
            if (regionCache != null) {
                regionCache.put(currentRegionName, null);
            }
            return false;
        }
        if (!deepcheck) {
            return true;
        }
        try {
            class_9240 levelStorageInfo = new class_9240(Vanilla.MinecraftServer_storageSource(world.method_8503()).method_27005(), world.method_27983(), "chunk");
            class_2861 region = new class_2861(levelStorageInfo, regionPath, regionsFolder, true);
            if (regionCache != null) {
                regionCache.put(currentRegionName, region);
            }
            return region.method_12423(chpos);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static void forceChunkUpdate(class_2338 pos, class_3218 world) {
        List players;
        class_1923 chunkPos = new class_1923(pos);
        class_2818 worldChunk = world.method_14178().method_12126(chunkPos.field_9181, chunkPos.field_9180, false);
        if (worldChunk != null && !(players = world.method_14178().field_17254.method_17210(chunkPos, false)).isEmpty()) {
            class_2672 packet = new class_2672(worldChunk, world.method_22336(), null, null);
            players.forEach(p -> p.field_13987.method_14364((class_2596)packet));
        }
    }
}

