/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.PolygonHelper;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2582;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_9307;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@ParametersAreNonnullByDefault
public class FrontierOverlay
extends FrontierData {
    private static final MapImage markerVertex = new MapImage(class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/marker.png"), 0, 0, 12, 12, -1, 1.0f);
    private static final MapImage markerDot = new MapImage(class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/marker.png"), 12, 0, 8, 8, -1, 1.0f);
    public class_2338 topLeft;
    public class_2338 bottomRight;
    public float perimeter = 0.0f;
    public float area = 0.0f;
    private int vertexSelected = -1;
    private boolean highlighted = false;
    private final IClientAPI jmAPI;
    private final List<PolygonOverlay> polygonOverlays = new ArrayList<PolygonOverlay>();
    private Area polygonArea;
    private final List<MarkerOverlay> markerOverlays = new ArrayList<MarkerOverlay>();
    private BannerDisplayData bannerDisplay;
    private int hash;
    private boolean dirtyhash = true;
    private boolean needUpdateOverlay = true;

    public FrontierOverlay(FrontierData data, @Nullable IClientAPI jmAPI) {
        super(data);
        this.jmAPI = jmAPI;
        this.updateOverlay();
        if (this.banner != null) {
            this.bannerDisplay = new BannerDisplayData(this.banner);
        }
    }

    @Override
    public void updateFromData(FrontierData other) {
        super.updateFromData(other);
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = this.vertices.size() - 1;
        }
        if (other.hasChange(FrontierData.Change.Name) || other.hasChange(FrontierData.Change.Vertices) || other.hasChange(FrontierData.Change.Other)) {
            this.updateOverlay();
        }
        if (other.hasChange(FrontierData.Change.Banner)) {
            this.bannerDisplay = this.banner == null ? null : new BannerDisplayData(this.banner);
            this.dirtyhash = true;
        }
    }

    public int getHash() {
        if (this.dirtyhash) {
            this.dirtyhash = false;
            int prime = 31;
            this.hash = 1;
            this.hash = prime * this.hash + this.id.hashCode();
            this.hash = prime * this.hash + this.color;
            this.hash = prime * this.hash + (this.dimension == null ? 0 : this.dimension.hashCode());
            this.hash = prime * this.hash + (this.name1 == null ? 0 : this.name1.hashCode());
            this.hash = prime * this.hash + (this.name2 == null ? 0 : this.name2.hashCode());
            this.hash = prime * this.hash + (this.visible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenNameVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.fullscreenOwnerVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapNameVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.minimapOwnerVisible ? 1231 : 1237);
            this.hash = prime * this.hash + (this.announceInChat ? 1231 : 1237);
            this.hash = prime * this.hash + (this.announceInTitle ? 1231 : 1237);
            this.hash = prime * this.hash + (this.vertices == null ? 0 : this.vertices.hashCode());
            this.hash = prime * this.hash + (this.chunks == null ? 0 : this.chunks.hashCode());
            this.hash = prime * this.hash + this.mode.ordinal();
            this.hash = prime * this.hash + (this.banner == null ? 0 : this.banner.hashCode());
            this.hash = prime * this.hash + (this.usersShared == null ? 0 : this.usersShared.hashCode());
        }
        return this.hash;
    }

    public void updateOverlayIfNeeded() {
        if (this.needUpdateOverlay) {
            this.needUpdateOverlay = false;
            this.updateOverlay();
        }
    }

    public void updateOverlay() {
        this.dirtyhash = true;
        if (this.jmAPI == null) {
            return;
        }
        this.removeOverlay();
        this.recalculateOverlays();
        if (this.visible) {
            try {
                for (PolygonOverlay polygon : this.polygonOverlays) {
                    this.jmAPI.show((Displayable)polygon);
                }
                for (MarkerOverlay marker : this.markerOverlays) {
                    this.jmAPI.show((Displayable)marker);
                }
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    public void removeOverlay() {
        for (PolygonOverlay polygon : this.polygonOverlays) {
            this.jmAPI.remove((Displayable)polygon);
        }
        for (MarkerOverlay marker : this.markerOverlays) {
            this.jmAPI.remove((Displayable)marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointIsInside(class_2338 pos, double maxDistanceToOpen) {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.size() > 2) {
                return this.polygonArea != null && this.polygonArea.contains((double)pos.method_10263() + 0.5, (double)pos.method_10260() + 0.5);
            }
            if (maxDistanceToOpen > 0.0) {
                List list = this.vertices;
                synchronized (list) {
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        class_243 point = class_243.method_24954((class_2382)pos);
                        int y1 = pos.method_10264();
                        class_243 edge1 = class_243.method_24954((class_2382)((class_2338)this.vertices.get(i)).method_33096(y1));
                        int y = pos.method_10264();
                        class_243 edge2 = class_243.method_24954((class_2382)((class_2338)this.vertices.get((i + 1) % this.vertices.size())).method_33096(y));
                        double distance = FrontierOverlay.closestPointToEdge(point, edge1, edge2).method_1025(point);
                        if (!(distance <= maxDistanceToOpen * maxDistanceToOpen)) continue;
                        return true;
                    }
                }
            }
        } else if (pos.method_10263() >= this.topLeft.method_10263() && pos.method_10263() <= this.bottomRight.method_10263() && pos.method_10260() >= this.topLeft.method_10260() && pos.method_10260() <= this.bottomRight.method_10260()) {
            return this.chunks.contains(new class_1923(pos));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestVertex(class_2338 pos, double limit) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = limit * limit;
        int closest = -1;
        if (!this.vertices.isEmpty()) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    int y;
                    class_2338 vertex = (class_2338)this.vertices.get(i);
                    double dist = vertex.method_10262((class_2382)pos.method_33096(y = vertex.method_10264()));
                    if (!(dist <= distance)) continue;
                    distance = dist;
                    closest = i;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestEdge(class_2338 pos) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = Double.MAX_VALUE;
        int closest = -1;
        double angleSimilarity = -1.0;
        if (this.vertices.size() == 1) {
            closest = 0;
        } else if (this.vertices.size() > 1) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    double dist;
                    double dot;
                    class_243 point = class_243.method_24954((class_2382)pos);
                    int y1 = pos.method_10264();
                    class_243 edge1 = class_243.method_24954((class_2382)((class_2338)this.vertices.get(i)).method_33096(y1));
                    int y = pos.method_10264();
                    class_243 edge2 = class_243.method_24954((class_2382)((class_2338)this.vertices.get((i + 1) % this.vertices.size())).method_33096(y));
                    if (edge1.equals((Object)edge2)) {
                        dot = -1.0;
                        dist = point.method_1025(edge1);
                    } else {
                        class_243 closestPoint = FrontierOverlay.closestPointToEdge(point, edge1, edge2);
                        if (!closestPoint.equals((Object)edge1) && !closestPoint.equals((Object)edge2)) {
                            dot = -1.0;
                        } else {
                            class_243 toPos;
                            class_243 edge = edge2.method_1020(edge1);
                            class_241 edgeDirection = new class_241((float)edge.field_1352, (float)edge.field_1350).method_35581();
                            if (closestPoint.equals((Object)edge1)) {
                                toPos = point.method_1020(edge1);
                            } else {
                                edgeDirection = edgeDirection.method_35588();
                                toPos = point.method_1020(edge2);
                            }
                            class_241 toPosDirection = new class_241((float)toPos.field_1352, (float)toPos.field_1350).method_35581();
                            dot = toPosDirection.method_35583(edgeDirection);
                        }
                        dist = point.method_1025(closestPoint);
                    }
                    if (dist < distance) {
                        distance = dist;
                        closest = i;
                        angleSimilarity = dot;
                        continue;
                    }
                    if (dist != distance || !(dot > angleSimilarity)) continue;
                    closest = i;
                    angleSimilarity = dot;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    private static class_243 closestPointToEdge(class_243 point, class_243 edge1, class_243 edge2) {
        class_243 edge = edge2.method_1020(edge1);
        if (edge.field_1352 == 0.0 && edge.field_1350 == 0.0) {
            return edge1;
        }
        double u = ((point.field_1352 - edge1.field_1352) * edge.field_1352 + (point.field_1350 - edge1.field_1350) * edge.field_1350) / (edge.field_1352 * edge.field_1352 + edge.field_1350 * edge.field_1350);
        if (u < 0.0) {
            return edge1;
        }
        if (u > 1.0) {
            return edge2;
        }
        return new class_243(edge1.field_1352 + u * edge.field_1352, point.field_1351, edge1.field_1350 + u * edge.field_1350);
    }

    @Override
    public void setId(UUID id) {
        super.setId(id);
        this.needUpdateOverlay = true;
    }

    @Override
    public void addVertex(class_2338 pos) {
        this.addVertex(pos, this.vertexSelected + 1, Config.snapDistance);
        this.selectNextVertex();
    }

    public void addVertex(class_2338 pos, int index, int snapDistance) {
        if (snapDistance != 0) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.addVertex(pos, index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void removeVertex(int index) {
        super.removeVertex(index);
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean toggleChunk(class_1923 chunk) {
        boolean added = super.toggleChunk(chunk);
        this.needUpdateOverlay = true;
        return added;
    }

    @Override
    public boolean addChunk(class_1923 chunk) {
        if (super.addChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChunk(class_1923 chunk) {
        if (super.removeChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    public void moveSelectedVertex(class_2338 pos, float snapDistance) {
        if (this.vertexSelected < 0 || this.vertexSelected >= this.vertices.size()) {
            return;
        }
        if (snapDistance != 0.0f) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.moveVertex(pos, this.vertexSelected);
        this.needUpdateOverlay = true;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    @Override
    public void setName1(String name) {
        super.setName1(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setName2(String name) {
        super.setName2(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.vertexSelected = -1;
        }
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenVisible(boolean visible) {
        super.setFullscreenVisible(visible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenNameVisible(boolean nameVisible) {
        super.setFullscreenNameVisible(nameVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setFullscreenOwnerVisible(boolean ownerVisible) {
        super.setFullscreenOwnerVisible(ownerVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapVisible(boolean visible) {
        super.setMinimapVisible(visible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapNameVisible(boolean nameVisible) {
        super.setMinimapNameVisible(nameVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setMinimapOwnerVisible(boolean ownerVisible) {
        super.setMinimapOwnerVisible(ownerVisible);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        super.setDimension(dimension);
        this.dirtyhash = true;
    }

    @Override
    public void setBanner(@Nullable class_1799 itemBanner) {
        super.setBanner(itemBanner);
        this.needUpdateOverlay = true;
        this.bannerDisplay = itemBanner == null ? null : new BannerDisplayData(this.banner);
    }

    @Override
    public void setBanner(class_1767 base, class_9307 bannerPatterns) {
        super.setBanner(base, bannerPatterns);
        this.bannerDisplay = new BannerDisplayData(this.banner);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setBannerData(@Nullable FrontierData.BannerData bannerData) {
        super.setBannerData(bannerData);
        this.needUpdateOverlay = true;
        this.bannerDisplay = bannerData == null ? null : new BannerDisplayData(this.banner);
    }

    @Override
    public void addUserShared(SettingsUserShared userShared) {
        super.addUserShared(userShared);
        this.dirtyhash = true;
    }

    @Override
    public void removeUserShared(int index) {
        super.removeUserShared(index);
        this.dirtyhash = true;
    }

    @Override
    public void setUsersShared(List<SettingsUserShared> usersShared) {
        super.setUsersShared(usersShared);
        this.dirtyhash = true;
    }

    public class_2338 getClosestVertex(class_2338 vertex, double belowDistance) {
        class_2338 closest = null;
        double closestDistance = belowDistance;
        for (PolygonOverlay overlay : this.polygonOverlays) {
            for (class_2338 v : overlay.getOuterArea().getPoints()) {
                double distance = v.method_10262((class_2382)vertex);
                if (!(distance <= closestDistance)) continue;
                closestDistance = distance;
                closest = v;
            }
            if (overlay.getHoles() == null) continue;
            for (MapPolygon hole : overlay.getHoles()) {
                for (class_2338 v : hole.getPoints()) {
                    double distance = v.method_10262((class_2382)vertex);
                    if (!(distance <= closestDistance)) continue;
                    closestDistance = distance;
                    closest = v;
                }
            }
        }
        return closest;
    }

    public void renderBanner(class_310 mc, class_332 graphics, int x, int y, int scale) {
        if (this.bannerDisplay == null || this.bannerDisplay.patternLayers == null) {
            return;
        }
        this.renderBannerLayer(graphics, x, y, scale, class_4722.field_49769.method_24144(), class_4722.field_49769.method_24148(), this.banner.baseColor);
        for (int i = 0; i < this.bannerDisplay.patternLayers.comp_2428().size(); ++i) {
            class_9307.class_9308 layer = (class_9307.class_9308)this.bannerDisplay.patternLayers.comp_2428().get(i);
            class_2960 patternTextureLocation = ((class_2582)layer.comp_2429().comp_349()).comp_2456().method_45138("entity/banner/");
            class_1058 sprite = (class_1058)mc.method_1549(class_4722.field_21706).apply(patternTextureLocation);
            this.renderBannerLayer(graphics, x, y, scale, class_4722.field_21706, sprite, layer.comp_2430());
        }
    }

    private void renderBannerLayer(class_332 graphics, int x, int y, int scale, class_2960 sheet, class_1058 sprite, class_1767 dye) {
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)sheet);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        class_289 tesselator = class_289.method_1348();
        class_287 buf = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        int color = dye.method_7787();
        int width = 22 * scale;
        int height = 40 * scale;
        float zLevel = 0.0f;
        float u1 = sprite.method_4594();
        float u2 = sprite.method_4594() + 0.04296875f;
        float v1 = sprite.method_4593() + 0.001953125f;
        float v2 = sprite.method_4593() + 0.080078125f;
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        buf.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913(u1, v2).method_39415(color);
        buf.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913(u2, v2).method_39415(color);
        buf.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913(u2, v1).method_39415(color);
        buf.method_22918(matrix, (float)x, (float)y, zLevel).method_22913(u1, v1).method_39415(color);
        class_286.method_43433((class_9801)buf.method_60800());
        RenderSystem.disableBlend();
    }

    public void removeSelectedVertex() {
        if (this.vertexSelected < 0) {
            return;
        }
        super.removeVertex(this.vertexSelected);
        this.vertexSelected = this.vertices.isEmpty() ? -1 : (this.vertexSelected > 0 ? --this.vertexSelected : this.vertices.size() - 1);
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
        this.needUpdateOverlay = true;
    }

    public void selectNextVertex() {
        ++this.vertexSelected;
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = -1;
        }
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    public int getSelectedVertexIndex() {
        return this.vertexSelected;
    }

    public class_2338 getSelectedVertex() {
        if (this.vertexSelected >= 0 && this.vertexSelected < this.vertices.size()) {
            return (class_2338)this.vertices.get(this.vertexSelected);
        }
        return null;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.needUpdateOverlay = true;
    }

    public class_2338 getCenter() {
        return new class_2338((this.topLeft.method_10263() + this.bottomRight.method_10263()) / 2, 70, (this.topLeft.method_10260() + this.bottomRight.method_10260()) / 2);
    }

    private class_2338 snapVertex(class_2338 vertex, float snapDistance) {
        class_2338 v;
        class_2338 closest = vertex.method_33096(70);
        double closestDistance = snapDistance * snapDistance;
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers((class_5321<class_1937>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(closest, closestDistance)) == null) continue;
            closest = v;
            closestDistance = v.method_10262((class_2382)vertex);
        }
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers((class_5321<class_1937>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(closest, closestDistance)) == null) continue;
            closest = v;
            closestDistance = v.method_10262((class_2382)vertex);
        }
        return closest;
    }

    private void recalculateOverlays() {
        this.polygonOverlays.clear();
        this.markerOverlays.clear();
        this.updateBounds();
        this.area = 0.0f;
        this.perimeter = 0.0f;
        this.polygonArea = null;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(this.highlighted ? 3.0f : 0.0f).setStrokeColor(-1).setFillColor(this.color).setFillOpacity((float)Config.polygonsOpacity);
        if (this.mode == FrontierData.Mode.Vertex) {
            this.recalculateVertices(shapeProps);
        } else {
            this.recalculateChunks(shapeProps);
        }
    }

    private void addPolygonOverlays(ShapeProperties shapeProps, MapPolygon polygon, @Nullable List<MapPolygon> polygonHoles) {
        PolygonOverlay polygonOverlay = null;
        PolygonOverlay polygonOverlayFullscreen = null;
        PolygonOverlay polygonOverlayMinimap = null;
        boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.fullscreenVisible);
        boolean fullscreenNameV = Config.getVisibilityValue(Config.fullscreenNameVisibility, this.fullscreenNameVisible);
        boolean fullscreenOwnerV = Config.getVisibilityValue(Config.fullscreenOwnerVisibility, this.fullscreenOwnerVisible);
        boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.minimapVisible);
        boolean minimapNameV = Config.getVisibilityValue(Config.minimapNameVisibility, this.minimapNameVisible);
        boolean minimapOwnerV = Config.getVisibilityValue(Config.minimapOwnerVisibility, this.minimapOwnerVisible);
        if (fullscreenV && minimapV && fullscreenNameV == minimapNameV && fullscreenOwnerV == minimapOwnerV) {
            polygonOverlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            polygonOverlay.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen, Context.UI.Minimap, Context.UI.Webmap});
        } else {
            if (fullscreenV) {
                polygonOverlayFullscreen = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
                polygonOverlayFullscreen.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen});
            }
            if (minimapV) {
                polygonOverlayMinimap = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
                polygonOverlayMinimap.setActiveUIs(new Context.UI[]{Context.UI.Minimap, Context.UI.Webmap});
            }
        }
        if (polygonOverlay != null) {
            this.addNameAndOwner(polygonOverlay, fullscreenNameV, fullscreenOwnerV);
            this.polygonOverlays.add(polygonOverlay);
        } else {
            if (polygonOverlayFullscreen != null) {
                this.addNameAndOwner(polygonOverlayFullscreen, fullscreenNameV, fullscreenOwnerV);
                this.polygonOverlays.add(polygonOverlayFullscreen);
            }
            if (polygonOverlayMinimap != null) {
                this.addNameAndOwner(polygonOverlayMinimap, minimapNameV, minimapOwnerV);
                this.polygonOverlays.add(polygonOverlayMinimap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateVertices(ShapeProperties shapeProps) {
        List list = this.vertices;
        synchronized (list) {
            if (this.vertices.size() > 2) {
                MapPolygon polygon = new MapPolygon(this.vertices);
                this.addPolygonOverlays(shapeProps, polygon, null);
                this.polygonArea = PolygonHelper.toArea((MapPolygon)polygon);
                class_2338 last = (class_2338)this.vertices.getLast();
                for (class_2338 vertex : this.vertices) {
                    this.area += (float)Math.abs(vertex.method_10260() + last.method_10260()) / 2.0f * (float)(vertex.method_10263() - last.method_10263());
                    last = vertex;
                }
                this.area = Math.abs(this.area);
            } else {
                boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.fullscreenVisible);
                boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.minimapVisible);
                if (fullscreenV || minimapV) {
                    ArrayList<Context.UI> ui = new ArrayList<Context.UI>();
                    if (fullscreenV && minimapV) {
                        ui.add(Context.UI.Fullscreen);
                        ui.add(Context.UI.Minimap);
                        ui.add(Context.UI.Webmap);
                    } else if (fullscreenV) {
                        ui.add(Context.UI.Fullscreen);
                    } else {
                        ui.add(Context.UI.Minimap);
                        ui.add(Context.UI.Webmap);
                    }
                    Context.UI[] uiArray = ui.toArray(new Context.UI[0]);
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        MarkerOverlay marker = new MarkerOverlay("mapfrontiers", (class_2338)this.vertices.get(i), markerVertex);
                        marker.setDimension(this.dimension);
                        marker.setDisplayOrder(100);
                        marker.setActiveUIs(uiArray);
                        this.markerOverlays.add(marker);
                        if (i != 0 || this.vertices.size() != 2) continue;
                        this.addMarkerDots((class_2338)this.vertices.get(0), (class_2338)this.vertices.get(1));
                    }
                }
            }
            if (this.vertices.size() > 1) {
                class_2338 last = (class_2338)this.vertices.getLast();
                for (class_2338 vertex : this.vertices) {
                    this.perimeter += (float)Math.sqrt(vertex.method_10262((class_2382)last));
                    last = vertex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateChunks(ShapeProperties shapeProps) {
        HashMultimap edges = HashMultimap.create();
        Set set = this.chunks;
        synchronized (set) {
            for (class_1923 chunk : this.chunks) {
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180 + 1));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180));
            }
        }
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            class_1923 edge2;
            class_1923 starting = (class_1923)Collections.min(edges.keySet(), (e1, e2) -> e1.field_9181 == e2.field_9181 ? e1.field_9180 - e2.field_9180 : e1.field_9181 - e2.field_9181);
            ArrayList<class_1923> arrayList = new ArrayList<class_1923>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((class_1923)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (class_1923)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.field_9181 - ((class_1923)edge).field_9181 + ((class_1923)edge).field_9180 - edge2.field_9180)) {
                    edge2 = (class_1923)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.field_9181 - ((class_1923)edge).field_9181 + edge2.field_9180 - ((class_1923)edge).field_9180;
            } while (!(edge = edge2).equals((Object)starting));
            this.perimeter += (float)(arrayList.size() * 16);
            boolean bl = clockwise = ((class_1923)arrayList.get((int)0)).field_9181 != ((class_1923)arrayList.get((int)1)).field_9181;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            class_1923 ray = (class_1923)arrayList.getFirst();
            class_1923 outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    class_1923 outerStart = (class_1923)list.getFirst();
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new class_1923(ray.field_9181 - 1, ray.field_9180);
            }
            if (outerFound != null) {
                holesPolygons.put(outerFound, arrayList);
                continue;
            }
            MapFrontiers.LOGGER.warn(String.format("Frontier %1$s is too large and the polygon corresponding to the hole %2$s could not be located", this.id, arrayList.getFirst()));
        }
        for (List list : outerPolygons) {
            FrontierOverlay.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                FrontierOverlay.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            MapPolygon polygon = new MapPolygon(list.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328())).toList());
            ArrayList<MapPolygon> polygonHoles = null;
            if (holesPolygons.containsKey(list.getFirst())) {
                polygonHoles = new ArrayList<MapPolygon>();
                for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                    polygonHoles.add(new MapPolygon(hole.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328())).toList()));
                }
            }
            this.addPolygonOverlays(shapeProps, polygon, polygonHoles);
        }
        this.area = this.chunks.size() * 256;
    }

    private static void addNewEdge(Multimap<class_1923, class_1923> edges, class_1923 from, class_1923 to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    private static void removeCollinear(List<class_1923> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        class_1923 prev = chunks.getFirst();
        for (int i = chunks.size() - 1; i > 0; --i) {
            class_1923 next = chunks.get(i - 1);
            if (prev.field_9181 == next.field_9181 || prev.field_9180 == next.field_9180) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private void addNameAndOwner(PolygonOverlay polygonOverlay, boolean nameVisible, boolean ownerVisible) {
        if (!nameVisible && !ownerVisible) {
            return;
        }
        TextProperties textProps = new TextProperties().setColor(this.color).setScale(2.0f).setBackgroundOpacity(0.0f);
        if (Config.hideNamesThatDontFit) {
            if (this.mode == FrontierData.Mode.Vertex) {
                textProps = this.setMinSizeTextProperties(textProps, this.bottomRight.method_10263() - this.topLeft.method_10263(), nameVisible, ownerVisible);
            } else {
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                for (class_2338 vertex : polygonOverlay.getOuterArea().getPoints()) {
                    if (vertex.method_10263() < minX) {
                        minX = vertex.method_10263();
                    }
                    if (vertex.method_10263() <= maxX) continue;
                    maxX = vertex.method_10263();
                }
                textProps = this.setMinSizeTextProperties(textProps, maxX - minX, nameVisible, ownerVisible);
            }
        }
        int lines = 0;
        Object label = "";
        if (nameVisible) {
            if (!this.name1.isEmpty()) {
                ++lines;
                label = (String)label + this.name1 + "\n";
            }
            if (!this.name2.isEmpty()) {
                ++lines;
                label = (String)label + this.name2 + "\n";
            }
        }
        if (ownerVisible && !this.owner.username.isEmpty()) {
            ++lines;
            label = (String)label + String.valueOf(class_124.field_1056) + this.owner.username + "\n";
        }
        if (lines > 0) {
            if (lines > 1) {
                textProps.setOffsetY(10);
            }
            polygonOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
        }
    }

    private TextProperties setMinSizeTextProperties(TextProperties textProperties, int polygonWidth, boolean nameVisible, boolean ownerVisible) {
        int zoom;
        int name1Width = nameVisible ? class_310.method_1551().field_1772.method_1727(this.name1) * 2 : 0;
        int name2Width = nameVisible ? class_310.method_1551().field_1772.method_1727(this.name2) * 2 : 0;
        int ownerWidth = ownerVisible ? class_310.method_1551().field_1772.method_1727(this.owner.username) * 2 : 0;
        int labelWidth = Math.max(ownerWidth, Math.max(name1Width, name2Width)) + 6;
        float polygonWidthScaled = (float)polygonWidth / 256.0f;
        for (zoom = 2; (float)labelWidth > polygonWidthScaled && zoom < 8192; zoom *= 2, polygonWidthScaled *= 2.0f) {
        }
        return textProperties.setMinZoom(zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.isEmpty()) {
                this.topLeft = new class_2338(0, 70, 0);
                this.bottomRight = new class_2338(0, 70, 0);
            } else {
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                List list = this.vertices;
                synchronized (list) {
                    for (class_2338 vertex : this.vertices) {
                        if (vertex.method_10263() < minX) {
                            minX = vertex.method_10263();
                        }
                        if (vertex.method_10260() < minZ) {
                            minZ = vertex.method_10260();
                        }
                        if (vertex.method_10263() > maxX) {
                            maxX = vertex.method_10263();
                        }
                        if (vertex.method_10260() <= maxZ) continue;
                        maxZ = vertex.method_10260();
                    }
                }
                this.topLeft = new class_2338(minX, 70, minZ);
                this.bottomRight = new class_2338(maxX, 70, maxZ);
            }
        } else if (this.chunks.isEmpty()) {
            this.topLeft = new class_2338(0, 70, 0);
            this.bottomRight = new class_2338(0, 70, 0);
        } else {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Set set = this.chunks;
            synchronized (set) {
                for (class_1923 chunk : this.chunks) {
                    if (chunk.field_9181 < minX) {
                        minX = chunk.field_9181;
                    }
                    if (chunk.field_9180 < minZ) {
                        minZ = chunk.field_9180;
                    }
                    if (chunk.field_9181 > maxX) {
                        maxX = chunk.field_9181;
                    }
                    if (chunk.field_9180 <= maxZ) continue;
                    maxZ = chunk.field_9180;
                }
            }
            this.topLeft = new class_2338(minX * 16, 70, minZ * 16);
            this.bottomRight = new class_2338(maxX * 16 + 16, 70, maxZ * 16 + 16);
        }
    }

    private void addMarkerDots(class_2338 from, class_2338 to) {
        if (Math.abs(to.method_10260() - from.method_10260()) < Math.abs(to.method_10263() - from.method_10263())) {
            if (from.method_10263() > to.method_10263()) {
                this.addLineMarkerDots(to.method_10263(), to.method_10260(), from.method_10263(), from.method_10260());
            } else {
                this.addLineMarkerDots(from.method_10263(), from.method_10260(), to.method_10263(), to.method_10260());
            }
        } else if (from.method_10260() > to.method_10260()) {
            this.addLineMarkerDots(to.method_10263(), to.method_10260(), from.method_10263(), from.method_10260());
        } else {
            this.addLineMarkerDots(from.method_10263(), from.method_10260(), to.method_10263(), to.method_10260());
        }
    }

    private void addLineMarkerDots(int x0, int z0, int x1, int z1) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dz = -Math.abs(z1 - z0);
        int sz = z0 < z1 ? 1 : -1;
        int err = dx + dz;
        int i = 0;
        while (x0 != x1 || z0 != z1) {
            int e2 = 2 * err;
            if (e2 >= dz) {
                if (x0 == x1) break;
                err += dz;
                x0 += sx;
            }
            if (e2 <= dx) {
                if (z0 == z1) break;
                err += dx;
                z0 += sz;
            }
            class_2338 pos = new class_2338(x0, 70, z0);
            MarkerOverlay dot = new MarkerOverlay("mapfrontiers", pos, markerDot);
            dot.setDimension(this.dimension);
            dot.setDisplayOrder(99);
            int minZoom = 2;
            if (i % 2 == 0) {
                minZoom = 16384;
            } else if (i % 4 == 1) {
                minZoom = 8192;
            } else if (i % 8 == 3) {
                minZoom = 4096;
            }
            dot.setMinZoom(minZoom);
            this.markerOverlays.add(dot);
            ++i;
        }
    }

    static {
        markerVertex.setAnchorX(markerVertex.getDisplayWidth() / 2.0).setAnchorY(markerVertex.getDisplayHeight() / 2.0);
        markerDot.setAnchorX(markerDot.getDisplayWidth() / 2.0).setAnchorY(markerDot.getDisplayHeight() / 2.0);
    }

    public static class BannerDisplayData {
        public class_9307 patternLayers;

        public BannerDisplayData(FrontierData.BannerData bannerData) {
            class_638 level = class_310.method_1551().field_1687;
            Optional bannerPatterns = class_9307.field_49405.parse((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)bannerData.patterns).result();
            bannerPatterns.ifPresentOrElse(p -> {
                this.patternLayers = p;
            }, () -> MapFrontiers.LOGGER.error("Error creating banner pattern layers"));
        }
    }
}

