/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierList;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.client.gui.screen.StackeableScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_746;

@ParametersAreNonnullByDefault
public class FullscreenMap {
    private final IClientAPI jmAPI;
    private class_437 fullscreen;
    private FrontierOverlay frontierHighlighted;
    private IThemeButton buttonFrontiers;
    private IThemeButton buttonNew;
    private IThemeButton buttonInfo;
    private IThemeButton buttonEdit;
    private IThemeButton buttonVisible;
    private IThemeButton buttonDelete;
    private boolean editing = false;
    private ChunkDrawing drawingChunk = ChunkDrawing.Nothing;
    private class_1923 lastEditedChunk;

    public FullscreenMap(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> {
            if (this.frontierHighlighted != null && this.frontierHighlighted.getId().equals(frontierID)) {
                this.frontierHighlighted = null;
                this.editing = false;
                this.updateButtons();
            }
        });
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> {
            UIState uiState = jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState == null || frontierOverlay.getDimension() != uiState.dimension) {
                return;
            }
            class_746 localPlayer = class_310.method_1551().field_1724;
            if (playerID == -1 || localPlayer != null && localPlayer.method_5628() == playerID.intValue()) {
                this.stopEditing();
                if (this.frontierHighlighted != null) {
                    this.frontierHighlighted.setHighlighted(false);
                }
                this.frontierHighlighted = frontierOverlay;
                this.frontierHighlighted.setHighlighted(true);
                this.updateButtons();
                if (Config.afterCreatingFrontier == Config.AfterCreatingFrontier.Edit) {
                    this.buttonEditToggled();
                } else if (Config.afterCreatingFrontier == Config.AfterCreatingFrontier.Info) {
                    this.buttonInfoPressed();
                }
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> {
            if (this.frontierHighlighted != null && this.frontierHighlighted.getId().equals(frontierOverlay.getId())) {
                this.frontierHighlighted = frontierOverlay;
                this.frontierHighlighted.setHighlighted(true);
                this.editing = false;
                this.updateButtons();
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent(this, profile -> this.updateButtons());
        ClientEventHandler.subscribeMouseReleaseEvent(this, button -> {
            if (button != 1) {
                return;
            }
            if (!this.editing || this.drawingChunk == ChunkDrawing.Nothing || this.frontierHighlighted.getMode() != FrontierData.Mode.Chunk) {
                return;
            }
            this.drawingChunk = ChunkDrawing.Nothing;
        });
    }

    public void close() {
        if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
        }
        ClientEventHandler.unsuscribeAllEvents(this);
    }

    public void addButtons(ThemeButtonDisplay buttonDisplay, class_437 fullscreen) {
        this.fullscreen = fullscreen;
        String path = "textures/gui/journeymap/";
        this.buttonFrontiers = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_frontiers", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "frontiers.png")), b -> this.buttonFrontiersPressed());
        this.buttonNew = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_new_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "new_frontier.png")), b -> this.buttonNewPressed());
        this.buttonInfo = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_frontier_info", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "info_frontier.png")), b -> this.buttonInfoPressed());
        this.buttonEdit = buttonDisplay.addThemeToggleButton(class_1074.method_4662((String)"mapfrontiers.button_done_editing", (Object[])new Object[0]), class_1074.method_4662((String)"mapfrontiers.button_edit_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "edit_frontier.png")), this.editing, b -> this.buttonEditToggled());
        this.buttonVisible = buttonDisplay.addThemeToggleButton(class_1074.method_4662((String)"mapfrontiers.button_hide_frontier", (Object[])new Object[0]), class_1074.method_4662((String)"mapfrontiers.button_show_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "visible_frontier.png")), false, b -> this.buttonVisibleToggled());
        this.buttonDelete = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_delete_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "delete_frontier.png")), b -> this.buttonDelete());
        this.updateButtons();
    }

    public void addPopupMenu(ModPopupMenu popupMenu) {
        if (this.editing && this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex) {
            popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.add_vertex", (Object[])new Object[0]), this::buttonAddVertex);
            if (this.frontierHighlighted.getSelectedVertexIndex() != -1) {
                popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.remove_vertex", (Object[])new Object[0]), p -> this.buttonRemoveVertex());
            }
        }
    }

    public void stopEditing() {
        if (this.editing) {
            this.editing = false;
            boolean personalFrontier = this.frontierHighlighted.getPersonal();
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
            frontierManager.clientUpdateFrontier(this.frontierHighlighted);
        }
    }

    public void updateButtons() {
        class_746 player = class_310.method_1551().field_1724;
        if (this.buttonInfo == null || player == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)player);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontierHighlighted, playerUser);
        this.buttonFrontiers.setEnabled(!this.editing);
        this.buttonNew.setEnabled(!this.editing);
        this.buttonInfo.setEnabled(this.frontierHighlighted != null && !this.editing);
        this.buttonEdit.setEnabled(actions.canUpdate && this.frontierHighlighted.getVisible() && this.frontierHighlighted.getFullscreenVisible());
        this.buttonVisible.setEnabled(actions.canUpdate && !this.editing);
        this.buttonDelete.setEnabled(actions.canDelete && !this.editing);
        if (this.frontierHighlighted != null) {
            this.buttonVisible.setToggled(Boolean.valueOf(this.frontierHighlighted.getVisible() && this.frontierHighlighted.getFullscreenVisible()));
        } else {
            this.buttonVisible.setToggled(Boolean.valueOf(false));
        }
    }

    private void buttonFrontiersPressed() {
        StackeableScreen.open(new FrontierList(this.jmAPI, this, this.fullscreen));
    }

    private void buttonNewPressed() {
        if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
            this.frontierHighlighted = null;
        }
        StackeableScreen.open(new NewFrontier(this.jmAPI, this.fullscreen));
        this.updateButtons();
    }

    private void buttonInfoPressed() {
        StackeableScreen.open(new FrontierInfo(this.jmAPI, this.frontierHighlighted, this.fullscreen));
    }

    private void buttonEditToggled() {
        this.buttonEdit.toggle();
        boolean toggled = this.buttonEdit.getToggled();
        if (toggled) {
            this.editing = true;
            this.drawingChunk = ChunkDrawing.Nothing;
        } else {
            this.stopEditing();
        }
        this.updateButtons();
    }

    private void buttonVisibleToggled() {
        this.frontierHighlighted.setVisible(this.buttonVisible.getToggled() == false);
        boolean personalFrontier = this.frontierHighlighted.getPersonal();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
        frontierManager.clientUpdateFrontier(this.frontierHighlighted);
        this.updateButtons();
    }

    private void buttonDelete() {
        if (this.editing) {
            this.stopEditing();
        }
        boolean personalFrontier = this.frontierHighlighted.getPersonal();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
        frontierManager.clientDeleteFrontier(this.frontierHighlighted);
        this.frontierHighlighted = null;
        this.updateButtons();
    }

    private void buttonAddVertex(class_2338 pos) {
        this.frontierHighlighted.selectClosestEdge(pos);
        this.frontierHighlighted.addVertex(pos);
        this.updateButtons();
    }

    private void buttonRemoveVertex() {
        this.frontierHighlighted.removeSelectedVertex();
        this.updateButtons();
    }

    public boolean isEditingVertices() {
        return this.editing && this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex;
    }

    public boolean isEditingChunks() {
        return this.editing && this.frontierHighlighted.getMode() == FrontierData.Mode.Chunk;
    }

    public FrontierOverlay getSelected() {
        return this.frontierHighlighted;
    }

    public void selectFrontier(@Nullable FrontierOverlay frontier) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState != null && frontier != null && frontier.getDimension().equals((Object)uiState.dimension)) {
            if (this.frontierHighlighted != frontier) {
                if (this.frontierHighlighted != null) {
                    this.frontierHighlighted.setHighlighted(false);
                }
                this.frontierHighlighted = frontier;
                this.frontierHighlighted.setHighlighted(true);
            }
        } else if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
            this.frontierHighlighted = null;
        }
        this.updateButtons();
    }

    public boolean mapClicked(class_5321<class_1937> dimension, class_2338 position, int button) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState == null) {
            return false;
        }
        double maxDistanceToClosest = Math.max(2.0, 8192.0 / (double)uiState.zoom);
        if (this.editing && this.frontierHighlighted != null) {
            if (this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex) {
                this.frontierHighlighted.selectClosestVertex(position, maxDistanceToClosest);
            } else if (button == 1) {
                this.lastEditedChunk = new class_1923(position);
                this.drawingChunk = this.frontierHighlighted.toggleChunk(this.lastEditedChunk) ? ChunkDrawing.Adding : ChunkDrawing.Removing;
                return true;
            }
            return false;
        }
        FrontiersOverlayManager globalManager = MapFrontiersClient.getFrontiersOverlayManager(false);
        FrontiersOverlayManager personalManager = MapFrontiersClient.getFrontiersOverlayManager(true);
        if (globalManager == null || personalManager == null) {
            return false;
        }
        FrontierOverlay newFrontierHighlighted = personalManager.getFrontierInPosition(dimension, position, maxDistanceToClosest);
        if (newFrontierHighlighted == null) {
            newFrontierHighlighted = globalManager.getFrontierInPosition(dimension, position, maxDistanceToClosest);
        }
        this.selectFrontier(newFrontierHighlighted);
        return false;
    }

    public boolean mapDragged(class_5321<class_1937> dimension, class_2338 position) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState == null || !this.editing) {
            return false;
        }
        if (this.frontierHighlighted == null || !this.frontierHighlighted.getDimension().equals(dimension)) {
            return false;
        }
        if (this.frontierHighlighted.getMode() == FrontierData.Mode.Chunk) {
            return false;
        }
        if (this.frontierHighlighted.getSelectedVertexIndex() == -1) {
            return false;
        }
        float snapDistance = (float)Math.pow(2.0, Math.max(4.0 - (double)uiState.zoom, 1.0));
        this.frontierHighlighted.moveSelectedVertex(position, snapDistance);
        return true;
    }

    public void mouseMoved(class_5321<class_1937> dimension, class_2338 position) {
        if (!this.editing || this.drawingChunk == ChunkDrawing.Nothing) {
            return;
        }
        if (this.frontierHighlighted == null || !this.frontierHighlighted.getDimension().equals(dimension)) {
            return;
        }
        if (this.frontierHighlighted.getMode() != FrontierData.Mode.Chunk) {
            return;
        }
        class_1923 chunk = new class_1923(position);
        if (chunk.equals((Object)this.lastEditedChunk)) {
            return;
        }
        this.lastEditedChunk = chunk;
        if (this.drawingChunk == ChunkDrawing.Adding) {
            this.frontierHighlighted.addChunk(chunk);
        } else {
            this.frontierHighlighted.removeChunk(chunk);
        }
    }

    private static enum ChunkDrawing {
        Nothing,
        Adding,
        Removing;

    }
}

