/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.awt.Color;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class ColorPicker
extends AbstractWidgetNoNarration {
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/color_picker.png");
    private static final int textureSizeX = 274;
    private static final int textureSizeY = 134;
    private static final int[] palette = new int[]{-65536, Short.MIN_VALUE, -256, -8323328, -16711936, -16711808, -16711681, -16744193, -16776961, -8388353, -65281, -65408, -11063545, -16777216, -12566464, -8355712, -4210753, -1};
    private static final int[] paletteInactive = new int[]{-13355980, -10921639, -8487298, -9737365, -10987432, -10526881, -10066330, -12434878, -14935012, -13684945, -12434878, -12895429, -14079703, -15856114, -13750738, -11711155, -9605779, -7500403};
    private double hsX;
    private double hsY;
    private double v;
    private int color;
    private int colorFullBrightness;
    private boolean hsGrabbed = false;
    private boolean vGrabbed = false;
    private final BiConsumer<ColorPicker, Boolean> callbackColorUpdated;

    public ColorPicker(int x, int y, int color, BiConsumer<ColorPicker, Boolean> callbackColorUpdated) {
        super(x, y, 304, 127, (class_2561)class_2561.method_43473());
        this.callbackColorUpdated = callbackColorUpdated;
        this.setColor(color);
    }

    public void setColor(int newColor) {
        this.color = newColor;
        float[] hsv = Color.RGBtoHSB((newColor & 0xFF0000) >> 16, (newColor & 0xFF00) >> 8, newColor & 0xFF, null);
        double angle = (double)hsv[0] * Math.PI * 2.0;
        double dist = (double)hsv[1] * 64.0;
        this.hsX = dist * Math.cos(angle);
        this.hsY = dist * Math.sin(angle);
        this.v = 127.5 - (double)hsv[2] * 127.5;
        this.colorFullBrightness = Color.HSBtoRGB(hsv[0], hsv[1], 1.0f);
    }

    public int getColor() {
        return this.color;
    }

    public boolean method_25361(double mouseX, double mouseY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_25361(mouseX, mouseY);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.hsGrabbed = false;
        this.vGrabbed = false;
        this.updateMouse(mouseX, mouseY, false);
        if (!this.hsGrabbed && !this.vGrabbed) {
            double paletteX = (mouseX - (double)(this.method_46426() + 165)) / 23.0;
            double paletteY = (mouseY - (double)(this.method_46427() + 57)) / 23.0;
            if (paletteX >= 0.0 && paletteX < 6.0 && paletteY >= 0.0 && paletteY < 3.0) {
                this.setColor(palette[(int)paletteX + (int)paletteY * 6]);
                this.callbackColorUpdated.accept(this, false);
            }
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(mouseX, mouseY, false);
        this.hsGrabbed = false;
        this.vGrabbed = false;
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(mouseX, mouseY, true);
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texX = this.field_22763 ? 0 : 137;
        graphics.method_25290(texture, this.method_46426(), this.method_46427(), (float)texX, 0.0f, 128, 128, 274, 134);
        if (this.field_22763) {
            RenderSystem.setShaderColor((float)((float)((this.colorFullBrightness & 0xFF0000) >> 16) / 255.0f), (float)((float)((this.colorFullBrightness & 0xFF00) >> 8) / 255.0f), (float)((float)(this.colorFullBrightness & 0xFF) / 255.0f), (float)1.0f);
        }
        graphics.method_25290(texture, this.method_46426() + 132, this.method_46427(), (float)(texX + 129), 0.0f, 8, 128, 274, 134);
        if (!this.field_22763) {
            RenderSystem.setShaderColor((float)((float)((this.colorFullBrightness & 0xFF0000) >> 16) / 255.0f), (float)((float)((this.colorFullBrightness & 0xFF00) >> 8) / 255.0f), (float)((float)(this.colorFullBrightness & 0xFF) / 255.0f), (float)1.0f);
        }
        graphics.method_25294(this.method_46426() + (int)this.hsX + 64, this.method_46427() + (int)this.hsY + 64, this.method_46426() + (int)this.hsX + 65, this.method_46427() + (int)this.hsY + 65, this.colorFullBrightness);
        graphics.method_25294(this.method_46426() + 131, this.method_46427() + (int)this.v, this.method_46426() + 139, this.method_46427() + (int)this.v + 1, this.color);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(texture, this.method_46426() + (int)this.hsX + 64 - 2, this.method_46427() + (int)this.hsY + 64 - 2, (float)texX, 129.0f, 5, 5, 274, 134);
        graphics.method_25290(texture, this.method_46426() + 131, this.method_46427() + (int)this.v - 2, (float)(texX + 6), 129.0f, 10, 5, 274, 134);
        graphics.method_25294(this.method_46426() + 165, this.method_46427() + 58, this.method_46426() + 304, this.method_46427() + 128, -16777216);
        int col = 0;
        int row = 0;
        for (int c : this.field_22763 ? palette : paletteInactive) {
            if (this.field_22763 && c == this.color) {
                graphics.method_25294(this.method_46426() + 165 + col * 23, this.method_46427() + 58 + row * 23, this.method_46426() + 189 + col * 23, this.method_46427() + 82 + row * 23, -1);
            }
            graphics.method_25294(this.method_46426() + 166 + col * 23, this.method_46427() + 59 + row * 23, this.method_46426() + 188 + col * 23, this.method_46427() + 81 + row * 23, c);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
    }

    private void updateMouse(double mouseX, double mouseY, boolean dragging) {
        double localY;
        double localX;
        if (!this.vGrabbed) {
            localX = mouseX - (double)(this.method_46426() + 64);
            double dist = Math.sqrt(localX * localX + (localY = mouseY - (double)(this.method_46427() + 64)) * localY);
            if (dist < 66.0) {
                this.hsGrabbed = true;
            }
            if (this.hsGrabbed) {
                if (dist >= 64.0) {
                    localX = localX / dist * 64.0;
                    localY = localY / dist * 64.0;
                }
                this.hsX = localX;
                this.hsY = localY;
                this.updateColor(dragging);
                return;
            }
        }
        if (!this.hsGrabbed) {
            localX = mouseX - (double)(this.method_46426() + 132);
            localY = mouseY - (double)this.method_46427();
            if (localX >= 0.0 && localX < 8.0 && localY >= 0.0 && localY < 128.0) {
                this.vGrabbed = true;
            }
            if (this.vGrabbed) {
                this.v = Math.max(0.0, Math.min(localY, 127.99));
                this.updateColor(dragging);
            }
        }
    }

    private void updateColor(boolean dragging) {
        double dist = Math.sqrt(this.hsX * this.hsX + this.hsY * this.hsY);
        double hue = Math.atan2(this.hsY, this.hsX) / (Math.PI * 2);
        double sat = dist / 64.0;
        double lum = 1.0 - this.v / 128.0;
        this.color = Color.HSBtoRGB((float)hue, (float)sat, (float)lum);
        this.colorFullBrightness = Color.HSBtoRGB((float)hue, (float)sat, 1.0f);
        this.callbackColorUpdated.accept(this, dragging);
    }
}

