/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class TabbedBox
extends AbstractWidgetNoNarration {
    private final class_327 font;
    private final IntConsumer tabChanged;
    private final int width;
    private final int height;
    private final List<Tab> tabs;
    private int selected;

    public TabbedBox(class_327 font, int x, int y, int width, int height, IntConsumer tabChanged) {
        super(x, y, width, 16, (class_2561)class_2561.method_43473());
        this.font = font;
        this.tabChanged = tabChanged;
        this.tabs = new ArrayList<Tab>();
        this.selected = -1;
        this.width = width;
        this.height = height;
    }

    public void addTab(class_2561 text, boolean enabled) {
        this.tabs.add(new Tab(this.font, text, enabled));
        this.updateTabPositions();
        if (this.selected == -1) {
            this.selected = 0;
        }
    }

    public void setTabSelected(int tab) {
        this.selected = tab;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).render(graphics, mouseX, mouseY, partialTicks, i == this.selected);
        }
        graphics.method_25294(this.method_46426(), this.method_46427() + 16, this.method_46426() + this.width, this.method_46427() + this.height, -955248624);
        if (this.selected == -1) {
            graphics.method_25292(this.method_46426(), this.method_46426() + this.width, this.method_46427() + 16, -8947849);
        } else {
            int selectedX = this.tabs.get((int)this.selected).x;
            graphics.method_25292(this.method_46426(), selectedX, this.method_46427() + 16, -8947849);
            graphics.method_25292(selectedX + 70, this.method_46426() + this.width, this.method_46427() + 16, -8947849);
        }
        graphics.method_25292(this.method_46426(), this.method_46426() + this.width, this.method_46427() + this.height, -8947849);
        graphics.method_25301(this.method_46426(), this.method_46427() + 16, this.method_46427() + this.height, -8947849);
        graphics.method_25301(this.method_46426() + this.width, this.method_46427() + 16, this.method_46427() + this.height, -8947849);
    }

    public boolean method_25361(double mouseX, double mouseY) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).clicked() || this.selected == i) continue;
            this.selected = i;
            if (this.tabChanged != null) {
                this.tabChanged.accept(this.selected);
            }
            return true;
        }
        return false;
    }

    private void updateTabPositions() {
        int tabX = this.method_46426() + this.width / 2 - this.tabs.size() * 35;
        for (Tab tab : this.tabs) {
            tab.x = tabX;
            tab.y = this.method_46427();
            tabX += 70;
        }
    }

    private static class Tab {
        private int x = 0;
        private int y = 0;
        private boolean isHovered = false;
        private final boolean active;
        private final SimpleLabel label;

        public Tab(class_327 font, class_2561 text, boolean active) {
            this.active = active;
            this.label = new SimpleLabel(font, 0, 0, SimpleLabel.Align.Center, text, -8947849);
        }

        public void render(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
            this.isHovered = this.active ? mouseX >= this.x && mouseY >= this.y && mouseX < this.x + 71 && mouseY < this.y + 16 : false;
            graphics.method_25294(this.x, this.y, this.x + 70, this.y + 16, -955248624);
            graphics.method_25292(this.x, this.x + 70, this.y, -8947849);
            graphics.method_25301(this.x, this.y, this.y + 16, -8947849);
            graphics.method_25301(this.x + 70, this.y, this.y + 16, -8947849);
            if (this.active) {
                if (selected || this.isHovered) {
                    this.label.setColor(-1);
                } else {
                    this.label.setColor(-8947849);
                }
            } else {
                this.label.setColor(-12303292);
            }
            this.label.method_46421(this.x + 35);
            this.label.method_46419(this.y + 5);
            this.label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean clicked() {
            return this.isHovered;
        }
    }
}

