/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class ShapeChunkButtons
extends AbstractWidgetNoNarration {
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private int size;
    private final SimpleLabel labelShapes;
    private final SimpleLabel labelChunks;
    private final Consumer<ShapeChunkButtons> callbackShapeUpdated;

    public ShapeChunkButtons(class_327 font, int x, int y, int selected, Consumer<ShapeChunkButtons> callbackShapeUpdated) {
        super(x, y, 214, 120, (class_2561)class_2561.method_43473());
        this.selected = selected;
        this.labelShapes = new SimpleLabel(font, x + 107, y, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.initial_shape"), -1);
        this.labelChunks = new SimpleLabel(font, x + 107, y + 127, SimpleLabel.Align.Center, (class_2561)class_2561.method_43470((String)""), -1);
        this.callbackShapeUpdated = callbackShapeUpdated;
        this.updateChunksLabel();
    }

    public void setSize(int size) {
        this.size = Math.min(Math.max(size, 1), 32);
        this.updateChunksLabel();
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2 || this.selected == 7) {
            return ShapeMeasure.None;
        }
        if (this.selected < 5) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Length;
    }

    public boolean method_25361(double mouseX, double mouseY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_25361(mouseX, mouseY);
    }

    public void method_25348(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.method_46426() + 3.0) / 55.0;
        double row = (mouseY - (double)this.method_46427() - 13.0) / 55.0;
        if (col >= 0.0 && col < 4.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 4;
            this.updateChunksLabel();
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0;
        int row = 0;
        for (int i = 0; i < 8; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.method_25290(texture, this.method_46426() + col * 55, this.method_46427() + row * 55 + 16, (float)(texX + 588), (float)texY, 49, 49, 980, 98);
            if (++col != 4) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.labelChunks.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void updateChunksLabel() {
        int chunks = 0;
        switch (this.selected) {
            case 1: {
                chunks = 1;
                break;
            }
            case 2: {
                chunks = this.size * this.size;
                break;
            }
            case 3: {
                chunks = Math.max(1, (this.size - 1) * 4);
                break;
            }
            case 4: {
                chunks = (this.size * this.size + 1) / 2;
                if (this.size % 2 != 0) break;
                chunks += this.size;
                break;
            }
            case 5: 
            case 6: {
                chunks = this.size;
                break;
            }
            case 7: {
                chunks = 1024;
            }
        }
        this.labelChunks.setText((class_2561)class_2561.method_43469((String)"mapfrontiers.chunks", (Object[])new Object[]{chunks}));
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Length;

    }
}

