/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1144;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class ShapeVertexButtons
extends AbstractWidgetNoNarration {
    private static final int[] vertexCount = new int[]{0, 1, 3, 3, 3, 3, 4, 4, 6, 6, 8, 16};
    private static final double[] vertexAngle = new double[]{0.0, 0.0, -90.0, 0.0, 90.0, 180.0, 45.0, 0.0, 30.0, 0.0, 22.5, 0.0};
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private final SimpleLabel labelShapes;
    private final SimpleLabel labelVertices;
    private final Consumer<ShapeVertexButtons> callbackShapeUpdated;

    public ShapeVertexButtons(class_327 font, int x, int y, int selected, Consumer<ShapeVertexButtons> callbackShapeUpdated) {
        super(x, y, 324, 120, (class_2561)class_2561.method_43473());
        this.selected = selected;
        this.labelShapes = new SimpleLabel(font, x + 162, y, SimpleLabel.Align.Center, (class_2561)class_2561.method_43471((String)"mapfrontiers.initial_shape"), -1);
        this.labelVertices = new SimpleLabel(font, x + 162, y + 127, SimpleLabel.Align.Center, (class_2561)class_2561.method_43470((String)""), -1);
        this.callbackShapeUpdated = callbackShapeUpdated;
        this.updateVertexLabel();
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2) {
            return ShapeMeasure.None;
        }
        if (this.selected < 7) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Radius;
    }

    public List<class_241> getVertices() {
        if (vertexCount[this.selected] == 0) {
            return null;
        }
        ArrayList<class_241> vertices = new ArrayList<class_241>();
        if (vertexCount[this.selected] == 1) {
            vertices.add(class_241.field_1340);
            return vertices;
        }
        double angle = vertexAngle[this.selected] / 180.0 * Math.PI;
        for (int i = 0; i < vertexCount[this.selected]; ++i) {
            double vertexAngle = Math.PI * 2 / (double)vertexCount[this.selected] * (double)i + angle;
            vertices.add(new class_241((float)Math.cos(vertexAngle), (float)Math.sin(vertexAngle)));
        }
        return vertices;
    }

    public boolean method_25361(double mouseX, double mouseY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_25361(mouseX, mouseY);
    }

    public void method_25348(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.method_46426() + 3.0) / 55.0;
        double row = (mouseY - (double)this.method_46427() - 13.0) / 55.0;
        if (col >= 0.0 && col < 6.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 6;
            this.updateVertexLabel();
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0;
        int row = 0;
        for (int i = 0; i < 12; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.method_25290(texture, this.method_46426() + col * 55, this.method_46427() + row * 55 + 16, (float)texX, (float)texY, 49, 49, 980, 98);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.labelVertices.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private void updateVertexLabel() {
        this.labelVertices.setText((class_2561)class_2561.method_43469((String)"mapfrontiers.vertices", (Object[])new Object[]{vertexCount[this.selected]}));
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Radius;

    }
}

