/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class ScrollBox
extends AbstractWidgetNoNarration {
    private final int elementHeight;
    private int scrollStart = 0;
    private final int scrollHeight;
    private int scrollBarPos = 0;
    private int scrollBarHeight = 0;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private int scrollBarGrabbedYPos = 0;
    private final List<ScrollElement> elements = new ArrayList<ScrollElement>();
    private int selected = -1;
    private Consumer<ScrollElement> elementClickedCallback;
    private Consumer<ScrollElement> elementDeletedCallback;

    public ScrollBox(int x, int y, int width, int height, int elementHeight) {
        super(x, y, width, Math.max(height, elementHeight), (class_2561)class_2561.method_43473());
        this.elementHeight = elementHeight;
        this.scrollHeight = this.field_22759 / elementHeight;
        this.field_22759 = this.scrollHeight * elementHeight;
    }

    public void setElementClickedCallback(Consumer<ScrollElement> callback) {
        this.elementClickedCallback = callback;
    }

    public void setElementDeletedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletedCallback = callback;
    }

    public List<ScrollElement> getElements() {
        return this.elements;
    }

    public void addElement(ScrollElement element) {
        element.setX(this.method_46426());
        element.setY(this.method_46427() + this.elements.size() * this.elementHeight);
        this.elements.add(element);
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void selectElement(ScrollElement element) {
        this.selected = this.elements.indexOf(element);
    }

    public ScrollElement getSelectedElement() {
        if (this.selected >= 0 && this.selected < this.elements.size()) {
            return this.elements.get(this.selected);
        }
        return null;
    }

    public void selectIndex(int index) {
        this.selected = Math.min(Math.max(index, -1), this.elements.size() - 1);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void selectElementIf(Predicate<ScrollElement> pred) {
        ScrollElement element = this.elements.stream().filter(pred).findFirst().orElse(null);
        if (element == null) {
            this.selected = -1;
        } else {
            this.selectElement(element);
        }
    }

    public void removeElement(ScrollElement element) {
        ListIterator<ScrollElement> it = this.elements.listIterator();
        while (it.hasNext()) {
            if (it.next() != element) continue;
            this.removeElement(element, it);
            return;
        }
    }

    private void removeElement(ScrollElement element, ListIterator<ScrollElement> it) {
        element.delete();
        it.remove();
        if (this.selected == this.elements.size()) {
            this.selected = this.elements.size() - 1;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(this.method_46427() + i * this.elementHeight);
        }
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
        if (this.elementDeletedCallback != null) {
            this.elementDeletedCallback.accept(element);
        }
    }

    public void removeAll() {
        for (ScrollElement element : this.elements) {
            element.delete();
        }
        this.elements.clear();
        this.selected = -1;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.field_22764 && (this.field_22762 || this.scrollBarHovered) && !this.scrollBarGrabbed) {
            int amount = (int)(-vDelta);
            if (amount < 0 && this.scrollStart == 0) {
                return false;
            }
            if (amount > 0 && this.scrollStart + this.scrollHeight >= this.elements.size()) {
                return false;
            }
            this.scrollStart += amount;
            this.updateScrollWindow();
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    public void scrollBottom() {
        this.scrollStart = this.elements.size() - this.scrollHeight;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).render(graphics, mouseX, mouseY, partialTicks, this.selected == i);
        }
        if (this.scrollBarHeight > 0) {
            this.scrollBarHovered = mouseX >= this.method_46426() + this.field_22758 + 5 && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 + 15 && mouseY < this.method_46427() + this.field_22759;
            int barColor = -8947849;
            if (this.scrollBarGrabbed) {
                barColor = -10066330;
            } else if (this.scrollBarHovered) {
                barColor = -5592406;
            }
            graphics.method_25294(this.method_46426() + this.field_22758 + 5, this.method_46427(), this.method_46426() + this.field_22758 + 15, this.method_46427() + this.field_22759, 0x1AFFFFFF);
            graphics.method_25294(this.method_46426() + this.field_22758 + 5, this.method_46427() + this.scrollBarPos, this.method_46426() + this.field_22758 + 15, this.method_46427() + this.scrollBarPos + this.scrollBarHeight, barColor);
        }
    }

    public boolean method_25361(double mouseX, double mouseY) {
        if (this.field_22764) {
            if (this.scrollBarHeight > 0 && mouseX >= (double)(this.method_46426() + this.field_22758 + 5) && mouseY >= (double)this.method_46427() && mouseX < (double)(this.method_46426() + this.field_22758 + 15) && mouseY < (double)(this.method_46427() + this.field_22759)) {
                if (mouseY < (double)(this.method_46427() + this.scrollBarPos)) {
                    this.method_25401(mouseX, mouseY, 0.0, 1.0);
                } else if (mouseY > (double)(this.method_46427() + this.scrollBarPos + this.scrollBarHeight)) {
                    this.method_25401(mouseX, mouseY, 0.0, -1.0);
                } else {
                    this.scrollBarGrabbed = true;
                    this.scrollBarGrabbedYPos = (int)mouseY - this.method_46427() - this.scrollBarPos;
                }
                return true;
            }
            if (this.field_22762 && !this.scrollBarGrabbed) {
                ListIterator<ScrollElement> it = this.elements.listIterator();
                while (it.hasNext()) {
                    ScrollElement element = it.next();
                    ScrollElement.Action action = element.mousePressed(mouseX, mouseY);
                    if (action == ScrollElement.Action.Deleted) {
                        this.removeElement(element, it);
                        return true;
                    }
                    if (action != ScrollElement.Action.Clicked) continue;
                    this.selectElement(element);
                    if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(element);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void mouseReleased() {
        if (this.field_22764 && this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            this.scrollBarGrabbed = false;
            this.updateScrollBar();
        }
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            int delta = (int)mouseY - this.method_46427() - this.scrollBarPos - this.scrollBarGrabbedYPos;
            if (delta == 0) {
                return;
            }
            this.scrollBarPos += delta;
            if (this.scrollBarPos < 0) {
                this.scrollBarPos = 0;
            } else if (this.scrollBarPos + this.scrollBarHeight > this.field_22759) {
                this.scrollBarPos = this.field_22759 - this.scrollBarHeight;
            }
            int newScrollStart = Math.round((float)this.scrollBarPos / (float)this.field_22759 * (float)this.elements.size());
            if (newScrollStart != this.scrollStart) {
                this.scrollStart = newScrollStart;
                this.updateScrollWindow();
            }
        }
    }

    private void updateScrollWindow() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollStart = 0;
        } else {
            int bottomExtra = this.elements.size() - (this.scrollStart + this.scrollHeight);
            if (bottomExtra < 0) {
                this.scrollStart += bottomExtra;
            }
            if (this.scrollStart < 0) {
                this.scrollStart = 0;
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i < this.scrollStart || i >= this.scrollStart + this.scrollHeight) {
                this.elements.get((int)i).visible = false;
                continue;
            }
            this.elements.get((int)i).visible = true;
            this.elements.get(i).setY(this.method_46427() + (i - this.scrollStart) * this.elementHeight);
        }
    }

    private void updateScrollBar() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollBarHeight = 0;
            this.scrollBarHovered = false;
            this.scrollBarGrabbed = false;
            return;
        }
        this.scrollBarHeight = Math.round((float)this.scrollHeight / (float)this.elements.size() * (float)this.field_22759);
        this.scrollBarPos = Math.round((float)this.scrollStart / (float)this.elements.size() * (float)this.field_22759);
        if (this.scrollBarPos + this.scrollBarHeight > this.field_22759) {
            this.scrollBarPos = this.field_22759 - this.scrollBarHeight;
        }
    }

    public static class ScrollElement {
        public boolean visible = true;
        protected int x = 0;
        protected int y = 0;
        protected boolean isHovered = false;
        protected final int height;
        protected final int width;

        public ScrollElement(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void delete() {
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void render(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                this.renderWidget(graphics, mouseX, mouseY, partialTicks, selected);
            } else {
                this.isHovered = false;
            }
        }

        public void renderWidget(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
        }

        public Action mousePressed(double mouseX, double mouseY) {
            return Action.None;
        }

        static enum Action {
            None,
            Clicked,
            Deleted;

        }
    }
}

