/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7446;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class HUD {
    private static final class_310 mc = class_310.method_1551();
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontiersOverlayManager personalFrontiersOverlayManager;
    private FrontierOverlay frontier;
    private int frontierHash;
    private class_2338 lastPlayerPosition = new class_2338(0, 0, 0);
    private final SimpleLabel frontierName1;
    private final SimpleLabel frontierName2;
    private final SimpleLabel frontierOwner;
    private final List<Config.HUDSlot> slots;
    private int posX = 0;
    private int posY = 0;
    private int nameOffsetY = 0;
    private int ownerOffsetY = 0;
    private int bannerOffsetY = 0;
    private int hudWidth = 0;
    private int hudHeight = 0;
    private int textScale = 1;
    private int bannerScale = 1;
    private boolean needUpdate = true;
    private boolean previewMode = false;
    private int displayWidth;
    private int displayHeight;

    public static HUD asPreview() {
        HUD hud = new HUD(null, null);
        hud.previewMode = true;
        class_7225 patternRegistry = (class_7225)HUD.mc.field_1687.method_30349().method_46759(class_7924.field_41252).get();
        class_9307 patterns = new class_9307.class_3750().method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39148).get(), class_1767.field_7942).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39144).get(), class_1767.field_7967).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39140).get(), class_1767.field_7951).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39168).get(), class_1767.field_7951).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39167).get(), class_1767.field_7963).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39156).get(), class_1767.field_7942).method_57573();
        FrontierData frontierData = new FrontierData();
        frontierData.setOwner(new SettingsUser((class_1657)HUD.mc.field_1724));
        frontierData.setName1("Preview Frontier");
        frontierData.setName2("-----------------");
        frontierData.setBanner(class_1767.field_7963, patterns);
        hud.frontier = new FrontierOverlay(frontierData, null);
        return hud;
    }

    public HUD(@Nullable FrontiersOverlayManager frontiersOverlayManager, @Nullable FrontiersOverlayManager personalFrontiersOverlayManager) {
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.personalFrontiersOverlayManager = personalFrontiersOverlayManager;
        this.slots = new ArrayList<Config.HUDSlot>();
        this.frontierName1 = new SimpleLabel(HUD.mc.field_1772, 0, 0, SimpleLabel.Align.Center, (class_2561)class_2561.method_43473(), -1);
        this.frontierName2 = new SimpleLabel(HUD.mc.field_1772, 0, 0, SimpleLabel.Align.Center, (class_2561)class_2561.method_43473(), -1);
        this.frontierOwner = new SimpleLabel(HUD.mc.field_1772, 0, 0, SimpleLabel.Align.Center, (class_2561)class_2561.method_43473(), -1);
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> this.frontierChanged());
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedConfigEvent(this, this::configUpdated);
    }

    public int getWidth() {
        return this.hudWidth;
    }

    public int getHeight() {
        return this.hudHeight;
    }

    public boolean isInside(int x, int y) {
        return x >= this.posX && x < this.posX + this.hudWidth && y >= this.posY && y < this.posY + this.hudHeight;
    }

    public void tick() {
        if (this.previewMode || this.frontiersOverlayManager == null || this.personalFrontiersOverlayManager == null || HUD.mc.field_1724 == null) {
            return;
        }
        class_2338 currentPlayerPosition = HUD.mc.field_1724.method_24515();
        if (currentPlayerPosition.method_10263() != this.lastPlayerPosition.method_10263() || currentPlayerPosition.method_10260() != this.lastPlayerPosition.method_10260()) {
            this.lastPlayerPosition = currentPlayerPosition;
            FrontierOverlay newFrontier = this.personalFrontiersOverlayManager.getFrontierInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_37908().method_27983(), this.lastPlayerPosition);
            if (newFrontier == null) {
                newFrontier = this.frontiersOverlayManager.getFrontierInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_37908().method_27983(), this.lastPlayerPosition);
            }
            if (newFrontier != null) {
                if (this.frontierHash != newFrontier.getHash()) {
                    this.frontier = newFrontier;
                    this.frontierHash = newFrontier.getHash();
                    this.needUpdate = true;
                }
            } else if (this.frontier != null) {
                this.frontier = null;
                this.frontierHash = 0;
                this.needUpdate = true;
            }
        }
        if (this.frontier != null && this.frontierHash != this.frontier.getHash()) {
            this.frontierHash = this.frontier.getHash();
            this.needUpdate = true;
        }
    }

    public void configUpdated() {
        if (this.previewMode) {
            this.updateData();
        } else {
            this.needUpdate = true;
        }
    }

    private void frontierChanged() {
        if (this.previewMode || this.frontiersOverlayManager == null || this.personalFrontiersOverlayManager == null) {
            return;
        }
        FrontierOverlay newFrontier = this.personalFrontiersOverlayManager.getFrontierInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_37908().method_27983(), this.lastPlayerPosition);
        if (newFrontier == null) {
            newFrontier = this.frontiersOverlayManager.getFrontierInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_37908().method_27983(), this.lastPlayerPosition);
        }
        if (newFrontier != null) {
            if (this.frontierHash != newFrontier.getHash()) {
                this.frontier = newFrontier;
                this.frontierHash = newFrontier.getHash();
                this.needUpdate = true;
            }
        } else if (this.frontier != null) {
            this.frontier = null;
            this.frontierHash = 0;
            this.needUpdate = true;
        }
    }

    public void drawInGameHUD(class_332 graphics, float partialTicks) {
        if (this.previewMode) {
            return;
        }
        if (HUD.mc.field_1755 != null && !(HUD.mc.field_1755 instanceof class_408)) {
            return;
        }
        if (this.frontier == null) {
            return;
        }
        if (!Config.hudEnabled) {
            return;
        }
        this.draw(graphics, partialTicks);
    }

    public void draw(class_332 graphics, float partialTicks) {
        if (this.displayWidth != mc.method_22683().method_4489() || this.displayHeight != mc.method_22683().method_4506()) {
            this.needUpdate = true;
        }
        if ((Config.hudAnchor == Config.HUDAnchor.Minimap || Config.hudAnchor == Config.HUDAnchor.MinimapHorizontal || Config.hudAnchor == Config.HUDAnchor.MinimapVertical) && Services.JOURNEYMAP.minimapPropertiesChanged()) {
            this.needUpdate = true;
        }
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateData();
        }
        if (this.slots.isEmpty()) {
            return;
        }
        float factor = (float)mc.method_22683().method_4495();
        int frameColor = Services.JOURNEYMAP.minimapLabelBackgroundColor();
        int textNameColor = Services.JOURNEYMAP.minimapLabelHighlightColor();
        int textOwnerColor = Services.JOURNEYMAP.minimapLabelForegroundColor();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(1.0f / factor, 1.0f / factor, 1.0f);
        graphics.method_51448().method_22904(0.0, 0.0, -100.0);
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.drawName(graphics, frameColor, textNameColor, partialTicks);
                    break;
                }
                case Owner: {
                    this.drawOwner(graphics, frameColor, textOwnerColor, partialTicks);
                    break;
                }
                case Banner: {
                    this.drawBanner(graphics, frameColor);
                    break;
                }
            }
        }
        graphics.method_51448().method_22909();
        GlStateManager._enableBlend();
    }

    private void drawName(class_332 graphics, int frameColor, int textColor, float partialTicks) {
        graphics.method_25294(this.posX, this.posY + this.nameOffsetY, this.posX + this.hudWidth, this.posY + this.nameOffsetY + 24 * this.textScale, frameColor);
        this.frontierName1.setColor(textColor);
        this.frontierName2.setColor(textColor);
        this.frontierName1.method_25394(graphics, 0, 0, partialTicks);
        this.frontierName2.method_25394(graphics, 0, 0, partialTicks);
    }

    private void drawOwner(class_332 graphics, int frameColor, int textColor, float partialTicks) {
        graphics.method_25294(this.posX, this.posY + this.ownerOffsetY, this.posX + this.hudWidth, this.posY + this.ownerOffsetY + 12 * this.textScale, frameColor);
        this.frontierOwner.setColor(textColor);
        this.frontierOwner.method_25394(graphics, 0, 0, partialTicks);
    }

    private void drawBanner(class_332 graphics, int frameColor) {
        graphics.method_25294(this.posX + this.hudWidth / 2 - 11 * this.bannerScale - 2, this.posY + this.bannerOffsetY, this.posX + this.hudWidth / 2 + 11 * this.bannerScale + 2, this.posY + this.bannerOffsetY + 4 + 40 * this.bannerScale, frameColor);
        this.frontier.renderBanner(mc, graphics, this.posX + this.hudWidth / 2 - 11 * this.bannerScale, this.posY + this.bannerOffsetY + 2, this.bannerScale);
    }

    private void updateData() {
        String owner;
        this.displayWidth = mc.method_22683().method_4489();
        this.displayHeight = mc.method_22683().method_4506();
        this.slots.clear();
        if (this.frontier == null) {
            return;
        }
        this.addSlot(Config.hudSlot1);
        this.addSlot(Config.hudSlot2);
        this.addSlot(Config.hudSlot3);
        if (this.slots.isEmpty()) {
            return;
        }
        this.hudWidth = 0;
        this.hudHeight = 0;
        this.bannerScale = Config.hudBannerSize;
        this.textScale = Services.JOURNEYMAP.getMinimapFontScale();
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    int name1Width = HUD.mc.field_1772.method_1727(this.frontier.getName1()) + 3;
                    int name2Width = HUD.mc.field_1772.method_1727(this.frontier.getName2()) + 3;
                    int nameWidth = Math.max(name1Width, name2Width) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, nameWidth);
                    this.hudHeight += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    int ownerWidth = (HUD.mc.field_1772.method_1727(owner) + 3) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, ownerWidth);
                    this.hudHeight += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    this.hudWidth = Math.max(this.hudWidth, 22 * this.bannerScale + 4);
                    this.hudHeight += 40 * this.bannerScale + 4;
                    break;
                }
            }
        }
        Config.Point anchorPos = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPos = Config.getHUDOrigin(Config.hudAnchor, this.hudWidth, this.hudHeight);
        this.posX = anchorPos.x - originPos.x + Config.hudXPosition;
        this.posY = anchorPos.y - originPos.y + Config.hudYPosition;
        int offsetY = 0;
        this.nameOffsetY = 0;
        this.ownerOffsetY = 0;
        this.bannerOffsetY = 0;
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.nameOffsetY = offsetY;
                    this.frontierName1.method_46421(this.posX + this.hudWidth / 2);
                    this.frontierName1.method_46419(this.posY + this.nameOffsetY + 2 * this.textScale);
                    this.frontierName1.setScale(this.textScale);
                    this.frontierName1.setText((class_2561)class_2561.method_43470((String)this.frontier.getName1()));
                    this.frontierName2.method_46421(this.posX + this.hudWidth / 2);
                    this.frontierName2.method_46419(this.posY + this.nameOffsetY + 14 * this.textScale);
                    this.frontierName2.setScale(this.textScale);
                    this.frontierName2.setText((class_2561)class_2561.method_43470((String)this.frontier.getName2()));
                    offsetY += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    this.ownerOffsetY = offsetY;
                    this.frontierOwner.method_46421(this.posX + this.hudWidth / 2);
                    this.frontierOwner.method_46419(this.posY + this.ownerOffsetY + 2);
                    this.frontierOwner.setScale(this.textScale);
                    this.frontierOwner.setText((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1056) + owner)));
                    offsetY += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    this.bannerOffsetY = offsetY;
                    offsetY += 40 * this.bannerScale + 4;
                    break;
                }
            }
        }
    }

    private String getOwnerString() {
        Object ownerString = "";
        if (!StringUtils.isBlank((CharSequence)this.frontier.getOwner().username)) {
            ownerString = this.frontier.getOwner().username;
        } else if (this.frontier.getOwner().uuid != null) {
            ownerString = this.frontier.getOwner().uuid.toString();
            ownerString = ((String)ownerString).substring(0, 8) + "...";
        }
        return ownerString;
    }

    private void addSlot(Config.HUDSlot slot) {
        if (slot == Config.HUDSlot.Name) {
            if (this.frontier.isNamed()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Owner) {
            if (!this.frontier.getOwner().isEmpty()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Banner && this.frontier.hasBanner()) {
            this.slots.add(slot);
        }
    }
}

